package ONVIF::PTZ::Types::NetworkInterfaceInfo;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Name_of :ATTR(:get<Name>);
my %HwAddress_of :ATTR(:get<HwAddress>);
my %MTU_of :ATTR(:get<MTU>);

__PACKAGE__->_factory(
    [ qw(        Name
        HwAddress
        MTU

    ) ],
    {
        'Name' => \%Name_of,
        'HwAddress' => \%HwAddress_of,
        'MTU' => \%MTU_of,
    },
    {
        'Name' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'HwAddress' => 'ONVIF::PTZ::Types::HwAddress',
        'MTU' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
    },
    {

        'Name' => 'Name',
        'HwAddress' => 'HwAddress',
        'MTU' => 'MTU',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::NetworkInterfaceInfo

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
NetworkInterfaceInfo from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Name


=item * HwAddress


=item * MTU




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::NetworkInterfaceInfo
   Name =>  $some_value, # string
   HwAddress => $some_value, # HwAddress
   MTU =>  $some_value, # int
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

