/*
 * Decompiled with CFR 0.152.
 */
package uk.me.nxg.unity;

import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import uk.me.nxg.unity.FunctionDefinition;
import uk.me.nxg.unity.FunctionDefinitionMap;
import uk.me.nxg.unity.OneUnit;
import uk.me.nxg.unity.Parser;
import uk.me.nxg.unity.Parser_cds;
import uk.me.nxg.unity.Parser_fits;
import uk.me.nxg.unity.Parser_ogip;
import uk.me.nxg.unity.Parser_vounits;
import uk.me.nxg.unity.Syntax;
import uk.me.nxg.unity.SyntaxMaker;
import uk.me.nxg.unity.UnitDefinitionMap;
import uk.me.nxg.unity.UnitExpr;
import uk.me.nxg.unity.UnitParserException;
import uk.me.nxg.unity.UnitWriter;
import uk.me.nxg.unity.UnitWriterCds;
import uk.me.nxg.unity.UnitWriterDebugging;
import uk.me.nxg.unity.UnitWriterFits;
import uk.me.nxg.unity.UnitWriterLaTeX;
import uk.me.nxg.unity.UnitWriterOgip;
import uk.me.nxg.unity.UnitWriterVOUnits;
import uk.me.nxg.unity.UnwritableExpression;

class SyntaxFactory {
    private static final Map<Syntax, SyntaxMaker> parsers;

    private SyntaxFactory() {
    }

    static Parser createParser(Syntax syntax, Reader reader) throws UnitParserException {
        if (syntax == null) {
            throw new IllegalArgumentException("syntax must not be null");
        }
        if (!syntax.isReadable()) {
            throw new UnitParserException(String.format("Syntax '%s' is not readable", new Object[]{syntax}));
        }
        SyntaxMaker syntaxMaker = parsers.get((Object)syntax);
        assert (syntaxMaker != null);
        UnitDefinitionMap.Resolver resolver = UnitDefinitionMap.getInstance().getResolver(syntax);
        FunctionDefinitionMap.Resolver resolver2 = FunctionDefinitionMap.getInstance().getResolver(syntax);
        Parser parser = syntaxMaker.makeParser();
        assert (resolver != null) : String.format("parser for syntax %s failed to make a resolver", new Object[]{syntax});
        parser.setUnitMaker(new OneUnit.Maker(resolver));
        parser.setFunctionMaker(new FunctionDefinition.Maker(resolver2));
        if (reader != null) {
            parser.setReader(reader, syntax);
        }
        return parser;
    }

    static UnitWriter createWriter(Syntax syntax, UnitExpr unitExpr) throws UnwritableExpression {
        if (syntax == null) {
            throw new IllegalArgumentException("syntax must not be null");
        }
        if (!syntax.isWritable()) {
            throw new UnwritableExpression(String.format("Syntax '%s' is not writable", new Object[]{syntax}));
        }
        SyntaxMaker syntaxMaker = parsers.get((Object)syntax);
        assert (syntaxMaker != null) : syntax;
        return syntaxMaker.makeWriter(unitExpr);
    }

    static {
        HashMap<Syntax, SyntaxMaker> hashMap = new HashMap<Syntax, SyntaxMaker>();
        hashMap.put(Syntax.VOUNITS, new SyntaxMaker(){

            @Override
            public Parser makeParser() {
                return new Parser_vounits();
            }

            @Override
            public UnitWriter makeWriter(UnitExpr unitExpr) {
                return new UnitWriterVOUnits(unitExpr);
            }
        });
        hashMap.put(Syntax.FITS, new SyntaxMaker(){

            @Override
            public Parser makeParser() {
                return new Parser_fits();
            }

            @Override
            public UnitWriter makeWriter(UnitExpr unitExpr) {
                return new UnitWriterFits(unitExpr);
            }
        });
        hashMap.put(Syntax.OGIP, new SyntaxMaker(){

            @Override
            public Parser makeParser() {
                return new Parser_ogip();
            }

            @Override
            public UnitWriter makeWriter(UnitExpr unitExpr) {
                return new UnitWriterOgip(unitExpr);
            }
        });
        hashMap.put(Syntax.CDS, new SyntaxMaker(){

            @Override
            public Parser makeParser() {
                return new Parser_cds();
            }

            @Override
            public UnitWriter makeWriter(UnitExpr unitExpr) {
                return new UnitWriterCds(unitExpr);
            }
        });
        hashMap.put(Syntax.LATEX, new SyntaxMaker(){

            @Override
            public Parser makeParser() throws UnitParserException {
                throw new UnitParserException("Can't create a LaTeX parser");
            }

            @Override
            public UnitWriter makeWriter(UnitExpr unitExpr) {
                return new UnitWriterLaTeX(unitExpr);
            }
        });
        hashMap.put(Syntax.DEBUG, new SyntaxMaker(){

            @Override
            public Parser makeParser() throws UnitParserException {
                throw new UnitParserException("Can't create a debug parser");
            }

            @Override
            public UnitWriter makeWriter(UnitExpr unitExpr) {
                return new UnitWriterDebugging(unitExpr);
            }
        });
        hashMap.put(Syntax.ALL, new SyntaxMaker(){

            @Override
            public Parser makeParser() throws UnitParserException {
                throw new UnitParserException("Can't create a parser for syntax ALL: pick a syntax");
            }

            @Override
            public UnitWriter makeWriter(UnitExpr unitExpr) throws UnwritableExpression {
                throw new UnwritableExpression("Can't create a writer for syntax ALL: pick a syntax");
            }
        });
        parsers = Collections.unmodifiableMap(hashMap);
    }
}

