// =============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2008-2008 - INRIA - Jean-Baptiste Silvy
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- TEST WITH GRAPHIC -->

// <-- Non-regression test for bug 2179 -->
//
// <-- GitLab URL -->
// https://gitlab.com/scilab/scilab/-/issues/2179
//
// <-- Short Description -->
// Problem with bar3d and %nan. Create blank Screen or crash.

Z = zeros(100,5);
A = abs(rand(40,5));
Z(1:40,:) = A;
scf();
bar3d(Z);
Index = find(Z==0);
Z(Index) = %nan;
scf();
bar3d(Z);
A = abs(rand(10,5));
Z(91:100,:) = A;
scf();
bar3d(Z); 

// all the 3 created figures should display something



