---
layout: post
title: Polyglot 1.7.0 y portada `page_id` para diferentes enlaces permanentes por idioma
lang: es
---

Me complace anunciar Jekyll-Polyglot 1.7.0, que tiene una nueva función para proporcionar a las páginas enlaces permanentes específicos del idioma y conservar su asociación con otras páginas relativas.

Esta nueva característica es proporcionada por **[antoniovazquezblanco](https://github.com/antoniovazquezblanco)**, que es un apuesto caballero y un erudito.

## use el frontmatter `page_id` para asociar páginas con diferentes enlaces permanentes

Polyglot asocia páginas haciendo coincidir sus enlaces permanentes o nombres de archivos. Sin embargo, es posible que algunas traducciones de sitios prefieran páginas con enlaces permanentes únicos.

Polyglot ya coordina múltiples copias del mismo documento en diferentes idiomas. Por lo tanto, cerrar una propiedad diferente como `page_id` no es diferente a cerrar el enlace permanente.

El uso de un `page_id` para coordinar páginas similares con diferentes enlaces permanentes garantiza que los enlaces permanentes personalizados aún se puedan ver en sitios de idiomas específicos.

### redirecciones para enlaces permanentes únicos

El desafío con los enlaces permanentes únicos viene con relativizar esas URL. Polyglot evita este problema por completo sugiriendo enlaces permanentes consistentes.

Para ayudar con esto, conjuntos políglotas `redirect_from` portada oculta en estas páginas, enumerando los enlaces permanentes únicos de las páginas correspondientes.

Cuando se utiliza el complemento `jekyll-redirect-from`, se recogerá esa información frontal y se realizarán redireccionamientos inteligentes al enlace permanente personalizado de la página.

Para ver esto en acción, visite [esta página con un enlace permanente largo en diferentes idiomas](/a-really-long/permalink/).

## Otras correcciones de errores

* Esta versión debería tener una solución para [#151](https://github.com/untra/polyglot/issues/151) y [#184](https://github.com/untra/polyglot/issues/184), evitando fallas en el inicio al llamar a otros comandos jekyll.