% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.cluster.R
\name{as.cluster}
\alias{as.cluster}
\alias{as.cluster.cluster}
\alias{as.cluster.list}
\alias{as.cluster.SOCKnode}
\alias{as.cluster.SOCK0node}
\alias{as.cluster.RichSOCKnode}
\alias{c.cluster}
\title{Coerce an Object to a Cluster Object}
\usage{
as.cluster(x, ...)

\method{as.cluster}{cluster}(x, ...)

\method{as.cluster}{list}(x, ...)

\method{as.cluster}{SOCKnode}(x, ...)

\method{as.cluster}{SOCK0node}(x, ...)

\method{as.cluster}{RichSOCKnode}(x, ...)

\method{c}{cluster}(..., recursive = FALSE)
}
\arguments{
\item{x}{An object to be coerced.}

\item{\dots}{Additional arguments passed to the underlying coercion method.
For \code{c(...)}, the clusters and cluster nodes to be combined.}

\item{recursive}{Not used.}
}
\value{
An object of class \code{cluster}.

\code{c(...)} combine multiple clusters and / or cluster nodes into one
cluster returned as an of class \code{cluster}.  A warning will be produced if
there are duplicated nodes in the resulting cluster.
}
\description{
Coerce an Object to a Cluster Object
}
\examples{
cl1 <- makeClusterPSOCK(2, dryrun = TRUE)
cl2 <- makeClusterPSOCK(c("n1", "server.remote.org"), dryrun = TRUE)
cl <- c(cl1, cl2)
print(cl)
}
