% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/334-extractDrugLongestAliphaticChain.R
\name{extractDrugLongestAliphaticChain}
\alias{extractDrugLongestAliphaticChain}
\title{Descriptor that Calculates the Number of Atoms in the Longest Aliphatic Chain}
\usage{
extractDrugLongestAliphaticChain(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process
should be shown or not, default is \code{TRUE}.}
}
\value{
A data frame, each row represents one of the molecules,
each column represents one feature.
This function returns one column named \code{nAtomLAC}.
}
\description{
Descriptor that Calculates the Number of Atoms in the Longest Aliphatic Chain
}
\details{
This descriptor calculates the number of atoms in the longest aliphatic chain.
}
\examples{
smi = system.file('vignettedata/FDAMDD.smi', package = 'Rcpi')
\donttest{
mol = readMolFromSmi(smi, type = 'mol')
dat = extractDrugLongestAliphaticChain(mol)
head(dat)}
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
\keyword{Aliphatic}
\keyword{Chain}
\keyword{Longest}
\keyword{extractDrugLongestAliphaticChain}
