# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.dataprotection import DataProtectionMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-dataprotection
# USAGE
    python put_backup_instance_kubernetes_cluster_backup_datasource_parameters.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = DataProtectionMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.backup_instances.begin_create_or_update(
        resource_group_name="aksrg",
        vault_name="aksvault",
        backup_instance_name="aksbi",
        parameters={
            "properties": {
                "dataSourceInfo": {
                    "datasourceType": "Microsoft.ContainerService/managedclusters",
                    "objectType": "Datasource",
                    "resourceID": "/subscriptions/62b829ee-7936-40c9-a1c9-47a93f9f3965/resourceGroups/aksrg/providers/Microsoft.ContainerService/managedClusters/akscluster",
                    "resourceLocation": "eastus2euap",
                    "resourceName": "akscluster",
                    "resourceType": "Microsoft.ContainerService/managedclusters",
                    "resourceUri": "/subscriptions/62b829ee-7936-40c9-a1c9-47a93f9f3965/resourceGroups/aksrg/providers/Microsoft.ContainerService/managedClusters/akscluster",
                },
                "dataSourceSetInfo": {
                    "datasourceType": "Microsoft.ContainerService/managedclusters",
                    "objectType": "DatasourceSet",
                    "resourceID": "/subscriptions/62b829ee-7936-40c9-a1c9-47a93f9f3965/resourceGroups/aksrg/providers/Microsoft.ContainerService/managedClusters/akscluster",
                    "resourceLocation": "eastus2euap",
                    "resourceName": "akscluster",
                    "resourceType": "Microsoft.ContainerService/managedclusters",
                    "resourceUri": "/subscriptions/62b829ee-7936-40c9-a1c9-47a93f9f3965/resourceGroups/aksrg/providers/Microsoft.ContainerService/managedClusters/akscluster",
                },
                "friendlyName": "aksbi",
                "objectType": "BackupInstance",
                "policyInfo": {
                    "policyId": "/subscriptions/62b829ee-7936-40c9-a1c9-47a93f9f3965/resourcegroups/aksrg/providers/Microsoft.DataProtection/BackupVaults/aksvault/backupPolicies/akspolicy",
                    "policyParameters": {
                        "backupDatasourceParametersList": [
                            {
                                "excludedNamespaces": ["kube-system"],
                                "excludedResourceTypes": ["v1/Secret"],
                                "includeClusterScopeResources": True,
                                "includedNamespaces": ["test"],
                                "includedResourceTypes": [],
                                "includedVolumeTypes": ["AzureDisk", "AzureFileShareSMB"],
                                "labelSelectors": [],
                                "objectType": "KubernetesClusterBackupDatasourceParameters",
                                "snapshotVolumes": True,
                            }
                        ],
                        "dataStoreParametersList": [
                            {
                                "dataStoreType": "OperationalStore",
                                "objectType": "AzureOperationalStoreParameters",
                                "resourceGroupId": "/subscriptions/62b829ee-7936-40c9-a1c9-47a93f9f3965/resourceGroups/aksrg",
                            }
                        ],
                    },
                },
            }
        },
    ).result()
    print(response)


# x-ms-original-file: 2025-07-01/BackupInstanceOperations/PutBackupInstance_KubernetesClusterBackupDatasourceParameters.json
if __name__ == "__main__":
    main()
