-- autogenerated from https://www.unicode.org/Public/15.1.0/ucd/DerivedCoreProperties.txt
-- |
-- Module      : Unicode.Internal.Char.DerivedCoreProperties
-- Copyright   : (c) 2020 Composewell Technologies and Contributors
-- License     : Apache-2.0
-- Maintainer  : streamly@composewell.com
-- Stability   : experimental

{-# OPTIONS_HADDOCK hide #-}
{-# OPTIONS_GHC -Wno-unrecognised-pragmas #-}
{-# HLINT ignore "Use camelCase" #-}

module Unicode.Internal.Char.DerivedCoreProperties
    ( isXID_Continue
    , isXID_Start
    , isID_Continue
    , isID_Start
    , isUppercase
    , isLowercase
    , isAlphabetic
    ) where

import Data.Bits (Bits(..))
import Data.Char (ord)
import Data.Int (Int8)
import Data.Word (Word16)
import GHC.Exts (Ptr(..))
import Unicode.Internal.Bits (lookupBit, lookupWord16AsInt)

{-# INLINE isXID_Continue #-}
isXID_Continue :: Char -> Bool
isXID_Continue c
    | c < '\x002F' = False
    | c < '\x323B0' = lookupIsXID_ContinueBitMap (ord c)
    | c < '\xE0000' = False
    | c < '\xE01F0' = lookupIsXID_ContinueBitMap (ord c - 0xADC50)
    | otherwise = False

{-# INLINE lookupIsXID_ContinueBitMap #-}
lookupIsXID_ContinueBitMap :: Int -> Bool
lookupIsXID_ContinueBitMap n =
    lookupBit data# (
        lookupWord16AsInt offsets# (
            n `shiftR` 8
        ) + ((n `shiftR` 3) .&. mask)
    ) (n .&. 7)
    where
    mask = (1 `shiftL` 5) - 1
    !(Ptr data#) = isXID_ContinueDataBitMap
    !(Ptr offsets#) = isXID_ContinueOffsetsBitMap

isXID_ContinueDataBitMap :: Ptr Int8
isXID_ContinueDataBitMap = Ptr
    "\132\252\47\63\80\253\255\243\224\67\0\0\255\255\255\255\255\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\239\111\
    \\240\239\254\255\255\63\135\0\0\0\0\255\255\255\31\255\255\255\31\0\0\0\0\255\254\255\255\127\0\0\0\48\0\0\0\0\0\128\1\0\16\0\0\0\2\128\0\0\255\31\
    \\0\0\0\0\0\0\255\31\226\255\1\0\224\0\0\0\254\255\62\31\254\255\255\255\255\255\255\255\255\255\127\230\254\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\195\255\3\0\31\80\0\0\255\7\255\255\255\255\255\255\255\255\255\195\255\255\255\255\255\255\255\255\255\255\255\255\239\159\255\
    \\253\255\159\238\159\249\255\255\253\237\243\159\57\224\176\207\255\2\0\236\199\61\214\24\199\255\195\199\61\129\0\192\255\0\0\184\255\3\255\255\255\255\255\255\255\255\255\255\255\1\
    \\255\255\255\255\255\7\255\255\255\255\255\255\255\255\63\0\0\255\255\255\15\255\7\255\255\255\126\0\255\255\255\255\255\255\255\255\255\251\255\255\255\255\191\32\255\255\255\255\255\255\
    \\255\128\0\128\255\255\127\0\127\127\127\127\127\127\127\127\255\255\255\255\255\255\255\255\255\61\127\61\255\255\255\255\255\61\255\255\255\255\61\127\61\255\127\255\255\255\255\255\255\255\
    \\3\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\
    \\255\63\255\1\0\0\63\0\0\0\0\255\255\255\255\255\255\255\231\255\255\255\255\255\255\255\255\255\255\255\255\3\0\255\255\255\255\255\255\63\36\255\239\255\255\127\255\255\183\255\
    \\63\255\63\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\3\254\255\255\135\254\255\255\7\0\0\0\0\0\4\160\4\
    \\255\255\127\255\255\255\127\255\15\255\15\192\255\255\255\255\63\31\0\255\255\255\255\255\15\255\255\255\3\255\7\0\0\0\0\128\255\252\255\255\255\255\255\255\255\255\255\255\255\255\
    \\249\255\255\255\255\255\255\255\7\235\3\0\0\252\255\223\253\255\255\253\255\243\223\61\96\39\207\255\0\0\239\223\253\255\255\253\239\243\223\61\96\96\207\255\14\0\191\231\223\223\
    \\255\255\255\123\95\252\253\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\253\255\255\247\255\255\255\247\224\255\255\255\255\255\254\255\255\255\
    \\255\255\255\255\255\255\255\127\0\0\255\255\255\255\0\0\0\0\0\0\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\3\0\255\255\255\255\255\255\255\255\255\255\255\255\207\255\254\255\239\159\249\255\255\253\197\243\159\121\128\176\207\255\3\80\255\255\0\0\255\255\24\0\0\224\0\0\0\0\
    \\138\170\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\255\3\0\248\15\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\1\0\0\0\0\0\0\255\255\255\255\255\255\7\0\255\255\255\255\255\255\7\0\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\0\0\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\1\0\0\3\255\3\160\194\255\254\255\255\255\31\254\255\223\255\255\254\255\255\255\31\64\0\0\0\0\0\0\0\255\3\
    \\254\255\255\135\254\255\255\7\224\255\255\255\255\255\255\255\255\255\255\127\252\252\252\28\0\0\0\0\255\255\255\255\255\255\255\0\255\227\255\255\255\255\255\63\255\1\255\255\255\255\
    \\255\231\0\0\247\255\255\255\255\7\0\4\0\0\0\39\0\240\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\15\0\255\255\127\248\255\255\255\255\255\15\255\255\255\255\255\255\255\127\255\255\255\159\255\3\255\3\128\0\255\191\255\127\0\0\0\0\0\0\255\255\255\255\255\31\255\63\255\67\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\127\0\0\255\255\255\255\255\255\255\3\255\255\255\255\255\0\255\3\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\27\3\0\0\0\0\0\0\0\0\224\255\255\255\255\255\255\255\255\255\255\255\255\255\127\0\0\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\31\255\255\255\255\255\255\1\0\1\0\
    \\0\0\255\255\255\255\255\255\255\255\255\255\255\63\240\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\251\252\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\223\184\192\215\255\255\251\255\255\255\255\255\255\255\255\255\191\255\223\253\255\255\255\255\255\223\125\240\128\207\255\0\252\238\255\127\252\255\255\251\47\127\132\95\255\192\255\12\0\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\255\255\255\255\255\63\255\255\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\224\227\7\248\231\15\0\0\0\60\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\3\255\
    \\255\255\255\255\0\255\255\255\255\255\255\15\0\255\247\255\247\183\255\251\255\251\27\0\0\0\0\0\0\0\0\28\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\224\227\7\248\231\15\0\0\0\60\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\127\111\255\127\242\111\255\
    \\255\255\191\249\15\0\255\3\0\0\0\0\0\0\0\0\255\252\255\255\255\255\255\252\27\0\0\0\255\255\255\255\255\63\255\255\255\255\15\0\255\255\255\31\255\255\255\255\255\255\
    \\255\255\1\128\255\3\255\255\255\127\251\255\255\255\255\127\180\255\0\255\3\191\253\255\255\255\127\251\1\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\255\255\127\0\191\231\223\223\255\255\255\123\95\252\253\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\223\255\255\255\255\
    \\255\255\255\255\223\100\222\255\235\239\255\255\255\255\255\255\255\255\255\3\255\255\255\255\255\255\255\255\255\63\255\255\255\255\191\32\255\255\255\255\255\247\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\3\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\1\0\255\255\61\255\255\255\
    \\255\255\255\255\255\231\0\254\3\0\255\255\0\0\255\255\255\255\255\255\255\255\255\255\63\63\255\255\255\255\63\63\255\170\255\255\255\63\255\255\255\255\255\255\223\95\220\31\207\15\
    \\255\31\220\31\255\255\253\255\255\255\255\199\7\0\255\3\0\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\255\255\127\0\255\255\255\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\32\255\255\255\255\255\255\127\0\15\0\255\
    \\3\248\255\255\224\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\63\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\31\248\15\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\251\252\255\255\255\255\255\255\255\255\255\255\255\255\255\255\254\255\255\255\127\2\255\255\
    \\255\255\255\1\254\255\255\255\255\191\182\0\255\255\255\135\7\0\255\255\223\255\255\255\223\255\255\127\255\255\255\127\255\255\255\253\255\255\255\253\255\255\247\207\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\253\255\255\247\255\255\255\247\255\255\223\255\255\255\223\255\255\127\255\255\255\127\255\255\255\253\255\255\255\253\255\255\
    \\247\207\255\255\255\255\255\255\127\248\255\255\255\255\255\31\32\0\16\0\0\248\254\255\0\0\0\0\0\0\0\0\0\0\255\255\255\31\128\0\255\255\255\255\1\0\0\0\255\255\
    \\63\0\0\0\0\0\255\255\31\0\0\0\255\255\127\0\248\224\255\253\127\95\219\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\248\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\1\0\255\255\255\255\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\223\
    \\184\192\215\255\255\251\255\255\255\255\255\255\255\255\255\191\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\195\255\3\0\31\80\0\0\255\255\
    \\255\255\255\255\255\255\255\135\255\255\255\255\255\255\255\128\255\255\0\0\0\0\0\0\0\0\27\0\3\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\238\135\249\255\255\253\109\211\135\57\2\94\192\255\63\0\238\191\251\255\255\253\237\243\191\59\1\0\207\255\0\254\254\255\255\255\255\255\255\
    \\7\255\127\255\3\0\0\0\0\214\247\255\255\175\255\255\63\95\127\255\243\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\159\255\255\254\255\255\7\255\255\255\255\255\
    \\255\255\255\255\199\255\1\255\255\63\128\255\255\31\0\255\255\15\0\255\223\13\0\255\255\255\255\255\255\255\255\255\255\143\48\255\3\0\0\255\31\255\255\255\15\0\0\255\255\255\
    \\255\255\255\240\191\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\255\255\255\255\255\16\0\0\255\255\255\255\255\255\15\0\255\255\255\255\255\255\255\255\63\0\255\3\255\
    \\255\255\232\255\255\255\255\255\255\127\0\255\63\255\3\255\255\127\252\255\255\255\255\255\255\255\255\7\0\0\56\255\255\124\0\126\126\126\0\127\127\255\255\255\255\255\247\255\3\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\55\255\3\255\255\255\255\255\255\255\63\0\0\255\255\255\255\255\255\255\255\252\255\255\255\255\255\255\0\0\0\0\0\255\3\255\
    \\255\255\255\0\224\255\255\255\7\255\255\255\255\255\7\255\255\255\63\255\255\255\255\15\255\62\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\63\255\3\255\255\255\255\15\255\255\255\255\15\255\255\255\255\255\255\127\0\255\255\63\0\255\0\0\0\191\255\255\255\255\255\253\7\0\0\0\0\0\0\0\0\63\253\255\255\255\
    \\255\191\145\255\255\63\0\255\255\127\0\255\255\255\127\0\0\0\0\0\0\0\0\255\255\55\0\255\255\63\0\255\255\255\3\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\
    \\192\0\0\0\0\0\0\0\0\255\255\255\255\255\255\63\0\255\255\63\0\255\255\7\0\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\127\
    \\0\0\0\192\255\63\128\255\255\255\255\255\255\255\7\4\0\255\255\255\1\255\3\255\255\255\255\255\255\223\255\240\0\255\255\255\255\79\0\255\255\255\255\255\255\255\255\31\222\255\
    \\23\0\0\0\0\255\255\251\255\255\255\255\192\3\0\0\0\0\0\0\0\127\189\255\191\255\1\255\255\255\255\255\255\255\7\255\3\239\159\249\255\255\253\237\251\159\57\129\224\207\
    \\31\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\7\255\195\3\0\0\0\255\255\255\255\255\255\255\255\191\0\255\3\0\0\0\
    \\0\255\255\255\255\255\255\255\255\17\0\255\3\0\0\0\0\255\255\255\255\255\255\255\1\255\3\0\0\0\0\0\0\255\255\255\231\255\15\255\3\127\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\7\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\3\0\128\255\255\255\
    \\255\255\255\255\127\128\0\255\255\255\255\255\255\255\255\255\35\0\0\255\255\255\255\255\255\255\255\255\1\255\253\255\255\255\255\127\255\1\0\255\3\0\0\252\255\255\255\252\255\255\
    \\254\127\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\
    \\1\255\255\255\127\255\3\255\255\255\255\255\255\255\255\255\127\255\3\255\255\255\63\31\0\255\255\255\255\255\255\255\255\255\255\255\255\255\7\255\31\255\1\255\99\0\0\0\0\0\
    \\0\0\0\0\0\0\0\255\255\255\127\224\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\127\255\255\249\219\7\255\255\255\255\255\
    \\255\255\63\0\0\0\128\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\0\127\0\0\
    \\0\0\0\255\255\255\255\255\255\255\255\255\15\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\239\255\255\255\150\254\247\10\132\234\150\170\150\247\247\
    \\94\255\251\255\15\238\251\255\15\0\0\0\0\0\0\0\0"#

isXID_ContinueOffsetsBitMap :: Ptr Word16
isXID_ContinueOffsetsBitMap = Ptr
    "\14\2\133\0\141\0\56\5\38\5\138\8\171\0\153\1\3\1\242\2\51\10\203\0\102\2\87\5\83\10\198\3\224\6\133\0\60\1\52\7\132\0\133\0\115\10\147\10\234\0\41\2\84\4\40\3\4\4\133\0\133\0\80\7\80\0\0\0\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\80\8\32\1\244\1\244\1\112\0\178\2\
    \\244\1\244\1\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\99\1\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\
    \\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\
    \\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\119\5\133\0\179\10\71\2\211\10\92\6\243\10\19\11\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\
    \\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\56\4\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\133\0\
    \\87\9\60\9\22\5\51\11\18\3\228\3\185\1\215\7\246\4\83\11\115\11\219\5\133\0\147\11\179\11\211\11\49\0\243\11\97\3\162\4\178\4\30\9\19\12\51\12\83\12\115\12\147\12\123\1\179\12\211\12\243\12\60\6\19\13\244\1\51\13\123\6\145\6\112\7\133\0\133\0\133\0\226\4\210\4\62\3\244\1\244\1\244\1\244\1\244\1\244\1\
    \\244\1\244\1\244\1\76\3\133\0\133\0\133\0\133\0\154\3\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\133\0\133\0\83\13\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\
    \\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\133\0\133\0\115\13\247\7\244\1\244\1\15\8\244\9\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\129\3\133\0\133\0\133\0\133\0\217\1\16\0\244\1\244\1\
    \\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\18\0\133\0\31\4\45\4\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\147\13\244\1\244\1\244\1\244\1\244\1\
    \\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\145\5\244\1\165\5\243\5\244\1\199\6\134\2\146\2\170\8\244\1\244\1\254\8\244\1\244\1\244\1\244\1\179\13\211\13\116\4\130\4\244\1\187\5\244\1\244\1\29\6\243\13\19\14\244\1\244\1\244\1\244\1\51\14\244\1\244\1\244\1\244\1\244\1\
    \\244\1\244\1\244\1\244\1\244\1\244\1\244\1\246\1\244\1\244\1\244\1\244\1\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\
    \\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\
    \\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\
    \\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\95\1\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\87\1\208\2\133\0\133\0\133\0\
    \\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\220\2\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\22\7\133\0\133\0\
    \\232\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\133\0\133\0\240\1\244\1\244\1\244\1\244\1\244\1\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\207\1\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\
    \\133\0\133\0\133\0\101\1\72\3\133\0"#

{-# INLINE isXID_Start #-}
isXID_Start :: Char -> Bool
isXID_Start c = c >= '\x0041' && c <= '\x323AF' && lookupIsXID_StartBitMap (ord c)

{-# INLINE lookupIsXID_StartBitMap #-}
lookupIsXID_StartBitMap :: Int -> Bool
lookupIsXID_StartBitMap n =
    lookupBit data# (
        lookupWord16AsInt offsets# (
            n `shiftR` 8
        ) + ((n `shiftR` 3) .&. mask)
    ) (n .&. 7)
    where
    mask = (1 `shiftL` 5) - 1
    !(Ptr data#) = isXID_StartDataBitMap
    !(Ptr offsets#) = isXID_StartOffsetsBitMap

isXID_StartDataBitMap :: Ptr Int8
isXID_StartDataBitMap = Ptr
    "\132\252\47\63\80\253\255\243\224\67\0\0\255\255\255\255\255\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\239\111\
    \\254\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\195\255\3\0\31\80\0\0\224\255\255\255\255\255\254\255\255\
    \\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\0\0\0\0\0\0\255\255\255\255\255\255\255\3\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\0\0\0\0\0\0\0\0\254\255\255\7\254\255\255\7\0\0\0\0\0\4\32\4\255\255\127\255\255\255\127\255\255\255\255\191\32\255\255\255\255\255\255\
    \\255\128\0\0\255\255\127\0\127\127\127\127\127\127\127\127\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\63\240\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\7\0\255\239\255\255\
    \\127\255\255\183\255\63\255\63\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\31\120\12\0\191\231\223\223\255\255\255\123\95\252\253\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\253\255\255\247\
    \\255\255\255\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\255\255\255\255\255\63\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\255\255\255\255\255\255\255\255\255\255\255\255\255\159\255\255\254\255\255\7\255\255\255\255\255\255\255\
    \\255\255\199\255\1\0\239\254\255\255\63\0\0\0\0\0\255\255\255\31\255\255\255\31\0\0\0\0\255\254\255\255\31\0\0\0\255\255\255\255\255\255\255\255\15\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\1\0\0\0\0\0\0\255\255\255\255\255\255\7\0\255\255\255\255\255\
    \\255\7\0\128\0\0\63\60\98\192\225\255\3\64\0\0\255\255\255\255\191\32\255\255\255\255\255\247\255\31\255\255\0\12\0\0\255\255\255\255\255\127\0\128\255\255\255\63\255\255\
    \\255\255\255\255\255\255\255\255\0\0\126\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\1\0\0\247\
    \\15\0\0\255\255\127\196\255\255\255\255\255\255\98\62\5\0\0\56\255\7\28\0\255\255\255\255\7\0\4\0\0\0\39\0\240\0\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\255\255\127\248\255\255\255\255\255\15\0\0\0\0\224\0\252\255\255\255\63\255\1\255\255\255\255\255\231\0\
    \\0\0\0\0\222\111\4\255\255\255\255\255\31\128\63\0\64\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\63\0\0\255\255\255\255\255\
    \\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\0\128\255\252\255\255\255\255\255\255\255\255\255\255\255\255\249\255\255\255\255\255\255\255\7\
    \\235\3\0\0\252\255\255\63\0\255\255\127\0\0\0\255\255\255\31\240\255\255\255\255\255\7\0\0\128\0\0\223\255\0\124\224\159\249\255\255\253\237\35\0\0\0\176\3\0\2\
    \\0\232\199\61\214\24\199\255\3\0\0\1\0\0\0\0\0\0\0\255\254\255\255\255\31\0\0\0\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\31\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\31\255\255\255\255\255\255\1\0\0\0\0\0\255\255\255\255\255\7\0\0\0\192\254\255\255\255\255\255\255\
    \\255\255\255\255\255\47\0\96\192\0\156\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\0\0\255\255\255\255\15\255\255\255\255\15\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\3\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\128\0\0\255\31\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\138\170\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\128\0\255\255\63\0\0\0\0\0\255\255\3\0\0\0\0\0\255\255\31\
    \\0\0\0\255\255\127\0\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\0\128\0\0\0\0\0\0\0\0\0\0\0\254\255\255\7\254\255\255\7\192\255\255\255\255\255\255\
    \\63\255\255\255\127\252\252\252\28\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\252\255\255\255\255\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\223\184\64\215\255\255\251\255\255\255\255\255\255\255\255\255\191\255\
    \\255\255\255\255\255\127\0\255\255\63\0\255\0\0\0\191\255\255\255\255\255\253\7\0\0\0\0\0\0\0\0\191\231\223\223\255\255\255\123\95\252\253\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\223\255\255\255\255\255\255\255\255\223\100\222\255\235\239\255\255\255\255\255\255\255\255\255\61\127\61\255\255\255\255\255\61\255\255\255\255\
    \\61\127\61\255\127\255\255\255\255\255\255\254\255\255\255\127\2\255\255\255\255\255\1\0\0\0\0\0\0\0\0\255\255\255\135\7\0\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\3\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\1\0\255\255\61\255\255\255\255\255\255\255\255\
    \\7\0\0\0\0\255\255\0\0\255\255\255\255\255\255\255\255\255\255\63\63\255\255\255\255\63\63\255\170\255\255\255\63\255\255\255\255\255\255\223\95\220\31\207\15\255\31\220\31\255\
    \\255\255\255\255\255\0\0\16\0\0\0\0\0\0\0\255\255\255\255\255\7\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\127\0\0\0\0\0\
    \\15\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\15\0\0\255\255\255\255\255\255\0\0\15\0\0\0\248\255\255\224\255\255\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\255\255\255\255\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\127\111\255\127\242\111\255\255\255\0\128\2\
    \\0\0\0\0\0\0\0\0\0\0\0\255\252\255\255\255\255\1\0\10\0\0\0\255\255\255\255\255\255\31\0\128\7\0\128\3\0\0\0\255\255\255\255\255\255\0\0\176\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\127\0\0\0\0\0\15\0\0\0\0\255\255\255\255\255\255\255\255\255\255\223\255\255\255\255\255\255\255\255\223\
    \\100\222\255\235\239\255\255\255\255\255\255\255\255\255\255\255\255\255\7\255\31\255\1\255\3\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\63\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\0\255\255\255\255\255\255\15\0\255\247\255\247\183\255\251\255\251\27\0\0\0\0\0\0\0\0\255\255\255\127\224\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\31\128\63\0\64\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\127\0\248\160\255\253\
    \\127\95\219\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\248\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\
    \\0\0\0\255\255\255\255\0\224\255\255\255\7\255\255\255\255\63\0\255\255\255\63\255\255\255\255\15\255\62\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\31\
    \\255\255\255\255\255\255\1\0\0\0\0\0\255\255\3\128\255\255\3\0\255\255\3\0\255\223\1\0\255\255\255\255\255\255\15\0\0\0\128\16\0\0\0\0\255\255\255\255\255\255\
    \\255\255\255\255\255\1\255\255\255\255\255\5\255\255\255\255\255\255\255\255\63\0\0\255\255\255\255\255\255\255\255\252\255\255\255\255\255\255\0\0\0\0\0\255\3\255\255\251\255\255\
    \\15\0\128\1\0\0\0\0\0\0\0\127\189\255\191\255\1\255\255\255\255\255\127\0\0\0\0\0\0\255\255\255\63\31\0\255\255\255\255\255\15\255\255\255\3\0\0\0\0\0\
    \\0\255\255\255\255\255\255\255\255\255\255\255\1\255\255\255\255\255\5\255\255\255\255\255\255\255\255\63\0\255\255\63\0\255\255\7\0\255\255\3\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\255\255\255\255\255\255\255\255\255\7\1\0\0\0\0\0\0\0\248\255\0\0\0\0\0\0\0\0\11\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\7\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\63\4\16\1\0\0\255\255\255\1\255\7\255\255\255\126\0\0\255\255\255\255\255\
    \\3\0\0\0\0\0\0\253\255\255\255\0\0\0\224\255\255\255\255\255\255\255\255\255\255\63\0\2\0\0\252\255\255\255\7\48\4\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\1\0\255\255\255\255\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\240\
    \\255\255\255\255\255\255\35\0\0\1\255\3\0\254\255\225\159\249\255\255\253\197\35\0\64\0\176\3\0\3\16\224\135\249\255\255\253\109\3\0\0\0\94\0\0\28\0\224\191\251\
    \\255\255\253\237\35\0\0\1\0\3\0\0\2\224\223\253\255\255\253\255\35\0\0\0\39\3\0\0\0\225\223\253\255\255\253\239\35\0\0\0\96\3\0\6\0\240\223\253\255\255\
    \\255\255\39\0\64\112\128\3\0\0\252\224\255\127\252\255\255\251\47\127\0\0\0\0\0\0\0\254\255\255\255\255\255\5\0\127\0\0\0\0\0\0\0\214\247\255\255\175\255\5\
    \\32\95\0\0\240\0\0\0\0\224\255\255\255\255\255\15\0\224\31\0\0\0\0\0\0\248\255\255\255\1\192\0\252\255\255\255\255\63\0\0\0\224\0\0\0\254\3\62\31\254\
    \\255\255\255\255\255\255\255\255\255\127\224\254\255\255\255\255\255\255\255\255\255\255\247\187\247\255\255\7\0\0\0\255\255\255\255\255\255\15\0\252\255\255\255\255\255\15\0\0\0\0\
    \\0\0\0\252\104\126\126\126\0\127\127\255\255\255\255\255\247\255\3\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\0\0\0\63\253\255\255\255\255\191\145\255\255\63\0\255\
    \\255\127\0\255\255\255\127\0\0\0\0\0\0\0\0\255\255\55\0\255\255\63\0\255\255\255\3\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\192\0\0\0\0\0\0\0\
    \\0\248\255\255\255\255\255\255\0\0\0\0\0\0\0\38\0\248\255\255\255\255\255\0\0\0\0\255\255\255\1\0\0\248\255\255\255\127\0\0\0\144\0\255\255\255\255\71\0\248\
    \\255\255\255\255\255\7\0\30\0\0\20\0\0\0\0\224\159\249\255\255\253\237\35\0\0\1\224\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\
    \\7\0\0\0\0\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\248\255\255\255\255\7\4\0\0\1\240\255\255\255\255\255\3\0\32\0\
    \\0\255\255\255\255\255\255\255\255\255\1\255\253\255\255\255\127\0\0\1\0\0\0\0\0\252\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\127\251\255\255\255\255\1\
    \\0\64\0\0\0\191\253\255\255\255\3\0\1\0\0\0\0\0\0\0\0\0\0\0\0\244\255\253\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\
    \\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\1\255\255\255\
    \\127\0\0\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\63\0\0\255\255\223\255\255\255\223\255\255\127\255\255\255\127\255\255\255\253\255\255\255\253\255\255\247\15\0\0\0\
    \\0\0\0\255\255\255\255\255\255\255\255\15\8\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\239\255\255\255\150\254\247\10\132\234\150\170\150\247\247\
    \\94\255\251\255\15\238\251\255\15\0\0\0\0\0\0\0\0"#

isXID_StartOffsetsBitMap :: Ptr Word16
isXID_StartOffsetsBitMap = Ptr
    "\157\0\51\0\59\0\38\5\239\4\175\5\5\4\45\10\15\10\139\10\171\10\167\3\203\10\235\10\11\11\193\3\84\2\51\0\148\5\3\6\50\0\51\0\217\1\214\8\242\8\65\9\179\4\43\11\7\3\133\0\51\0\31\6\103\4\0\0\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\72\1\188\0\4\1\4\1\75\11\91\0\
    \\4\1\4\1\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\133\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\
    \\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\
    \\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\155\1\51\0\116\2\106\3\107\11\135\3\179\2\139\11\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\
    \\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\236\2\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\51\0\
    \\123\8\96\8\220\0\9\9\123\4\207\4\40\1\217\3\233\3\155\8\37\4\204\7\51\0\69\5\171\11\203\11\248\1\117\9\59\2\64\4\80\4\151\4\235\11\11\12\41\9\43\12\31\7\87\6\63\6\75\12\77\3\255\6\107\12\4\1\139\12\171\12\8\1\203\12\51\0\51\0\51\0\18\5\2\5\24\2\4\1\4\1\4\1\4\1\4\1\4\1\
    \\4\1\4\1\4\1\38\2\51\0\51\0\51\0\51\0\140\2\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\51\0\51\0\235\12\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\
    \\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\51\0\51\0\11\13\184\6\4\1\4\1\208\6\149\9\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\178\7\51\0\51\0\51\0\51\0\233\0\16\0\4\1\4\1\
    \\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\18\0\51\0\211\2\225\2\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\113\7\4\1\4\1\4\1\4\1\4\1\
    \\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\123\5\104\1\116\1\43\13\4\1\4\1\4\1\4\1\4\1\4\1\4\1\236\7\6\8\39\3\53\3\4\1\152\6\4\1\4\1\224\6\148\1\75\13\4\1\4\1\4\1\4\1\107\13\4\1\4\1\4\1\4\1\4\1\
    \\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\
    \\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\
    \\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\
    \\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\129\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\121\0\183\1\51\0\51\0\51\0\
    \\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\195\1\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\229\5\51\0\51\0\
    \\248\0\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\4\1\51\0\51\0\0\1\4\1\4\1\4\1\4\1\4\1\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\62\1\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\
    \\51\0\51\0\51\0\72\1"#

{-# INLINE isID_Continue #-}
isID_Continue :: Char -> Bool
isID_Continue c
    | c < '\x002F' = False
    | c < '\x323B0' = lookupIsID_ContinueBitMap (ord c)
    | c < '\xE0000' = False
    | c < '\xE01F0' = lookupIsID_ContinueBitMap (ord c - 0xADC50)
    | otherwise = False

{-# INLINE lookupIsID_ContinueBitMap #-}
lookupIsID_ContinueBitMap :: Int -> Bool
lookupIsID_ContinueBitMap n =
    lookupBit data# (
        lookupWord16AsInt offsets# (
            n `shiftR` 8
        ) + ((n `shiftR` 3) .&. mask)
    ) (n .&. 7)
    where
    mask = (1 `shiftL` 5) - 1
    !(Ptr data#) = isID_ContinueDataBitMap
    !(Ptr offsets#) = isID_ContinueOffsetsBitMap

isID_ContinueDataBitMap :: Ptr Int8
isID_ContinueDataBitMap = Ptr
    "\132\252\47\63\80\253\255\243\224\67\0\0\255\255\255\255\255\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\239\111\
    \\240\239\254\255\255\63\135\0\0\0\0\255\255\255\31\255\255\255\31\0\0\0\0\255\254\255\255\127\0\0\0\48\0\0\0\0\0\128\1\0\16\0\0\0\2\128\0\0\255\31\
    \\0\0\0\0\0\0\255\31\226\255\1\0\224\0\0\0\254\255\62\31\254\255\255\255\255\255\255\255\255\255\127\254\254\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\195\255\3\0\31\80\0\0\255\7\255\255\255\255\255\255\255\255\255\195\255\255\255\255\255\255\255\255\255\255\255\255\239\159\255\
    \\253\255\159\238\159\249\255\255\253\237\243\159\57\224\176\207\255\2\0\236\199\61\214\24\199\255\195\199\61\129\0\192\255\0\0\184\255\3\255\255\255\255\255\255\255\255\255\255\255\1\
    \\255\255\255\255\255\7\255\255\255\255\255\255\255\255\63\0\0\255\255\255\15\255\7\255\255\255\126\0\255\255\255\255\255\255\255\255\255\251\255\255\255\255\191\32\255\255\255\255\255\255\
    \\255\128\0\128\255\255\127\0\127\127\127\127\127\127\127\127\255\255\255\255\255\255\255\255\255\61\127\61\255\255\255\255\255\61\255\255\255\255\61\127\61\255\127\255\255\255\255\255\255\255\
    \\3\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\
    \\255\63\255\1\0\0\63\0\0\0\0\255\255\255\255\255\255\255\231\255\255\255\255\255\255\255\255\255\255\255\255\3\0\255\255\255\255\255\255\63\36\255\239\255\255\127\255\255\183\255\
    \\63\255\63\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\3\254\255\255\135\254\255\255\7\0\0\0\0\0\4\160\4\
    \\255\255\127\255\255\255\127\255\15\255\15\192\255\255\255\255\63\31\0\255\255\255\255\255\15\255\255\255\3\255\7\0\0\0\0\128\255\252\255\255\255\255\255\255\255\255\255\255\255\255\
    \\249\255\255\255\255\255\255\255\7\235\3\0\0\252\255\223\253\255\255\253\255\243\223\61\96\39\207\255\0\0\239\223\253\255\255\253\239\243\223\61\96\96\207\255\14\0\191\231\223\223\
    \\255\255\255\123\95\252\253\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\253\255\255\247\255\255\255\247\224\255\255\255\255\255\254\255\255\255\
    \\255\255\255\255\255\255\255\127\0\0\255\255\255\255\0\0\0\0\0\0\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\3\0\255\255\255\255\255\255\255\255\255\255\255\255\207\255\254\255\239\159\249\255\255\253\197\243\159\121\128\176\207\255\3\80\255\255\0\0\255\255\24\0\0\224\0\0\0\0\
    \\223\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\255\3\0\248\15\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\1\0\0\0\0\0\0\255\255\255\255\255\255\7\0\255\255\255\255\255\255\7\0\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\0\0\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\1\0\0\3\255\3\160\194\255\254\255\255\255\31\254\255\223\255\255\254\255\255\255\31\64\0\0\0\0\0\0\0\255\3\
    \\254\255\255\135\254\255\255\7\224\255\255\255\255\255\255\255\255\255\255\127\252\252\252\28\0\0\0\0\255\255\255\255\255\255\255\0\255\227\255\255\255\255\255\63\255\1\255\255\255\255\
    \\255\231\0\0\247\255\255\255\255\7\0\4\0\0\0\39\0\240\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\15\0\255\255\127\248\255\255\255\255\255\15\255\255\255\255\255\255\255\127\255\255\255\159\255\3\255\3\128\0\255\191\255\127\0\0\0\0\0\0\255\255\255\255\255\31\255\63\255\67\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\127\0\0\255\255\255\255\255\255\255\3\255\255\255\255\255\0\255\3\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\27\3\0\0\0\0\0\0\0\0\224\255\255\255\255\255\255\255\255\255\255\255\255\255\127\0\0\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\31\255\255\255\255\255\255\1\0\1\0\
    \\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\251\252\255\255\255\255\255\255\255\255\255\255\255\255\255\255\223\188\192\215\255\255\251\255\255\255\255\255\255\255\255\255\
    \\191\255\223\253\255\255\255\255\255\223\125\240\128\207\255\0\252\238\255\127\252\255\255\251\47\127\132\95\255\192\255\12\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\31\0\0\0\0\0\0\0\0\255\255\255\255\255\63\255\255\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\224\227\7\248\231\15\0\0\0\
    \\60\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\3\255\255\255\255\255\0\255\255\255\255\255\255\15\0\255\247\255\
    \\247\183\255\251\255\251\27\0\0\0\0\0\0\0\0\28\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\224\227\7\248\231\15\0\0\0\60\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\127\111\255\127\242\111\255\255\255\191\249\15\0\255\3\0\0\0\0\0\0\0\0\
    \\255\252\255\255\255\255\255\252\27\0\0\0\255\255\255\255\255\63\255\255\255\255\15\0\255\255\255\31\255\255\255\255\255\255\255\255\1\128\255\3\255\255\255\127\251\255\255\255\255\127\
    \\180\255\0\255\3\191\253\255\255\255\127\251\1\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\127\0\191\231\223\
    \\223\255\255\255\123\95\252\253\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\223\255\255\255\255\255\255\255\255\223\100\222\255\235\239\255\255\255\255\255\255\
    \\255\255\255\3\255\255\255\255\255\255\255\255\255\63\255\255\255\255\191\32\255\255\255\255\255\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\1\0\255\255\61\255\255\255\255\255\255\255\255\231\0\254\3\0\255\255\0\0\255\255\
    \\255\255\255\255\255\255\255\255\63\63\255\255\255\255\63\63\255\170\255\255\255\63\255\255\255\255\255\255\223\95\220\31\207\15\255\31\220\31\255\255\253\255\255\255\255\199\7\0\255\3\
    \\0\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\127\0\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\
    \\255\255\255\255\255\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\32\255\255\255\255\255\255\127\0\15\0\255\3\248\255\255\224\255\255\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\3\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\248\15\0\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\251\252\255\255\255\255\255\255\255\255\255\255\255\255\255\255\254\255\255\255\127\2\255\255\255\255\255\1\254\255\255\255\255\191\182\0\255\255\255\135\
    \\7\0\255\255\223\255\255\255\223\255\255\127\255\255\255\127\255\255\255\253\255\255\255\253\255\255\247\207\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\
    \\255\255\253\255\255\247\255\255\255\247\255\255\223\255\255\255\223\255\255\127\255\255\255\127\255\255\255\253\255\255\255\253\255\255\247\207\255\255\255\255\255\255\127\248\255\255\255\255\255\31\
    \\32\0\16\0\0\248\254\255\0\0\0\0\0\0\0\0\0\0\255\255\255\31\128\0\255\255\255\255\1\0\0\0\255\255\63\0\0\0\0\0\255\255\31\0\0\0\255\255\127\0\
    \\248\224\255\253\127\95\219\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\248\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\3\0\0\0\0\127\0\248\224\255\253\127\95\219\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\248\255\255\255\255\255\255\255\63\0\0\255\255\255\255\255\255\
    \\255\255\252\255\255\255\255\255\255\0\0\0\0\0\255\15\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\1\0\255\255\255\255\
    \\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\223\188\192\215\255\255\251\255\
    \\255\255\255\255\255\255\255\255\191\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\195\255\3\0\31\80\0\0\255\255\255\255\255\255\255\255\255\
    \\135\255\255\255\255\255\255\255\128\255\255\0\0\0\0\0\0\0\0\27\0\3\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\238\135\249\255\255\253\109\211\135\57\2\94\192\255\63\0\238\191\251\255\255\253\237\243\191\59\1\0\207\255\0\254\254\255\255\255\255\255\255\7\255\127\255\3\0\0\
    \\0\0\214\247\255\255\175\255\255\63\95\127\255\243\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\159\255\255\254\255\255\7\255\255\255\255\255\255\255\255\255\199\255\1\
    \\255\255\63\128\255\255\31\0\255\255\15\0\255\223\13\0\255\255\255\255\255\255\255\255\255\255\143\48\255\3\0\0\255\31\255\255\255\15\0\0\255\255\255\255\255\255\240\191\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\3\0\255\255\255\255\255\16\0\0\255\255\255\255\255\255\15\0\255\255\255\255\255\255\255\255\63\0\255\3\255\255\255\232\255\255\255\255\
    \\255\255\127\0\255\63\255\3\255\255\127\252\255\255\255\255\255\255\255\255\7\0\0\56\255\255\124\0\126\126\126\0\127\127\255\255\255\255\255\247\255\3\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\55\255\3\255\255\255\255\0\224\255\255\255\7\255\255\255\255\255\7\255\255\255\63\255\255\255\255\15\255\62\0\0\0\0\0\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\63\255\3\255\255\255\255\15\255\255\255\255\15\255\255\255\255\255\255\127\0\255\255\63\0\255\0\0\0\191\255\255\255\255\255\253\7\0\0\
    \\0\0\0\0\0\0\63\253\255\255\255\255\191\145\255\255\63\0\255\255\127\0\255\255\255\127\0\0\0\0\0\0\0\0\255\255\55\0\255\255\63\0\255\255\255\3\0\0\0\0\
    \\0\0\0\0\255\255\255\255\255\255\255\192\0\0\0\0\0\0\0\0\255\255\255\255\255\255\63\0\255\255\63\0\255\255\7\0\255\255\3\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\255\255\255\255\255\255\255\255\127\0\0\0\192\255\63\128\255\255\255\255\255\255\255\7\4\0\255\255\255\1\255\3\255\255\255\255\255\255\223\255\240\0\255\255\255\255\79\0\
    \\255\255\255\255\255\255\255\255\31\222\255\23\0\0\0\0\255\255\251\255\255\255\255\192\3\0\0\0\0\0\0\0\127\189\255\191\255\1\255\255\255\255\255\255\255\7\255\3\239\159\
    \\249\255\255\253\237\251\159\57\129\224\207\31\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\7\255\195\3\0\0\0\255\255\255\255\
    \\255\255\255\255\191\0\255\3\0\0\0\0\255\255\255\255\255\255\255\255\17\0\255\3\0\0\0\0\255\255\255\255\255\255\255\1\255\3\0\0\0\0\0\0\255\255\255\231\255\15\
    \\255\3\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\7\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\
    \\255\255\255\255\255\3\0\128\255\255\255\255\255\255\255\127\128\0\255\255\255\255\255\255\255\255\255\35\0\0\255\255\255\255\255\255\255\255\255\1\255\253\255\255\255\255\127\255\1\0\
    \\255\3\0\0\252\255\255\255\252\255\255\254\127\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\255\255\255\255\255\255\255\1\255\255\255\127\255\3\255\255\255\255\255\255\255\255\255\127\255\3\255\255\255\63\31\0\255\255\255\255\255\255\255\255\255\255\255\255\255\7\
    \\255\31\255\1\255\99\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\127\224\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\127\255\255\249\219\7\255\255\255\255\255\255\255\63\0\0\0\128\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\31\0\127\0\0\0\0\0\255\255\255\255\255\255\255\255\255\15\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\239\255\255\255\
    \\150\254\247\10\132\234\150\170\150\247\247\94\255\251\255\15\238\251\255\15\0\0\0\0\0\0\0\0"#

isID_ContinueOffsetsBitMap :: Ptr Word16
isID_ContinueOffsetsBitMap = Ptr
    "\14\2\133\0\141\0\40\5\22\5\122\8\171\0\153\1\3\1\242\2\94\10\203\0\102\2\71\5\126\10\198\3\208\6\133\0\60\1\36\7\132\0\133\0\158\10\190\10\234\0\41\2\84\4\40\3\4\4\133\0\133\0\64\7\80\0\0\0\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\64\8\32\1\244\1\244\1\112\0\178\2\
    \\244\1\244\1\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\99\1\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\
    \\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\
    \\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\103\5\133\0\222\10\71\2\254\10\76\6\30\11\62\11\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\
    \\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\56\4\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\133\0\
    \\71\9\44\9\133\0\130\9\18\3\228\3\185\1\199\7\246\4\94\11\126\11\203\5\133\0\158\11\190\11\222\11\49\0\254\11\97\3\162\4\178\4\14\9\30\12\62\12\94\12\126\12\158\12\123\1\190\12\222\12\254\12\44\6\30\13\244\1\62\13\107\6\129\6\96\7\133\0\133\0\133\0\226\4\210\4\62\3\244\1\244\1\244\1\244\1\244\1\244\1\
    \\244\1\244\1\244\1\76\3\133\0\133\0\133\0\133\0\154\3\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\133\0\133\0\94\13\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\
    \\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\133\0\133\0\126\13\231\7\244\1\244\1\255\7\31\10\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\129\3\133\0\133\0\133\0\133\0\217\1\16\0\244\1\244\1\
    \\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\18\0\133\0\31\4\45\4\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\158\13\244\1\244\1\244\1\244\1\244\1\
    \\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\129\5\244\1\149\5\227\5\244\1\183\6\134\2\146\2\154\8\244\1\244\1\238\8\244\1\244\1\244\1\244\1\190\13\222\13\116\4\130\4\244\1\171\5\244\1\244\1\13\6\254\13\30\14\244\1\244\1\244\1\244\1\62\14\244\1\244\1\244\1\244\1\244\1\
    \\244\1\244\1\244\1\244\1\244\1\244\1\244\1\246\1\244\1\244\1\244\1\244\1\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\
    \\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\
    \\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\
    \\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\95\1\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\87\1\208\2\133\0\133\0\133\0\
    \\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\220\2\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\6\7\133\0\133\0\
    \\232\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\244\1\133\0\133\0\240\1\244\1\244\1\244\1\244\1\244\1\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\207\1\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\133\0\
    \\133\0\133\0\133\0\101\1\72\3\133\0"#

{-# INLINE isID_Start #-}
isID_Start :: Char -> Bool
isID_Start c = c >= '\x0041' && c <= '\x323AF' && lookupIsID_StartBitMap (ord c)

{-# INLINE lookupIsID_StartBitMap #-}
lookupIsID_StartBitMap :: Int -> Bool
lookupIsID_StartBitMap n =
    lookupBit data# (
        lookupWord16AsInt offsets# (
            n `shiftR` 8
        ) + ((n `shiftR` 3) .&. mask)
    ) (n .&. 7)
    where
    mask = (1 `shiftL` 5) - 1
    !(Ptr data#) = isID_StartDataBitMap
    !(Ptr offsets#) = isID_StartOffsetsBitMap

isID_StartDataBitMap :: Ptr Int8
isID_StartDataBitMap = Ptr
    "\132\252\47\63\80\253\255\243\224\67\0\0\255\255\255\255\255\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\239\111\
    \\254\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\195\255\3\0\31\80\0\0\224\255\255\255\255\255\254\255\255\
    \\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\0\0\0\0\0\0\255\255\255\255\255\255\255\3\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\0\0\0\0\0\0\0\0\254\255\255\7\254\255\255\7\0\0\0\0\0\4\32\4\255\255\127\255\255\255\127\255\255\255\255\191\32\255\255\255\255\255\255\
    \\255\128\0\0\255\255\127\0\127\127\127\127\127\127\127\127\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\252\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\7\
    \\0\255\239\255\255\127\255\255\183\255\63\255\63\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\31\120\12\0\191\231\223\223\255\255\255\123\95\252\253\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\
    \\255\253\255\255\247\255\255\255\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\255\255\255\255\255\63\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\255\255\255\255\255\255\255\255\255\255\255\255\255\159\255\255\254\255\255\7\255\255\
    \\255\255\255\255\255\255\255\199\255\1\0\239\254\255\255\63\0\0\0\0\0\255\255\255\31\255\255\255\31\0\0\0\0\255\254\255\255\31\0\0\0\255\255\255\255\255\255\255\255\15\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\1\0\0\0\0\0\0\255\255\255\255\255\255\7\0\
    \\255\255\255\255\255\255\7\0\128\0\0\63\60\98\192\225\255\3\64\0\0\255\255\255\255\191\32\255\255\255\255\255\247\255\31\255\255\0\12\0\0\255\255\255\255\255\127\0\128\255\
    \\255\255\63\255\255\255\255\255\255\255\255\255\255\0\0\126\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\
    \\255\1\0\0\247\15\0\0\255\255\127\196\255\255\255\255\255\255\98\62\5\0\0\56\255\7\28\0\255\255\255\255\7\0\4\0\0\0\39\0\240\0\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\255\255\127\248\255\255\255\255\255\15\0\0\0\0\224\0\252\255\255\255\63\255\1\255\255\
    \\255\255\255\231\0\0\0\0\0\222\111\4\255\255\255\255\255\31\128\63\0\64\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\63\0\0\
    \\255\255\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\0\128\255\252\255\255\255\255\255\255\255\255\255\255\255\255\249\255\255\255\
    \\255\255\255\255\7\235\3\0\0\252\255\255\63\0\255\255\127\0\0\0\255\255\255\31\240\255\255\255\255\255\7\0\0\128\0\0\223\255\0\124\224\159\249\255\255\253\237\35\0\0\
    \\0\176\3\0\2\0\232\199\61\214\24\199\255\3\0\0\1\0\0\0\0\0\0\0\255\254\255\255\255\31\0\0\0\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\
    \\255\255\255\255\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\31\255\255\255\255\255\255\1\0\0\0\0\0\255\255\255\255\255\7\0\0\0\192\254\255\
    \\255\255\255\255\255\255\255\255\255\255\47\0\96\192\0\156\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\0\0\255\255\255\255\15\255\255\255\255\15\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\3\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\128\0\0\
    \\255\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\223\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\128\0\255\255\63\0\0\0\0\0\255\255\3\0\0\0\
    \\0\0\255\255\31\0\0\0\255\255\127\0\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\0\128\0\0\0\0\0\0\0\0\0\0\0\254\255\255\7\254\255\255\7\192\255\
    \\255\255\255\255\255\255\255\255\255\127\252\252\252\28\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\223\188\64\215\255\255\251\255\255\255\255\255\255\255\255\255\191\255\255\255\255\255\255\127\0\255\255\63\0\255\0\0\
    \\0\191\255\255\255\255\255\253\7\0\0\0\0\0\0\0\0\191\231\223\223\255\255\255\123\95\252\253\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\223\
    \\255\255\255\255\255\255\255\255\223\100\222\255\235\239\255\255\255\255\255\255\255\255\255\61\127\61\255\255\255\255\255\61\255\255\255\255\61\127\61\255\127\255\255\255\255\255\255\254\255\255\
    \\255\127\2\255\255\255\255\255\1\0\0\0\0\0\0\0\0\255\255\255\135\7\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\1\0\255\255\61\255\255\255\255\255\255\255\255\7\0\0\0\0\255\255\0\0\255\255\255\255\255\
    \\255\255\255\255\255\63\63\255\255\255\255\63\63\255\170\255\255\255\63\255\255\255\255\255\255\223\95\220\31\207\15\255\31\220\31\255\255\255\255\255\255\0\0\16\0\0\0\0\0\0\
    \\0\255\255\255\255\255\7\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\127\0\0\0\0\0\15\0\0\0\0\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\255\255\255\15\0\0\255\255\255\255\255\255\0\0\15\0\0\0\248\255\255\224\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\127\111\255\127\242\111\255\255\255\0\128\2\0\0\0\0\0\0\0\0\0\0\0\255\252\255\
    \\255\255\255\1\0\10\0\0\0\255\255\255\255\255\255\31\0\128\7\0\128\3\0\0\0\255\255\255\255\255\255\0\0\176\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\255\255\255\255\255\127\0\0\0\0\0\15\0\0\0\0\255\255\255\255\255\255\255\255\255\255\223\255\255\255\255\255\255\255\255\223\100\222\255\235\239\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\7\255\31\255\1\255\3\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\3\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\0\255\255\255\255\255\255\15\0\255\247\255\247\
    \\183\255\251\255\251\27\0\0\0\0\0\0\0\0\255\255\255\127\224\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\
    \\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\31\128\63\0\64\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\127\0\248\160\255\253\127\95\219\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\3\0\0\0\248\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\0\127\0\248\160\255\253\127\95\219\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\248\255\255\255\255\255\255\255\63\0\0\255\255\255\255\255\255\255\255\252\255\255\255\255\255\255\0\0\0\0\0\255\15\255\255\
    \\255\255\0\224\255\255\255\7\255\255\255\255\63\0\255\255\255\63\255\255\255\255\15\255\62\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\31\255\255\255\255\255\
    \\255\1\0\0\0\0\0\255\255\3\128\255\255\3\0\255\255\3\0\255\223\1\0\255\255\255\255\255\255\15\0\0\0\128\16\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\
    \\1\255\255\255\255\255\5\255\255\255\255\255\255\255\255\63\0\255\255\63\0\255\255\7\0\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\251\255\255\15\0\128\1\
    \\0\0\0\0\0\0\0\127\189\255\191\255\1\255\255\255\255\255\127\0\0\0\0\0\0\255\255\255\63\31\0\255\255\255\255\255\15\255\255\255\3\0\0\0\0\0\0\255\255\255\
    \\255\255\255\255\255\255\255\255\1\255\255\255\255\255\5\255\255\255\255\255\255\255\255\63\0\255\255\255\3\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\192\0\0\0\0\0\
    \\0\0\0\255\255\255\255\255\255\255\255\255\7\1\0\0\0\0\0\0\0\248\255\0\0\0\0\0\0\0\0\11\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\7\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\63\4\16\1\0\0\255\255\255\1\255\7\255\255\255\126\0\0\255\255\255\255\255\
    \\3\0\0\0\0\0\0\253\255\255\255\0\0\0\224\255\255\255\255\255\255\255\255\255\255\63\0\2\0\0\252\255\255\255\7\48\4\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\1\0\255\255\255\255\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\240\
    \\255\255\255\255\255\255\35\0\0\1\255\3\0\254\255\225\159\249\255\255\253\197\35\0\64\0\176\3\0\3\16\224\135\249\255\255\253\109\3\0\0\0\94\0\0\28\0\224\191\251\
    \\255\255\253\237\35\0\0\1\0\3\0\0\2\224\223\253\255\255\253\255\35\0\0\0\39\3\0\0\0\225\223\253\255\255\253\239\35\0\0\0\96\3\0\6\0\240\223\253\255\255\
    \\255\255\39\0\64\112\128\3\0\0\252\224\255\127\252\255\255\251\47\127\0\0\0\0\0\0\0\254\255\255\255\255\255\13\0\127\0\0\0\0\0\0\0\214\247\255\255\175\255\13\
    \\32\95\0\0\240\0\0\0\0\224\255\255\255\255\255\15\0\224\31\0\0\0\0\0\0\248\255\255\255\1\192\0\252\255\255\255\255\63\0\0\0\224\0\0\0\254\3\62\31\254\
    \\255\255\255\255\255\255\255\255\255\127\248\254\255\255\255\255\255\255\255\255\255\255\247\187\247\255\255\7\0\0\0\255\255\255\255\255\255\15\0\252\255\255\255\255\255\15\0\0\0\0\
    \\0\0\0\252\104\126\126\126\0\127\127\255\255\255\255\255\247\255\3\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\0\0\0\63\253\255\255\255\255\191\145\255\255\63\0\255\
    \\255\127\0\255\255\255\127\0\0\0\0\0\0\0\0\255\255\55\0\248\255\255\255\255\255\255\0\0\0\0\0\0\0\38\0\248\255\255\255\255\255\0\0\0\0\255\255\255\1\0\
    \\0\248\255\255\255\127\0\0\0\144\0\255\255\255\255\71\0\248\255\255\255\255\255\7\0\30\0\0\20\0\0\0\0\224\159\249\255\255\253\237\35\0\0\1\224\3\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\7\0\0\0\0\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\248\255\
    \\255\255\255\7\4\0\0\1\240\255\255\255\255\255\3\0\32\0\0\255\255\255\255\255\255\255\255\255\1\255\253\255\255\255\127\0\0\1\0\0\0\0\0\252\255\255\255\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\127\251\255\255\255\255\1\0\64\0\0\0\191\253\255\255\255\3\0\1\0\0\0\0\0\0\0\0\0\0\0\0\244\255\253\255\255\255\15\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\255\255\255\255\255\255\255\1\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\63\0\0\255\255\223\255\255\255\223\255\255\127\255\
    \\255\255\127\255\255\255\253\255\255\255\253\255\255\247\15\0\0\0\0\0\0\255\255\255\255\255\255\255\255\15\8\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\239\255\255\255\150\254\247\10\132\234\150\170\150\247\247\94\255\251\255\15\238\251\255\15\0\0\0\0\0\0\0\0"#

isID_StartOffsetsBitMap :: Ptr Word16
isID_StartOffsetsBitMap = Ptr
    "\157\0\51\0\59\0\24\5\220\0\161\5\10\4\95\10\65\10\189\10\221\10\172\3\253\10\29\11\61\11\198\3\89\2\51\0\134\5\245\5\50\0\51\0\222\1\3\9\31\9\111\9\184\4\93\11\12\3\133\0\51\0\17\6\108\4\0\0\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\77\1\188\0\9\1\9\1\125\11\91\0\
    \\9\1\9\1\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\133\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\
    \\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\
    \\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\160\1\51\0\121\2\111\3\157\11\140\3\184\2\189\11\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\
    \\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\241\2\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\51\0\
    \\109\8\82\8\51\0\168\8\128\4\212\4\45\1\222\3\238\3\200\8\42\4\190\7\51\0\55\5\221\11\167\9\253\1\55\9\64\2\69\4\85\4\156\4\253\11\29\12\87\9\61\12\17\7\73\6\49\6\93\12\82\3\241\6\125\12\9\1\157\12\189\12\13\1\221\12\51\0\51\0\51\0\4\5\244\4\29\2\9\1\9\1\9\1\9\1\9\1\9\1\
    \\9\1\9\1\9\1\43\2\51\0\51\0\51\0\51\0\145\2\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\51\0\51\0\253\12\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\
    \\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\51\0\51\0\29\13\170\6\9\1\9\1\194\6\199\9\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\164\7\51\0\51\0\51\0\51\0\238\0\16\0\9\1\9\1\
    \\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\18\0\51\0\216\2\230\2\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\99\7\9\1\9\1\9\1\9\1\9\1\
    \\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\109\5\109\1\121\1\61\13\9\1\9\1\9\1\9\1\9\1\9\1\9\1\222\7\248\7\44\3\58\3\9\1\138\6\9\1\9\1\210\6\153\1\93\13\9\1\9\1\9\1\9\1\125\13\9\1\9\1\9\1\9\1\9\1\
    \\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\
    \\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\
    \\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\
    \\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\129\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\121\0\188\1\51\0\51\0\51\0\
    \\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\200\1\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\215\5\51\0\51\0\
    \\253\0\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\9\1\51\0\51\0\5\1\9\1\9\1\9\1\9\1\9\1\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\67\1\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\51\0\
    \\51\0\51\0\51\0\77\1"#

{-# INLINE isUppercase #-}
isUppercase :: Char -> Bool
isUppercase c = c >= '\x0041' && c <= '\x1F189' && lookupIsUppercaseBitMap (ord c)

{-# INLINE lookupIsUppercaseBitMap #-}
lookupIsUppercaseBitMap :: Int -> Bool
lookupIsUppercaseBitMap n =
    lookupBit data# (
        lookupWord16AsInt offsets# (
            n `shiftR` 8
        ) + ((n `shiftR` 3) .&. mask)
    ) (n .&. 7)
    where
    mask = (1 `shiftL` 5) - 1
    !(Ptr data#) = isUppercaseDataBitMap
    !(Ptr offsets#) = isUppercaseOffsetsBitMap

isUppercaseDataBitMap :: Ptr Int8
isUppercaseDataBitMap = Ptr
    "\255\255\255\255\255\255\0\0\0\0\0\0\85\85\85\85\1\84\85\85\85\85\85\85\171\42\85\85\85\85\85\85\254\255\255\255\127\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\255\255\255\255\255\231\0\0\0\0\0\0\0\0\85\85\85\85\85\21\0\0\85\85\85\5\0\0\0\0\0\0\0\0\0\0\0\0\240\255\255\31\
    \\0\0\0\192\255\255\127\0\0\0\0\255\255\255\1\0\0\0\4\0\0\0\0\0\0\254\255\255\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\255\255\255\255\255\255\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\0\0\0\0\0\0\0\0\254\255\255\7\0\0\0\0\
    \\0\0\0\0\0\0\0\0\255\255\127\127\0\0\0\0\255\0\63\0\255\0\255\0\63\0\170\0\255\0\0\0\0\0\0\0\0\0\15\0\15\0\15\0\31\0\15\85\85\85\
    \\85\85\85\85\170\170\84\85\85\85\85\85\43\214\206\219\177\213\210\174\17\144\164\170\74\85\85\210\85\85\85\85\85\85\85\85\85\85\85\85\85\85\85\85\85\85\21\64\85\85\
    \\85\85\85\85\85\85\85\85\85\85\254\255\255\255\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\192\255\255\
    \\255\0\0\0\0\0\0\255\255\255\3\255\255\255\3\255\255\255\3\255\255\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\255\255\255\255\191\32\0\0\0\0\0\0\84\85\84\85\85\85\85\85\85\85\0\106\85\40\69\85\85\125\95\85\245\2\65\1\0\0\32\0\85\85\85\85\
    \\85\85\5\108\122\85\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\255\255\255\255\255\255\255\255\255\255\63\0\132\56\39\62\80\61\15\192\32\0\0\0\255\255\0\0\8\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\247\255\247\
    \\55\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\69\128\64\215\254\255\251\15\0\0\0\128\
    \\28\85\85\85\144\230\176\231\223\31\0\0\0\123\95\252\1\0\0\240\255\255\63\0\0\0\255\255\255\3\0\0\240\255\255\63\0\0\0\255\255\255\3\0\0\0\255\255\255\1\
    \\0\0\0\252\255\255\7\176\231\223\31\0\0\0\123\95\252\1\0\0\240\255\255\63\0\0\0\255\255\255\3\0\0\240\255\255\63\0\0\0\255\255\255\3\0\0\208\100\222\63\
    \\0\0\0\255\255\255\3\0\0\255\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\255\247\255\247\55\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\3\0\0\240\255\255\63\0\0\0\255\255\255\3\0\0\208\100\222\63\0\0\0\255\255\255\3\0\0\
    \\0\0\0\0\0\0\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\0\0\0\0\0\0\157\234\37\192\85\85\85\85\
    \\85\85\85\85\85\85\85\85\5\40\4\0"#

isUppercaseOffsetsBitMap :: Ptr Word16
isUppercaseOffsetsBitMap = Ptr
    "\184\0\247\0\190\1\62\2\0\0\26\0\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\130\1\59\1\59\1\226\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\40\0\59\1\22\1\215\0\59\1\2\2\59\1\59\1\69\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\62\3\59\1\59\1\59\1\59\1\59\1\
    \\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\
    \\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\
    \\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\64\0\158\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\
    \\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\
    \\59\1\59\1\59\1\59\1\59\1\121\0\59\1\59\1\59\1\59\1\197\2\20\2\59\1\59\1\59\1\59\1\59\1\59\1\137\0\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\160\0\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\
    \\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\
    \\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\214\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\
    \\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\
    \\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\165\2\94\2\113\2\93\0\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\113\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\95\1"#

{-# INLINE isLowercase #-}
isLowercase :: Char -> Bool
isLowercase c = c >= '\x0061' && c <= '\x1E943' && lookupIsLowercaseBitMap (ord c)

{-# INLINE lookupIsLowercaseBitMap #-}
lookupIsLowercaseBitMap :: Int -> Bool
lookupIsLowercaseBitMap n =
    lookupBit data# (
        lookupWord16AsInt offsets# (
            n `shiftR` 8
        ) + ((n `shiftR` 3) .&. mask)
    ) (n .&. 7)
    where
    mask = (1 `shiftL` 5) - 1
    !(Ptr data#) = isLowercaseDataBitMap
    !(Ptr offsets#) = isLowercaseOffsetsBitMap

isLowercaseDataBitMap :: Ptr Int8
isLowercaseDataBitMap = Ptr
    "\170\170\170\170\170\170\170\85\85\171\170\170\170\170\170\212\41\49\36\78\42\45\81\230\64\82\85\181\170\170\41\170\170\170\170\170\170\250\147\133\170\255\255\255\255\255\255\255\255\239\
    \\255\255\255\255\1\3\0\0\0\31\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\252\255\255\15\0\0\192\223\
    \\255\255\0\0\0\252\255\255\15\0\0\192\235\239\255\0\0\0\252\255\255\223\15\0\0\192\255\255\127\63\0\0\0\255\255\255\253\0\0\0\252\255\255\247\11\0\0\0\0\0\
    \\0\255\255\255\255\255\255\170\170\170\170\2\168\170\170\170\170\170\170\84\213\170\170\170\170\170\170\0\0\0\0\0\0\255\255\255\255\255\1\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\255\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\15\255\251\255\127\224\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\252\255\255\255\15\127\0\248\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\247\255\3\255\255\255\255\255\255\255\255\255\255\0\0\0\0\
    \\0\0\0\0\32\0\0\0\0\0\138\60\0\0\1\0\0\240\255\255\255\127\227\170\170\170\47\25\255\255\255\255\191\32\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\63\0\196\8\0\
    \\0\128\16\50\192\67\0\0\0\0\255\255\16\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\3\0\0\0\0\168\170\171\
    \\170\170\170\170\170\170\170\255\149\170\80\186\170\170\130\160\170\10\5\170\2\0\0\92\7\170\170\170\170\170\170\170\170\170\170\170\170\170\170\170\170\170\170\234\191\170\170\170\170\170\
    \\170\170\170\170\170\170\170\0\0\0\0\0\0\255\255\255\255\255\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\255\255\255\255\255\255\7\0\0\196\8\0\0\128\16\50\192\67\0\0\0\0\255\255\16\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\128\0\0\255\31\0\0\0\
    \\0\0\0\0\0\0\0\0\0\254\255\255\7\0\0\0\0\0\4\32\4\0\0\0\128\255\255\127\255\15\0\0\192\255\255\255\0\0\0\252\255\255\15\0\0\192\255\255\255\0\
    \\0\0\252\255\255\15\0\0\192\255\255\255\0\0\0\252\255\255\63\0\0\0\252\255\255\247\3\0\0\240\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\128\255\251\255\251\27\0\0\0\0\
    \\0\0\0\0\170\170\170\170\170\42\0\0\170\170\170\58\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\185\255\255\255\255\255\253\7\0\0\0\0\0\0\0\0\254\255\
    \\255\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\98\21\218\63\170\170\170\170\170\170\170\170\170\170\170\170\26\80\8\0\255\0\
    \\63\0\255\0\255\0\63\0\255\0\255\0\255\63\255\0\255\0\255\0\223\64\220\0\207\0\255\0\220\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\128\0\0\255\31\0\
    \\0\0\0\0\0\0\0\0\0\0\0"#

isLowercaseOffsetsBitMap :: Ptr Word16
isLowercaseOffsetsBitMap = Ptr
    "\135\2\0\0\31\0\90\1\145\0\171\0\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\46\1\40\1\40\1\158\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\242\2\218\2\13\2\130\3\115\2\190\1\40\1\40\1\207\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\98\3\122\1\40\1\40\1\40\1\40\1\
    \\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\
    \\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\
    \\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\28\3\237\1\40\1\40\1\40\1\66\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\
    \\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\
    \\40\1\37\1\40\1\40\1\40\1\72\3\40\1\40\1\40\1\40\1\198\0\4\3\40\1\48\3\40\1\40\1\40\1\40\1\65\2\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\130\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\
    \\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\
    \\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\60\0\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\
    \\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\
    \\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\89\0\167\2\186\2\119\0\40\1\40\1\40\1\40\1\40\1\40\1\40\1\230\0\0\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\28\1"#

{-# INLINE isAlphabetic #-}
isAlphabetic :: Char -> Bool
isAlphabetic c = c >= '\x0041' && c <= '\x323AF' && lookupIsAlphabeticBitMap (ord c)

{-# INLINE lookupIsAlphabeticBitMap #-}
lookupIsAlphabeticBitMap :: Int -> Bool
lookupIsAlphabeticBitMap n =
    lookupBit data# (
        lookupWord16AsInt offsets# (
            n `shiftR` 8
        ) + ((n `shiftR` 3) .&. mask)
    ) (n .&. 7)
    where
    mask = (1 `shiftL` 5) - 1
    !(Ptr data#) = isAlphabeticDataBitMap
    !(Ptr offsets#) = isAlphabeticOffsetsBitMap

isAlphabeticDataBitMap :: Ptr Int8
isAlphabeticDataBitMap = Ptr
    "\132\252\47\62\80\189\255\243\224\67\0\0\255\255\255\255\255\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\239\111\
    \\240\239\254\255\255\63\0\0\0\0\0\255\255\255\31\255\255\255\31\0\0\0\0\255\254\255\255\31\0\0\0\254\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\195\255\3\0\31\80\0\0\255\7\255\255\255\255\255\255\255\254\0\192\255\255\255\255\255\255\255\255\255\255\255\255\239\31\254\225\
    \\0\156\224\255\255\255\255\255\254\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\0\0\0\0\0\0\255\255\255\252\255\31\0\0\255\255\255\1\255\7\255\255\255\126\
    \\0\0\255\255\255\255\255\3\240\255\248\3\255\255\255\255\191\32\255\255\255\255\255\255\255\128\0\0\255\255\127\0\127\127\127\127\127\127\127\127\255\255\255\255\255\255\255\3\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\0\0\0\0\128\255\31\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\3\252\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\255\255\127\0\255\239\255\255\127\255\255\183\255\63\255\63\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\120\12\0\191\231\223\223\255\255\255\123\95\252\253\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\253\255\255\247\255\255\255\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\0\0\
    \\0\0\0\0\0\0\255\255\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\159\255\255\254\255\255\7\255\255\255\255\255\255\255\255\255\199\255\1\255\255\255\255\255\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\1\0\0\0\0\0\0\255\255\255\255\255\255\7\0\255\255\255\255\255\255\7\0\240\0\255\255\255\255\71\0\255\
    \\255\255\255\255\255\255\255\30\192\0\20\0\0\0\0\254\255\255\7\254\255\255\7\192\255\255\255\255\255\255\255\255\255\255\127\252\252\252\28\0\0\0\0\255\255\255\255\255\255\0\
    \\224\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\252\255\255\255\7\48\4\255\31\255\255\0\12\0\0\255\255\255\255\255\127\240\143\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\0\0\126\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\1\0\0\0\0\0\0\0\0\
    \\0\0\0\0\255\255\255\255\255\255\255\255\0\0\0\128\255\252\255\255\255\255\255\255\255\255\255\255\255\255\249\255\255\255\255\255\255\255\7\235\3\0\0\252\255\255\255\7\255\255\
    \\255\255\7\0\255\255\255\31\255\255\255\255\255\255\247\255\0\128\0\0\255\255\0\124\255\255\255\255\7\0\4\0\0\0\39\0\240\0\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\255\255\127\248\255\255\255\255\255\15\255\255\255\255\255\255\255\127\254\255\31\0\0\0\0\0\128\0\0\
    \\128\1\112\0\0\0\0\0\0\255\255\255\255\255\31\128\63\0\64\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\63\0\0\255\255\255\
    \\255\255\15\0\0\255\255\251\255\255\255\159\192\3\0\0\0\0\0\0\0\127\189\255\191\255\1\255\255\255\255\255\255\255\1\0\0\0\0\0\0\0\255\254\255\255\255\31\254\255\
    \\15\255\255\254\255\255\255\31\0\0\0\0\0\0\0\0\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\31\255\255\255\255\255\255\
    \\1\0\0\0\0\0\238\159\249\255\255\253\237\227\159\25\192\176\15\0\2\0\236\199\61\214\24\199\255\195\199\29\129\0\0\0\0\0\128\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\255\255\255\255\255\27\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\223\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\128\0\255\255\63\0\0\0\0\0\255\
    \\255\3\0\0\0\0\0\255\255\31\0\0\0\255\255\127\0\255\255\255\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\128\0\0\255\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\192\255\255\255\255\
    \\255\255\3\0\0\191\231\223\223\255\255\255\123\95\252\253\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\223\255\255\255\255\255\255\255\255\223\100\222\255\
    \\235\239\255\255\255\255\255\255\255\239\255\223\225\255\15\0\254\255\239\159\249\255\255\253\197\227\159\89\128\176\15\0\3\16\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\3\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\1\0\255\255\255\255\255\255\254\255\255\255\127\2\255\255\
    \\255\255\255\1\0\0\0\0\255\191\182\0\255\255\255\135\7\0\255\255\255\255\255\255\255\127\17\0\0\0\0\0\0\0\255\255\255\255\255\255\63\1\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\255\255\255\255\255\255\63\127\0\0\0\63\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\15\0\0\255\255\255\255\255\255\255\255\187\7\0\
    \\128\3\0\0\0\255\255\255\255\255\255\255\255\179\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\63\127\0\0\0\63\0\0\0\0\255\255\255\255\
    \\255\255\255\255\255\255\223\255\255\255\255\255\255\255\255\223\100\222\255\235\239\255\255\255\255\255\255\255\255\255\255\255\255\255\7\255\31\255\1\255\67\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\127\111\255\127\242\111\255\255\255\191\153\7\0\0\0\0\0\0\0\0\0\0\0\255\252\255\255\255\255\255\252\
    \\26\0\0\0\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\0\0\0\0\0\0\0\0\254\255\255\7\254\255\255\7\0\0\0\0\0\4\32\4\255\255\127\255\255\255\127\255\15\255\1\0\0\255\255\
    \\255\63\31\0\255\255\255\255\255\15\255\255\255\3\0\0\0\0\0\0\239\255\255\255\150\254\247\10\132\234\150\170\150\247\247\94\255\251\255\15\238\251\255\15\0\0\0\0\0\0\
    \\0\0\255\255\255\3\255\255\255\3\255\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\32\0\0\0\0\0\223\188\64\215\255\255\251\255\255\255\255\255\255\255\255\255\
    \\191\255\255\255\255\0\0\0\255\255\255\255\255\255\15\0\255\255\255\255\255\255\255\255\47\0\0\0\0\0\252\232\255\255\255\255\255\255\255\255\255\61\127\61\255\255\255\255\255\61\
    \\255\255\255\255\61\127\61\255\127\255\255\255\255\255\255\127\249\0\0\255\255\255\255\255\255\255\255\0\60\255\255\255\255\191\32\255\255\255\255\255\247\127\0\248\224\255\253\127\95\219\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\248\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\0\
    \\127\0\248\224\255\253\127\95\219\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\248\255\255\255\255\255\255\255\63\0\0\255\255\255\255\255\255\255\255\252\255\255\255\255\
    \\255\255\0\0\0\0\0\255\15\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\0\224\255\255\255\7\255\255\255\255\
    \\255\7\255\255\255\63\255\255\255\255\15\255\62\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\31\255\255\255\255\255\255\1\0\0\0\0\0\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\0\0\255\255\255\255\15\255\255\255\255\15\128\255\255\15\0\255\255\15\0\255\223\13\0\255\255\255\255\255\255\207\255\255\1\
    \\128\16\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\1\255\255\255\255\255\7\255\255\255\255\255\255\255\255\63\0\0\0\0\0\62\0\255\255\255\255\255\255\255\1\4\0\
    \\255\255\255\1\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\0\0\0\0\0\0\255\255\255\3\255\255\255\3\255\255\
    \\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\7\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\61\127\61\255\255\255\255\255\61\255\255\255\255\61\
    \\127\61\255\127\255\255\255\255\255\61\255\255\255\255\255\255\255\255\7\0\0\0\0\255\255\0\0\255\255\255\255\255\255\255\255\255\255\63\63\255\255\255\255\63\63\255\170\255\255\255\
    \\63\255\255\255\255\255\255\223\95\220\31\207\15\255\31\220\31\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\1\0\255\255\255\
    \\255\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\238\135\249\255\255\253\109\195\135\25\2\94\0\0\63\0\238\191\251\255\255\
    \\253\237\227\191\27\1\0\15\0\0\30\255\223\253\255\255\253\255\227\223\29\96\39\15\0\0\0\239\223\253\255\255\253\239\227\223\29\96\96\15\0\14\0\255\223\253\255\255\255\255\
    \\231\223\93\240\128\15\0\0\252\238\255\127\252\255\255\251\47\127\128\95\255\0\0\12\0\254\255\255\255\255\255\255\7\127\32\0\0\0\0\0\0\214\247\255\255\175\255\255\59\95\
    \\32\0\240\0\0\0\0\255\255\255\255\255\255\239\255\239\31\0\0\0\0\0\0\255\255\255\255\255\243\0\252\255\255\255\255\191\255\3\0\255\255\255\255\255\255\127\0\0\224\0\
    \\252\255\255\255\63\255\1\255\255\255\255\255\231\0\0\0\0\0\222\111\4\224\0\0\0\254\3\62\31\254\255\255\255\255\255\255\255\255\255\127\224\254\255\255\255\255\255\255\255\255\
    \\255\255\247\255\255\255\255\255\255\127\0\255\63\0\0\255\255\127\252\255\255\255\255\255\255\255\127\5\0\0\56\255\255\60\0\126\126\126\0\127\127\255\255\255\255\255\247\255\3\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\0\0\255\255\255\255\255\0\255\255\255\255\255\255\15\0\255\247\255\247\183\255\251\255\251\27\0\0\0\0\0\0\0\0\255\
    \\255\255\255\255\255\127\0\255\255\63\0\255\0\0\0\191\255\255\255\255\255\253\7\0\0\0\0\0\0\0\0\63\253\255\255\255\255\191\145\255\255\63\0\255\255\127\0\255\255\255\
    \\127\0\0\0\0\0\0\0\0\255\255\55\0\255\255\63\0\255\255\255\3\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\192\0\0\0\0\0\0\0\0\255\255\255\255\255\
    \\255\63\0\255\255\63\0\255\255\7\0\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\239\159\249\255\255\253\237\227\159\25\129\224\15\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\255\255\255\231\255\7\0\0\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\231\127\0\
    \\0\255\255\255\255\255\255\255\255\255\32\0\0\255\255\255\255\255\255\255\255\255\1\255\253\255\255\255\255\127\127\1\0\0\0\0\0\252\255\255\255\252\255\255\254\127\0\0\0\0\
    \\0\0\0\0\0\127\251\255\255\255\255\127\180\203\0\0\0\191\253\255\255\255\127\123\1\0\0\0\0\0\0\0\0\0\0\0\0\255\255\253\255\255\255\255\199\1\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\255\255\255\255\255\255\255\1\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\63\0\0\255\255\255\255\255\255\0\0\15\0\0\0\248\255\255\224\255\
    \\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\135\255\255\255\255\255\255\255\128\255\255\0\0\0\0\0\0\0\0\11\0\3\0\255\255\223\
    \\255\255\255\223\255\255\127\255\255\255\127\255\255\255\253\255\255\255\253\255\255\247\15\0\0\0\0\0\0\255\255\255\127\224\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\127\255\255\249\219\7\255\255\255\255\255\255\255\63\0\0\0\128\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\
    \\255\143\8\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"#

isAlphabeticOffsetsBitMap :: Ptr Word16
isAlphabeticOffsetsBitMap = Ptr
    "\69\7\82\0\90\0\178\7\28\1\206\5\120\0\179\2\182\0\122\5\119\10\82\4\151\10\183\10\215\10\10\4\11\8\82\0\240\7\253\9\81\0\82\0\30\2\20\9\48\9\96\7\159\3\247\10\23\11\252\0\82\0\25\10\23\5\0\0\73\1\73\1\43\5\73\1\73\1\73\1\73\1\73\1\73\1\73\1\141\1\212\0\109\4\73\1\55\11\152\0\
    \\73\1\73\1\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\45\7\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\
    \\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\
    \\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\224\1\82\0\211\2\45\3\208\7\74\3\87\11\119\11\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\
    \\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\131\3\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\82\0\
    \\70\8\43\8\82\0\129\8\183\4\149\2\109\1\34\4\50\4\188\8\247\8\151\11\82\0\183\11\215\11\247\11\49\0\23\12\97\2\144\4\160\4\211\4\70\9\121\2\237\3\55\12\103\6\6\6\238\5\87\12\16\3\236\6\119\12\73\1\151\12\183\12\77\1\215\12\82\0\82\0\82\0\3\5\243\4\62\2\73\1\73\1\73\1\73\1\73\1\73\1\
    \\73\1\73\1\73\1\76\2\82\0\82\0\82\0\82\0\235\2\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\82\0\82\0\247\12\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\
    \\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\82\0\82\0\23\13\55\13\73\1\73\1\133\4\87\13\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\161\8\82\0\82\0\82\0\82\0\46\1\16\0\73\1\73\1\
    \\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\18\0\82\0\106\3\120\3\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\185\6\73\1\73\1\73\1\73\1\73\1\
    \\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\97\5\173\1\185\1\119\13\73\1\73\1\73\1\73\1\73\1\73\1\73\1\151\13\183\13\191\3\205\3\73\1\71\6\73\1\73\1\205\6\217\1\215\13\73\1\73\1\73\1\73\1\128\7\73\1\73\1\154\7\73\1\73\1\
    \\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\
    \\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\
    \\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\
    \\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\248\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\240\0\252\1\82\0\82\0\82\0\
    \\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\8\2\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\176\5\82\0\82\0\
    \\61\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\73\1\82\0\82\0\69\1\73\1\73\1\73\1\73\1\73\1\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\131\1\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\
    \\82\0\82\0\82\0\141\1"#

