"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CumulativeTvd = void 0;
const variance_1 = require("@ot-builder/variance");
class CumulativeTvd {
    constructor(ms) {
        this.pending = [];
        this.valueCreator = new variance_1.OtVar.ValueFactory(ms);
    }
    addDelta(master, delta) {
        if (delta)
            this.pending.push([master, delta]);
    }
    collectTo(v) {
        if (!this.pending.length)
            return v;
        return variance_1.OtVar.Ops.add(v, this.valueCreator.create(0, this.pending));
    }
}
exports.CumulativeTvd = CumulativeTvd;
//# sourceMappingURL=tvd-access.js.map