"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.traceMath = void 0;
const TraceImpl_Glyph = require("./trace-impl/glyph");
function traceMath(table) {
    if (!table.variants)
        return TraceImpl_Glyph.Nop;
    const procs = [];
    if (table.variants.vertical)
        for (const [from, to] of table.variants.vertical)
            procs.push(traceGlyphConstruction(from, to));
    if (table.variants.horizontal)
        for (const [from, to] of table.variants.horizontal)
            procs.push(traceGlyphConstruction(from, to));
    return TraceImpl_Glyph.Seq(procs);
}
exports.traceMath = traceMath;
function traceGlyphConstruction(from, to) {
    return tracer => {
        if (!tracer.has(from))
            return;
        if (to.assembly) {
            for (const part of to.assembly.parts)
                tracer.add(part.partGlyph);
            for (const variant of to.variants)
                tracer.add(variant.variantGlyph);
        }
    };
}
//# sourceMappingURL=math.js.map