"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WriteCmap = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const handlers_1 = require("./handlers");
function ByPlatform(a, b) {
    return a.platform - b.platform || a.encoding - b.encoding;
}
exports.WriteCmap = (0, bin_util_1.Write)((frag, cmap, gOrd, cfg) => {
    const assignments = [];
    const options = { ...cfg };
    for (const handlerF of handlers_1.SubtableHandlers) {
        const handler = handlerF();
        const fgSubtable = handler.writeOpt(cmap, gOrd, options);
        if (fgSubtable) {
            const handlerAsg = handler.createAssignments(fgSubtable);
            for (const asg of handlerAsg)
                assignments.push(asg);
        }
    }
    assignments.sort(ByPlatform);
    frag.uint16(0); // Version
    frag.uint16(assignments.length);
    for (const asg of assignments) {
        frag.uint16(asg.platform);
        frag.uint16(asg.encoding);
        frag.ptr32(asg.frag);
    }
});
//# sourceMappingURL=write.js.map