#ifndef DUMMYDECODER_H_
#define DUMMYDECODER_H_

#include <thread>

#include "decoders/decoderbase.h"
#include "mythframe.h"
#include "programinfo.h"

class DummyDecoder : public DecoderBase
{
  public:
    DummyDecoder(MythPlayer *parent, const ProgramInfo &pginfo) :
        DecoderBase(parent, pginfo) {}
    ~DummyDecoder() override = default;

    // DecoderBase
    int         OpenFile(MythMediaBuffer* /*Buffer*/, bool /*novideo*/, TestBufferVec & /*testbuf*/) override
                    { return 0; }
    bool        GetFrame(DecodeType /*Type*/, bool &/*Retry*/) override
                    { std::this_thread::sleep_for(10ms); return false; }
    bool        IsLastFrameKey(void) const override       { return true; }
    QString     GetCodecDecoderName(void) const override  { return "dummy"; }
    MythCodecID GetVideoCodecID(void) const override      { return kCodec_NONE; }
    bool        SyncPositionMap(void) override            { return false; }
};

#endif
