# 2025-08-04 Triage Log

Overall positive week, but most of the changes are in very small incremental scenarios.

Triage done by **@panstromek**.
Revision range: [e3514bde..07b7dc90](https://perf.rust-lang.org/?start=e3514bde96d2d13586337a48db77fa64b850d249&end=07b7dc90ee4df5815dbb91ef8e98cb93571230f5&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 1.0%]   | 28    |
| Regressions ❌ <br /> (secondary)  | 0.7%  | [0.0%, 2.8%]   | 29    |
| Improvements ✅ <br /> (primary)   | -0.5% | [-2.7%, -0.1%] | 95    |
| Improvements ✅ <br /> (secondary) | -0.9% | [-9.2%, -0.0%] | 62    |
| All ❌✅ (primary)                 | -0.3% | [-2.7%, 1.0%]  | 123   |

2 Regressions, 4 Improvements, 10 Mixed; 6 of them in rollups
35 artifact comparisons made in total

#### Regressions

LoongArch64 LSX fast-path for `str.contains(&str)` [#144393](https://github.com/rust-lang/rust/pull/144393) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=686bc1c5f9c06762b18082434c04d514acf6707e&end=ba7e63b63871a429533c189adbfb1d9a6337e000&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -    | -            | 0     |
| Regressions ❌ <br /> (secondary)  | 0.9% | [0.9%, 1.0%] | 6     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | -    | -            | 0     |

match-stress noise, triaged by @lqd in [PR comment](https://github.com/rust-lang/rust/pull/144393#issuecomment-3134946709)

uniquify root goals during HIR typeck [#144405](https://github.com/rust-lang/rust/pull/144405) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=606dcc0d2e54d260f67d8a91f8adaf797a4ed38a&end=32e7a4b92b109c24e9822c862a7c74436b50e564&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -    | -            | 0     |
| Regressions ❌ <br /> (secondary)  | 1.2% | [0.1%, 4.1%] | 14    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | -    | -            | 0     |

Regression is mostly in new solver, which is not yet enabled by default. The other one is small regression in secondary stress test, that should be fine. See also [comment by author](https://github.com/rust-lang/rust/pull/144405#issuecomment-3138919139).

#### Improvements

Complete span AST lowering. [#144557](https://github.com/rust-lang/rust/pull/144557) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ac0cb05326706ef430a975aa85177e8642f2f457&end=686bc1c5f9c06762b18082434c04d514acf6707e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-1.8%, -0.2%] | 9     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.7% | [-1.8%, -0.2%] | 9     |


Rollup of 6 pull requests [#144718](https://github.com/rust-lang/rust/pull/144718) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=32e7a4b92b109c24e9822c862a7c74436b50e564&end=cc0a5b73053c62a3df5f84b3ee85079c9b65fa87&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.6%, -0.5%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-1.0%, -0.1%] | 8     |
| All ❌✅ (primary)                 | -0.5% | [-0.6%, -0.5%] | 2     |


Optimize region constraints [#144446](https://github.com/rust-lang/rust/pull/144446) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=adcb3d3b4cd3b7c4cde642f3ed537037f293738e&end=6c02dd4eae83befde07dc4782395e2005055e9fa&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.1% | [-0.1%, -0.1%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-1.0%, -0.3%] | 12    |
| All ❌✅ (primary)                 | -0.1% | [-0.1%, -0.1%] | 2     |


dont assemble shadowed impl candidates [#144732](https://github.com/rust-lang/rust/pull/144732) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7cd950546b4ce68843b4cbdb1ab3a43776202d3a&end=f34ba774c78ea32b7c40598b8ad23e75cdac42a6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.3% | [-2.9%, -0.1%] | 7     |
| All ❌✅ (primary)                 | -     | -              | 0     |


#### Mixed

Rollup of 6 pull requests [#144637](https://github.com/rust-lang/rust/pull/144637) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7278554d82fa474a4e8b5c67afb009e11e41a841&end=ac0cb05326706ef430a975aa85177e8642f2f457&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.1%  | [1.1%, 1.1%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.1% | [-0.1%, -0.1%] | 1     |
| All ❌✅ (primary)                 | 1.1%  | [1.1%, 1.1%]   | 1     |


Looks like a spurious change in `image` to me. Erases gain from https://github.com/rust-lang/rust/pull/144543, which was indentified as codegen unit perturbation in https://github.com/rust-lang/rust/pull/144543#issuecomment-3124957313, but this PR goes even furhter, only to return back to previous state in https://github.com/rust-lang/rust/pull/144718

All these changes are in the backend part of the breakdown graph, so this truly seems like spurious codegen unit shuffling.

Rollup of 4 pull requests [#144692](https://github.com/rust-lang/rust/pull/144692) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e5e79f8bd428d0b8d26e8240d718b134ef297459&end=3048886e59c94470e726ecaaf2add7242510ac11&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.9%  | [0.9%, 1.0%]   | 6     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.1%] | 4     |
| All ❌✅ (primary)                 | -     | -              | 0     |

Regression in `match-stress` is a bimodal noise.

Remove eval_always from check_private_in_public. [#116316](https://github.com/rust-lang/rust/pull/116316) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3048886e59c94470e726ecaaf2add7242510ac11&end=606dcc0d2e54d260f67d8a91f8adaf797a4ed38a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.1%, 2.1%]   | 40    |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.1%, 0.5%]   | 20    |
| Improvements ✅ <br /> (primary)   | -0.7% | [-2.8%, -0.2%] | 41    |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.3%, -0.2%] | 26    |
| All ❌✅ (primary)                 | -0.1% | [-2.8%, 2.1%]  | 81    |

Regressions outweigh improvements. Also, as per the reviewer comment, incr-patched regressions are eliminated in https://github.com/rust-lang/rust/pull/144479.

Rollup of 7 pull requests [#144768](https://github.com/rust-lang/rust/pull/144768) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6c02dd4eae83befde07dc4782395e2005055e9fa&end=e3ee7f7aea5b45af3b42b5e4713da43876a65ac9&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 0.7%]   | 12    |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.2%]   | 1     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.1% | [-0.1%, -0.1%] | 1     |
| All ❌✅ (primary)                 | 0.4%  | [0.2%, 0.7%]   | 12    |

doc regression on various benchmarks.  Based on detailed results, it's in the def_kind query, so it's likely [#143849](https://github.com/rust-lang/rust/pull/143849), because it adds a callsite. Other PRs look mostly unrelated (few triagebot and config changes, confusables improvement, minor rustdoc-json change).

Remove the witness type from coroutine *args* (without actually removing the type) [#144458](https://github.com/rust-lang/rust/pull/144458) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4b55fe199cfe9c710555a5af7f2a49491ad38254&end=63f6845e570305a92eaf855897768617366164d6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.0%  | [0.0%, 0.0%]   | 1     |
| Improvements ✅ <br /> (primary)   | -1.5% | [-1.5%, -1.5%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-1.5%, -0.0%] | 5     |
| All ❌✅ (primary)                 | -1.5% | [-1.5%, -1.5%] | 1     |

`include-blobs` regression looks like noise, just returned to previous state.

Perform check_private_in_public by module. [#144479](https://github.com/rust-lang/rust/pull/144479) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=63f6845e570305a92eaf855897768617366164d6&end=c23f07d8c56c51b5e634bda55daca2b073306340&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.0%, 0.5%]   | 3     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-1.1%, -0.2%] | 27    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.6%, -0.1%] | 4     |
| All ❌✅ (primary)                 | -0.7% | [-1.1%, -0.2%] | 27    |

Improvements outweigh regressions. Addresses some regressions from https://github.com/rust-lang/rust/pull/116316 (triaged above). `include-blob` regression is noise, `externs` is probably real, but the benchmark is very artificial.

Use less HIR to compute effective visibility. [#144554](https://github.com/rust-lang/rust/pull/144554) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=889701db1ff614160314734fe4138c2f820a95bb&end=6d091b2baa33698682453c7bb72809554204e434&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.3%]   | 6     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.1%, 0.5%]   | 7     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.1% | [-0.2%, -0.1%] | 5     |
| All ❌✅ (primary)                 | 0.2%  | [0.2%, 0.3%]   | 6     |

Some small regressions on `incr-unchanged` scenarios. Looks like the post-merge results are worse then the pre-merge ones. Pinged the author to confirm if it's ok. 

expand WF obligations when checking method calls [#144704](https://github.com/rust-lang/rust/pull/144704) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=da19b9d24c4ed900b91b45ec7f7795ec43613b1e&end=7cd950546b4ce68843b4cbdb1ab3a43776202d3a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.3%, 0.4%]   | 3     |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.2%, 1.1%]   | 12    |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.4%, -0.2%] | 19    |
| Improvements ✅ <br /> (secondary) | -1.2% | [-8.1%, -0.2%] | 32    |
| All ❌✅ (primary)                 | -0.2% | [-0.4%, 0.4%]  | 22    |

Perf improvements greatly outweigh regressions. Already triaged by @nnethercote.

Rollup of 12 pull requests [#144869](https://github.com/rust-lang/rust/pull/144869) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f34ba774c78ea32b7c40598b8ad23e75cdac42a6&end=383b9c447b61641e1f1a3850253944a897a60827&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.1%  | [0.1%, 0.1%]   | 2     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.8% | [-1.0%, -0.0%] | 7     |
| All ❌✅ (primary)                 | -     | -              | 0     |

`include-blob` regression looks like noise (returning to some baseline state).

Rollup of 12 pull requests [#144876](https://github.com/rust-lang/rust/pull/144876) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=383b9c447b61641e1f1a3850253944a897a60827&end=07b7dc90ee4df5815dbb91ef8e98cb93571230f5&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.5%, 0.5%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.9%  | [0.9%, 1.0%]   | 6     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-0.9%, -0.5%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.3% | [-0.9%, 0.5%]  | 3     |


`match-stress` is bimodal noise. `image` looks like a similar kind of perturbation like happened in https://github.com/rust-lang/rust/pull/144543, https://github.com/rust-lang/rust/pull/144637 and https://github.com/rust-lang/rust/pull/144718, probably caused by codegen unit scheduling change, but this time it doesn't have as large backend wall time change. The changes are still in LLVM though, based on detailed results. We'll see whether it comes back. I don't think this is worth more investigation.

