% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/affine.R
\name{wk_trans_affine}
\alias{wk_trans_affine}
\alias{wk_affine_identity}
\alias{wk_affine_rotate}
\alias{wk_affine_scale}
\alias{wk_affine_translate}
\alias{wk_affine_fit}
\alias{wk_affine_rescale}
\alias{wk_affine_compose}
\alias{wk_affine_invert}
\title{Affine transformer}
\usage{
wk_trans_affine(trans_matrix)

wk_affine_identity()

wk_affine_rotate(rotation_deg)

wk_affine_scale(scale_x = 1, scale_y = 1)

wk_affine_translate(dx = 0, dy = 0)

wk_affine_fit(src, dst)

wk_affine_rescale(rct_in, rct_out)

wk_affine_compose(...)

wk_affine_invert(x)
}
\arguments{
\item{trans_matrix}{A 3x3 transformation matrix}

\item{rotation_deg}{A rotation to apply in degrees counterclockwise.}

\item{scale_x, scale_y}{Scale factor to apply in the x and y directions, respectively}

\item{dx, dy}{Coordinate offsets in the x and y direction}

\item{src, dst}{Point vectors of control points used to estimate the affine mapping
(using \code{\link[base:qr]{base::qr.solve()}}).}

\item{rct_in, rct_out}{The input and output bounds}

\item{...}{Zero or more transforms in the order they should be applied.}

\item{x}{A \code{\link[=wk_trans_affine]{wk_trans_affine()}}}
}
\description{
Affine transformer
}
