--
-- Copyright 2025 The Android Open Source Project
--
-- Licensed under the Apache License, Version 2.0 (the "License");
-- you may not use this file except in compliance with the License.
-- You may obtain a copy of the License at
--
--     https://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.
INCLUDE PERFETTO MODULE wattson.curves.tg5_l3;

INCLUDE PERFETTO MODULE wattson.utils;

CREATE PERFETTO TABLE _device_curves_l3 AS
WITH
  data(device, freq_khz, dep_policy, dep_freq, l3_hit, l3_miss) AS (
    SELECT
      *
    FROM (VALUES
      ("Tensor", 300000, 4, 400000, 0.3989, 0.0629),
      ("Tensor", 300000, 4, 553000, 0.4119, 0.0656),
      ("Tensor", 300000, 6, 500000, 0.3298, 0.1029),
      ("Tensor", 574000, 4, 400000, 0.4894, 0.0239),
      ("Tensor", 574000, 4, 553000, 0.4991, 0.0960),
      ("Tensor", 574000, 4, 696000, 0.4949, 0.0971),
      ("Tensor", 574000, 4, 799000, 0.6116, 0.1266),
      ("Tensor", 574000, 4, 910000, 0.5897, 0.1385),
      ("Tensor", 574000, 4, 1024000, 0.5619, 0.0635),
      ("Tensor", 574000, 6, 500000, 0.5377, 0.1210),
      ("Tensor", 574000, 6, 851000, 0.5271, 0.1591),
      ("Tensor", 574000, 6, 984000, 0.5395, 0.1599),
      ("Tensor", 574000, 6, 1106000, 0.5552, 0.1393),
      ("Tensor", 738000, 4, 400000, 0.5825, 0.1271),
      ("Tensor", 738000, 4, 553000, 0.5751, 0.0396),
      ("Tensor", 738000, 4, 696000, 0.6433, 0.1050),
      ("Tensor", 738000, 4, 799000, 0.6401, 0.1293),
      ("Tensor", 738000, 4, 910000, 0.7069, 0.1252),
      ("Tensor", 738000, 4, 1024000, 0.6999, 0.1143),
      ("Tensor", 738000, 4, 1197000, 0.9076, 0.1960),
      ("Tensor", 738000, 4, 1328000, 0.9708, 0.1953),
      ("Tensor", 738000, 6, 500000, 0.6437, 0.2086),
      ("Tensor", 738000, 6, 851000, 0.6274, 0.1852),
      ("Tensor", 738000, 6, 984000, 0.6231, 0.2066),
      ("Tensor", 738000, 6, 1106000, 0.6256, 0.2199),
      ("Tensor", 738000, 6, 1277000, 0.6719, 0.2485),
      ("Tensor", 738000, 6, 1426000, 1.1072, 0.3483),
      ("Tensor", 930000, 4, 400000, 0.7812, 0.1727),
      ("Tensor", 930000, 4, 553000, 0.7343, 0.1846),
      ("Tensor", 930000, 4, 696000, 0.7551, 0.2006),
      ("Tensor", 930000, 4, 799000, 0.7330, 0.1864),
      ("Tensor", 930000, 4, 910000, 0.8250, 0.1451),
      ("Tensor", 930000, 4, 1024000, 0.7331, 0.2092),
      ("Tensor", 930000, 4, 1197000, 1.0791, 0.4804),
      ("Tensor", 930000, 4, 1328000, 1.0172, 0.0844),
      ("Tensor", 930000, 4, 1491000, 1.0396, 0.2614),
      ("Tensor", 930000, 4, 1663000, 1.6492, 0.3497),
      ("Tensor", 930000, 4, 1836000, 1.5561, 0.3407),
      ("Tensor", 930000, 6, 500000, 0.8530, 0.4182),
      ("Tensor", 930000, 6, 851000, 0.8694, 0.2854),
      ("Tensor", 930000, 6, 984000, 0.8620, 0.2568),
      ("Tensor", 930000, 6, 1106000, 0.8763, 0.2336),
      ("Tensor", 930000, 6, 1277000, 0.8717, 0.3756),
      ("Tensor", 930000, 6, 1426000, 1.1774, 0.5021),
      ("Tensor", 930000, 6, 1582000, 1.1264, 0.5799),
      ("Tensor", 930000, 6, 1745000, 1.2303, 0.5421),
      ("Tensor", 930000, 6, 1826000, 1.2330, 0.4498),
      ("Tensor", 1098000, 4, 400000, 0.9744, 0.2106),
      ("Tensor", 1098000, 4, 553000, 0.9980, 0.0500),
      ("Tensor", 1098000, 4, 696000, 0.9500, 0.1928),
      ("Tensor", 1098000, 4, 799000, 0.9132, 0.2391),
      ("Tensor", 1098000, 4, 910000, 0.9922, 0.2576),
      ("Tensor", 1098000, 4, 1024000, 0.9607, 0.2397),
      ("Tensor", 1098000, 4, 1197000, 1.1253, 0.6195),
      ("Tensor", 1098000, 4, 1328000, 1.1609, 0.0960),
      ("Tensor", 1098000, 4, 1491000, 1.1783, 0.0851),
      ("Tensor", 1098000, 4, 1663000, 1.6941, 0.4295),
      ("Tensor", 1098000, 4, 1836000, 1.7152, 0.4610),
      ("Tensor", 1098000, 4, 1999000, 1.7941, 0.4293),
      ("Tensor", 1098000, 4, 2130000, 1.6758, 0.4437),
      ("Tensor", 1098000, 6, 500000, 1.0485, 0.4038),
      ("Tensor", 1098000, 6, 851000, 1.0510, 0.2815),
      ("Tensor", 1098000, 6, 984000, 1.0785, 0.4137),
      ("Tensor", 1098000, 6, 1106000, 1.0909, 0.3933),
      ("Tensor", 1098000, 6, 1277000, 1.1533, 0.3811),
      ("Tensor", 1098000, 6, 1426000, 1.2718, 0.3814),
      ("Tensor", 1098000, 6, 1582000, 1.3463, 0.4100),
      ("Tensor", 1098000, 6, 1745000, 1.3065, 0.5207),
      ("Tensor", 1098000, 6, 1826000, 1.3456, 0.4903),
      ("Tensor", 1098000, 6, 2048000, 1.3466, 0.7218),
      ("Tensor", 1098000, 6, 2188000, 1.3132, 0.4923),
      ("Tensor", 1197000, 4, 400000, 1.0507, 0.2411),
      ("Tensor", 1197000, 4, 553000, 1.0387, 0.2875),
      ("Tensor", 1197000, 4, 696000, 1.0173, 0.2232),
      ("Tensor", 1197000, 4, 799000, 1.0160, 0.2418),
      ("Tensor", 1197000, 4, 910000, 1.0555, 0.0966),
      ("Tensor", 1197000, 4, 1024000, 1.0663, 0.0987),
      ("Tensor", 1197000, 4, 1197000, 1.1885, 0.2852),
      ("Tensor", 1197000, 4, 1328000, 1.2442, 0.2724),
      ("Tensor", 1197000, 4, 1491000, 1.2474, 0.3269),
      ("Tensor", 1197000, 4, 1663000, 1.8142, 0.3429),
      ("Tensor", 1197000, 4, 1836000, 1.7692, 1.0737),
      ("Tensor", 1197000, 4, 1999000, 1.7939, 0.1120),
      ("Tensor", 1197000, 4, 2130000, 1.8126, 0.3744),
      ("Tensor", 1197000, 4, 2253000, 1.7413, 0.5198),
      ("Tensor", 1197000, 6, 500000, 1.1288, 0.6817),
      ("Tensor", 1197000, 6, 851000, 1.1779, 0.5681),
      ("Tensor", 1197000, 6, 984000, 1.1835, 0.3389),
      ("Tensor", 1197000, 6, 1106000, 1.2115, 0.4506),
      ("Tensor", 1197000, 6, 1277000, 1.1726, 0.8719),
      ("Tensor", 1197000, 6, 1426000, 1.3825, 0.5140),
      ("Tensor", 1197000, 6, 1582000, 1.4179, 0.3585),
      ("Tensor", 1197000, 6, 1745000, 1.3804, 0.3197),
      ("Tensor", 1197000, 6, 1826000, 1.3379, 0.5614),
      ("Tensor", 1197000, 6, 2048000, 1.3335, 0.5443),
      ("Tensor", 1197000, 6, 2188000, 1.4382, 0.5255),
      ("Tensor", 1197000, 6, 2252000, 1.3961, 0.5423),
      ("Tensor", 1328000, 4, 400000, 1.2307, 0.5565),
      ("Tensor", 1328000, 4, 553000, 1.2186, 0.2366),
      ("Tensor", 1328000, 4, 696000, 1.2243, 0.4145),
      ("Tensor", 1328000, 4, 799000, 1.2620, 0.0973),
      ("Tensor", 1328000, 4, 910000, 1.2462, 0.5669),
      ("Tensor", 1328000, 4, 1024000, 1.2787, 0.2332),
      ("Tensor", 1328000, 4, 1197000, 1.4364, 0.3260),
      ("Tensor", 1328000, 4, 1328000, 1.3636, 0.3354),
      ("Tensor", 1328000, 4, 1491000, 1.3733, 0.0512),
      ("Tensor", 1328000, 4, 1663000, 1.9295, 0.4588),
      ("Tensor", 1328000, 4, 1836000, 1.8278, 0.9316),
      ("Tensor", 1328000, 4, 1999000, 1.9043, 0.4921),
      ("Tensor", 1328000, 4, 2130000, 1.9144, 0.1139),
      ("Tensor", 1328000, 4, 2253000, 1.9550, 0.0603),
      ("Tensor", 1328000, 6, 500000, 1.3772, 0.5737),
      ("Tensor", 1328000, 6, 851000, 1.3985, 0.6368),
      ("Tensor", 1328000, 6, 984000, 1.3933, 0.5311),
      ("Tensor", 1328000, 6, 1106000, 1.3932, 0.4567),
      ("Tensor", 1328000, 6, 1277000, 1.3984, 0.6616),
      ("Tensor", 1328000, 6, 1426000, 1.5067, 0.5776),
      ("Tensor", 1328000, 6, 1582000, 1.5167, 1.0309),
      ("Tensor", 1328000, 6, 1745000, 1.5021, 0.6845),
      ("Tensor", 1328000, 6, 1826000, 1.4775, 0.6285),
      ("Tensor", 1328000, 6, 2048000, 1.5237, 0.5402),
      ("Tensor", 1328000, 6, 2188000, 1.5349, 0.7490),
      ("Tensor", 1328000, 6, 2252000, 1.5436, 0.7984),
      ("Tensor", 1328000, 6, 2401000, 2.1755, 1.0387),
      ("Tensor", 1328000, 6, 2507000, 2.2320, 0.7382),
      ("Tensor", 1328000, 6, 2630000, 2.2489, 1.1762),
      ("Tensor", 1401000, 4, 400000, 1.3279, 0.2793),
      ("Tensor", 1401000, 4, 553000, 1.3065, 0.3853),
      ("Tensor", 1401000, 4, 696000, 1.3290, 0.3016),
      ("Tensor", 1401000, 4, 799000, 1.2483, 0.3683),
      ("Tensor", 1401000, 4, 910000, 1.4059, 0.2825),
      ("Tensor", 1401000, 4, 1024000, 1.3702, 0.3389),
      ("Tensor", 1401000, 4, 1197000, 1.3920, 0.3614),
      ("Tensor", 1401000, 4, 1328000, 1.3752, 0.3310),
      ("Tensor", 1401000, 4, 1491000, 1.4015, 0.6546),
      ("Tensor", 1401000, 4, 1663000, 1.8982, 1.0324),
      ("Tensor", 1401000, 4, 1836000, 1.9447, 0.5336),
      ("Tensor", 1401000, 4, 1999000, 2.1219, 0.0662),
      ("Tensor", 1401000, 4, 2130000, 1.9576, 0.5584),
      ("Tensor", 1401000, 4, 2253000, 2.0221, 0.1254),
      ("Tensor", 1401000, 6, 500000, 1.5283, 0.5764),
      ("Tensor", 1401000, 6, 851000, 1.5211, 0.5643),
      ("Tensor", 1401000, 6, 984000, 1.5574, 0.7558),
      ("Tensor", 1401000, 6, 1106000, 1.5492, 0.7862),
      ("Tensor", 1401000, 6, 1277000, 1.5389, 0.7523),
      ("Tensor", 1401000, 6, 1426000, 1.6449, 0.5993),
      ("Tensor", 1401000, 6, 1582000, 1.5953, 0.5512),
      ("Tensor", 1401000, 6, 1745000, 1.5672, 0.5489),
      ("Tensor", 1401000, 6, 1826000, 1.5639, 0.5507),
      ("Tensor", 1401000, 6, 2048000, 1.5878, 0.7536),
      ("Tensor", 1401000, 6, 2188000, 1.5562, 0.5431),
      ("Tensor", 1401000, 6, 2252000, 1.5908, 0.6087),
      ("Tensor", 1401000, 6, 2401000, 2.2693, 0.8953),
      ("Tensor", 1401000, 6, 2507000, 2.3182, 1.2289),
      ("Tensor", 1401000, 6, 2630000, 2.3090, 1.0687),
      ("Tensor", 1401000, 6, 2704000, 2.2751, 0.9966),
      ("Tensor", 1401000, 6, 2802000, 2.3278, 0.9065),
      ("Tensor", 1598000, 4, 400000, 1.7424, 0.8926),
      ("Tensor", 1598000, 4, 553000, 1.7003, 0.4482),
      ("Tensor", 1598000, 4, 696000, 1.6099, 0.5281),
      ("Tensor", 1598000, 4, 799000, 1.8018, 0.9634),
      ("Tensor", 1598000, 4, 910000, 1.7615, 0.3445),
      ("Tensor", 1598000, 4, 1024000, 1.7317, 0.3396),
      ("Tensor", 1598000, 4, 1197000, 1.7293, 0.5079),
      ("Tensor", 1598000, 4, 1328000, 1.8771, 0.4685),
      ("Tensor", 1598000, 4, 1491000, 1.8724, 0.4693),
      ("Tensor", 1598000, 4, 1663000, 1.9587, 1.2295),
      ("Tensor", 1598000, 4, 1836000, 2.2287, 0.5220),
      ("Tensor", 1598000, 4, 1999000, 2.1786, 0.1494),
      ("Tensor", 1598000, 4, 2130000, 2.1631, 0.4924),
      ("Tensor", 1598000, 4, 2253000, 2.1703, 0.5427),
      ("Tensor", 1598000, 6, 500000, 1.9632, 0.9534),
      ("Tensor", 1598000, 6, 851000, 1.9820, 0.9433),
      ("Tensor", 1598000, 6, 984000, 1.9745, 0.8002),
      ("Tensor", 1598000, 6, 1106000, 1.9514, 0.8323),
      ("Tensor", 1598000, 6, 1277000, 1.9796, 1.1016),
      ("Tensor", 1598000, 6, 1426000, 1.9432, 0.8556),
      ("Tensor", 1598000, 6, 1582000, 2.0700, 0.8211),
      ("Tensor", 1598000, 6, 1745000, 2.0052, 0.9492),
      ("Tensor", 1598000, 6, 1826000, 2.0165, 0.7016),
      ("Tensor", 1598000, 6, 2048000, 2.0881, 0.6641),
      ("Tensor", 1598000, 6, 2188000, 2.1239, 0.8702),
      ("Tensor", 1598000, 6, 2252000, 2.0952, 1.1728),
      ("Tensor", 1598000, 6, 2401000, 2.4810, 0.9498),
      ("Tensor", 1598000, 6, 2507000, 2.4644, 0.9131),
      ("Tensor", 1598000, 6, 2630000, 2.4030, 1.3728),
      ("Tensor", 1598000, 6, 2704000, 2.4271, 1.2680),
      ("Tensor", 1598000, 6, 2802000, 2.4761, 0.9789),
      ("Tensor", 1704000, 4, 400000, 1.9466, 0.9753),
      ("Tensor", 1704000, 4, 553000, 1.9336, 1.0846),
      ("Tensor", 1704000, 4, 696000, 1.9280, 0.2116),
      ("Tensor", 1704000, 4, 799000, 1.9616, 0.4219),
      ("Tensor", 1704000, 4, 910000, 1.9627, 0.1957),
      ("Tensor", 1704000, 4, 1024000, 1.9763, 0.5599),
      ("Tensor", 1704000, 4, 1197000, 1.9514, 0.4326),
      ("Tensor", 1704000, 4, 1328000, 2.0093, 0.4861),
      ("Tensor", 1704000, 4, 1491000, 1.9438, 0.1584),
      ("Tensor", 1704000, 4, 1663000, 2.3012, 0.6019),
      ("Tensor", 1704000, 4, 1836000, 2.2896, 0.5019),
      ("Tensor", 1704000, 4, 1999000, 2.2292, 0.6076),
      ("Tensor", 1704000, 4, 2130000, 2.2087, 0.5726),
      ("Tensor", 1704000, 4, 2253000, 2.2317, 0.4878),
      ("Tensor", 1704000, 6, 500000, 2.3606, 0.7822),
      ("Tensor", 1704000, 6, 851000, 2.2564, 0.9656),
      ("Tensor", 1704000, 6, 984000, 2.2618, 0.9988),
      ("Tensor", 1704000, 6, 1106000, 2.2796, 0.9681),
      ("Tensor", 1704000, 6, 1277000, 2.2224, 0.8812),
      ("Tensor", 1704000, 6, 1426000, 2.2368, 1.0353),
      ("Tensor", 1704000, 6, 1582000, 2.3125, 0.8402),
      ("Tensor", 1704000, 6, 1745000, 2.3199, 0.7728),
      ("Tensor", 1704000, 6, 1826000, 2.3633, 0.8597),
      ("Tensor", 1704000, 6, 2048000, 2.2779, 0.6885),
      ("Tensor", 1704000, 6, 2188000, 2.2575, 1.0289),
      ("Tensor", 1704000, 6, 2252000, 2.2798, 0.9689),
      ("Tensor", 1704000, 6, 2401000, 2.5202, 1.0626),
      ("Tensor", 1704000, 6, 2507000, 2.4070, 0.8463),
      ("Tensor", 1704000, 6, 2630000, 2.5998, 1.0795),
      ("Tensor", 1704000, 6, 2704000, 2.6273, 1.0329),
      ("Tensor", 1704000, 6, 2802000, 2.6179, 0.7569),
      ("Tensor", 1803000, 4, 400000, 2.2197, 0.4673),
      ("Tensor", 1803000, 4, 553000, 2.3144, 0.5120),
      ("Tensor", 1803000, 4, 696000, 2.2720, 0.1952),
      ("Tensor", 1803000, 4, 799000, 2.3472, 0.5479),
      ("Tensor", 1803000, 4, 910000, 2.3035, 0.5622),
      ("Tensor", 1803000, 4, 1024000, 2.2129, 0.6828),
      ("Tensor", 1803000, 4, 1197000, 2.3176, 0.1645),
      ("Tensor", 1803000, 4, 1328000, 2.3127, 0.4992),
      ("Tensor", 1803000, 4, 1491000, 2.1449, 1.4705),
      ("Tensor", 1803000, 4, 1663000, 2.3243, 0.6256),
      ("Tensor", 1803000, 4, 1836000, 2.1328, 0.6293),
      ("Tensor", 1803000, 4, 1999000, 2.3165, 0.5265),
      ("Tensor", 1803000, 4, 2130000, 2.2775, 0.6412),
      ("Tensor", 1803000, 4, 2253000, 2.4124, 0.5151),
      ("Tensor", 1803000, 6, 500000, 2.5536, 1.5678),
      ("Tensor", 1803000, 6, 851000, 2.5831, 1.1737),
      ("Tensor", 1803000, 6, 984000, 2.6063, 1.0591),
      ("Tensor", 1803000, 6, 1106000, 2.6951, 0.9158),
      ("Tensor", 1803000, 6, 1277000, 2.5400, 1.5096),
      ("Tensor", 1803000, 6, 1426000, 2.6623, 1.1037),
      ("Tensor", 1803000, 6, 1582000, 2.6996, 1.0774),
      ("Tensor", 1803000, 6, 1745000, 2.6692, 1.6543),
      ("Tensor", 1803000, 6, 1826000, 2.7288, 1.1255),
      ("Tensor", 1803000, 6, 2048000, 2.6649, 1.1010),
      ("Tensor", 1803000, 6, 2188000, 2.6489, 1.1485),
      ("Tensor", 1803000, 6, 2252000, 2.6389, 1.0942),
      ("Tensor", 1803000, 6, 2401000, 2.6256, 1.0997),
      ("Tensor", 1803000, 6, 2507000, 2.6630, 1.2641),
      ("Tensor", 1803000, 6, 2630000, 2.7385, 2.3263),
      ("Tensor", 1803000, 6, 2704000, 2.6901, 1.0629),
      ("Tensor", 1803000, 6, 2802000, 2.7476, 1.0673),
      ("Tensor G4", 820000, _dsu_dep!(), 610000, 0.4824, 0.8357),
      ("Tensor G4", 955000, _dsu_dep!(), 610000, 0.4801, 0.852),
      ("Tensor G4", 1098000, _dsu_dep!(), 610000, 0.4988, 0.8219),
      ("Tensor G4", 1197000, _dsu_dep!(), 610000, 0.5025, 0.8369),
      ("Tensor G4", 1328000, _dsu_dep!(), 610000, 0.516, 0.8928),
      ("Tensor G4", 1425000, _dsu_dep!(), 610000, 0.5266, 0.8895),
      ("Tensor G4", 1548000, _dsu_dep!(), 610000, 0.5286, 0.915),
      ("Tensor G4", 1696000, _dsu_dep!(), 610000, 0.5288, 1.0169),
      ("Tensor G4", 1849000, _dsu_dep!(), 610000, 0.5326, 1.1313),
      ("Tensor G4", 1950000, _dsu_dep!(), 610000, 0.5495, 1.1839),
      ("Tensor G4", 820000, _dsu_dep!(), 820000, 0.4815, 0.8114),
      ("Tensor G4", 955000, _dsu_dep!(), 820000, 0.5055, 0.9356),
      ("Tensor G4", 1098000, _dsu_dep!(), 820000, 0.5168, 0.9567),
      ("Tensor G4", 1197000, _dsu_dep!(), 820000, 0.5228, 0.8653),
      ("Tensor G4", 1328000, _dsu_dep!(), 820000, 0.5228, 0.8895),
      ("Tensor G4", 1425000, _dsu_dep!(), 820000, 0.5309, 0.9692),
      ("Tensor G4", 1548000, _dsu_dep!(), 820000, 0.5461, 0.9987),
      ("Tensor G4", 1696000, _dsu_dep!(), 820000, 0.564, 1.053),
      ("Tensor G4", 1849000, _dsu_dep!(), 820000, 0.5649, 0.9087),
      ("Tensor G4", 1950000, _dsu_dep!(), 820000, 0.5737, 1.0893),
      ("Tensor G4", 820000, _dsu_dep!(), 970000, 0.4923, 0.852),
      ("Tensor G4", 955000, _dsu_dep!(), 970000, 0.5014, 0.8357),
      ("Tensor G4", 1098000, _dsu_dep!(), 970000, 0.4952, 1.0169),
      ("Tensor G4", 1197000, _dsu_dep!(), 970000, 0.5284, 0.8594),
      ("Tensor G4", 1328000, _dsu_dep!(), 970000, 0.5332, 0.8521),
      ("Tensor G4", 1425000, _dsu_dep!(), 970000, 0.5424, 0.8612),
      ("Tensor G4", 1548000, _dsu_dep!(), 970000, 0.5641, 0.883),
      ("Tensor G4", 1696000, _dsu_dep!(), 970000, 0.5524, 0.915),
      ("Tensor G4", 1849000, _dsu_dep!(), 970000, 0.5685, 0.8765),
      ("Tensor G4", 1950000, _dsu_dep!(), 970000, 0.5527, 0.8164),
      ("Tensor G4", 820000, _dsu_dep!(), 1098000, 0.5084, 0.947),
      ("Tensor G4", 955000, _dsu_dep!(), 1098000, 0.5177, 0.8058),
      ("Tensor G4", 1098000, _dsu_dep!(), 1098000, 0.5284, 0.763),
      ("Tensor G4", 1197000, _dsu_dep!(), 1098000, 0.596, 0.8633),
      ("Tensor G4", 1328000, _dsu_dep!(), 1098000, 0.596, 0.8633),
      ("Tensor G4", 1425000, _dsu_dep!(), 1098000, 0.5373, 0.7504),
      ("Tensor G4", 1548000, _dsu_dep!(), 1098000, 0.5186, 0.8604),
      ("Tensor G4", 1696000, _dsu_dep!(), 1098000, 0.5772, 89.73),
      ("Tensor G4", 1849000, _dsu_dep!(), 1098000, 0.5758, 0.9588),
      ("Tensor G4", 1950000, _dsu_dep!(), 1098000, 0.5904, 1.1074),
      ("Tensor G4", 820000, _dsu_dep!(), 1197000, 0.5105, 0.866),
      ("Tensor G4", 955000, _dsu_dep!(), 1197000, 0.5241, 0.8533),
      ("Tensor G4", 1098000, _dsu_dep!(), 1197000, 0.5347, 0.8569),
      ("Tensor G4", 1197000, _dsu_dep!(), 1197000, 0.524, 0.8318),
      ("Tensor G4", 1328000, _dsu_dep!(), 1197000, 0.5298, 0.8374),
      ("Tensor G4", 1425000, _dsu_dep!(), 1197000, 0.5201, 0.9479),
      ("Tensor G4", 1548000, _dsu_dep!(), 1197000, 0.497, 0.9093),
      ("Tensor G4", 1696000, _dsu_dep!(), 1197000, 0.5007, 0.8765),
      ("Tensor G4", 1849000, _dsu_dep!(), 1197000, 0.6107, 0.8682),
      ("Tensor G4", 1950000, _dsu_dep!(), 1197000, 0.5888, 0.9738),
      ("Tensor G4", 820000, _dsu_dep!(), 1328000, 0.534, 0.9162),
      ("Tensor G4", 955000, _dsu_dep!(), 1328000, 0.5551, 0.9499),
      ("Tensor G4", 1098000, _dsu_dep!(), 1328000, 0.556, 0.954),
      ("Tensor G4", 1197000, _dsu_dep!(), 1328000, 0.5711, 0.9117),
      ("Tensor G4", 1328000, _dsu_dep!(), 1328000, 0.5372, 0.956),
      ("Tensor G4", 1425000, _dsu_dep!(), 1328000, 0.5482, 0.934),
      ("Tensor G4", 1548000, _dsu_dep!(), 1328000, 0.5615, 0.7495),
      ("Tensor G4", 1696000, _dsu_dep!(), 1328000, 0.53, 0.9145),
      ("Tensor G4", 1849000, _dsu_dep!(), 1328000, 0.5504, 0.9478),
      ("Tensor G4", 1950000, _dsu_dep!(), 1328000, 0.6243, 0.9335),
      ("Tensor G4", 820000, _dsu_dep!(), 1444000, 0.5437, 0.9403),
      ("Tensor G4", 955000, _dsu_dep!(), 1444000, 0.5635, 0.9997),
      ("Tensor G4", 1098000, _dsu_dep!(), 1444000, 0.5711, 0.919),
      ("Tensor G4", 1197000, _dsu_dep!(), 1444000, 0.5595, 0.9455),
      ("Tensor G4", 1328000, _dsu_dep!(), 1444000, 0.5772, 0.9415),
      ("Tensor G4", 1425000, _dsu_dep!(), 1444000, 0.5507, 0.9582),
      ("Tensor G4", 1548000, _dsu_dep!(), 1444000, 0.5535, 0.8986),
      ("Tensor G4", 1696000, _dsu_dep!(), 1444000, 0.507, 0.9369),
      ("Tensor G4", 1849000, _dsu_dep!(), 1444000, 0.628, 0.8878),
      ("Tensor G4", 1950000, _dsu_dep!(), 1444000, 0.658, 1.0974),
      ("Tensor G4", 820000, _dsu_dep!(), 1548000, 0.578, 0.8322),
      ("Tensor G4", 955000, _dsu_dep!(), 1548000, 0.603, 0.9371),
      ("Tensor G4", 1098000, _dsu_dep!(), 1548000, 0.6163, 0.962),
      ("Tensor G4", 1197000, _dsu_dep!(), 1548000, 0.6105, 0.9323),
      ("Tensor G4", 1328000, _dsu_dep!(), 1548000, 0.589, 0.8355),
      ("Tensor G4", 1425000, _dsu_dep!(), 1548000, 0.5924, 0.9416),
      ("Tensor G4", 1548000, _dsu_dep!(), 1548000, 0.5611, 0.8911),
      ("Tensor G4", 1696000, _dsu_dep!(), 1548000, 0.5792, 0.905),
      ("Tensor G4", 1849000, _dsu_dep!(), 1548000, 0.6021, 0.9761),
      ("Tensor G4", 1950000, _dsu_dep!(), 1548000, 0.6579, 1.0438),
      ("Tensor G4", 820000, _dsu_dep!(), 1704000, 1.5584, 1.2388),
      ("Tensor G4", 955000, _dsu_dep!(), 1704000, 1.5287, 1.104),
      ("Tensor G4", 1098000, _dsu_dep!(), 1704000, 1.6412, 1.2419),
      ("Tensor G4", 1197000, _dsu_dep!(), 1704000, 1.9947, 1.318),
      ("Tensor G4", 1328000, _dsu_dep!(), 1704000, 1.6701, 1.178),
      ("Tensor G4", 1425000, _dsu_dep!(), 1704000, 1.5944, 1.3017),
      ("Tensor G4", 1548000, _dsu_dep!(), 1704000, 1.6769, 1.6058),
      ("Tensor G4", 1696000, _dsu_dep!(), 1704000, 1.7215, 1.8),
      ("Tensor G4", 1849000, _dsu_dep!(), 1704000, 1.9143, 2.0842),
      ("Tensor G4", 1950000, _dsu_dep!(), 1704000, 1.932, 2.8572),
      ("Tensor G4", 820000, _dsu_dep!(), 1800000, 1.575, 1.5401),
      ("Tensor G4", 955000, _dsu_dep!(), 1800000, 1.6833, 1.5087),
      ("Tensor G4", 1098000, _dsu_dep!(), 1800000, 1.5571, 2.0737),
      ("Tensor G4", 1197000, _dsu_dep!(), 1800000, 1.6815, 1.8473),
      ("Tensor G4", 1328000, _dsu_dep!(), 1800000, 1.7828, 1.666),
      ("Tensor G4", 1425000, _dsu_dep!(), 1800000, 1.8061, 1.8018),
      ("Tensor G4", 1548000, _dsu_dep!(), 1800000, 1.9956, 1.64),
      ("Tensor G4", 1696000, _dsu_dep!(), 1800000, 1.8592, 1.701),
      ("Tensor G4", 1849000, _dsu_dep!(), 1800000, 1.5758, 1.5364),
      ("Tensor G4", 1950000, _dsu_dep!(), 1800000, 1.9823, 1.7952),
      ("Tensor G4", 820000, _dsu_dep!(), 1880000, 1.7249, 1.7787),
      ("Tensor G4", 955000, _dsu_dep!(), 1880000, 1.7635, 2.0677),
      ("Tensor G4", 1098000, _dsu_dep!(), 1880000, 1.805, 1.5907),
      ("Tensor G4", 1197000, _dsu_dep!(), 1880000, 1.7293, 2.0645),
      ("Tensor G4", 1328000, _dsu_dep!(), 1880000, 1.918, 1.9844),
      ("Tensor G4", 1425000, _dsu_dep!(), 1880000, 2.0013, 1.5541),
      ("Tensor G4", 1548000, _dsu_dep!(), 1880000, 2.0504, 1.9877),
      ("Tensor G4", 1696000, _dsu_dep!(), 1880000, 1.9603, 1.8955),
      ("Tensor G4", 1849000, _dsu_dep!(), 1880000, 2.1168, 1.9674),
      ("Tensor G4", 1950000, _dsu_dep!(), 1880000, 2.2047, 2.4697),
      ("Tensor G4", 820000, _dsu_dep!(), 1950000, 1.9756, 1.4938),
      ("Tensor G4", 955000, _dsu_dep!(), 1950000, 1.90147, 1.8144),
      ("Tensor G4", 1098000, _dsu_dep!(), 1950000, 2.1539, 2.0811),
      ("Tensor G4", 1197000, _dsu_dep!(), 1950000, 2.2192, 1.8968),
      ("Tensor G4", 1328000, _dsu_dep!(), 1950000, 2.2974, 2.1572),
      ("Tensor G4", 1425000, _dsu_dep!(), 1950000, 2.3865, 2.2972),
      ("Tensor G4", 1548000, _dsu_dep!(), 1950000, 2.4361, 2.3942),
      ("Tensor G4", 1696000, _dsu_dep!(), 1950000, 2.8677, 2.2737),
      ("Tensor G4", 1849000, _dsu_dep!(), 1950000, 2.6123, 2.5181),
      ("Tensor G4", 1950000, _dsu_dep!(), 1950000, 2.7293, 2.5798),
      ("Tensor G4", 820000, _dsu_dep!(), 2024000, 2.0136, 1.7557),
      ("Tensor G4", 955000, _dsu_dep!(), 2024000, 1.9834, 1.6844),
      ("Tensor G4", 1098000, _dsu_dep!(), 2024000, 2.1129, 1.8735),
      ("Tensor G4", 1197000, _dsu_dep!(), 2024000, 2.5894, 2.2185),
      ("Tensor G4", 1328000, _dsu_dep!(), 2024000, 2.6949, 2.1905),
      ("Tensor G4", 1425000, _dsu_dep!(), 2024000, 2.8143, 2.7641),
      ("Tensor G4", 1548000, _dsu_dep!(), 2024000, 2.8513, 2.6064),
      ("Tensor G4", 1696000, _dsu_dep!(), 2024000, 2.663, 2.3265),
      ("Tensor G4", 1849000, _dsu_dep!(), 2024000, 2.6618, 2.595),
      ("Tensor G4", 1950000, _dsu_dep!(), 2024000, 2.7227, 2.7533),
      ("Tensor G4", 820000, _dsu_dep!(), 2120000, 2.5414, 2.6693),
      ("Tensor G4", 955000, _dsu_dep!(), 2120000, 2.7682, 2.7252),
      ("Tensor G4", 1098000, _dsu_dep!(), 2120000, 3.1524, 2.8636),
      ("Tensor G4", 1197000, _dsu_dep!(), 2120000, 3.0192, 2.6325),
      ("Tensor G4", 1328000, _dsu_dep!(), 2120000, 2.9797, 3.1899),
      ("Tensor G4", 1425000, _dsu_dep!(), 2120000, 3.176, 3.069),
      ("Tensor G4", 1548000, _dsu_dep!(), 2120000, 3.1105, 2.2982),
      ("Tensor G4", 1696000, _dsu_dep!(), 2120000, 2.9221, 3.2752),
      ("Tensor G4", 1849000, _dsu_dep!(), 2120000, 3.2659, 3.0112),
      ("Tensor G4", 1950000, _dsu_dep!(), 2120000, 3.1351, 3.5576),
      ("Tensor G4", 820000, _dsu_dep!(), 2150000, 2.9947, 2.6827),
      ("Tensor G4", 955000, _dsu_dep!(), 2150000, 2.9357, 2.5455),
      ("Tensor G4", 1098000, _dsu_dep!(), 2150000, 3.1562, 2.8923),
      ("Tensor G4", 1197000, _dsu_dep!(), 2150000, 3.0068, 3.2811),
      ("Tensor G4", 1328000, _dsu_dep!(), 2150000, 3.1187, 3.0526),
      ("Tensor G4", 1425000, _dsu_dep!(), 2150000, 3.2907, 2.9659),
      ("Tensor G4", 1548000, _dsu_dep!(), 2150000, 2.9841, 3.347),
      ("Tensor G4", 1696000, _dsu_dep!(), 2150000, 3.2313, 3.1632),
      ("Tensor G4", 1849000, _dsu_dep!(), 2150000, 3.091, 3.1305),
      ("Tensor G4", 1950000, _dsu_dep!(), 2150000, 3.326, 3.0211)) AS _values
  )
SELECT
  *
FROM data
UNION ALL
SELECT
  *
FROM _tg5_l3_lut;
