#pragma once
/*
 *  $Id: selection.h 28515 2025-09-05 05:07:39Z yeti-dn $
 *  Copyright (C) 2003-2024 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_SELECTION_H__
#define __GWY_SELECTION_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define GWY_TYPE_SELECTION            (gwy_selection_get_type())
#define GWY_SELECTION(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_SELECTION, GwySelection))
#define GWY_SELECTION_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_SELECTION, GwySelectionClass))
#define GWY_IS_SELECTION(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_SELECTION))
#define GWY_IS_SELECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_SELECTION))
#define GWY_SELECTION_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_SELECTION, GwySelectionClass))

typedef struct _GwySelection             GwySelection;
typedef struct _GwySelectionClass        GwySelectionClass;
typedef struct _GwySelectionPrivate      GwySelectionPrivate;
typedef struct _GwySelectionClassPrivate GwySelectionClassPrivate;

struct _GwySelection {
    GObject parent_instance;
    GwySelectionPrivate *priv;
};

struct _GwySelectionClass {
    GObjectClass parent_class;
    GwySelectionClassPrivate *priv;

    guint object_size;

    /* TODO: maybe geometrical methods: clamp (the same as crop?), scale */
    void (*crop)(GwySelection *selection,
                 gdouble xmin,
                 gdouble ymin,
                 gdouble xmax,
                 gdouble ymax);
    void (*move)(GwySelection *selection,
                 gdouble xv,
                 gdouble vy);
    const gchar* (*coord_symbol)(GwySelection *selection,
                                 gint i);

    /*< private >*/
    void (*reserved1)(void);
    void (*reserved2)(void);
    void (*reserved3)(void);
    void (*reserved4)(void);
    void (*reserved5)(void);
    void (*reserved6)(void);

    /* Signals */
    /*< public >*/
    void (*changed)(GwySelection *selection,
                    gint i);
    void (*finished)(GwySelection *selection);
};

typedef gboolean (*GwySelectionFilterFunc)(GwySelection *selection,
                                           gint i,
                                           gpointer data);

GType          gwy_selection_get_type          (void)                          G_GNUC_CONST;
guint          gwy_selection_get_object_size   (GwySelection *selection);
const gchar*   gwy_selection_get_coord_symbol  (GwySelection *selection,
                                                gint i);
void           gwy_selection_clear             (GwySelection *selection);
gboolean       gwy_selection_get_object        (GwySelection *selection,
                                                gint i,
                                                gdouble *data);
gint           gwy_selection_set_object        (GwySelection *selection,
                                                gint i,
                                                const gdouble *data);
void           gwy_selection_delete_object     (GwySelection *selection,
                                                gint i);
gint           gwy_selection_get_data          (GwySelection *selection,
                                                gdouble *data);
gint           gwy_selection_get_n_objects     (GwySelection *selection);
const gdouble* gwy_selection_get_data_array    (GwySelection *selection);
void           gwy_selection_set_data          (GwySelection *selection,
                                                gint nselected,
                                                const gdouble *data);
guint          gwy_selection_get_max_objects   (GwySelection *selection);
void           gwy_selection_set_max_objects   (GwySelection *selection,
                                                guint max_objects);
gboolean       gwy_selection_is_full           (GwySelection *selection);
void           gwy_selection_crop              (GwySelection *selection,
                                                gdouble xmin,
                                                gdouble ymin,
                                                gdouble xmax,
                                                gdouble ymax);
void           gwy_selection_move              (GwySelection *selection,
                                                gdouble vx,
                                                gdouble vy);
void           gwy_selection_filter            (GwySelection *selection,
                                                GwySelectionFilterFunc filter,
                                                gpointer data);
void           gwy_selection_move_objects      (GwySelection *selection,
                                                const gdouble *v);
void           gwy_selection_changed           (GwySelection *selection,
                                                gint i);
gboolean       gwy_selection_get_changed_object(GwySelection *selection,
                                                gdouble *data);
void           gwy_selection_finished          (GwySelection *selection);
GwySelection*  gwy_selection_copy              (GwySelection *selection);
void           gwy_selection_assign            (GwySelection *destination,
                                                GwySelection *source);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
