// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/securityposture/v1/securityposture.proto

package securityposturepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// State of a Posture.
type Posture_State int32

const (
	// Unspecified operation state.
	Posture_STATE_UNSPECIFIED Posture_State = 0
	// The Posture is marked deprecated when it is not in use by the user.
	Posture_DEPRECATED Posture_State = 1
	// The Posture is created successfully but is not yet ready for usage.
	Posture_DRAFT Posture_State = 2
	// The Posture state is active. Ready for use/deployments.
	Posture_ACTIVE Posture_State = 3
)

// Enum value maps for Posture_State.
var (
	Posture_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "DEPRECATED",
		2: "DRAFT",
		3: "ACTIVE",
	}
	Posture_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"DEPRECATED":        1,
		"DRAFT":             2,
		"ACTIVE":            3,
	}
)

func (x Posture_State) Enum() *Posture_State {
	p := new(Posture_State)
	*p = x
	return p
}

func (x Posture_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Posture_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securityposture_v1_securityposture_proto_enumTypes[0].Descriptor()
}

func (Posture_State) Type() protoreflect.EnumType {
	return &file_google_cloud_securityposture_v1_securityposture_proto_enumTypes[0]
}

func (x Posture_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Posture_State.Descriptor instead.
func (Posture_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{1, 0}
}

// State of a PostureDeployment.
type PostureDeployment_State int32

const (
	// Unspecified operation state.
	PostureDeployment_STATE_UNSPECIFIED PostureDeployment_State = 0
	// The PostureDeployment is being created.
	PostureDeployment_CREATING PostureDeployment_State = 1
	// The PostureDeployment is being deleted.
	PostureDeployment_DELETING PostureDeployment_State = 2
	// The PostureDeployment state is being updated.
	PostureDeployment_UPDATING PostureDeployment_State = 3
	// The PostureDeployment state is active and in use.
	PostureDeployment_ACTIVE PostureDeployment_State = 4
	// The PostureDeployment creation failed.
	PostureDeployment_CREATE_FAILED PostureDeployment_State = 5
	// The PostureDeployment update failed.
	PostureDeployment_UPDATE_FAILED PostureDeployment_State = 6
	// The PostureDeployment deletion failed.
	PostureDeployment_DELETE_FAILED PostureDeployment_State = 7
)

// Enum value maps for PostureDeployment_State.
var (
	PostureDeployment_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "DELETING",
		3: "UPDATING",
		4: "ACTIVE",
		5: "CREATE_FAILED",
		6: "UPDATE_FAILED",
		7: "DELETE_FAILED",
	}
	PostureDeployment_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"DELETING":          2,
		"UPDATING":          3,
		"ACTIVE":            4,
		"CREATE_FAILED":     5,
		"UPDATE_FAILED":     6,
		"DELETE_FAILED":     7,
	}
)

func (x PostureDeployment_State) Enum() *PostureDeployment_State {
	p := new(PostureDeployment_State)
	*p = x
	return p
}

func (x PostureDeployment_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PostureDeployment_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securityposture_v1_securityposture_proto_enumTypes[1].Descriptor()
}

func (PostureDeployment_State) Type() protoreflect.EnumType {
	return &file_google_cloud_securityposture_v1_securityposture_proto_enumTypes[1]
}

func (x PostureDeployment_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PostureDeployment_State.Descriptor instead.
func (PostureDeployment_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{14, 0}
}

// State of a PostureTemplate
type PostureTemplate_State int32

const (
	// Unspecified state
	PostureTemplate_STATE_UNSPECIFIED PostureTemplate_State = 0
	// If the Posture template is adhering to the latest controls and standards.
	PostureTemplate_ACTIVE PostureTemplate_State = 1
	// If the Posture template controls and standards are outdated and not
	// recommended for use.
	PostureTemplate_DEPRECATED PostureTemplate_State = 2
)

// Enum value maps for PostureTemplate_State.
var (
	PostureTemplate_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "DEPRECATED",
	}
	PostureTemplate_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"DEPRECATED":        2,
	}
)

func (x PostureTemplate_State) Enum() *PostureTemplate_State {
	p := new(PostureTemplate_State)
	*p = x
	return p
}

func (x PostureTemplate_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PostureTemplate_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securityposture_v1_securityposture_proto_enumTypes[2].Descriptor()
}

func (PostureTemplate_State) Type() protoreflect.EnumType {
	return &file_google_cloud_securityposture_v1_securityposture_proto_enumTypes[2]
}

func (x PostureTemplate_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PostureTemplate_State.Descriptor instead.
func (PostureTemplate_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{21, 0}
}

// Represents the metadata of the long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have been cancelled successfully
	// have [Operation.error][] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
	// `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
	// Output only. This is a output only optional field which will be filled only
	// in cases where PostureDeployments enter failure states like UPDATE_FAILED
	// or CREATE_FAILED or DELETE_FAILED.
	ErrorMessage string `protobuf:"bytes,8,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{0}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

func (x *OperationMetadata) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

// Postures
// Definition of a Posture.
type Posture struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Identifier. The name of this Posture resource, in the format of
	// organizations/{org_id}/locations/{location_id}/postures/{posture}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. State of Posture resource.
	State Posture_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.securityposture.v1.Posture_State" json:"state,omitempty"`
	// Output only. Immutable. The revision ID of the posture.
	// The format is an 8-character hexadecimal string.
	// https://google.aip.dev/162
	RevisionId string `protobuf:"bytes,3,opt,name=revision_id,json=revisionId,proto3" json:"revision_id,omitempty"`
	// Output only. The timestamp that the posture was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp that the posture was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. User provided description of the posture.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// Required. List of Policy sets.
	PolicySets []*PolicySet `protobuf:"bytes,7,rep,name=policy_sets,json=policySets,proto3" json:"policy_sets,omitempty"`
	// Optional. An opaque tag indicating the current version of the Posture, used
	// for concurrency control. When the `Posture` is returned from either a
	// `GetPosture` or a `ListPostures` request, this `etag` indicates the version
	// of the current `Posture` to use when executing a read-modify-write loop.
	//
	// When the `Posture` is used in a `UpdatePosture` method, use the `etag`
	// value that was returned from a `GetPosture` request as part of a
	// read-modify-write loop for concurrency control. Not setting the `etag` in a
	// `UpdatePosture` request will result in an unconditional write of the
	// `Posture`.
	Etag string `protobuf:"bytes,8,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. User annotations. These attributes can only be set and used by
	// the user, and not by Google Security Postures.
	// .
	Annotations map[string]string `protobuf:"bytes,9,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Whether or not this Posture is in the process of being
	// updated.
	Reconciling bool `protobuf:"varint,10,opt,name=reconciling,proto3" json:"reconciling,omitempty"`
}

func (x *Posture) Reset() {
	*x = Posture{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Posture) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Posture) ProtoMessage() {}

func (x *Posture) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Posture.ProtoReflect.Descriptor instead.
func (*Posture) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{1}
}

func (x *Posture) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Posture) GetState() Posture_State {
	if x != nil {
		return x.State
	}
	return Posture_STATE_UNSPECIFIED
}

func (x *Posture) GetRevisionId() string {
	if x != nil {
		return x.RevisionId
	}
	return ""
}

func (x *Posture) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Posture) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Posture) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Posture) GetPolicySets() []*PolicySet {
	if x != nil {
		return x.PolicySets
	}
	return nil
}

func (x *Posture) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Posture) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *Posture) GetReconciling() bool {
	if x != nil {
		return x.Reconciling
	}
	return false
}

// PolicySet representation.
type PolicySet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the Policy set.
	PolicySetId string `protobuf:"bytes,1,opt,name=policy_set_id,json=policySetId,proto3" json:"policy_set_id,omitempty"`
	// Optional. Description of the Policy set.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Required. List of policies.
	Policies []*Policy `protobuf:"bytes,3,rep,name=policies,proto3" json:"policies,omitempty"`
}

func (x *PolicySet) Reset() {
	*x = PolicySet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PolicySet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicySet) ProtoMessage() {}

func (x *PolicySet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicySet.ProtoReflect.Descriptor instead.
func (*PolicySet) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{2}
}

func (x *PolicySet) GetPolicySetId() string {
	if x != nil {
		return x.PolicySetId
	}
	return ""
}

func (x *PolicySet) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *PolicySet) GetPolicies() []*Policy {
	if x != nil {
		return x.Policies
	}
	return nil
}

// Policy representation.
type Policy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the Policy that is user generated, immutable and unique
	// within the scope of a policy set.
	PolicyId string `protobuf:"bytes,1,opt,name=policy_id,json=policyId,proto3" json:"policy_id,omitempty"`
	// Optional. Contains list of mapping for a Policy to a standard and control.
	ComplianceStandards []*Policy_ComplianceStandard `protobuf:"bytes,2,rep,name=compliance_standards,json=complianceStandards,proto3" json:"compliance_standards,omitempty"`
	// Required. Constraint details.
	Constraint *Constraint `protobuf:"bytes,3,opt,name=constraint,proto3" json:"constraint,omitempty"`
	// Optional. Description of the Policy.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *Policy) Reset() {
	*x = Policy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Policy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Policy) ProtoMessage() {}

func (x *Policy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Policy.ProtoReflect.Descriptor instead.
func (*Policy) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{3}
}

func (x *Policy) GetPolicyId() string {
	if x != nil {
		return x.PolicyId
	}
	return ""
}

func (x *Policy) GetComplianceStandards() []*Policy_ComplianceStandard {
	if x != nil {
		return x.ComplianceStandards
	}
	return nil
}

func (x *Policy) GetConstraint() *Constraint {
	if x != nil {
		return x.Constraint
	}
	return nil
}

func (x *Policy) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// Representation of a Constraint.
type Constraint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Implementation:
	//
	//	*Constraint_SecurityHealthAnalyticsModule
	//	*Constraint_SecurityHealthAnalyticsCustomModule
	//	*Constraint_OrgPolicyConstraint
	//	*Constraint_OrgPolicyConstraintCustom
	Implementation isConstraint_Implementation `protobuf_oneof:"implementation"`
}

func (x *Constraint) Reset() {
	*x = Constraint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Constraint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Constraint) ProtoMessage() {}

func (x *Constraint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Constraint.ProtoReflect.Descriptor instead.
func (*Constraint) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{4}
}

func (m *Constraint) GetImplementation() isConstraint_Implementation {
	if m != nil {
		return m.Implementation
	}
	return nil
}

func (x *Constraint) GetSecurityHealthAnalyticsModule() *SecurityHealthAnalyticsModule {
	if x, ok := x.GetImplementation().(*Constraint_SecurityHealthAnalyticsModule); ok {
		return x.SecurityHealthAnalyticsModule
	}
	return nil
}

func (x *Constraint) GetSecurityHealthAnalyticsCustomModule() *SecurityHealthAnalyticsCustomModule {
	if x, ok := x.GetImplementation().(*Constraint_SecurityHealthAnalyticsCustomModule); ok {
		return x.SecurityHealthAnalyticsCustomModule
	}
	return nil
}

func (x *Constraint) GetOrgPolicyConstraint() *OrgPolicyConstraint {
	if x, ok := x.GetImplementation().(*Constraint_OrgPolicyConstraint); ok {
		return x.OrgPolicyConstraint
	}
	return nil
}

func (x *Constraint) GetOrgPolicyConstraintCustom() *OrgPolicyConstraintCustom {
	if x, ok := x.GetImplementation().(*Constraint_OrgPolicyConstraintCustom); ok {
		return x.OrgPolicyConstraintCustom
	}
	return nil
}

type isConstraint_Implementation interface {
	isConstraint_Implementation()
}

type Constraint_SecurityHealthAnalyticsModule struct {
	// Optional. SHA built-in detector.
	SecurityHealthAnalyticsModule *SecurityHealthAnalyticsModule `protobuf:"bytes,3,opt,name=security_health_analytics_module,json=securityHealthAnalyticsModule,proto3,oneof"`
}

type Constraint_SecurityHealthAnalyticsCustomModule struct {
	// Optional. SHA custom detector.
	SecurityHealthAnalyticsCustomModule *SecurityHealthAnalyticsCustomModule `protobuf:"bytes,4,opt,name=security_health_analytics_custom_module,json=securityHealthAnalyticsCustomModule,proto3,oneof"`
}

type Constraint_OrgPolicyConstraint struct {
	// Optional. Org Policy builtin constraint.
	OrgPolicyConstraint *OrgPolicyConstraint `protobuf:"bytes,5,opt,name=org_policy_constraint,json=orgPolicyConstraint,proto3,oneof"`
}

type Constraint_OrgPolicyConstraintCustom struct {
	// Optional. Org Policy custom constraint.
	OrgPolicyConstraintCustom *OrgPolicyConstraintCustom `protobuf:"bytes,6,opt,name=org_policy_constraint_custom,json=orgPolicyConstraintCustom,proto3,oneof"`
}

func (*Constraint_SecurityHealthAnalyticsModule) isConstraint_Implementation() {}

func (*Constraint_SecurityHealthAnalyticsCustomModule) isConstraint_Implementation() {}

func (*Constraint_OrgPolicyConstraint) isConstraint_Implementation() {}

func (*Constraint_OrgPolicyConstraintCustom) isConstraint_Implementation() {}

// Message for requesting list of Postures.
type ListPosturesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for ListPosturesRequest.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer items than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListPosturesRequest) Reset() {
	*x = ListPosturesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPosturesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPosturesRequest) ProtoMessage() {}

func (x *ListPosturesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPosturesRequest.ProtoReflect.Descriptor instead.
func (*ListPosturesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{5}
}

func (x *ListPosturesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPosturesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPosturesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Message for response to listing Postures.
type ListPosturesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Posture.
	Postures []*Posture `protobuf:"bytes,1,rep,name=postures,proto3" json:"postures,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Unreachable resources.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListPosturesResponse) Reset() {
	*x = ListPosturesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPosturesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPosturesResponse) ProtoMessage() {}

func (x *ListPosturesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPosturesResponse.ProtoReflect.Descriptor instead.
func (*ListPosturesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{6}
}

func (x *ListPosturesResponse) GetPostures() []*Posture {
	if x != nil {
		return x.Postures
	}
	return nil
}

func (x *ListPosturesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListPosturesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for requesting list of Posture revisions.
type ListPostureRevisionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name value for ListPostureRevisionsRequest.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Requested page size. Server may return fewer items than
	// requested. If unspecified, server will pick 100 as default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListPostureRevisionsRequest) Reset() {
	*x = ListPostureRevisionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPostureRevisionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPostureRevisionsRequest) ProtoMessage() {}

func (x *ListPostureRevisionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPostureRevisionsRequest.ProtoReflect.Descriptor instead.
func (*ListPostureRevisionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{7}
}

func (x *ListPostureRevisionsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ListPostureRevisionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPostureRevisionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Message for response to listing PostureRevisions.
type ListPostureRevisionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Posture revisions.
	Revisions []*Posture `protobuf:"bytes,1,rep,name=revisions,proto3" json:"revisions,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPostureRevisionsResponse) Reset() {
	*x = ListPostureRevisionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPostureRevisionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPostureRevisionsResponse) ProtoMessage() {}

func (x *ListPostureRevisionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPostureRevisionsResponse.ProtoReflect.Descriptor instead.
func (*ListPostureRevisionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{8}
}

func (x *ListPostureRevisionsResponse) GetRevisions() []*Posture {
	if x != nil {
		return x.Revisions
	}
	return nil
}

func (x *ListPostureRevisionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Message for getting a Posture.
type GetPostureRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Posture revision which needs to be retrieved.
	RevisionId string `protobuf:"bytes,3,opt,name=revision_id,json=revisionId,proto3" json:"revision_id,omitempty"`
}

func (x *GetPostureRequest) Reset() {
	*x = GetPostureRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPostureRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPostureRequest) ProtoMessage() {}

func (x *GetPostureRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPostureRequest.ProtoReflect.Descriptor instead.
func (*GetPostureRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{9}
}

func (x *GetPostureRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetPostureRequest) GetRevisionId() string {
	if x != nil {
		return x.RevisionId
	}
	return ""
}

// Message for creating a Posture.
type CreatePostureRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. User provided identifier. It should be unique in scope of an
	// Organization and location.
	PostureId string `protobuf:"bytes,2,opt,name=posture_id,json=postureId,proto3" json:"posture_id,omitempty"`
	// Required. The resource being created.
	Posture *Posture `protobuf:"bytes,3,opt,name=posture,proto3" json:"posture,omitempty"`
}

func (x *CreatePostureRequest) Reset() {
	*x = CreatePostureRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreatePostureRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePostureRequest) ProtoMessage() {}

func (x *CreatePostureRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePostureRequest.ProtoReflect.Descriptor instead.
func (*CreatePostureRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{10}
}

func (x *CreatePostureRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreatePostureRequest) GetPostureId() string {
	if x != nil {
		return x.PostureId
	}
	return ""
}

func (x *CreatePostureRequest) GetPosture() *Posture {
	if x != nil {
		return x.Posture
	}
	return nil
}

// Message for updating a Posture.
type UpdatePostureRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// Posture resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The resource being updated.
	Posture *Posture `protobuf:"bytes,2,opt,name=posture,proto3" json:"posture,omitempty"`
	// Required. Posture revision which needs to be updated.
	RevisionId string `protobuf:"bytes,3,opt,name=revision_id,json=revisionId,proto3" json:"revision_id,omitempty"`
}

func (x *UpdatePostureRequest) Reset() {
	*x = UpdatePostureRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdatePostureRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePostureRequest) ProtoMessage() {}

func (x *UpdatePostureRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePostureRequest.ProtoReflect.Descriptor instead.
func (*UpdatePostureRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{11}
}

func (x *UpdatePostureRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdatePostureRequest) GetPosture() *Posture {
	if x != nil {
		return x.Posture
	}
	return nil
}

func (x *UpdatePostureRequest) GetRevisionId() string {
	if x != nil {
		return x.RevisionId
	}
	return ""
}

// Message for deleting a Posture.
type DeletePostureRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Etag value of the Posture to be deleted.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeletePostureRequest) Reset() {
	*x = DeletePostureRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeletePostureRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePostureRequest) ProtoMessage() {}

func (x *DeletePostureRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePostureRequest.ProtoReflect.Descriptor instead.
func (*DeletePostureRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{12}
}

func (x *DeletePostureRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeletePostureRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Message for extracting existing policies on a workload as a Posture.
type ExtractPostureRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name. The format of this value is as follows:
	// `organizations/{organization}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. User provided identifier. It should be unique in scope of an
	// Organization and location.
	PostureId string `protobuf:"bytes,2,opt,name=posture_id,json=postureId,proto3" json:"posture_id,omitempty"`
	// Required. Workload from which the policies are to be extracted, it should
	// belong to the same organization defined in parent. The format of this value
	// varies depending on the scope of the request:
	// - `folder/folderNumber`
	// - `project/projectNumber`
	// - `organization/organizationNumber`
	Workload string `protobuf:"bytes,3,opt,name=workload,proto3" json:"workload,omitempty"`
}

func (x *ExtractPostureRequest) Reset() {
	*x = ExtractPostureRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExtractPostureRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExtractPostureRequest) ProtoMessage() {}

func (x *ExtractPostureRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExtractPostureRequest.ProtoReflect.Descriptor instead.
func (*ExtractPostureRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{13}
}

func (x *ExtractPostureRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ExtractPostureRequest) GetPostureId() string {
	if x != nil {
		return x.PostureId
	}
	return ""
}

func (x *ExtractPostureRequest) GetWorkload() string {
	if x != nil {
		return x.Workload
	}
	return ""
}

// ========================== PostureDeployments ==========================
// Message describing PostureDeployment resource.
type PostureDeployment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of this PostureDeployment resource, in the format of
	// organizations/{organization}/locations/{location_id}/postureDeployments/{postureDeployment}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Target resource where the Posture will be deployed. Currently
	// supported resources are of types: projects/projectNumber,
	// folders/folderNumber, organizations/organizationNumber.
	TargetResource string `protobuf:"bytes,13,opt,name=target_resource,json=targetResource,proto3" json:"target_resource,omitempty"`
	// Output only. State of PostureDeployment resource.
	State PostureDeployment_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.securityposture.v1.PostureDeployment_State" json:"state,omitempty"`
	// Required. Posture that needs to be deployed.
	// Format:
	// organizations/{org_id}/locations/{location_id}/postures/<posture>
	// Example:
	// organizations/99/locations/global/postures/les-miserables.
	PostureId string `protobuf:"bytes,3,opt,name=posture_id,json=postureId,proto3" json:"posture_id,omitempty"`
	// Required. Revision_id of the Posture that is to be deployed.
	PostureRevisionId string `protobuf:"bytes,4,opt,name=posture_revision_id,json=postureRevisionId,proto3" json:"posture_revision_id,omitempty"`
	// Output only. The timestamp that the PostureDeployment was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp that the PostureDeployment was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. User provided description of the PostureDeployment.
	Description string `protobuf:"bytes,7,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. An opaque tag indicating the current version of the
	// PostureDeployment, used for concurrency control. When the
	// `PostureDeployment` is returned from either a `GetPostureDeployment` or a
	// `ListPostureDeployments` request, this `etag` indicates the version of the
	// current `PostureDeployment` to use when executing a read-modify-write loop.
	//
	// When the `PostureDeployment` is used in a `UpdatePostureDeployment` method,
	// use the `etag` value that was returned from a `GetPostureDeployment`
	// request as part of a read-modify-write loop for concurrency control. Not
	// setting the `etag` in a `UpdatePostureDeployment` request will result in an
	// unconditional write of the `PostureDeployment`.
	Etag string `protobuf:"bytes,8,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. User annotations. These attributes can only be set and used by
	// the user, and not by Google Security Postures.
	// .
	Annotations map[string]string `protobuf:"bytes,9,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Whether or not this Posture is in the process of being
	// updated.
	Reconciling bool `protobuf:"varint,10,opt,name=reconciling,proto3" json:"reconciling,omitempty"`
	// Output only. This is a output only optional field which will be filled in
	// case where PostureDeployment state is UPDATE_FAILED or CREATE_FAILED or
	// DELETE_FAILED. It denotes the desired Posture.
	DesiredPostureId string `protobuf:"bytes,11,opt,name=desired_posture_id,json=desiredPostureId,proto3" json:"desired_posture_id,omitempty"`
	// Output only. Output only optional field which provides revision_id of the
	// desired_posture_id.
	DesiredPostureRevisionId string `protobuf:"bytes,12,opt,name=desired_posture_revision_id,json=desiredPostureRevisionId,proto3" json:"desired_posture_revision_id,omitempty"`
	// Output only. This is a output only optional field which will be filled in
	// case where PostureDeployment enters a failure state like UPDATE_FAILED or
	// CREATE_FAILED or DELETE_FAILED.
	FailureMessage string `protobuf:"bytes,14,opt,name=failure_message,json=failureMessage,proto3" json:"failure_message,omitempty"`
}

func (x *PostureDeployment) Reset() {
	*x = PostureDeployment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PostureDeployment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PostureDeployment) ProtoMessage() {}

func (x *PostureDeployment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PostureDeployment.ProtoReflect.Descriptor instead.
func (*PostureDeployment) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{14}
}

func (x *PostureDeployment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PostureDeployment) GetTargetResource() string {
	if x != nil {
		return x.TargetResource
	}
	return ""
}

func (x *PostureDeployment) GetState() PostureDeployment_State {
	if x != nil {
		return x.State
	}
	return PostureDeployment_STATE_UNSPECIFIED
}

func (x *PostureDeployment) GetPostureId() string {
	if x != nil {
		return x.PostureId
	}
	return ""
}

func (x *PostureDeployment) GetPostureRevisionId() string {
	if x != nil {
		return x.PostureRevisionId
	}
	return ""
}

func (x *PostureDeployment) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *PostureDeployment) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *PostureDeployment) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *PostureDeployment) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *PostureDeployment) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *PostureDeployment) GetReconciling() bool {
	if x != nil {
		return x.Reconciling
	}
	return false
}

func (x *PostureDeployment) GetDesiredPostureId() string {
	if x != nil {
		return x.DesiredPostureId
	}
	return ""
}

func (x *PostureDeployment) GetDesiredPostureRevisionId() string {
	if x != nil {
		return x.DesiredPostureRevisionId
	}
	return ""
}

func (x *PostureDeployment) GetFailureMessage() string {
	if x != nil {
		return x.FailureMessage
	}
	return ""
}

// Message for requesting list of PostureDeployments.
type ListPostureDeploymentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for ListPostureDeploymentsRequest.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. Server may return fewer items than
	// requested. If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter to be applied on the resource, defined by EBNF grammar
	// https://google.aip.dev/assets/misc/ebnf-filtering.txt.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListPostureDeploymentsRequest) Reset() {
	*x = ListPostureDeploymentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPostureDeploymentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPostureDeploymentsRequest) ProtoMessage() {}

func (x *ListPostureDeploymentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPostureDeploymentsRequest.ProtoReflect.Descriptor instead.
func (*ListPostureDeploymentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{15}
}

func (x *ListPostureDeploymentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPostureDeploymentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPostureDeploymentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPostureDeploymentsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Message for response to listing PostureDeployments.
type ListPostureDeploymentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of PostureDeployment.
	PostureDeployments []*PostureDeployment `protobuf:"bytes,1,rep,name=posture_deployments,json=postureDeployments,proto3" json:"posture_deployments,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListPostureDeploymentsResponse) Reset() {
	*x = ListPostureDeploymentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPostureDeploymentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPostureDeploymentsResponse) ProtoMessage() {}

func (x *ListPostureDeploymentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPostureDeploymentsResponse.ProtoReflect.Descriptor instead.
func (*ListPostureDeploymentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{16}
}

func (x *ListPostureDeploymentsResponse) GetPostureDeployments() []*PostureDeployment {
	if x != nil {
		return x.PostureDeployments
	}
	return nil
}

func (x *ListPostureDeploymentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListPostureDeploymentsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for getting a PostureDeployment.
type GetPostureDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPostureDeploymentRequest) Reset() {
	*x = GetPostureDeploymentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPostureDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPostureDeploymentRequest) ProtoMessage() {}

func (x *GetPostureDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPostureDeploymentRequest.ProtoReflect.Descriptor instead.
func (*GetPostureDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{17}
}

func (x *GetPostureDeploymentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for creating a PostureDeployment.
type CreatePostureDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for parent.
	// Format: organizations/{org_id}/locations/{location}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. User provided identifier. It should be unique in scope of an
	// Organization and location.
	PostureDeploymentId string `protobuf:"bytes,2,opt,name=posture_deployment_id,json=postureDeploymentId,proto3" json:"posture_deployment_id,omitempty"`
	// Required. The resource being created.
	PostureDeployment *PostureDeployment `protobuf:"bytes,3,opt,name=posture_deployment,json=postureDeployment,proto3" json:"posture_deployment,omitempty"`
}

func (x *CreatePostureDeploymentRequest) Reset() {
	*x = CreatePostureDeploymentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreatePostureDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePostureDeploymentRequest) ProtoMessage() {}

func (x *CreatePostureDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePostureDeploymentRequest.ProtoReflect.Descriptor instead.
func (*CreatePostureDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{18}
}

func (x *CreatePostureDeploymentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreatePostureDeploymentRequest) GetPostureDeploymentId() string {
	if x != nil {
		return x.PostureDeploymentId
	}
	return ""
}

func (x *CreatePostureDeploymentRequest) GetPostureDeployment() *PostureDeployment {
	if x != nil {
		return x.PostureDeployment
	}
	return nil
}

// Message for updating a PostureDeployment.
type UpdatePostureDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// PostureDeployment resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The resource being updated.
	PostureDeployment *PostureDeployment `protobuf:"bytes,2,opt,name=posture_deployment,json=postureDeployment,proto3" json:"posture_deployment,omitempty"`
}

func (x *UpdatePostureDeploymentRequest) Reset() {
	*x = UpdatePostureDeploymentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdatePostureDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePostureDeploymentRequest) ProtoMessage() {}

func (x *UpdatePostureDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePostureDeploymentRequest.ProtoReflect.Descriptor instead.
func (*UpdatePostureDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{19}
}

func (x *UpdatePostureDeploymentRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdatePostureDeploymentRequest) GetPostureDeployment() *PostureDeployment {
	if x != nil {
		return x.PostureDeployment
	}
	return nil
}

// Message for deleting a PostureDeployment.
type DeletePostureDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Etag value of the PostureDeployment to be deleted.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeletePostureDeploymentRequest) Reset() {
	*x = DeletePostureDeploymentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeletePostureDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePostureDeploymentRequest) ProtoMessage() {}

func (x *DeletePostureDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePostureDeploymentRequest.ProtoReflect.Descriptor instead.
func (*DeletePostureDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{20}
}

func (x *DeletePostureDeploymentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeletePostureDeploymentRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// PostureTemplates
// Message describing PostureTemplate object.
type PostureTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier. The name of the Posture template will be of the
	// format
	// organizations/{organization}/locations/{location}/postureTemplates/{postureTemplate}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The revision_id of a PostureTemplate.
	RevisionId string `protobuf:"bytes,2,opt,name=revision_id,json=revisionId,proto3" json:"revision_id,omitempty"`
	// Output only. Description of the Posture template.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. State of PostureTemplate resource.
	State PostureTemplate_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.securityposture.v1.PostureTemplate_State" json:"state,omitempty"`
	// Output only. Policy_sets to be used by the user.
	PolicySets []*PolicySet `protobuf:"bytes,5,rep,name=policy_sets,json=policySets,proto3" json:"policy_sets,omitempty"`
}

func (x *PostureTemplate) Reset() {
	*x = PostureTemplate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PostureTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PostureTemplate) ProtoMessage() {}

func (x *PostureTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PostureTemplate.ProtoReflect.Descriptor instead.
func (*PostureTemplate) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{21}
}

func (x *PostureTemplate) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PostureTemplate) GetRevisionId() string {
	if x != nil {
		return x.RevisionId
	}
	return ""
}

func (x *PostureTemplate) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *PostureTemplate) GetState() PostureTemplate_State {
	if x != nil {
		return x.State
	}
	return PostureTemplate_STATE_UNSPECIFIED
}

func (x *PostureTemplate) GetPolicySets() []*PolicySet {
	if x != nil {
		return x.PolicySets
	}
	return nil
}

// Message for requesting list of Posture Templates.
type ListPostureTemplatesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for ListPostureTemplatesRequest.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. Server may return fewer items than
	// requested. If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter to be applied on the resource, defined by EBNF grammar
	// https://google.aip.dev/assets/misc/ebnf-filtering.txt.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListPostureTemplatesRequest) Reset() {
	*x = ListPostureTemplatesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPostureTemplatesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPostureTemplatesRequest) ProtoMessage() {}

func (x *ListPostureTemplatesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPostureTemplatesRequest.ProtoReflect.Descriptor instead.
func (*ListPostureTemplatesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{22}
}

func (x *ListPostureTemplatesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPostureTemplatesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPostureTemplatesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPostureTemplatesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Message for response to listing PostureTemplates.
type ListPostureTemplatesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of PostureTemplate.
	PostureTemplates []*PostureTemplate `protobuf:"bytes,1,rep,name=posture_templates,json=postureTemplates,proto3" json:"posture_templates,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPostureTemplatesResponse) Reset() {
	*x = ListPostureTemplatesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPostureTemplatesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPostureTemplatesResponse) ProtoMessage() {}

func (x *ListPostureTemplatesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPostureTemplatesResponse.ProtoReflect.Descriptor instead.
func (*ListPostureTemplatesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{23}
}

func (x *ListPostureTemplatesResponse) GetPostureTemplates() []*PostureTemplate {
	if x != nil {
		return x.PostureTemplates
	}
	return nil
}

func (x *ListPostureTemplatesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Message for getting a Posture Template.
type GetPostureTemplateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Specific revision_id of a Posture Template.
	// PostureTemplate revision_id which needs to be retrieved.
	RevisionId string `protobuf:"bytes,2,opt,name=revision_id,json=revisionId,proto3" json:"revision_id,omitempty"`
}

func (x *GetPostureTemplateRequest) Reset() {
	*x = GetPostureTemplateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPostureTemplateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPostureTemplateRequest) ProtoMessage() {}

func (x *GetPostureTemplateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPostureTemplateRequest.ProtoReflect.Descriptor instead.
func (*GetPostureTemplateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{24}
}

func (x *GetPostureTemplateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetPostureTemplateRequest) GetRevisionId() string {
	if x != nil {
		return x.RevisionId
	}
	return ""
}

// Mapping for a Policy to standard and control.
type Policy_ComplianceStandard struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The compliance standard that the Policy maps to, e.g.: CIS-2.0.
	Standard string `protobuf:"bytes,1,opt,name=standard,proto3" json:"standard,omitempty"`
	// Optional. Control mapping provided by user for this Policy. e.g.: 1.5.
	Control string `protobuf:"bytes,2,opt,name=control,proto3" json:"control,omitempty"`
}

func (x *Policy_ComplianceStandard) Reset() {
	*x = Policy_ComplianceStandard{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Policy_ComplianceStandard) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Policy_ComplianceStandard) ProtoMessage() {}

func (x *Policy_ComplianceStandard) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Policy_ComplianceStandard.ProtoReflect.Descriptor instead.
func (*Policy_ComplianceStandard) Descriptor() ([]byte, []int) {
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP(), []int{3, 0}
}

func (x *Policy_ComplianceStandard) GetStandard() string {
	if x != nil {
		return x.Standard
	}
	return ""
}

func (x *Policy_ComplianceStandard) GetControl() string {
	if x != nil {
		return x.Control
	}
	return ""
}

var File_google_cloud_securityposture_v1_securityposture_proto protoreflect.FileDescriptor

var file_google_cloud_securityposture_v1_securityposture_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2f, 0x76,
	0x31, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f,
	0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x72, 0x67,
	0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x68, 0x61, 0x5f, 0x63,
	0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xff, 0x02, 0x0a, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65, 0x72,
	0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76, 0x65,
	0x72, 0x62, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3a,
	0x0a, 0x16, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63,
	0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61,
	0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70,
	0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x28, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xca, 0x06, 0x0a, 0x07, 0x50,
	0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x49, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x27, 0x0a,
	0x0b, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x72, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x50, 0x0a, 0x0b, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x73,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f,
	0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53,
	0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53,
	0x65, 0x74, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x60, 0x0a, 0x0b,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x25,
	0x0a, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63,
	0x69, 0x6c, 0x69, 0x6e, 0x67, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x45, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15,
	0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x45, 0x50, 0x52, 0x45, 0x43, 0x41,
	0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x52, 0x41, 0x46, 0x54, 0x10, 0x02,
	0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x03, 0x3a, 0x88, 0x01, 0xea,
	0x41, 0x84, 0x01, 0x0a, 0x26, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73,
	0x74, 0x75, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x12, 0x44, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70,
	0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65,
	0x7d, 0x2a, 0x08, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x73, 0x32, 0x07, 0x70, 0x6f, 0x73,
	0x74, 0x75, 0x72, 0x65, 0x52, 0x01, 0x01, 0x22, 0xa5, 0x01, 0x0a, 0x09, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x53, 0x65, 0x74, 0x12, 0x27, 0x0a, 0x0d, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f,
	0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0b, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53, 0x65, 0x74, 0x49, 0x64, 0x12, 0x25,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x08, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70,
	0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x22,
	0xed, 0x02, 0x0a, 0x06, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x64, 0x12, 0x72, 0x0a, 0x14,
	0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x6e, 0x64,
	0x61, 0x72, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x74,
	0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x63, 0x6f, 0x6d,
	0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x73,
	0x12, 0x50, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74,
	0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x54, 0x0a, 0x12, 0x43, 0x6f, 0x6d,
	0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x12,
	0x1f, 0x0a, 0x08, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64,
	0x12, 0x1d, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x22,
	0xc9, 0x04, 0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x8e,
	0x01, 0x0a, 0x20, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00,
	0x52, 0x1d, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12,
	0xa1, 0x01, 0x0a, 0x27, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x23,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x12, 0x6f, 0x0a, 0x15, 0x6f, 0x72, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f,
	0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52,
	0x13, 0x6f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x74, 0x12, 0x82, 0x01, 0x0a, 0x1c, 0x6f, 0x72, 0x67, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x5f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72,
	0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x19,
	0x6f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x42, 0x10, 0x0a, 0x0e, 0x69, 0x6d, 0x70,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x99, 0x01, 0x0a, 0x13,
	0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x73, 0x74,
	0x75, 0x72, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa6, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x44, 0x0a, 0x08, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x52, 0x08, 0x70, 0x6f,
	0x73, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20,
	0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x22, 0xa7, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65,
	0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8e, 0x01, 0x0a, 0x1c, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x09, 0x72,
	0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x52, 0x09, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x7d, 0x0a, 0x11, 0x47,
	0x65, 0x74, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a,
	0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22, 0xcb, 0x01, 0x0a, 0x14, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x73, 0x74,
	0x75, 0x72, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70,
	0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x49, 0x64, 0x12,
	0x47, 0x0a, 0x07, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x07, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x22, 0xc7, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x12, 0x47, 0x0a, 0x07, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74,
	0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x07, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x12, 0x24, 0x0a, 0x0b,
	0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x49, 0x64, 0x22, 0x73, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6f, 0x73, 0x74,
	0x75, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28,
	0x0a, 0x26, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17,
	0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0xa4, 0x01, 0x0a, 0x15, 0x45, 0x78, 0x74, 0x72,
	0x61, 0x63, 0x74, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72,
	0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x6f, 0x73,
	0x74, 0x75, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x09, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x49, 0x64, 0x12, 0x1f, 0x0a,
	0x08, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x22, 0x92,
	0x09, 0x0a, 0x11, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2c, 0x0a,
	0x0f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x53, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73,
	0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x6f, 0x73, 0x74, 0x75,
	0x72, 0x65, 0x49, 0x64, 0x12, 0x33, 0x0a, 0x13, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x5f,
	0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x52,
	0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x25, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x6a, 0x0a,
	0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x72, 0x65, 0x63,
	0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67,
	0x12, 0x31, 0x0a, 0x12, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x70, 0x6f, 0x73, 0x74,
	0x75, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x10, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72,
	0x65, 0x49, 0x64, 0x12, 0x42, 0x0a, 0x1b, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x70,
	0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x18, 0x64,
	0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x2c, 0x0a, 0x0f, 0x66, 0x61, 0x69, 0x6c, 0x75,
	0x72, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x8d, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47,
	0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03,
	0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x04, 0x12, 0x11, 0x0a, 0x0d,
	0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12,
	0x11, 0x0a, 0x0d, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44,
	0x10, 0x06, 0x12, 0x11, 0x0a, 0x0d, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x46, 0x41, 0x49,
	0x4c, 0x45, 0x44, 0x10, 0x07, 0x3a, 0xbb, 0x01, 0xea, 0x41, 0xb7, 0x01, 0x0a, 0x30, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x73,
	0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x59,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x2a, 0x12, 0x70, 0x6f, 0x73, 0x74, 0x75,
	0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x32, 0x11, 0x70,
	0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x01, 0x01, 0x22, 0xd4, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x73, 0x74,
	0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x12, 0x30, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f,
	0x73, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xcf, 0x01, 0x0a, 0x1e, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x63, 0x0a,
	0x13, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73,
	0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x12,
	0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x6b, 0x0a, 0x1b,
	0x47, 0x65, 0x74, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x32, 0x0a, 0x30, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75,
	0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x93, 0x02, 0x0a, 0x1e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x32, 0x12, 0x30, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f,
	0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x37,
	0x0a, 0x15, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x13, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x66, 0x0a, 0x12, 0x70, 0x6f, 0x73, 0x74, 0x75,
	0x72, 0x65, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x70, 0x6f,
	0x73, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x22,
	0xca, 0x01, 0x0a, 0x1e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72,
	0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x12, 0x66, 0x0a, 0x12, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x5f,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x70, 0x6f, 0x73, 0x74, 0x75,
	0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x87, 0x01, 0x0a,
	0x1e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70,
	0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a,
	0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x8c, 0x04, 0x0a, 0x0f, 0x50, 0x6f, 0x73, 0x74, 0x75,
	0x72, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41, 0x08,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x50, 0x0a, 0x0b, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x5f, 0x73, 0x65, 0x74, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x53, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x53, 0x65, 0x74, 0x73, 0x22, 0x3a, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49,
	0x56, 0x45, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x45, 0x50, 0x52, 0x45, 0x43, 0x41, 0x54,
	0x45, 0x44, 0x10, 0x02, 0x3a, 0xae, 0x01, 0xea, 0x41, 0xaa, 0x01, 0x0a, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x73, 0x74,
	0x75, 0x72, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x55, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70,
	0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f,
	0x7b, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x7d, 0x2a, 0x10, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x73, 0x32, 0x0f, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x54, 0x65, 0x6d,
	0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0xd0, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f,
	0x73, 0x74, 0x75, 0x72, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x12, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f,
	0x73, 0x74, 0x75, 0x72, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xa5, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73,
	0x74, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5d, 0x0a, 0x11, 0x70, 0x6f, 0x73,
	0x74, 0x75, 0x72, 0x65, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74,
	0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x10, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0x8d, 0x01, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f,
	0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x72, 0x65,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x32, 0x94, 0x1a, 0x0a, 0x0f, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x73,
	0x74, 0x75, 0x72, 0x65, 0x12, 0xbf, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x73,
	0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73,
	0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x73, 0x74,
	0x75, 0x72, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x42, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x6f,
	0x73, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0xdc, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x47, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x41, 0x12, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6f, 0x73, 0x74,
	0x75, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xac, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x50, 0x6f, 0x73,
	0x74, 0x75, 0x72, 0x65, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74,
	0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x75,
	0x72, 0x65, 0x22, 0x40, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe4, 0x01, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50,
	0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f,
	0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50,
	0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7d, 0xca, 0x41,
	0x1c, 0x0a, 0x07, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x19,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2c, 0x70,
	0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x3a,
	0x07, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x22, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0xe6, 0x01, 0x0a, 0x0d,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x12, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x7f, 0xca, 0x41, 0x1c, 0x0a, 0x07, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72,
	0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x13, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44,
	0x3a, 0x07, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x32, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd4, 0x01, 0x0a, 0x0d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50,
	0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f,
	0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50,
	0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6d, 0xca, 0x41,
	0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x2a, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xea, 0x01, 0x0a, 0x0e,
	0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x12, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x80, 0x01, 0xca, 0x41, 0x1c, 0x0a, 0x07, 0x50, 0x6f, 0x73,
	0x74, 0x75, 0x72, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1a, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x2c, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x2c, 0x77, 0x6f, 0x72, 0x6b,
	0x6c, 0x6f, 0x61, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x3a, 0x01, 0x2a, 0x22, 0x39, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x73,
	0x3a, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x12, 0xe7, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73,
	0x74, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72,
	0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72,
	0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4c, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x12, 0xd4, 0x01, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72,
	0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x74,
	0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x4a, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xae, 0x02, 0x0a, 0x17, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73,
	0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x6f,
	0x73, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb2, 0x01, 0xca, 0x41, 0x26, 0x0a, 0x11, 0x50, 0x6f, 0x73,
	0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x2f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x6f, 0x73, 0x74, 0x75,
	0x72, 0x65, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x6f,
	0x73, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x51, 0x3a, 0x12, 0x70, 0x6f, 0x73, 0x74, 0x75,
	0x72, 0x65, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x3b, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xb0, 0x02, 0x0a, 0x17, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f,
	0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50,
	0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb4, 0x01, 0xca, 0x41, 0x26, 0x0a, 0x11, 0x50, 0x6f,
	0x73, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x1e, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x64, 0x3a, 0x12, 0x70, 0x6f, 0x73, 0x74, 0x75,
	0x72, 0x65, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x32, 0x4e, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf2, 0x01,
	0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x77, 0xca, 0x41, 0x2a, 0x0a, 0x15,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x2a, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x6f, 0x73,
	0x74, 0x75, 0x72, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xdf, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x6f, 0x73, 0x74, 0x75,
	0x72, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x73, 0x12, 0xcc, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x50, 0x6f, 0x73, 0x74,
	0x75, 0x72, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70,
	0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x75, 0x72,
	0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0x48, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x1a, 0x52, 0xca, 0x41, 0x1e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xce, 0x02, 0xea, 0x41, 0x5f, 0x0a, 0x2a, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x0a, 0x23, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x76,
	0x31, 0x42, 0x0b, 0x56, 0x31, 0x6d, 0x61, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x4d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f,
	0x73, 0x74, 0x75, 0x72, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x70, 0x62, 0x3b, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x70, 0x62, 0xaa,
	0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x56,
	0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73, 0x74, 0x75, 0x72, 0x65,
	0x5c, 0x56, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x70, 0x6f, 0x73,
	0x74, 0x75, 0x72, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_securityposture_v1_securityposture_proto_rawDescOnce sync.Once
	file_google_cloud_securityposture_v1_securityposture_proto_rawDescData = file_google_cloud_securityposture_v1_securityposture_proto_rawDesc
)

func file_google_cloud_securityposture_v1_securityposture_proto_rawDescGZIP() []byte {
	file_google_cloud_securityposture_v1_securityposture_proto_rawDescOnce.Do(func() {
		file_google_cloud_securityposture_v1_securityposture_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_securityposture_v1_securityposture_proto_rawDescData)
	})
	return file_google_cloud_securityposture_v1_securityposture_proto_rawDescData
}

var file_google_cloud_securityposture_v1_securityposture_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_securityposture_v1_securityposture_proto_msgTypes = make([]protoimpl.MessageInfo, 28)
var file_google_cloud_securityposture_v1_securityposture_proto_goTypes = []interface{}{
	(Posture_State)(0),                          // 0: google.cloud.securityposture.v1.Posture.State
	(PostureDeployment_State)(0),                // 1: google.cloud.securityposture.v1.PostureDeployment.State
	(PostureTemplate_State)(0),                  // 2: google.cloud.securityposture.v1.PostureTemplate.State
	(*OperationMetadata)(nil),                   // 3: google.cloud.securityposture.v1.OperationMetadata
	(*Posture)(nil),                             // 4: google.cloud.securityposture.v1.Posture
	(*PolicySet)(nil),                           // 5: google.cloud.securityposture.v1.PolicySet
	(*Policy)(nil),                              // 6: google.cloud.securityposture.v1.Policy
	(*Constraint)(nil),                          // 7: google.cloud.securityposture.v1.Constraint
	(*ListPosturesRequest)(nil),                 // 8: google.cloud.securityposture.v1.ListPosturesRequest
	(*ListPosturesResponse)(nil),                // 9: google.cloud.securityposture.v1.ListPosturesResponse
	(*ListPostureRevisionsRequest)(nil),         // 10: google.cloud.securityposture.v1.ListPostureRevisionsRequest
	(*ListPostureRevisionsResponse)(nil),        // 11: google.cloud.securityposture.v1.ListPostureRevisionsResponse
	(*GetPostureRequest)(nil),                   // 12: google.cloud.securityposture.v1.GetPostureRequest
	(*CreatePostureRequest)(nil),                // 13: google.cloud.securityposture.v1.CreatePostureRequest
	(*UpdatePostureRequest)(nil),                // 14: google.cloud.securityposture.v1.UpdatePostureRequest
	(*DeletePostureRequest)(nil),                // 15: google.cloud.securityposture.v1.DeletePostureRequest
	(*ExtractPostureRequest)(nil),               // 16: google.cloud.securityposture.v1.ExtractPostureRequest
	(*PostureDeployment)(nil),                   // 17: google.cloud.securityposture.v1.PostureDeployment
	(*ListPostureDeploymentsRequest)(nil),       // 18: google.cloud.securityposture.v1.ListPostureDeploymentsRequest
	(*ListPostureDeploymentsResponse)(nil),      // 19: google.cloud.securityposture.v1.ListPostureDeploymentsResponse
	(*GetPostureDeploymentRequest)(nil),         // 20: google.cloud.securityposture.v1.GetPostureDeploymentRequest
	(*CreatePostureDeploymentRequest)(nil),      // 21: google.cloud.securityposture.v1.CreatePostureDeploymentRequest
	(*UpdatePostureDeploymentRequest)(nil),      // 22: google.cloud.securityposture.v1.UpdatePostureDeploymentRequest
	(*DeletePostureDeploymentRequest)(nil),      // 23: google.cloud.securityposture.v1.DeletePostureDeploymentRequest
	(*PostureTemplate)(nil),                     // 24: google.cloud.securityposture.v1.PostureTemplate
	(*ListPostureTemplatesRequest)(nil),         // 25: google.cloud.securityposture.v1.ListPostureTemplatesRequest
	(*ListPostureTemplatesResponse)(nil),        // 26: google.cloud.securityposture.v1.ListPostureTemplatesResponse
	(*GetPostureTemplateRequest)(nil),           // 27: google.cloud.securityposture.v1.GetPostureTemplateRequest
	nil,                                         // 28: google.cloud.securityposture.v1.Posture.AnnotationsEntry
	(*Policy_ComplianceStandard)(nil),           // 29: google.cloud.securityposture.v1.Policy.ComplianceStandard
	nil,                                         // 30: google.cloud.securityposture.v1.PostureDeployment.AnnotationsEntry
	(*timestamppb.Timestamp)(nil),               // 31: google.protobuf.Timestamp
	(*SecurityHealthAnalyticsModule)(nil),       // 32: google.cloud.securityposture.v1.SecurityHealthAnalyticsModule
	(*SecurityHealthAnalyticsCustomModule)(nil), // 33: google.cloud.securityposture.v1.SecurityHealthAnalyticsCustomModule
	(*OrgPolicyConstraint)(nil),                 // 34: google.cloud.securityposture.v1.OrgPolicyConstraint
	(*OrgPolicyConstraintCustom)(nil),           // 35: google.cloud.securityposture.v1.OrgPolicyConstraintCustom
	(*fieldmaskpb.FieldMask)(nil),               // 36: google.protobuf.FieldMask
	(*longrunningpb.Operation)(nil),             // 37: google.longrunning.Operation
}
var file_google_cloud_securityposture_v1_securityposture_proto_depIdxs = []int32{
	31, // 0: google.cloud.securityposture.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	31, // 1: google.cloud.securityposture.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	0,  // 2: google.cloud.securityposture.v1.Posture.state:type_name -> google.cloud.securityposture.v1.Posture.State
	31, // 3: google.cloud.securityposture.v1.Posture.create_time:type_name -> google.protobuf.Timestamp
	31, // 4: google.cloud.securityposture.v1.Posture.update_time:type_name -> google.protobuf.Timestamp
	5,  // 5: google.cloud.securityposture.v1.Posture.policy_sets:type_name -> google.cloud.securityposture.v1.PolicySet
	28, // 6: google.cloud.securityposture.v1.Posture.annotations:type_name -> google.cloud.securityposture.v1.Posture.AnnotationsEntry
	6,  // 7: google.cloud.securityposture.v1.PolicySet.policies:type_name -> google.cloud.securityposture.v1.Policy
	29, // 8: google.cloud.securityposture.v1.Policy.compliance_standards:type_name -> google.cloud.securityposture.v1.Policy.ComplianceStandard
	7,  // 9: google.cloud.securityposture.v1.Policy.constraint:type_name -> google.cloud.securityposture.v1.Constraint
	32, // 10: google.cloud.securityposture.v1.Constraint.security_health_analytics_module:type_name -> google.cloud.securityposture.v1.SecurityHealthAnalyticsModule
	33, // 11: google.cloud.securityposture.v1.Constraint.security_health_analytics_custom_module:type_name -> google.cloud.securityposture.v1.SecurityHealthAnalyticsCustomModule
	34, // 12: google.cloud.securityposture.v1.Constraint.org_policy_constraint:type_name -> google.cloud.securityposture.v1.OrgPolicyConstraint
	35, // 13: google.cloud.securityposture.v1.Constraint.org_policy_constraint_custom:type_name -> google.cloud.securityposture.v1.OrgPolicyConstraintCustom
	4,  // 14: google.cloud.securityposture.v1.ListPosturesResponse.postures:type_name -> google.cloud.securityposture.v1.Posture
	4,  // 15: google.cloud.securityposture.v1.ListPostureRevisionsResponse.revisions:type_name -> google.cloud.securityposture.v1.Posture
	4,  // 16: google.cloud.securityposture.v1.CreatePostureRequest.posture:type_name -> google.cloud.securityposture.v1.Posture
	36, // 17: google.cloud.securityposture.v1.UpdatePostureRequest.update_mask:type_name -> google.protobuf.FieldMask
	4,  // 18: google.cloud.securityposture.v1.UpdatePostureRequest.posture:type_name -> google.cloud.securityposture.v1.Posture
	1,  // 19: google.cloud.securityposture.v1.PostureDeployment.state:type_name -> google.cloud.securityposture.v1.PostureDeployment.State
	31, // 20: google.cloud.securityposture.v1.PostureDeployment.create_time:type_name -> google.protobuf.Timestamp
	31, // 21: google.cloud.securityposture.v1.PostureDeployment.update_time:type_name -> google.protobuf.Timestamp
	30, // 22: google.cloud.securityposture.v1.PostureDeployment.annotations:type_name -> google.cloud.securityposture.v1.PostureDeployment.AnnotationsEntry
	17, // 23: google.cloud.securityposture.v1.ListPostureDeploymentsResponse.posture_deployments:type_name -> google.cloud.securityposture.v1.PostureDeployment
	17, // 24: google.cloud.securityposture.v1.CreatePostureDeploymentRequest.posture_deployment:type_name -> google.cloud.securityposture.v1.PostureDeployment
	36, // 25: google.cloud.securityposture.v1.UpdatePostureDeploymentRequest.update_mask:type_name -> google.protobuf.FieldMask
	17, // 26: google.cloud.securityposture.v1.UpdatePostureDeploymentRequest.posture_deployment:type_name -> google.cloud.securityposture.v1.PostureDeployment
	2,  // 27: google.cloud.securityposture.v1.PostureTemplate.state:type_name -> google.cloud.securityposture.v1.PostureTemplate.State
	5,  // 28: google.cloud.securityposture.v1.PostureTemplate.policy_sets:type_name -> google.cloud.securityposture.v1.PolicySet
	24, // 29: google.cloud.securityposture.v1.ListPostureTemplatesResponse.posture_templates:type_name -> google.cloud.securityposture.v1.PostureTemplate
	8,  // 30: google.cloud.securityposture.v1.SecurityPosture.ListPostures:input_type -> google.cloud.securityposture.v1.ListPosturesRequest
	10, // 31: google.cloud.securityposture.v1.SecurityPosture.ListPostureRevisions:input_type -> google.cloud.securityposture.v1.ListPostureRevisionsRequest
	12, // 32: google.cloud.securityposture.v1.SecurityPosture.GetPosture:input_type -> google.cloud.securityposture.v1.GetPostureRequest
	13, // 33: google.cloud.securityposture.v1.SecurityPosture.CreatePosture:input_type -> google.cloud.securityposture.v1.CreatePostureRequest
	14, // 34: google.cloud.securityposture.v1.SecurityPosture.UpdatePosture:input_type -> google.cloud.securityposture.v1.UpdatePostureRequest
	15, // 35: google.cloud.securityposture.v1.SecurityPosture.DeletePosture:input_type -> google.cloud.securityposture.v1.DeletePostureRequest
	16, // 36: google.cloud.securityposture.v1.SecurityPosture.ExtractPosture:input_type -> google.cloud.securityposture.v1.ExtractPostureRequest
	18, // 37: google.cloud.securityposture.v1.SecurityPosture.ListPostureDeployments:input_type -> google.cloud.securityposture.v1.ListPostureDeploymentsRequest
	20, // 38: google.cloud.securityposture.v1.SecurityPosture.GetPostureDeployment:input_type -> google.cloud.securityposture.v1.GetPostureDeploymentRequest
	21, // 39: google.cloud.securityposture.v1.SecurityPosture.CreatePostureDeployment:input_type -> google.cloud.securityposture.v1.CreatePostureDeploymentRequest
	22, // 40: google.cloud.securityposture.v1.SecurityPosture.UpdatePostureDeployment:input_type -> google.cloud.securityposture.v1.UpdatePostureDeploymentRequest
	23, // 41: google.cloud.securityposture.v1.SecurityPosture.DeletePostureDeployment:input_type -> google.cloud.securityposture.v1.DeletePostureDeploymentRequest
	25, // 42: google.cloud.securityposture.v1.SecurityPosture.ListPostureTemplates:input_type -> google.cloud.securityposture.v1.ListPostureTemplatesRequest
	27, // 43: google.cloud.securityposture.v1.SecurityPosture.GetPostureTemplate:input_type -> google.cloud.securityposture.v1.GetPostureTemplateRequest
	9,  // 44: google.cloud.securityposture.v1.SecurityPosture.ListPostures:output_type -> google.cloud.securityposture.v1.ListPosturesResponse
	11, // 45: google.cloud.securityposture.v1.SecurityPosture.ListPostureRevisions:output_type -> google.cloud.securityposture.v1.ListPostureRevisionsResponse
	4,  // 46: google.cloud.securityposture.v1.SecurityPosture.GetPosture:output_type -> google.cloud.securityposture.v1.Posture
	37, // 47: google.cloud.securityposture.v1.SecurityPosture.CreatePosture:output_type -> google.longrunning.Operation
	37, // 48: google.cloud.securityposture.v1.SecurityPosture.UpdatePosture:output_type -> google.longrunning.Operation
	37, // 49: google.cloud.securityposture.v1.SecurityPosture.DeletePosture:output_type -> google.longrunning.Operation
	37, // 50: google.cloud.securityposture.v1.SecurityPosture.ExtractPosture:output_type -> google.longrunning.Operation
	19, // 51: google.cloud.securityposture.v1.SecurityPosture.ListPostureDeployments:output_type -> google.cloud.securityposture.v1.ListPostureDeploymentsResponse
	17, // 52: google.cloud.securityposture.v1.SecurityPosture.GetPostureDeployment:output_type -> google.cloud.securityposture.v1.PostureDeployment
	37, // 53: google.cloud.securityposture.v1.SecurityPosture.CreatePostureDeployment:output_type -> google.longrunning.Operation
	37, // 54: google.cloud.securityposture.v1.SecurityPosture.UpdatePostureDeployment:output_type -> google.longrunning.Operation
	37, // 55: google.cloud.securityposture.v1.SecurityPosture.DeletePostureDeployment:output_type -> google.longrunning.Operation
	26, // 56: google.cloud.securityposture.v1.SecurityPosture.ListPostureTemplates:output_type -> google.cloud.securityposture.v1.ListPostureTemplatesResponse
	24, // 57: google.cloud.securityposture.v1.SecurityPosture.GetPostureTemplate:output_type -> google.cloud.securityposture.v1.PostureTemplate
	44, // [44:58] is the sub-list for method output_type
	30, // [30:44] is the sub-list for method input_type
	30, // [30:30] is the sub-list for extension type_name
	30, // [30:30] is the sub-list for extension extendee
	0,  // [0:30] is the sub-list for field type_name
}

func init() { file_google_cloud_securityposture_v1_securityposture_proto_init() }
func file_google_cloud_securityposture_v1_securityposture_proto_init() {
	if File_google_cloud_securityposture_v1_securityposture_proto != nil {
		return
	}
	file_google_cloud_securityposture_v1_org_policy_constraints_proto_init()
	file_google_cloud_securityposture_v1_sha_constraints_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Posture); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PolicySet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Policy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Constraint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPosturesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPosturesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPostureRevisionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPostureRevisionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPostureRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreatePostureRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdatePostureRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeletePostureRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExtractPostureRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PostureDeployment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPostureDeploymentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPostureDeploymentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPostureDeploymentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreatePostureDeploymentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdatePostureDeploymentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeletePostureDeploymentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PostureTemplate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPostureTemplatesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPostureTemplatesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPostureTemplateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Policy_ComplianceStandard); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_securityposture_v1_securityposture_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*Constraint_SecurityHealthAnalyticsModule)(nil),
		(*Constraint_SecurityHealthAnalyticsCustomModule)(nil),
		(*Constraint_OrgPolicyConstraint)(nil),
		(*Constraint_OrgPolicyConstraintCustom)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_securityposture_v1_securityposture_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   28,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_securityposture_v1_securityposture_proto_goTypes,
		DependencyIndexes: file_google_cloud_securityposture_v1_securityposture_proto_depIdxs,
		EnumInfos:         file_google_cloud_securityposture_v1_securityposture_proto_enumTypes,
		MessageInfos:      file_google_cloud_securityposture_v1_securityposture_proto_msgTypes,
	}.Build()
	File_google_cloud_securityposture_v1_securityposture_proto = out.File
	file_google_cloud_securityposture_v1_securityposture_proto_rawDesc = nil
	file_google_cloud_securityposture_v1_securityposture_proto_goTypes = nil
	file_google_cloud_securityposture_v1_securityposture_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SecurityPostureClient is the client API for SecurityPosture service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SecurityPostureClient interface {
	// (-- This option restricts the visibility of the API to only projects that
	// will
	// (-- be labeled as `PREVIEW` or `GOOGLE_INTERNAL` by the service.
	// (-- option (google.api.api_visibility).restriction =
	// "PREVIEW,GOOGLE_INTERNAL"; Postures Lists Postures in a given organization
	// and location. In case a posture has multiple revisions, the latest revision
	// as per UpdateTime will be returned.
	ListPostures(ctx context.Context, in *ListPosturesRequest, opts ...grpc.CallOption) (*ListPosturesResponse, error)
	// Lists revisions of a Posture in a given organization and location.
	ListPostureRevisions(ctx context.Context, in *ListPostureRevisionsRequest, opts ...grpc.CallOption) (*ListPostureRevisionsResponse, error)
	// Gets a posture in a given organization and location.
	// User must provide revision_id to retrieve a specific revision of the
	// resource.
	// NOT_FOUND error is returned if the revision_id or the Posture name does not
	// exist. In case revision_id is not provided then the latest Posture revision
	// by UpdateTime is returned.
	GetPosture(ctx context.Context, in *GetPostureRequest, opts ...grpc.CallOption) (*Posture, error)
	// Creates a new Posture resource.
	// If a Posture with the specified name already exists in the specified
	// organization and location, the long running operation returns a
	// [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS] error.
	CreatePosture(ctx context.Context, in *CreatePostureRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an existing Posture.
	// A new revision of the posture will be created if the revision to be
	// updated is currently deployed on a workload.
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// Posture does not exist.
	// Returns a `google.rpc.Status` with `google.rpc.Code.ABORTED` if the etag
	// supplied in the request does not match the persisted etag of the Posture.
	// Updatable fields are state, description and policy_sets.
	// State update operation cannot be clubbed with update of description and
	// policy_sets.
	// An ACTIVE posture can be updated to both DRAFT or DEPRECATED states.
	// Postures in DRAFT or DEPRECATED states can only be updated to ACTIVE state.
	UpdatePosture(ctx context.Context, in *UpdatePostureRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes all the revisions of a resource.
	// A posture can only be deleted when none of the revisions are deployed to
	// any workload.
	DeletePosture(ctx context.Context, in *DeletePostureRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Extracts existing policies on a workload as a posture.
	// If a Posture on the given workload already exists, the long running
	// operation returns a [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS] error.
	ExtractPosture(ctx context.Context, in *ExtractPostureRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// PostureDeployments
	// Lists PostureDeployments in a given project and location.
	ListPostureDeployments(ctx context.Context, in *ListPostureDeploymentsRequest, opts ...grpc.CallOption) (*ListPostureDeploymentsResponse, error)
	// Gets details of a single PostureDeployment.
	GetPostureDeployment(ctx context.Context, in *GetPostureDeploymentRequest, opts ...grpc.CallOption) (*PostureDeployment, error)
	// Creates a new PostureDeployment in a given project and location.
	CreatePostureDeployment(ctx context.Context, in *CreatePostureDeploymentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single PostureDeployment.
	UpdatePostureDeployment(ctx context.Context, in *UpdatePostureDeploymentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single PostureDeployment.
	DeletePostureDeployment(ctx context.Context, in *DeletePostureDeploymentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// PostureTemplates
	// Lists all the PostureTemplates available to the user.
	ListPostureTemplates(ctx context.Context, in *ListPostureTemplatesRequest, opts ...grpc.CallOption) (*ListPostureTemplatesResponse, error)
	// Gets a PostureTemplate.
	// User must provide revision_id to retrieve a specific revision of the
	// resource.
	// NOT_FOUND error is returned if the revision_id or the PostureTemplate name
	// does not exist. In case revision_id is not provided then the
	// PostureTemplate with latest revision_id is returned.
	GetPostureTemplate(ctx context.Context, in *GetPostureTemplateRequest, opts ...grpc.CallOption) (*PostureTemplate, error)
}

type securityPostureClient struct {
	cc grpc.ClientConnInterface
}

func NewSecurityPostureClient(cc grpc.ClientConnInterface) SecurityPostureClient {
	return &securityPostureClient{cc}
}

func (c *securityPostureClient) ListPostures(ctx context.Context, in *ListPosturesRequest, opts ...grpc.CallOption) (*ListPosturesResponse, error) {
	out := new(ListPosturesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securityposture.v1.SecurityPosture/ListPostures", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityPostureClient) ListPostureRevisions(ctx context.Context, in *ListPostureRevisionsRequest, opts ...grpc.CallOption) (*ListPostureRevisionsResponse, error) {
	out := new(ListPostureRevisionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securityposture.v1.SecurityPosture/ListPostureRevisions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityPostureClient) GetPosture(ctx context.Context, in *GetPostureRequest, opts ...grpc.CallOption) (*Posture, error) {
	out := new(Posture)
	err := c.cc.Invoke(ctx, "/google.cloud.securityposture.v1.SecurityPosture/GetPosture", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityPostureClient) CreatePosture(ctx context.Context, in *CreatePostureRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.securityposture.v1.SecurityPosture/CreatePosture", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityPostureClient) UpdatePosture(ctx context.Context, in *UpdatePostureRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.securityposture.v1.SecurityPosture/UpdatePosture", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityPostureClient) DeletePosture(ctx context.Context, in *DeletePostureRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.securityposture.v1.SecurityPosture/DeletePosture", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityPostureClient) ExtractPosture(ctx context.Context, in *ExtractPostureRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.securityposture.v1.SecurityPosture/ExtractPosture", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityPostureClient) ListPostureDeployments(ctx context.Context, in *ListPostureDeploymentsRequest, opts ...grpc.CallOption) (*ListPostureDeploymentsResponse, error) {
	out := new(ListPostureDeploymentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securityposture.v1.SecurityPosture/ListPostureDeployments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityPostureClient) GetPostureDeployment(ctx context.Context, in *GetPostureDeploymentRequest, opts ...grpc.CallOption) (*PostureDeployment, error) {
	out := new(PostureDeployment)
	err := c.cc.Invoke(ctx, "/google.cloud.securityposture.v1.SecurityPosture/GetPostureDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityPostureClient) CreatePostureDeployment(ctx context.Context, in *CreatePostureDeploymentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.securityposture.v1.SecurityPosture/CreatePostureDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityPostureClient) UpdatePostureDeployment(ctx context.Context, in *UpdatePostureDeploymentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.securityposture.v1.SecurityPosture/UpdatePostureDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityPostureClient) DeletePostureDeployment(ctx context.Context, in *DeletePostureDeploymentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.securityposture.v1.SecurityPosture/DeletePostureDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityPostureClient) ListPostureTemplates(ctx context.Context, in *ListPostureTemplatesRequest, opts ...grpc.CallOption) (*ListPostureTemplatesResponse, error) {
	out := new(ListPostureTemplatesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securityposture.v1.SecurityPosture/ListPostureTemplates", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityPostureClient) GetPostureTemplate(ctx context.Context, in *GetPostureTemplateRequest, opts ...grpc.CallOption) (*PostureTemplate, error) {
	out := new(PostureTemplate)
	err := c.cc.Invoke(ctx, "/google.cloud.securityposture.v1.SecurityPosture/GetPostureTemplate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SecurityPostureServer is the server API for SecurityPosture service.
type SecurityPostureServer interface {
	// (-- This option restricts the visibility of the API to only projects that
	// will
	// (-- be labeled as `PREVIEW` or `GOOGLE_INTERNAL` by the service.
	// (-- option (google.api.api_visibility).restriction =
	// "PREVIEW,GOOGLE_INTERNAL"; Postures Lists Postures in a given organization
	// and location. In case a posture has multiple revisions, the latest revision
	// as per UpdateTime will be returned.
	ListPostures(context.Context, *ListPosturesRequest) (*ListPosturesResponse, error)
	// Lists revisions of a Posture in a given organization and location.
	ListPostureRevisions(context.Context, *ListPostureRevisionsRequest) (*ListPostureRevisionsResponse, error)
	// Gets a posture in a given organization and location.
	// User must provide revision_id to retrieve a specific revision of the
	// resource.
	// NOT_FOUND error is returned if the revision_id or the Posture name does not
	// exist. In case revision_id is not provided then the latest Posture revision
	// by UpdateTime is returned.
	GetPosture(context.Context, *GetPostureRequest) (*Posture, error)
	// Creates a new Posture resource.
	// If a Posture with the specified name already exists in the specified
	// organization and location, the long running operation returns a
	// [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS] error.
	CreatePosture(context.Context, *CreatePostureRequest) (*longrunningpb.Operation, error)
	// Updates an existing Posture.
	// A new revision of the posture will be created if the revision to be
	// updated is currently deployed on a workload.
	// Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
	// Posture does not exist.
	// Returns a `google.rpc.Status` with `google.rpc.Code.ABORTED` if the etag
	// supplied in the request does not match the persisted etag of the Posture.
	// Updatable fields are state, description and policy_sets.
	// State update operation cannot be clubbed with update of description and
	// policy_sets.
	// An ACTIVE posture can be updated to both DRAFT or DEPRECATED states.
	// Postures in DRAFT or DEPRECATED states can only be updated to ACTIVE state.
	UpdatePosture(context.Context, *UpdatePostureRequest) (*longrunningpb.Operation, error)
	// Deletes all the revisions of a resource.
	// A posture can only be deleted when none of the revisions are deployed to
	// any workload.
	DeletePosture(context.Context, *DeletePostureRequest) (*longrunningpb.Operation, error)
	// Extracts existing policies on a workload as a posture.
	// If a Posture on the given workload already exists, the long running
	// operation returns a [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS] error.
	ExtractPosture(context.Context, *ExtractPostureRequest) (*longrunningpb.Operation, error)
	// PostureDeployments
	// Lists PostureDeployments in a given project and location.
	ListPostureDeployments(context.Context, *ListPostureDeploymentsRequest) (*ListPostureDeploymentsResponse, error)
	// Gets details of a single PostureDeployment.
	GetPostureDeployment(context.Context, *GetPostureDeploymentRequest) (*PostureDeployment, error)
	// Creates a new PostureDeployment in a given project and location.
	CreatePostureDeployment(context.Context, *CreatePostureDeploymentRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single PostureDeployment.
	UpdatePostureDeployment(context.Context, *UpdatePostureDeploymentRequest) (*longrunningpb.Operation, error)
	// Deletes a single PostureDeployment.
	DeletePostureDeployment(context.Context, *DeletePostureDeploymentRequest) (*longrunningpb.Operation, error)
	// PostureTemplates
	// Lists all the PostureTemplates available to the user.
	ListPostureTemplates(context.Context, *ListPostureTemplatesRequest) (*ListPostureTemplatesResponse, error)
	// Gets a PostureTemplate.
	// User must provide revision_id to retrieve a specific revision of the
	// resource.
	// NOT_FOUND error is returned if the revision_id or the PostureTemplate name
	// does not exist. In case revision_id is not provided then the
	// PostureTemplate with latest revision_id is returned.
	GetPostureTemplate(context.Context, *GetPostureTemplateRequest) (*PostureTemplate, error)
}

// UnimplementedSecurityPostureServer can be embedded to have forward compatible implementations.
type UnimplementedSecurityPostureServer struct {
}

func (*UnimplementedSecurityPostureServer) ListPostures(context.Context, *ListPosturesRequest) (*ListPosturesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPostures not implemented")
}
func (*UnimplementedSecurityPostureServer) ListPostureRevisions(context.Context, *ListPostureRevisionsRequest) (*ListPostureRevisionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPostureRevisions not implemented")
}
func (*UnimplementedSecurityPostureServer) GetPosture(context.Context, *GetPostureRequest) (*Posture, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPosture not implemented")
}
func (*UnimplementedSecurityPostureServer) CreatePosture(context.Context, *CreatePostureRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePosture not implemented")
}
func (*UnimplementedSecurityPostureServer) UpdatePosture(context.Context, *UpdatePostureRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePosture not implemented")
}
func (*UnimplementedSecurityPostureServer) DeletePosture(context.Context, *DeletePostureRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePosture not implemented")
}
func (*UnimplementedSecurityPostureServer) ExtractPosture(context.Context, *ExtractPostureRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExtractPosture not implemented")
}
func (*UnimplementedSecurityPostureServer) ListPostureDeployments(context.Context, *ListPostureDeploymentsRequest) (*ListPostureDeploymentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPostureDeployments not implemented")
}
func (*UnimplementedSecurityPostureServer) GetPostureDeployment(context.Context, *GetPostureDeploymentRequest) (*PostureDeployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPostureDeployment not implemented")
}
func (*UnimplementedSecurityPostureServer) CreatePostureDeployment(context.Context, *CreatePostureDeploymentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePostureDeployment not implemented")
}
func (*UnimplementedSecurityPostureServer) UpdatePostureDeployment(context.Context, *UpdatePostureDeploymentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePostureDeployment not implemented")
}
func (*UnimplementedSecurityPostureServer) DeletePostureDeployment(context.Context, *DeletePostureDeploymentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePostureDeployment not implemented")
}
func (*UnimplementedSecurityPostureServer) ListPostureTemplates(context.Context, *ListPostureTemplatesRequest) (*ListPostureTemplatesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPostureTemplates not implemented")
}
func (*UnimplementedSecurityPostureServer) GetPostureTemplate(context.Context, *GetPostureTemplateRequest) (*PostureTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPostureTemplate not implemented")
}

func RegisterSecurityPostureServer(s *grpc.Server, srv SecurityPostureServer) {
	s.RegisterService(&_SecurityPosture_serviceDesc, srv)
}

func _SecurityPosture_ListPostures_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPosturesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityPostureServer).ListPostures(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securityposture.v1.SecurityPosture/ListPostures",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityPostureServer).ListPostures(ctx, req.(*ListPosturesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityPosture_ListPostureRevisions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPostureRevisionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityPostureServer).ListPostureRevisions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securityposture.v1.SecurityPosture/ListPostureRevisions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityPostureServer).ListPostureRevisions(ctx, req.(*ListPostureRevisionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityPosture_GetPosture_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPostureRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityPostureServer).GetPosture(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securityposture.v1.SecurityPosture/GetPosture",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityPostureServer).GetPosture(ctx, req.(*GetPostureRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityPosture_CreatePosture_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePostureRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityPostureServer).CreatePosture(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securityposture.v1.SecurityPosture/CreatePosture",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityPostureServer).CreatePosture(ctx, req.(*CreatePostureRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityPosture_UpdatePosture_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePostureRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityPostureServer).UpdatePosture(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securityposture.v1.SecurityPosture/UpdatePosture",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityPostureServer).UpdatePosture(ctx, req.(*UpdatePostureRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityPosture_DeletePosture_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePostureRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityPostureServer).DeletePosture(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securityposture.v1.SecurityPosture/DeletePosture",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityPostureServer).DeletePosture(ctx, req.(*DeletePostureRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityPosture_ExtractPosture_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExtractPostureRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityPostureServer).ExtractPosture(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securityposture.v1.SecurityPosture/ExtractPosture",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityPostureServer).ExtractPosture(ctx, req.(*ExtractPostureRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityPosture_ListPostureDeployments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPostureDeploymentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityPostureServer).ListPostureDeployments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securityposture.v1.SecurityPosture/ListPostureDeployments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityPostureServer).ListPostureDeployments(ctx, req.(*ListPostureDeploymentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityPosture_GetPostureDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPostureDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityPostureServer).GetPostureDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securityposture.v1.SecurityPosture/GetPostureDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityPostureServer).GetPostureDeployment(ctx, req.(*GetPostureDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityPosture_CreatePostureDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePostureDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityPostureServer).CreatePostureDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securityposture.v1.SecurityPosture/CreatePostureDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityPostureServer).CreatePostureDeployment(ctx, req.(*CreatePostureDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityPosture_UpdatePostureDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePostureDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityPostureServer).UpdatePostureDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securityposture.v1.SecurityPosture/UpdatePostureDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityPostureServer).UpdatePostureDeployment(ctx, req.(*UpdatePostureDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityPosture_DeletePostureDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePostureDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityPostureServer).DeletePostureDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securityposture.v1.SecurityPosture/DeletePostureDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityPostureServer).DeletePostureDeployment(ctx, req.(*DeletePostureDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityPosture_ListPostureTemplates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPostureTemplatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityPostureServer).ListPostureTemplates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securityposture.v1.SecurityPosture/ListPostureTemplates",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityPostureServer).ListPostureTemplates(ctx, req.(*ListPostureTemplatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityPosture_GetPostureTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPostureTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityPostureServer).GetPostureTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securityposture.v1.SecurityPosture/GetPostureTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityPostureServer).GetPostureTemplate(ctx, req.(*GetPostureTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SecurityPosture_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.securityposture.v1.SecurityPosture",
	HandlerType: (*SecurityPostureServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListPostures",
			Handler:    _SecurityPosture_ListPostures_Handler,
		},
		{
			MethodName: "ListPostureRevisions",
			Handler:    _SecurityPosture_ListPostureRevisions_Handler,
		},
		{
			MethodName: "GetPosture",
			Handler:    _SecurityPosture_GetPosture_Handler,
		},
		{
			MethodName: "CreatePosture",
			Handler:    _SecurityPosture_CreatePosture_Handler,
		},
		{
			MethodName: "UpdatePosture",
			Handler:    _SecurityPosture_UpdatePosture_Handler,
		},
		{
			MethodName: "DeletePosture",
			Handler:    _SecurityPosture_DeletePosture_Handler,
		},
		{
			MethodName: "ExtractPosture",
			Handler:    _SecurityPosture_ExtractPosture_Handler,
		},
		{
			MethodName: "ListPostureDeployments",
			Handler:    _SecurityPosture_ListPostureDeployments_Handler,
		},
		{
			MethodName: "GetPostureDeployment",
			Handler:    _SecurityPosture_GetPostureDeployment_Handler,
		},
		{
			MethodName: "CreatePostureDeployment",
			Handler:    _SecurityPosture_CreatePostureDeployment_Handler,
		},
		{
			MethodName: "UpdatePostureDeployment",
			Handler:    _SecurityPosture_UpdatePostureDeployment_Handler,
		},
		{
			MethodName: "DeletePostureDeployment",
			Handler:    _SecurityPosture_DeletePostureDeployment_Handler,
		},
		{
			MethodName: "ListPostureTemplates",
			Handler:    _SecurityPosture_ListPostureTemplates_Handler,
		},
		{
			MethodName: "GetPostureTemplate",
			Handler:    _SecurityPosture_GetPostureTemplate_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/securityposture/v1/securityposture.proto",
}
