//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armiotsecurity

import "time"

// DefenderSettingsList - List of IoT Defender settings
type DefenderSettingsList struct {
	// READ-ONLY; List data
	Value []*DefenderSettingsModel
}

// DefenderSettingsModel - IoT Defender settings
type DefenderSettingsModel struct {
	// IoT Defender settings properties
	Properties *DefenderSettingsProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DefenderSettingsProperties - IoT Defender settings properties
type DefenderSettingsProperties struct {
	// REQUIRED; Size of the device quota. Value is required to be in multiples of 100.
	DeviceQuota *int32

	// REQUIRED; MDE integration configuration
	MdeIntegration *DefenderSettingsPropertiesMdeIntegration

	// REQUIRED; The kind of onboarding for the subscription
	OnboardingKind *OnboardingKind

	// REQUIRED; Sentinel Workspace Resource Ids
	SentinelWorkspaceResourceIDs []*string

	// READ-ONLY; End time of the evaluation period, if such exist
	EvaluationEndTime *time.Time
}

// DefenderSettingsPropertiesMdeIntegration - MDE integration configuration
type DefenderSettingsPropertiesMdeIntegration struct {
	// REQUIRED; Integration status
	Status *MdeIntegration
}

// DeviceGroupList - List of device groups
type DeviceGroupList struct {
	// READ-ONLY; Link to next page of resources.
	NextLink *string

	// READ-ONLY; List data
	Value []*DeviceGroupModel
}

// DeviceGroupModel - Device group
type DeviceGroupModel struct {
	// Device group properties
	Properties any

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DeviceList - List of devices
type DeviceList struct {
	// READ-ONLY; When there are too many devices for one page, use this URI to fetch the next page.
	NextLink *string

	// READ-ONLY; List data
	Value []*DeviceModel
}

// DeviceModel - Device
type DeviceModel struct {
	// Device properties
	Properties *DeviceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DeviceProperties - Device properties
type DeviceProperties struct {
	// A bag of fields which extends the device information.
	AdditionalFields any

	// Authorized state of the device.
	AuthorizedState *AuthorizedState

	// Device business function
	BusinessFunction *string

	// Device criticality.
	Criticality *Criticality

	// Device category id
	DeviceCategoryID *int32

	// Device name
	DeviceName *string

	// Device sub type id
	DeviceSubTypeID *int32

	// Device tags
	DeviceTags []*string

	// Device type id
	DeviceTypeID *int32

	// List of device firmwares.
	Firmwares []*Firmware

	// Device hardware data
	Hardware *Hardware

	// Device operating system data
	OperatingSystem *OperatingSystem

	// List of device packages
	Packages []*Package

	// Purdue level of the device.
	PurdueLevel *PurdueLevel

	// READ-ONLY; List of Common Platform Enumeration (CPE)
	Cpes []*string

	// READ-ONLY; Device category display name
	DeviceCategoryDisplayName *string

	// READ-ONLY; Device data source.
	DeviceDataSource *DeviceDataSource

	// READ-ONLY; Device status.
	DeviceStatus *DeviceStatus

	// READ-ONLY; Device sub type display name
	DeviceSubTypeDisplayName *string

	// READ-ONLY; Device type display name
	DeviceTypeDisplayName *string

	// READ-ONLY; First time the device was seen.
	FirstSeen *time.Time

	// READ-ONLY; last time the device was programming or programed.
	LastProgrammingTime *time.Time

	// READ-ONLY; Last time the device was seen.
	LastSeen *time.Time

	// READ-ONLY; Last time the device was updated by the profiler.
	LastUpdated *time.Time

	// READ-ONLY; List of merged devices data
	MergedDevices []*MergedDevice

	// READ-ONLY; The device Id that this device was merged into
	MergedToDeviceID *string

	// READ-ONLY; List of the device network interface cards.
	Nics []*Nic

	// READ-ONLY; Device onboarding status.
	OnboardingStatus *OnboardingStatus

	// READ-ONLY; For nested device, this is the parent device id.
	ParentDeviceID *string

	// READ-ONLY; For nested device, this is the rack number in the parent device that holds the nested device.
	ParentRackNumber *int32

	// READ-ONLY; For nested device, this is the slot number in the parent device that holds the nested device.
	ParentSlotNumber *int32

	// READ-ONLY; Confidence of the device profile
	ProfilingConfidence *int32

	// READ-ONLY; Indicates whether this device is programming
	ProgrammingState *ProgrammingState

	// READ-ONLY; risk score of the device.
	RiskScore *int32

	// READ-ONLY; Version of the device model schema
	SchemaVersion *string

	// READ-ONLY; Sensor that scanned this device.
	Sensor *Sensor

	// READ-ONLY; List of the device slot in the backplane
	Slots []*Slot
}

// DimensionProperties - properties for dimension
type DimensionProperties struct {
	// localized display name of the dimension to customer
	DisplayName *string

	// dimension name
	Name *string

	// flag indicating whether this dimension should be included to the customer in Azure Monitor logs (aka Shoebox)
	ToBeExportedForCustomer *bool
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ErrorModel - Default error model
type ErrorModel struct {
	// READ-ONLY; Gets or sets the code.
	Code *string

	// READ-ONLY; Gets or sets the details.
	Details []*ErrorModel

	// READ-ONLY; Gets or sets the messages.
	Message *string

	// READ-ONLY; Gets or sets the target.
	Target *string
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail
}

// ErrorResponseModel - Default error response model
type ErrorResponseModel struct {
	// READ-ONLY; Gets or sets the error.
	Error *ErrorResponseModelError
}

// ErrorResponseModelError - Gets or sets the error.
type ErrorResponseModelError struct {
	// READ-ONLY; Gets or sets the code.
	Code *string

	// READ-ONLY; Gets or sets the details.
	Details []*ErrorModel

	// READ-ONLY; Gets or sets the messages.
	Message *string

	// READ-ONLY; Gets or sets the target.
	Target *string
}

// Firmware - Device firmware data
type Firmware struct {
	// A bag of fields which extends the firmware information.
	AdditionalFields any

	// Firmware module address.
	ModuleAddress *string

	// Firmware name.
	Name *string

	// Firmware serial.
	Serial *string

	// Firmware vendor.
	Vendor *string

	// Firmware version.
	Version *string
}

// Hardware - Device hardware data
type Hardware struct {
	// Hardware model.
	Model *string

	// Hardware serial number.
	SerialNumber *string

	// Hardware vendor.
	Vendor *string
}

// LocationList - List of Defender for IoT locations
type LocationList struct {
	// READ-ONLY; Link to next page of resources.
	NextLink *string

	// READ-ONLY; List data
	Value []*LocationModel
}

// LocationModel - IoT Defender location
type LocationModel struct {
	// IoT Defender location properties
	Properties any

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// MergedDevice - Merged device data
type MergedDevice struct {
	// READ-ONLY; Device data source
	DeviceDataSource *DeviceDataSource

	// READ-ONLY; device id
	ID *string

	// READ-ONLY; Device sensor data
	Sensor *Sensor
}

// Nic - Network interface card properties
type Nic struct {
	// READ-ONLY; Ipv4 address
	IPv4Address *string

	// READ-ONLY; Ipv6 address
	IPv6Address *string

	// READ-ONLY; Last seen time
	LastSeen *time.Time

	// READ-ONLY; Mac address
	MacAddress *string

	// READ-ONLY; Indicates whether the association of the mac to the ip address is certain or a guess.
	MacCertainty *MacCertainty

	// READ-ONLY; Network adapter vendor.
	NetworkAdapterVendor *string

	// READ-ONLY; List of virtual LAN (vlan)
	Vlans []*string
}

// OnPremiseSensor - On-premise IoT sensor
type OnPremiseSensor struct {
	// On-premise IoT sensor properties
	Properties any

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// OnPremiseSensorsList - List of on-premise IoT sensors
type OnPremiseSensorsList struct {
	// READ-ONLY; List data
	Value []*OnPremiseSensor
}

// OperatingSystem - Device operating system data
type OperatingSystem struct {
	// OS architecture
	Architecture *string

	// OS build
	Build *string

	// OS distribution
	Distribution *string

	// OS platform
	Platform *string

	// OS version
	Version *string
}

// Operation resource
type Operation struct {
	// Properties on the operation
	Display *OperationDisplay

	// Whether operation is a data action
	IsDataAction *bool

	// Operation name for display purposes
	Name *string

	// origin of the operation
	Origin *string

	// properties for the operation meta info
	Properties *OperationProperties
}

// OperationDisplay - The response model for get operation properties
type OperationDisplay struct {
	// Description of the operation for display purposes
	Description *string

	// Name of the operation for display purposes
	Operation *string

	// Name of the provider for display purposes
	Provider *string

	// Name of the resource type for display purposes
	Resource *string
}

// OperationList - Paged list of operation resources
type OperationList struct {
	// REQUIRED; Collection of items of type results.
	Value []*Operation

	// Total item count.
	Count *int64

	// The Url of next result page.
	NextLink *string
}

// OperationMetaLogSpecification - log specifications for operation api
type OperationMetaLogSpecification struct {
	// blob duration of the log
	BlobDuration *string

	// localized name of the log category
	DisplayName *string

	// name of the log category
	Name *string
}

// OperationMetaMetricSpecification - metric specifications for the operation
type OperationMetaMetricSpecification struct {
	// aggregation type of metric
	AggregationType *string

	// properties for dimension
	Dimensions []*DimensionProperties

	// description of the metric
	DisplayDescription *string

	// localized name of the metric
	DisplayName *string

	// enable regional mdm account
	EnableRegionalMdmAccount *string

	// internal metric name
	InternalMetricName *string

	// name of the metric
	Name *string

	// dimension name use to replace resource id if specified
	ResourceIDDimensionNameOverride *string

	// Metric namespace. Only set the namespace if different from the default value, leaving it empty makes it use the value from
	// the ARM manifest.
	SourceMdmNamespace *string

	// supported aggregation types
	SupportedAggregationTypes []*string

	// supported time grain types
	SupportedTimeGrainTypes []*string

	// units for the metric
	Unit *string
}

// OperationMetaServiceSpecification - The operation meta service specification
type OperationMetaServiceSpecification struct {
	// log specifications for the operation
	LogSpecifications []*OperationMetaLogSpecification

	// metric specifications for the operation
	MetricSpecifications []*OperationMetaMetricSpecification
}

// OperationProperties - properties on meta info
type OperationProperties struct {
	// meta service specification
	ServiceSpecification *OperationMetaServiceSpecification
}

// Package - Device package data
type Package struct {
	// Package name.
	Name *string

	// Package version.
	Version *string
}

// PackageDownloadInfo - Information on a specific package download
type PackageDownloadInfo struct {
	// READ-ONLY; Download link
	Link *string

	// READ-ONLY; Version number
	Version *string

	// READ-ONLY; Kind of the version
	VersionKind *VersionKind
}

// PackageDownloads - Information about package downloads
type PackageDownloads struct {
	// READ-ONLY; Authorized devices import template
	AuthorizedDevicesImportTemplate []*PackageDownloadInfo

	// READ-ONLY; All downloads for Central Manager
	CentralManager *PackageDownloadsCentralManager

	// READ-ONLY; Authorized devices import template
	DeviceInformationUpdateImportTemplate []*PackageDownloadInfo

	// READ-ONLY; Contains all Sensor binary downloads
	Sensor *PackageDownloadsSensor

	// READ-ONLY; SNMP Server file
	Snmp []*PackageDownloadInfo

	// READ-ONLY; All downloads for threat intelligence
	ThreatIntelligence []*PackageDownloadInfo

	// READ-ONLY; Used for local configuration export
	WmiTool []*PackageDownloadInfo
}

// PackageDownloadsCentralManager - All downloads for Central Manager
type PackageDownloadsCentralManager struct {
	// READ-ONLY; Contains full package downloads
	Full *PackageDownloadsCentralManagerFull

	// READ-ONLY; Central Manager upgrade package downloads (on existing installations)
	Upgrade []*UpgradePackageDownloadInfo
}

// PackageDownloadsCentralManagerFull - Contains full package downloads
type PackageDownloadsCentralManagerFull struct {
	// READ-ONLY; Contains all ISO full versions of the Central Manager
	Iso []*PackageDownloadInfo

	// READ-ONLY; Contains all OVF (virtual machine) full versions of the Central Manager
	Ovf *PackageDownloadsCentralManagerFullOvf
}

// PackageDownloadsCentralManagerFullOvf - Contains all OVF (virtual machine) full versions of the Central Manager
type PackageDownloadsCentralManagerFullOvf struct {
	// READ-ONLY; The Enterprise package type
	Enterprise []*PackageDownloadInfo

	// READ-ONLY; The EnterpriseHighAvailability package type
	EnterpriseHighAvailability []*PackageDownloadInfo

	// READ-ONLY; The Medium package type
	Medium []*PackageDownloadInfo

	// READ-ONLY; The MediumHighAvailability package type
	MediumHighAvailability []*PackageDownloadInfo
}

// PackageDownloadsSensor - Contains all Sensor binary downloads
type PackageDownloadsSensor struct {
	// Sensor upgrade package downloads (on existing installations)
	Upgrade []*UpgradePackageDownloadInfo

	// READ-ONLY; Contains full package downloads
	Full *PackageDownloadsSensorFull
}

// PackageDownloadsSensorFull - Contains full package downloads
type PackageDownloadsSensorFull struct {
	// Contains all OVF (virtual machine) full versions for the sensor
	Ovf *PackageDownloadsSensorFullOvf

	// READ-ONLY; Contains all ISO full versions for the sensor
	Iso []*PackageDownloadInfo
}

// PackageDownloadsSensorFullOvf - Contains all OVF (virtual machine) full versions for the sensor
type PackageDownloadsSensorFullOvf struct {
	// READ-ONLY; Enterprise package type
	Enterprise []*PackageDownloadInfo

	// READ-ONLY; Line package type
	Line []*PackageDownloadInfo

	// READ-ONLY; Medium package type
	Medium []*PackageDownloadInfo
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ResetPasswordInput - Reset password input.
type ResetPasswordInput struct {
	// The appliance id of the sensor.
	ApplianceID *string
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// Sensor that scanned the device
type Sensor struct {
	// READ-ONLY; Sensor name.
	Name *string

	// READ-ONLY; Sensor site.
	Site *string

	// READ-ONLY; Sensor type.
	Type *SensorType

	// READ-ONLY; Sensor zone.
	Zone *string
}

// SensorModel - IoT sensor model
type SensorModel struct {
	// IoT sensor properties
	Properties *SensorProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SensorProperties - IoT sensor properties
type SensorProperties struct {
	// Type of sensor
	SensorType *SensorType

	// TI Automatic mode status of the IoT sensor
	TiAutomaticUpdates *bool

	// Zone of the IoT sensor
	Zone *string

	// READ-ONLY; Last connectivity time of the IoT sensor
	ConnectivityTime *string

	// READ-ONLY; Dynamic mode status of the IoT sensor
	DynamicLearning *bool

	// READ-ONLY; Learning mode status of the IoT sensor
	LearningMode *bool

	// READ-ONLY; Status of the IoT sensor
	SensorStatus *SensorStatus

	// READ-ONLY; Version of the IoT sensor
	SensorVersion *string

	// READ-ONLY; TI Status of the IoT sensor
	TiStatus *TiStatus

	// READ-ONLY; TI Version of the IoT sensor
	TiVersion *string
}

// SensorsList - List of IoT sensors
type SensorsList struct {
	// READ-ONLY; List data
	Value []*SensorModel
}

// SiteModel - IoT site model
type SiteModel struct {
	// IoT site properties
	Properties *SiteProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SiteProperties - IoT site properties
type SiteProperties struct {
	// REQUIRED; Display name of the IoT site
	DisplayName *string

	// Tags of the IoT site
	Tags map[string]*string
}

// SitesList - List of IoT sites
type SitesList struct {
	// READ-ONLY; List data
	Value []*SiteModel
}

// Slot data in PLC backplane
type Slot struct {
	// A bag of fields which extends the slot information.
	AdditionalData any

	// Firmware revision of the slot.
	FirmwareVersion *string

	// Hardware revision of the slot.
	HardwareRevision *string

	// Hardware vendor of the slot.
	HardwareVendor *string

	// Model of the slot.
	Model *string

	// Module version of the slot.
	ModuleVersion *string

	// Product code of the slot.
	ProductCode *string

	// Serial number of the slot.
	SerialNumber *string

	// Slot type.
	SlotType *SlotType

	// READ-ONLY; List of Common Platform Enumeration (CPE) of the slot
	Cpes []*string

	// READ-ONLY; Rack number in the backplane
	RackNumber *int32

	// READ-ONLY; Slot number inside the rack
	SlotNumber *int32
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// UpgradePackageDownloadInfo - Information on a specific package upgrade download
type UpgradePackageDownloadInfo struct {
	// READ-ONLY; Minimum base version for upgrade
	FromVersion *string

	// READ-ONLY; Download link
	Link *string

	// READ-ONLY; Version number
	Version *string

	// READ-ONLY; Kind of the version
	VersionKind *VersionKind
}
