//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/cosmos/armcosmos/v3"
	"net/http"
	"net/url"
	"regexp"
)

// TableResourcesServer is a fake server for instances of the armcosmos.TableResourcesClient type.
type TableResourcesServer struct {
	// BeginCreateUpdateTable is the fake for method TableResourcesClient.BeginCreateUpdateTable
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateUpdateTable func(ctx context.Context, resourceGroupName string, accountName string, tableName string, createUpdateTableParameters armcosmos.TableCreateUpdateParameters, options *armcosmos.TableResourcesClientBeginCreateUpdateTableOptions) (resp azfake.PollerResponder[armcosmos.TableResourcesClientCreateUpdateTableResponse], errResp azfake.ErrorResponder)

	// BeginDeleteTable is the fake for method TableResourcesClient.BeginDeleteTable
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDeleteTable func(ctx context.Context, resourceGroupName string, accountName string, tableName string, options *armcosmos.TableResourcesClientBeginDeleteTableOptions) (resp azfake.PollerResponder[armcosmos.TableResourcesClientDeleteTableResponse], errResp azfake.ErrorResponder)

	// GetTable is the fake for method TableResourcesClient.GetTable
	// HTTP status codes to indicate success: http.StatusOK
	GetTable func(ctx context.Context, resourceGroupName string, accountName string, tableName string, options *armcosmos.TableResourcesClientGetTableOptions) (resp azfake.Responder[armcosmos.TableResourcesClientGetTableResponse], errResp azfake.ErrorResponder)

	// GetTableThroughput is the fake for method TableResourcesClient.GetTableThroughput
	// HTTP status codes to indicate success: http.StatusOK
	GetTableThroughput func(ctx context.Context, resourceGroupName string, accountName string, tableName string, options *armcosmos.TableResourcesClientGetTableThroughputOptions) (resp azfake.Responder[armcosmos.TableResourcesClientGetTableThroughputResponse], errResp azfake.ErrorResponder)

	// NewListTablesPager is the fake for method TableResourcesClient.NewListTablesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListTablesPager func(resourceGroupName string, accountName string, options *armcosmos.TableResourcesClientListTablesOptions) (resp azfake.PagerResponder[armcosmos.TableResourcesClientListTablesResponse])

	// BeginMigrateTableToAutoscale is the fake for method TableResourcesClient.BeginMigrateTableToAutoscale
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMigrateTableToAutoscale func(ctx context.Context, resourceGroupName string, accountName string, tableName string, options *armcosmos.TableResourcesClientBeginMigrateTableToAutoscaleOptions) (resp azfake.PollerResponder[armcosmos.TableResourcesClientMigrateTableToAutoscaleResponse], errResp azfake.ErrorResponder)

	// BeginMigrateTableToManualThroughput is the fake for method TableResourcesClient.BeginMigrateTableToManualThroughput
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMigrateTableToManualThroughput func(ctx context.Context, resourceGroupName string, accountName string, tableName string, options *armcosmos.TableResourcesClientBeginMigrateTableToManualThroughputOptions) (resp azfake.PollerResponder[armcosmos.TableResourcesClientMigrateTableToManualThroughputResponse], errResp azfake.ErrorResponder)

	// BeginRetrieveContinuousBackupInformation is the fake for method TableResourcesClient.BeginRetrieveContinuousBackupInformation
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRetrieveContinuousBackupInformation func(ctx context.Context, resourceGroupName string, accountName string, tableName string, location armcosmos.ContinuousBackupRestoreLocation, options *armcosmos.TableResourcesClientBeginRetrieveContinuousBackupInformationOptions) (resp azfake.PollerResponder[armcosmos.TableResourcesClientRetrieveContinuousBackupInformationResponse], errResp azfake.ErrorResponder)

	// BeginUpdateTableThroughput is the fake for method TableResourcesClient.BeginUpdateTableThroughput
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateTableThroughput func(ctx context.Context, resourceGroupName string, accountName string, tableName string, updateThroughputParameters armcosmos.ThroughputSettingsUpdateParameters, options *armcosmos.TableResourcesClientBeginUpdateTableThroughputOptions) (resp azfake.PollerResponder[armcosmos.TableResourcesClientUpdateTableThroughputResponse], errResp azfake.ErrorResponder)
}

// NewTableResourcesServerTransport creates a new instance of TableResourcesServerTransport with the provided implementation.
// The returned TableResourcesServerTransport instance is connected to an instance of armcosmos.TableResourcesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewTableResourcesServerTransport(srv *TableResourcesServer) *TableResourcesServerTransport {
	return &TableResourcesServerTransport{
		srv:                                      srv,
		beginCreateUpdateTable:                   newTracker[azfake.PollerResponder[armcosmos.TableResourcesClientCreateUpdateTableResponse]](),
		beginDeleteTable:                         newTracker[azfake.PollerResponder[armcosmos.TableResourcesClientDeleteTableResponse]](),
		newListTablesPager:                       newTracker[azfake.PagerResponder[armcosmos.TableResourcesClientListTablesResponse]](),
		beginMigrateTableToAutoscale:             newTracker[azfake.PollerResponder[armcosmos.TableResourcesClientMigrateTableToAutoscaleResponse]](),
		beginMigrateTableToManualThroughput:      newTracker[azfake.PollerResponder[armcosmos.TableResourcesClientMigrateTableToManualThroughputResponse]](),
		beginRetrieveContinuousBackupInformation: newTracker[azfake.PollerResponder[armcosmos.TableResourcesClientRetrieveContinuousBackupInformationResponse]](),
		beginUpdateTableThroughput:               newTracker[azfake.PollerResponder[armcosmos.TableResourcesClientUpdateTableThroughputResponse]](),
	}
}

// TableResourcesServerTransport connects instances of armcosmos.TableResourcesClient to instances of TableResourcesServer.
// Don't use this type directly, use NewTableResourcesServerTransport instead.
type TableResourcesServerTransport struct {
	srv                                      *TableResourcesServer
	beginCreateUpdateTable                   *tracker[azfake.PollerResponder[armcosmos.TableResourcesClientCreateUpdateTableResponse]]
	beginDeleteTable                         *tracker[azfake.PollerResponder[armcosmos.TableResourcesClientDeleteTableResponse]]
	newListTablesPager                       *tracker[azfake.PagerResponder[armcosmos.TableResourcesClientListTablesResponse]]
	beginMigrateTableToAutoscale             *tracker[azfake.PollerResponder[armcosmos.TableResourcesClientMigrateTableToAutoscaleResponse]]
	beginMigrateTableToManualThroughput      *tracker[azfake.PollerResponder[armcosmos.TableResourcesClientMigrateTableToManualThroughputResponse]]
	beginRetrieveContinuousBackupInformation *tracker[azfake.PollerResponder[armcosmos.TableResourcesClientRetrieveContinuousBackupInformationResponse]]
	beginUpdateTableThroughput               *tracker[azfake.PollerResponder[armcosmos.TableResourcesClientUpdateTableThroughputResponse]]
}

// Do implements the policy.Transporter interface for TableResourcesServerTransport.
func (t *TableResourcesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "TableResourcesClient.BeginCreateUpdateTable":
		resp, err = t.dispatchBeginCreateUpdateTable(req)
	case "TableResourcesClient.BeginDeleteTable":
		resp, err = t.dispatchBeginDeleteTable(req)
	case "TableResourcesClient.GetTable":
		resp, err = t.dispatchGetTable(req)
	case "TableResourcesClient.GetTableThroughput":
		resp, err = t.dispatchGetTableThroughput(req)
	case "TableResourcesClient.NewListTablesPager":
		resp, err = t.dispatchNewListTablesPager(req)
	case "TableResourcesClient.BeginMigrateTableToAutoscale":
		resp, err = t.dispatchBeginMigrateTableToAutoscale(req)
	case "TableResourcesClient.BeginMigrateTableToManualThroughput":
		resp, err = t.dispatchBeginMigrateTableToManualThroughput(req)
	case "TableResourcesClient.BeginRetrieveContinuousBackupInformation":
		resp, err = t.dispatchBeginRetrieveContinuousBackupInformation(req)
	case "TableResourcesClient.BeginUpdateTableThroughput":
		resp, err = t.dispatchBeginUpdateTableThroughput(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (t *TableResourcesServerTransport) dispatchBeginCreateUpdateTable(req *http.Request) (*http.Response, error) {
	if t.srv.BeginCreateUpdateTable == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateUpdateTable not implemented")}
	}
	beginCreateUpdateTable := t.beginCreateUpdateTable.get(req)
	if beginCreateUpdateTable == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tables/(?P<tableName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.TableCreateUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		tableNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("tableName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := t.srv.BeginCreateUpdateTable(req.Context(), resourceGroupNameParam, accountNameParam, tableNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateUpdateTable = &respr
		t.beginCreateUpdateTable.add(req, beginCreateUpdateTable)
	}

	resp, err := server.PollerResponderNext(beginCreateUpdateTable, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		t.beginCreateUpdateTable.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateUpdateTable) {
		t.beginCreateUpdateTable.remove(req)
	}

	return resp, nil
}

func (t *TableResourcesServerTransport) dispatchBeginDeleteTable(req *http.Request) (*http.Response, error) {
	if t.srv.BeginDeleteTable == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteTable not implemented")}
	}
	beginDeleteTable := t.beginDeleteTable.get(req)
	if beginDeleteTable == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tables/(?P<tableName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		tableNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("tableName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := t.srv.BeginDeleteTable(req.Context(), resourceGroupNameParam, accountNameParam, tableNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteTable = &respr
		t.beginDeleteTable.add(req, beginDeleteTable)
	}

	resp, err := server.PollerResponderNext(beginDeleteTable, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		t.beginDeleteTable.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteTable) {
		t.beginDeleteTable.remove(req)
	}

	return resp, nil
}

func (t *TableResourcesServerTransport) dispatchGetTable(req *http.Request) (*http.Response, error) {
	if t.srv.GetTable == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetTable not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tables/(?P<tableName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	tableNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("tableName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.GetTable(req.Context(), resourceGroupNameParam, accountNameParam, tableNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TableGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TableResourcesServerTransport) dispatchGetTableThroughput(req *http.Request) (*http.Response, error) {
	if t.srv.GetTableThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetTableThroughput not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tables/(?P<tableName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	tableNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("tableName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.GetTableThroughput(req.Context(), resourceGroupNameParam, accountNameParam, tableNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ThroughputSettingsGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TableResourcesServerTransport) dispatchNewListTablesPager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListTablesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListTablesPager not implemented")}
	}
	newListTablesPager := t.newListTablesPager.get(req)
	if newListTablesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tables`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		resp := t.srv.NewListTablesPager(resourceGroupNameParam, accountNameParam, nil)
		newListTablesPager = &resp
		t.newListTablesPager.add(req, newListTablesPager)
	}
	resp, err := server.PagerResponderNext(newListTablesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListTablesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListTablesPager) {
		t.newListTablesPager.remove(req)
	}
	return resp, nil
}

func (t *TableResourcesServerTransport) dispatchBeginMigrateTableToAutoscale(req *http.Request) (*http.Response, error) {
	if t.srv.BeginMigrateTableToAutoscale == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMigrateTableToAutoscale not implemented")}
	}
	beginMigrateTableToAutoscale := t.beginMigrateTableToAutoscale.get(req)
	if beginMigrateTableToAutoscale == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tables/(?P<tableName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/migrateToAutoscale`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		tableNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("tableName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := t.srv.BeginMigrateTableToAutoscale(req.Context(), resourceGroupNameParam, accountNameParam, tableNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMigrateTableToAutoscale = &respr
		t.beginMigrateTableToAutoscale.add(req, beginMigrateTableToAutoscale)
	}

	resp, err := server.PollerResponderNext(beginMigrateTableToAutoscale, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		t.beginMigrateTableToAutoscale.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMigrateTableToAutoscale) {
		t.beginMigrateTableToAutoscale.remove(req)
	}

	return resp, nil
}

func (t *TableResourcesServerTransport) dispatchBeginMigrateTableToManualThroughput(req *http.Request) (*http.Response, error) {
	if t.srv.BeginMigrateTableToManualThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMigrateTableToManualThroughput not implemented")}
	}
	beginMigrateTableToManualThroughput := t.beginMigrateTableToManualThroughput.get(req)
	if beginMigrateTableToManualThroughput == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tables/(?P<tableName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/migrateToManualThroughput`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		tableNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("tableName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := t.srv.BeginMigrateTableToManualThroughput(req.Context(), resourceGroupNameParam, accountNameParam, tableNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMigrateTableToManualThroughput = &respr
		t.beginMigrateTableToManualThroughput.add(req, beginMigrateTableToManualThroughput)
	}

	resp, err := server.PollerResponderNext(beginMigrateTableToManualThroughput, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		t.beginMigrateTableToManualThroughput.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMigrateTableToManualThroughput) {
		t.beginMigrateTableToManualThroughput.remove(req)
	}

	return resp, nil
}

func (t *TableResourcesServerTransport) dispatchBeginRetrieveContinuousBackupInformation(req *http.Request) (*http.Response, error) {
	if t.srv.BeginRetrieveContinuousBackupInformation == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRetrieveContinuousBackupInformation not implemented")}
	}
	beginRetrieveContinuousBackupInformation := t.beginRetrieveContinuousBackupInformation.get(req)
	if beginRetrieveContinuousBackupInformation == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tables/(?P<tableName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/retrieveContinuousBackupInformation`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.ContinuousBackupRestoreLocation](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		tableNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("tableName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := t.srv.BeginRetrieveContinuousBackupInformation(req.Context(), resourceGroupNameParam, accountNameParam, tableNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRetrieveContinuousBackupInformation = &respr
		t.beginRetrieveContinuousBackupInformation.add(req, beginRetrieveContinuousBackupInformation)
	}

	resp, err := server.PollerResponderNext(beginRetrieveContinuousBackupInformation, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		t.beginRetrieveContinuousBackupInformation.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRetrieveContinuousBackupInformation) {
		t.beginRetrieveContinuousBackupInformation.remove(req)
	}

	return resp, nil
}

func (t *TableResourcesServerTransport) dispatchBeginUpdateTableThroughput(req *http.Request) (*http.Response, error) {
	if t.srv.BeginUpdateTableThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateTableThroughput not implemented")}
	}
	beginUpdateTableThroughput := t.beginUpdateTableThroughput.get(req)
	if beginUpdateTableThroughput == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tables/(?P<tableName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.ThroughputSettingsUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		tableNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("tableName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := t.srv.BeginUpdateTableThroughput(req.Context(), resourceGroupNameParam, accountNameParam, tableNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateTableThroughput = &respr
		t.beginUpdateTableThroughput.add(req, beginUpdateTableThroughput)
	}

	resp, err := server.PollerResponderNext(beginUpdateTableThroughput, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		t.beginUpdateTableThroughput.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateTableThroughput) {
		t.beginUpdateTableThroughput.remove(req)
	}

	return resp, nil
}
