# -*- coding: utf-8 -*-
# Copyright 2020 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

from __future__ import absolute_import, division, print_function


__metaclass__ = type

from unittest.mock import patch

from ansible_collections.junipernetworks.junos.plugins.modules import junos_hostname
from ansible_collections.junipernetworks.junos.tests.unit.modules.utils import set_module_args

from .junos_module import TestJunosModule, load_fixture


class TestJunosHostnameModule(TestJunosModule):
    module = junos_hostname

    def setUp(self):
        super(TestJunosHostnameModule, self).setUp()

        self.mock_lock_configuration = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.junos.lock_configuration",
        )
        self.lock_configuration = self.mock_lock_configuration.start()

        self.mock_unlock_configuration = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.junos.unlock_configuration",
        )
        self.unlock_configuration = self.mock_unlock_configuration.start()

        self.mock_load_config = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.hostname.hostname.load_config",
        )
        self.load_config = self.mock_load_config.start()

        self.mock_commit_configuration = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.hostname.hostname.commit_configuration",
        )
        self.mock_commit_configuration = self.mock_commit_configuration.start()

        self.mock_execute_show_command = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.facts.hostname.hostname."
            "HostnameFacts.get_device_data",
        )
        self.execute_show_command = self.mock_execute_show_command.start()

    def tearDown(self):
        super(TestJunosHostnameModule, self).tearDown()
        self.mock_load_config.stop()
        self.mock_lock_configuration.stop()
        self.mock_unlock_configuration.stop()
        self.mock_commit_configuration.stop()
        self.mock_execute_show_command.stop()

    def load_fixtures(
        self,
        commands=None,
        format="text",
        changed=False,
        filename=None,
    ):
        def load_from_file(*args, **kwargs):
            output = load_fixture("junos_hostname_config.cfg")
            return output

        self.execute_show_command.side_effect = load_from_file

    def test_junos_hostname_merged_01(self):
        set_module_args(dict(config=dict(hostname="vsrx"), state="merged"))
        result = self.execute_module(changed=True)
        self.assertIn(
            "<nc:host-name>vsrx</nc:host-name>",
            str(result["commands"]),
        )

    def test_junos_hostname_parsed_01(self):
        parsed_str = """
            <rpc-reply message-id="urn:uuid:0cadb4e8-5bba-47f4-986e-72906227007f">
                <configuration changed-seconds="1590139550" changed-localtime="2020-05-22 09:25:50 UTC">
                    <version>18.4R1-S2.4</version>
                    <system>
                        <host-name>vsrx</host-name>
                    </system>
                </configuration>
            </rpc-reply>
        """
        set_module_args(dict(running_config=parsed_str, state="parsed"))
        result = self.execute_module(changed=False)
        parsed_dict = {"hostname": "vsrx"}
        self.assertEqual(sorted(parsed_dict), sorted(result["parsed"]))

    def test_junos_hostname_overridden_01(self):
        set_module_args(
            dict(config=dict(hostname="vsrx12"), state="overridden"),
        )
        result = self.execute_module(changed=True)
        self.assertIn(
            "<nc:host-name>vsrx12</nc:host-name>",
            str(result["commands"]),
        )

    def test_junos_hostname_gathered(self):
        """
        :return:
        """
        set_module_args(dict(state="gathered"))
        result = self.execute_module(changed=False)
        gathered_hostname = {"hostname": "vsrx10"}
        self.assertEqual(sorted(gathered_hostname), sorted(result["gathered"]))

    def test_junos_hostname_rendered(self):
        set_module_args(dict(config=dict(hostname="vsrx10"), state="rendered"))
        rendered = (
            '<nc:system xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0">'
            "<nc:host-name>vsrx10</nc:host-name></nc:system>"
        )
        result = self.execute_module(changed=False)
        self.assertEqual(sorted(result["rendered"]), sorted(rendered))

    def test_junos_hostname_replaced(self):
        set_module_args(dict(config=dict(hostname="vsrx12"), state="replaced"))
        result = self.execute_module(changed=True)
        self.assertIn(
            "<nc:host-name>vsrx12</nc:host-name>",
            str(result["commands"]),
        )
