/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.InputStream;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.webresources.TrackedInputStream;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractResource
implements WebResource {
    protected static final StringManager sm = StringManager.getManager(AbstractResource.class);
    private final WebResourceRoot root;
    private final String webAppPath;
    private String mimeType = null;
    private volatile String weakETag;

    protected AbstractResource(WebResourceRoot webResourceRoot, String string) {
        this.root = webResourceRoot;
        this.webAppPath = string;
    }

    @Override
    public final WebResourceRoot getWebResourceRoot() {
        return this.root;
    }

    @Override
    public final String getWebappPath() {
        return this.webAppPath;
    }

    @Override
    public final String getLastModifiedHttp() {
        return FastHttpDateFormat.formatDate((long)this.getLastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getETag() {
        if (this.weakETag == null) {
            AbstractResource abstractResource = this;
            synchronized (abstractResource) {
                if (this.weakETag == null) {
                    long l = this.getContentLength();
                    long l2 = this.getLastModified();
                    if (l >= 0L || l2 >= 0L) {
                        this.weakETag = "W/\"" + l + "-" + l2 + "\"";
                    }
                }
            }
        }
        return this.weakETag;
    }

    @Override
    public final void setMimeType(String string) {
        this.mimeType = string;
    }

    @Override
    public final String getMimeType() {
        return this.mimeType;
    }

    @Override
    public final InputStream getInputStream() {
        InputStream inputStream = this.doGetInputStream();
        if (inputStream == null || !this.root.getTrackLockedFiles()) {
            return inputStream;
        }
        return new TrackedInputStream(this.root, this.getName(), inputStream);
    }

    protected abstract InputStream doGetInputStream();

    protected abstract Log getLog();
}

