/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.argument;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.method.PMethod;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.argument.CreateArgumentsNodeGen;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedIntValueProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class CreateArgumentsNode
extends PNodeWithContext {
    public abstract Object[] execute(Node var1, Object var2, Object[] var3, PKeyword[] var4, Signature var5, Object var6, Object var7, Object[] var8, PKeyword[] var9, boolean var10);

    @Specialization
    static Object[] doIt(Node inliningTarget, Object callableOrName, Object[] userArguments, PKeyword[] keywords, Signature signature, Object self, Object classObject, Object[] defaults, PKeyword[] kwdefaults, boolean methodcall, @Cached InlinedIntValueProfile lenProfile, @Cached InlinedIntValueProfile maxPosProfile, @Cached InlinedIntValueProfile numKwdsProfile, @Cached LazyApplyKeywordsNode applyKeywords, @Cached LazyHandleTooManyArgumentsNode handleTooManyArgumentsNode, @Cached ApplyPositionalArguments applyPositional, @Cached LazyFillDefaultsNode fillDefaultsNode, @Cached LazyFillKwDefaultsNode fillKwDefaultsNode, @Cached CheckEnclosingTypeNode checkEnclosingTypeNode) {
        boolean more_filling;
        int cachedLen = lenProfile.profile(inliningTarget, userArguments.length);
        int cachedMaxPos = maxPosProfile.profile(inliningTarget, signature.getMaxNumOfPositionalArgs());
        int cachedNumKwds = numKwdsProfile.profile(inliningTarget, signature.getNumOfRequiredKeywords());
        assert (userArguments.length == cachedLen);
        boolean too_many_args = false;
        Object[] scope_w = PArguments.create(cachedMaxPos + cachedNumKwds);
        int upfront = 0;
        if (self != null) {
            ++upfront;
            if (cachedMaxPos > 0) {
                PArguments.setArgument(scope_w, 0, self);
            }
            if (classObject != null) {
                ++upfront;
                PArguments.setArgument(scope_w, 1, classObject);
            }
        }
        int avail = cachedLen + upfront;
        int input_argcount = applyPositional.execute(inliningTarget, userArguments, scope_w, upfront, cachedMaxPos, cachedLen);
        if (signature.takesVarArgs()) {
            int args_left = cachedMaxPos - upfront;
            if (args_left < 0) {
                assert (upfront == 1);
                Object[] varargs = new Object[cachedLen + 1];
                varargs[0] = self;
                PythonUtils.arraycopy(userArguments, 0, varargs, 1, cachedLen);
                PArguments.setVariableArguments(scope_w, varargs);
            } else if (cachedLen > args_left) {
                PArguments.setVariableArguments(scope_w, Arrays.copyOfRange(userArguments, args_left, userArguments.length));
            }
        } else if (avail > cachedMaxPos) {
            too_many_args = true;
        }
        if (keywords.length > 0) {
            applyKeywords.get(inliningTarget).execute(callableOrName, signature, scope_w, keywords);
        }
        if (too_many_args) {
            int adjustCount = self instanceof PythonModule ? 1 : 0;
            throw handleTooManyArgumentsNode.get(inliningTarget).execute(scope_w, callableOrName, signature, cachedMaxPos, cachedNumKwds, defaults.length, avail, methodcall, adjustCount);
        }
        boolean bl = more_filling = input_argcount < cachedMaxPos + cachedNumKwds;
        if (more_filling) {
            fillDefaultsNode.get(inliningTarget).execute(callableOrName, signature, scope_w, defaults, input_argcount, cachedMaxPos);
            fillKwDefaultsNode.get(inliningTarget).execute(callableOrName, scope_w, signature, kwdefaults, cachedMaxPos, cachedNumKwds);
        }
        checkEnclosingTypeNode.execute(inliningTarget, signature, callableOrName, scope_w);
        return scope_w;
    }

    protected static TruffleString getName(Object callable, Signature signature) {
        if (!signature.getRaiseErrorName().isEmpty()) {
            return signature.getRaiseErrorName();
        }
        if (callable instanceof TruffleString) {
            TruffleString ts = (TruffleString)callable;
            return ts;
        }
        if (callable instanceof PCode) {
            return ((PCode)callable).getName();
        }
        return CreateArgumentsNode.getProperty(callable, QualnameGetter.INSTANCE);
    }

    protected static Object getSelf(Object callable) {
        if (callable instanceof PBuiltinMethod) {
            return ((PBuiltinMethod)callable).getSelf();
        }
        if (callable instanceof PMethod) {
            return ((PMethod)callable).getSelf();
        }
        return null;
    }

    protected static Object getClassObject(Object callable) {
        if (callable instanceof PBuiltinMethod) {
            return ((PBuiltinMethod)callable).getClassObject();
        }
        return null;
    }

    protected static Object getFunction(Object callable) {
        if (callable instanceof PBuiltinMethod) {
            return ((PBuiltinMethod)callable).getFunction();
        }
        if (callable instanceof PMethod) {
            return ((PMethod)callable).getFunction();
        }
        return null;
    }

    private static <T> T getProperty(Object callable, Getter<T> getter) {
        if (callable instanceof PFunction) {
            return getter.fromPFunction((PFunction)callable);
        }
        if (callable instanceof PBuiltinFunction) {
            return getter.fromPBuiltinFunction((PBuiltinFunction)callable);
        }
        if (callable instanceof PBuiltinMethod) {
            PBuiltinFunction function = ((PBuiltinMethod)callable).getBuiltinFunction();
            return getter.fromPBuiltinFunction(function);
        }
        if (callable instanceof PMethod) {
            Object function = ((PMethod)callable).getFunction();
            if (function instanceof PBuiltinFunction) {
                return getter.fromPBuiltinFunction((PBuiltinFunction)function);
            }
            if (function instanceof PFunction) {
                return getter.fromPFunction((PFunction)function);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new IllegalStateException("cannot create arguments for non-function-or-method");
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    protected static abstract class ApplyPositionalArguments
    extends Node {
        protected ApplyPositionalArguments() {
        }

        public abstract int execute(Node var1, Object[] var2, Object[] var3, int var4, int var5, int var6);

        @Specialization(guards={"upfront < co_argcount"})
        static int doIt(Object[] args_w, Object[] scope_w, int upfront, int co_argcount, int num_args) {
            int take = Math.min(num_args, co_argcount - upfront);
            PythonUtils.arraycopy(args_w, 0, scope_w, 9 + upfront, take);
            return upfront + take;
        }

        @Specialization(guards={"upfront >= co_argcount"})
        static int doNothing(Object[] args_w, Object[] scope_w, int upfront, int co_argcount, int num_args) {
            return 0;
        }

        protected static ApplyPositionalArguments getUncached() {
            return CreateArgumentsNodeGen.ApplyPositionalArgumentsNodeGen.getUncached();
        }
    }

    @GenerateCached(value=false)
    @GenerateInline
    @GenerateUncached
    static abstract class LazyApplyKeywordsNode
    extends Node {
        LazyApplyKeywordsNode() {
        }

        public final ApplyKeywordsNode get(Node inliningTarget) {
            return this.execute(inliningTarget);
        }

        public abstract ApplyKeywordsNode execute(Node var1);

        @Specialization
        static ApplyKeywordsNode doIt(@Cached(inline=false) ApplyKeywordsNode applyKeywordsNode) {
            return applyKeywordsNode;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    protected static abstract class ApplyKeywordsNode
    extends PNodeWithContext {
        protected ApplyKeywordsNode() {
        }

        public abstract Object[] execute(Object var1, Signature var2, Object[] var3, PKeyword[] var4);

        @Specialization(guards={"kwLen == keywords.length", "calleeSignature == cachedSignature", "kwLen <= 32"}, limit="3")
        @ExplodeLoop
        static Object[] applyCached(Object callee, Signature calleeSignature, Object[] arguments, PKeyword[] keywords, @Bind Node inliningTarget, @Cached.Exclusive @Cached PRaiseNode raise, @Cached(value="keywords.length") int kwLen, @Cached(value="calleeSignature") Signature cachedSignature, @Cached(value="cachedSignature.takesVarKeywordArgs()") boolean takesVarKwds, @Cached(value="cachedSignature.getParameterIds()", dimensions=1) TruffleString[] parameters, @Cached(value="parameters.length") int positionalParamNum, @Cached(value="cachedSignature.getKeywordNames()", dimensions=1) TruffleString[] kwNames, @Cached.Exclusive @Cached InlinedBranchProfile posArgOnlyPassedAsKeywordProfile, @Cached.Exclusive @Cached InlinedBranchProfile kwOnlyIdxFoundProfile, @Cached.Exclusive @Cached SearchNamedParameterNode searchParamNode, @Cached.Exclusive @Cached SearchNamedParameterNode searchKwNode) {
            PKeyword[] unusedKeywords = takesVarKwds ? PKeyword.create(kwLen) : null;
            int k = 0;
            int additionalKwds = 0;
            TruffleString lastWrongKeyword = null;
            int positionalOnlyArgIndex = calleeSignature.getPositionalOnlyArgIndex();
            List<TruffleString> posArgOnlyPassedAsKeywordNames = null;
            for (int i = 0; i < kwLen; ++i) {
                int kwOnlyIdx;
                PKeyword kwArg = keywords[i];
                TruffleString name = kwArg.getName();
                int kwIdx = searchParamNode.execute(inliningTarget, parameters, name);
                if (kwIdx == -1 && (kwOnlyIdx = searchKwNode.execute(inliningTarget, kwNames, name)) != -1) {
                    kwOnlyIdxFoundProfile.enter(inliningTarget);
                    kwIdx = kwOnlyIdx + positionalParamNum;
                }
                if (kwIdx != -1) {
                    if (positionalOnlyArgIndex > -1 && kwIdx < positionalOnlyArgIndex) {
                        if (unusedKeywords != null) {
                            unusedKeywords[k++] = kwArg;
                            continue;
                        }
                        posArgOnlyPassedAsKeywordProfile.enter(inliningTarget);
                        posArgOnlyPassedAsKeywordNames = ApplyKeywordsNode.addPosArgOnlyPassedAsKeyword(posArgOnlyPassedAsKeywordNames, name);
                        continue;
                    }
                    if (PArguments.getArgument(arguments, kwIdx) != null) {
                        throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.S_PAREN_GOT_MULTIPLE_VALUES_FOR_ARG, CreateArgumentsNode.getName(callee, cachedSignature), name);
                    }
                    PArguments.setArgument(arguments, kwIdx, kwArg.getValue());
                    continue;
                }
                if (unusedKeywords != null) {
                    unusedKeywords[k++] = kwArg;
                    continue;
                }
                ++additionalKwds;
                lastWrongKeyword = name;
            }
            ApplyKeywordsNode.storeKeywordsOrRaise(callee, arguments, unusedKeywords, k, additionalKwds, lastWrongKeyword, posArgOnlyPassedAsKeywordNames, inliningTarget, posArgOnlyPassedAsKeywordProfile, raise, cachedSignature);
            return arguments;
        }

        @Specialization(replaces={"applyCached"})
        static Object[] applyUncached(Object callee, Signature calleeSignature, Object[] arguments, PKeyword[] keywords, @Bind Node inliningTarget, @Cached.Exclusive @Cached PRaiseNode raise, @Cached.Exclusive @Cached InlinedBranchProfile posArgOnlyPassedAsKeywordProfile, @Cached.Exclusive @Cached InlinedBranchProfile kwOnlyIdxFoundProfile, @Cached.Exclusive @Cached SearchNamedParameterNode searchParamNode, @Cached.Exclusive @Cached SearchNamedParameterNode searchKwNode) {
            TruffleString[] parameters = calleeSignature.getParameterIds();
            int positionalParamNum = parameters.length;
            TruffleString[] kwNames = calleeSignature.getKeywordNames();
            int kwLen = keywords.length;
            PKeyword[] unusedKeywords = calleeSignature.takesVarKeywordArgs() ? PKeyword.create(kwLen) : null;
            int k = 0;
            int additionalKwds = 0;
            TruffleString lastWrongKeyword = null;
            int positionalOnlyArgIndex = calleeSignature.getPositionalOnlyArgIndex();
            List<TruffleString> posArgOnlyPassedAsKeywordNames = null;
            for (int i = 0; i < kwLen; ++i) {
                int kwOnlyIdx;
                PKeyword kwArg = keywords[i];
                TruffleString name = kwArg.getName();
                int kwIdx = searchParamNode.execute(inliningTarget, parameters, name);
                if (kwIdx == -1 && (kwOnlyIdx = searchKwNode.execute(inliningTarget, kwNames, name)) != -1) {
                    kwOnlyIdxFoundProfile.enter(inliningTarget);
                    kwIdx = kwOnlyIdx + positionalParamNum;
                }
                if (kwIdx != -1) {
                    if (positionalOnlyArgIndex > -1 && kwIdx < positionalOnlyArgIndex) {
                        if (unusedKeywords != null) {
                            unusedKeywords[k++] = kwArg;
                            continue;
                        }
                        posArgOnlyPassedAsKeywordProfile.enter(inliningTarget);
                        posArgOnlyPassedAsKeywordNames = ApplyKeywordsNode.addPosArgOnlyPassedAsKeyword(posArgOnlyPassedAsKeywordNames, name);
                        continue;
                    }
                    if (PArguments.getArgument(arguments, kwIdx) != null) {
                        throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.S_PAREN_GOT_MULTIPLE_VALUES_FOR_ARG, CreateArgumentsNode.getName(callee, calleeSignature), name);
                    }
                    PArguments.setArgument(arguments, kwIdx, kwArg.getValue());
                    continue;
                }
                if (unusedKeywords != null) {
                    unusedKeywords[k++] = kwArg;
                    continue;
                }
                ++additionalKwds;
                lastWrongKeyword = name;
            }
            ApplyKeywordsNode.storeKeywordsOrRaise(callee, arguments, unusedKeywords, k, additionalKwds, lastWrongKeyword, posArgOnlyPassedAsKeywordNames, inliningTarget, posArgOnlyPassedAsKeywordProfile, raise, calleeSignature);
            return arguments;
        }

        @CompilerDirectives.TruffleBoundary
        private static List<TruffleString> addPosArgOnlyPassedAsKeyword(List<TruffleString> names, TruffleString name) {
            if (names == null) {
                ArrayList<TruffleString> newList = new ArrayList<TruffleString>();
                newList.add(name);
                return newList;
            }
            names.add(name);
            return names;
        }

        private static void storeKeywordsOrRaise(Object callee, Object[] arguments, PKeyword[] unusedKeywords, int unusedKeywordCount, int tooManyKeywords, TruffleString lastWrongKeyword, List<TruffleString> posArgOnlyPassedAsKeywordNames, Node inliningTarget, InlinedBranchProfile posArgOnlyPassedAsKeywordProfile, PRaiseNode raise, Signature signature) {
            if (tooManyKeywords == 1) {
                throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.GOT_UNEXPECTED_KEYWORD_ARG, CreateArgumentsNode.getName(callee, signature), lastWrongKeyword);
            }
            if (tooManyKeywords > 1) {
                throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.GOT_UNEXPECTED_KEYWORD_ARG, CreateArgumentsNode.getName(callee, signature), tooManyKeywords);
            }
            if (posArgOnlyPassedAsKeywordNames != null) {
                posArgOnlyPassedAsKeywordProfile.enter(inliningTarget);
                TruffleString names = StringUtils.joinUncached(StringLiterals.T_COMMA_SPACE, posArgOnlyPassedAsKeywordNames);
                throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.GOT_SOME_POS_ONLY_ARGS_PASSED_AS_KEYWORD, CreateArgumentsNode.getName(callee, signature), names);
            }
            if (unusedKeywords != null) {
                PArguments.setKeywordArguments(arguments, Arrays.copyOf(unusedKeywords, unusedKeywordCount));
            }
        }

        @GenerateUncached
        @GenerateInline
        @GenerateCached(value=false)
        protected static abstract class SearchNamedParameterNode
        extends Node {
            protected SearchNamedParameterNode() {
            }

            public abstract int execute(Node var1, TruffleString[] var2, TruffleString var3);

            @Idempotent
            protected static boolean nameIsAtIndex(TruffleString[] parameters, TruffleString name, int index) {
                return SearchNamedParameterNode.uncached(parameters, name, TruffleString.EqualNode.getUncached()) == index;
            }

            @Specialization(guards={"name == cachedName", "parameters == cachedParameters", "nameIsAtIndex(cachedParameters, cachedName, index)"}, limit="1")
            static int cachedSingle(TruffleString[] parameters, TruffleString name, @Cached(value="name") TruffleString cachedName, @Cached(value="parameters", dimensions=0) TruffleString[] cachedParameters, @Cached.Shared @Cached(inline=false) TruffleString.EqualNode equalNode, @Cached(value="uncached(parameters, name, equalNode)") int index) {
                return index;
            }

            @Specialization(guards={"cachedLen == parameters.length", "cachedLen <= 32"}, replaces={"cachedSingle"}, limit="3")
            @ExplodeLoop
            static int cached(TruffleString[] parameters, TruffleString name, @Cached(value="parameters.length") int cachedLen, @Cached.Shared @Cached(inline=false) TruffleString.EqualNode equalNode) {
                int idx = -1;
                for (int i = 0; i < cachedLen; ++i) {
                    if (!equalNode.execute((AbstractTruffleString)parameters[i], (AbstractTruffleString)name, PythonUtils.TS_ENCODING)) continue;
                    idx = i;
                }
                return idx;
            }

            @Specialization(replaces={"cached"})
            static int uncached(TruffleString[] parameters, TruffleString name, @Cached.Shared @Cached(inline=false) TruffleString.EqualNode equalNode) {
                for (int i = 0; i < parameters.length; ++i) {
                    if (!equalNode.execute((AbstractTruffleString)parameters[i], (AbstractTruffleString)name, PythonUtils.TS_ENCODING)) continue;
                    return i;
                }
                return -1;
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    static abstract class LazyHandleTooManyArgumentsNode
    extends Node {
        LazyHandleTooManyArgumentsNode() {
        }

        public final HandleTooManyArgumentsNode get(Node inliningTarget) {
            return this.execute(inliningTarget);
        }

        public abstract HandleTooManyArgumentsNode execute(Node var1);

        @Specialization
        static HandleTooManyArgumentsNode doIt(@Cached(inline=false) HandleTooManyArgumentsNode node) {
            return node;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    protected static abstract class HandleTooManyArgumentsNode
    extends PNodeWithContext {
        protected HandleTooManyArgumentsNode() {
        }

        public abstract PException execute(Object[] var1, Object var2, Signature var3, int var4, int var5, int var6, int var7, boolean var8, int var9);

        @Specialization(guards={"co_kwonlyargcount == cachedKwOnlyArgCount", "cachedKwOnlyArgCount <= 32"}, limit="3")
        @ExplodeLoop
        static PException doCached(Object[] scope_w, Object callable, Signature signature, int co_argcount, int co_kwonlyargcount, int ndefaults, int avail, boolean methodcall, int adjustCount, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raise, @Cached.Shared @Cached TruffleString.EqualNode equalNode, @Cached(value="co_kwonlyargcount") int cachedKwOnlyArgCount) {
            int kwonly_given = 0;
            for (int i = 0; i < cachedKwOnlyArgCount; ++i) {
                if (PArguments.getArgument(scope_w, co_argcount + i) == null) continue;
                ++kwonly_given;
            }
            boolean forgotSelf = methodcall && avail + 1 == co_argcount && (signature.getParameterIds().length == 0 || !equalNode.execute((AbstractTruffleString)signature.getParameterIds()[0], (AbstractTruffleString)BuiltinNames.T_SELF, PythonUtils.TS_ENCODING));
            TruffleString name = CreateArgumentsNode.getName(callable, signature);
            throw HandleTooManyArgumentsNode.raiseTooManyArguments(inliningTarget, name, co_argcount - adjustCount, ndefaults, avail - adjustCount, forgotSelf, kwonly_given, raise);
        }

        @Specialization(replaces={"doCached"})
        static PException doUncached(Object[] scope_w, Object callable, Signature signature, int co_argcount, int co_kwonlyargcount, int ndefaults, int avail, boolean methodcall, int adjustCount, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raise, @Cached.Shared @Cached TruffleString.EqualNode equalNode) {
            int kwonly_given = 0;
            for (int i = 0; i < co_kwonlyargcount; ++i) {
                if (PArguments.getArgument(scope_w, co_argcount + i) == null) continue;
                ++kwonly_given;
            }
            boolean forgotSelf = methodcall && avail + 1 == co_argcount && (signature.getParameterIds().length == 0 || !equalNode.execute((AbstractTruffleString)signature.getParameterIds()[0], (AbstractTruffleString)BuiltinNames.T_SELF, PythonUtils.TS_ENCODING));
            TruffleString name = CreateArgumentsNode.getName(callable, signature);
            throw HandleTooManyArgumentsNode.raiseTooManyArguments(inliningTarget, name, co_argcount - adjustCount, ndefaults, avail - adjustCount, forgotSelf, kwonly_given, raise);
        }

        private static PException raiseTooManyArguments(Node inliningTarget, TruffleString name, int co_argcount, int ndefaults, int avail, boolean forgotSelf, int kwonly_given, PRaiseNode raise) {
            String forgotSelfMsg;
            String string = forgotSelfMsg = forgotSelf ? ". Did you forget 'self' in the function definition?" : "";
            if (ndefaults > 0) {
                if (kwonly_given == 0) {
                    throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.TAKES_FROM_D_TO_D_POS_ARG_S_BUT_D_S_GIVEN_S, name, co_argcount - ndefaults, co_argcount, co_argcount == 1 ? "" : "s", avail, avail == 1 ? "was" : "were", forgotSelfMsg);
                }
                throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.TAKES_FROM_D_TO_D_POS_ARG_S_BUT_D_POS_ARG_S, name, co_argcount - ndefaults, co_argcount, co_argcount == 1 ? "" : "s", avail, avail == 1 ? "" : "s", kwonly_given, kwonly_given == 1 ? "" : "s", forgotSelfMsg);
            }
            if (kwonly_given == 0) {
                throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.TAKES_D_POS_ARG_S_BUT_GIVEN_S, name, co_argcount - ndefaults, co_argcount == 1 ? "" : "s", avail, avail == 1 ? "was" : "were", forgotSelfMsg);
            }
            throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.TAKES_D_POS_ARG_S_BUT_D_POS_ARG_S, name, co_argcount, co_argcount == 1 ? "" : "s", avail, avail == 1 ? "" : "s", kwonly_given, kwonly_given == 1 ? "" : "s", forgotSelfMsg);
        }

        protected static HandleTooManyArgumentsNode getUncached() {
            return CreateArgumentsNodeGen.HandleTooManyArgumentsNodeGen.getUncached();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    protected static abstract class LazyFillDefaultsNode
    extends Node {
        protected LazyFillDefaultsNode() {
        }

        public final FillDefaultsNode get(Node inliningTarget) {
            return this.execute(inliningTarget);
        }

        public abstract FillDefaultsNode execute(Node var1);

        @Specialization
        static FillDefaultsNode doIt(@Cached(inline=false) FillDefaultsNode node) {
            return node;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    protected static abstract class FillDefaultsNode
    extends FillBaseNode {
        protected FillDefaultsNode() {
        }

        public abstract void execute(Object var1, Signature var2, Object[] var3, Object[] var4, int var5, int var6);

        @Specialization(guards={"input_argcount == cachedInputArgcount", "co_argcount == cachedArgcount", "checkIterations(input_argcount, co_argcount)"}, limit="3")
        @ExplodeLoop
        static void doCached(Object callable, Signature signature, Object[] scope_w, Object[] defaults, int input_argcount, int co_argcount, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raise, @Cached(value="input_argcount") int cachedInputArgcount, @Cached(value="co_argcount") int cachedArgcount, @Cached.Shared @Cached InlinedConditionProfile missingProfile) {
            TruffleString[] missingNames = new TruffleString[cachedArgcount - cachedInputArgcount];
            int firstDefaultArgIdx = cachedArgcount - defaults.length;
            int missingCnt = 0;
            for (int i = cachedInputArgcount; i < cachedArgcount; ++i) {
                if (PArguments.getArgument(scope_w, i) != null) continue;
                int defnum = i - firstDefaultArgIdx;
                if (defnum >= 0) {
                    PArguments.setArgument(scope_w, i, defaults[defnum]);
                    continue;
                }
                missingNames[missingCnt++] = signature.getParameterIds()[i];
            }
            if (missingProfile.profile(inliningTarget, missingCnt > 0)) {
                throw FillDefaultsNode.raiseMissing(inliningTarget, callable, missingNames, missingCnt, PythonUtils.toTruffleStringUncached("positional"), raise, signature);
            }
        }

        @Specialization(replaces={"doCached"})
        static void doUncached(Object callable, Signature signature, Object[] scope_w, Object[] defaults, int input_argcount, int co_argcount, @Bind Node inliningTarget, @Cached.Shared @Cached PRaiseNode raise, @Cached.Shared @Cached InlinedConditionProfile missingProfile) {
            TruffleString[] missingNames = new TruffleString[co_argcount - input_argcount];
            int firstDefaultArgIdx = co_argcount - defaults.length;
            int missingCnt = 0;
            for (int i = input_argcount; i < co_argcount; ++i) {
                if (PArguments.getArgument(scope_w, i) != null) continue;
                int defnum = i - firstDefaultArgIdx;
                if (defnum >= 0) {
                    PArguments.setArgument(scope_w, i, defaults[defnum]);
                    continue;
                }
                missingNames[missingCnt++] = signature.getParameterIds()[i];
            }
            if (missingProfile.profile(inliningTarget, missingCnt > 0)) {
                throw FillDefaultsNode.raiseMissing(inliningTarget, callable, missingNames, missingCnt, PythonUtils.toTruffleStringUncached("positional"), raise, signature);
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    protected static abstract class LazyFillKwDefaultsNode
    extends FillBaseNode {
        protected LazyFillKwDefaultsNode() {
        }

        public final FillKwDefaultsNode get(Node inliningTarget) {
            return this.execute(inliningTarget);
        }

        protected abstract FillKwDefaultsNode execute(Node var1);

        @Specialization
        static FillKwDefaultsNode doIt(@Cached(inline=false) FillKwDefaultsNode node) {
            return node;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    protected static abstract class FillKwDefaultsNode
    extends FillBaseNode {
        protected FillKwDefaultsNode() {
        }

        public abstract void execute(Object var1, Object[] var2, Signature var3, PKeyword[] var4, int var5, int var6);

        @Specialization(guards={"co_argcount == cachedArgcount", "co_kwonlyargcount == cachedKwOnlyArgcount", "checkIterations(co_argcount, co_kwonlyargcount)"}, limit="2")
        @ExplodeLoop
        static void doCached(Object callable, Object[] scope_w, Signature signature, PKeyword[] kwdefaults, int co_argcount, int co_kwonlyargcount, @Bind Node inliningTarget, @Cached.Exclusive @Cached PRaiseNode raise, @Cached.Exclusive @Cached FindKwDefaultNode findKwDefaultNode, @Cached(value="co_argcount") int cachedArgcount, @Cached(value="co_kwonlyargcount") int cachedKwOnlyArgcount, @Cached.Exclusive @Cached InlinedConditionProfile missingProfile) {
            TruffleString[] missingNames = new TruffleString[cachedKwOnlyArgcount];
            int missingCnt = 0;
            for (int i = cachedArgcount; i < cachedArgcount + cachedKwOnlyArgcount; ++i) {
                if (PArguments.getArgument(scope_w, i) != null) continue;
                TruffleString kwname = signature.getKeywordNames()[i - cachedArgcount];
                PKeyword kwdefault = findKwDefaultNode.execute(inliningTarget, kwdefaults, kwname);
                if (kwdefault != null) {
                    PArguments.setArgument(scope_w, i, kwdefault.getValue());
                    continue;
                }
                missingNames[missingCnt++] = kwname;
            }
            if (missingProfile.profile(inliningTarget, missingCnt > 0)) {
                throw FillKwDefaultsNode.raiseMissing(inliningTarget, callable, missingNames, missingCnt, PythonUtils.toTruffleStringUncached("keyword-only"), raise, signature);
            }
        }

        @Specialization(replaces={"doCached"})
        static void doUncached(Object callable, Object[] scope_w, Signature signature, PKeyword[] kwdefaults, int co_argcount, int co_kwonlyargcount, @Bind Node inliningTarget, @Cached.Exclusive @Cached PRaiseNode raise, @Cached.Exclusive @Cached FindKwDefaultNode findKwDefaultNode, @Cached.Exclusive @Cached InlinedConditionProfile missingProfile) {
            TruffleString[] missingNames = new TruffleString[co_kwonlyargcount];
            int missingCnt = 0;
            for (int i = co_argcount; i < co_argcount + co_kwonlyargcount; ++i) {
                if (PArguments.getArgument(scope_w, i) != null) continue;
                TruffleString kwname = signature.getKeywordNames()[i - co_argcount];
                PKeyword kwdefault = findKwDefaultNode.execute(inliningTarget, kwdefaults, kwname);
                if (kwdefault != null) {
                    PArguments.setArgument(scope_w, i, kwdefault.getValue());
                    continue;
                }
                missingNames[missingCnt++] = kwname;
            }
            if (missingProfile.profile(inliningTarget, missingCnt > 0)) {
                throw FillKwDefaultsNode.raiseMissing(inliningTarget, callable, missingNames, missingCnt, PythonUtils.toTruffleStringUncached("keyword-only"), raise, signature);
            }
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PythonOptions.class})
    static abstract class CheckEnclosingTypeNode
    extends Node {
        CheckEnclosingTypeNode() {
        }

        public abstract void execute(Node var1, Signature var2, Object var3, Object[] var4);

        @Specialization(guards={"checkEnclosingType(signature, callable)"})
        static void doEnclosingTypeCheck(Node inliningTarget, Signature signature, PBuiltinFunction callable, Object[] scope_w, @Bind(value="getSelf(scope_w)") Object self, @Cached GetClassNode getClassNode, @Cached(inline=false) IsSubtypeNode isSubtypeMRONode, @Cached PRaiseNode raiseNode) {
            if (!isSubtypeMRONode.execute(getClassNode.execute(inliningTarget, self), callable.getEnclosingType())) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.DESCR_S_FOR_P_OBJ_DOESNT_APPLY_TO_P, callable.getName(), callable.getEnclosingType(), self);
            }
        }

        @Specialization(guards={"!checkEnclosingType(signature, callable)"})
        static void doNothing(Signature signature, Object callable, Object[] scope_w) {
        }

        static boolean checkEnclosingType(Signature signature, Object function) {
            return signature.checkEnclosingType() && function instanceof PBuiltinFunction && ((PBuiltinFunction)function).getEnclosingType() != null;
        }

        static Object getSelf(Object[] scope_w) {
            return PArguments.getArgument(scope_w, 0);
        }
    }

    private static final class QualnameGetter
    extends Getter<TruffleString> {
        private static final QualnameGetter INSTANCE = new QualnameGetter();

        private QualnameGetter() {
        }

        @Override
        public TruffleString fromPFunction(PFunction fun) {
            return fun.getQualname();
        }

        @Override
        public TruffleString fromPBuiltinFunction(PBuiltinFunction fun) {
            return fun.getQualname();
        }
    }

    private static abstract class Getter<T> {
        private Getter() {
        }

        public abstract T fromPFunction(PFunction var1);

        public abstract T fromPBuiltinFunction(PBuiltinFunction var1);
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    protected static abstract class FindKwDefaultNode
    extends Node {
        protected FindKwDefaultNode() {
        }

        public abstract PKeyword execute(Node var1, PKeyword[] var2, TruffleString var3);

        @Idempotent
        protected final boolean isSingleContext() {
            return PythonLanguage.get(this).isSingleContext();
        }

        @Idempotent
        protected static boolean kwIsCorrect(PKeyword[] kwdefaults, TruffleString kwname, PKeyword result) {
            return FindKwDefaultNode.doUncached(kwdefaults, kwname, TruffleString.EqualNode.getUncached()) == result;
        }

        protected static TruffleString.EqualNode getUncachedEqualNode() {
            return TruffleString.EqualNode.getUncached();
        }

        @Specialization(guards={"kwname == cachedKwName", "kwdefaults == cachedKwdefaults", "isSingleContext()", "kwIsCorrect(cachedKwdefaults, cachedKwName, result)"}, limit="1")
        PKeyword cachedSingle(PKeyword[] kwdefaults, TruffleString kwname, @Cached(value="kwname") TruffleString cachedKwName, @Cached(value="kwdefaults", weak=true, dimensions=0) PKeyword[] cachedKwdefaults, @Cached(value="doUncached(kwdefaults, kwname, getUncachedEqualNode())", weak=true) PKeyword result) {
            return result;
        }

        @Specialization(guards={"kwdefaults.length == cachedLength", "cachedLength < 32"}, replaces={"cachedSingle"}, limit="3")
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL_UNTIL_RETURN)
        static PKeyword doCached(PKeyword[] kwdefaults, TruffleString kwname, @Cached(value="kwdefaults.length") int cachedLength, @Cached.Shared @Cached(inline=false) TruffleString.EqualNode equalNode) {
            for (int j = 0; j < cachedLength; ++j) {
                if (!equalNode.execute((AbstractTruffleString)kwdefaults[j].getName(), (AbstractTruffleString)kwname, PythonUtils.TS_ENCODING)) continue;
                return kwdefaults[j];
            }
            return null;
        }

        @Specialization(replaces={"doCached"})
        static PKeyword doUncached(PKeyword[] kwdefaults, TruffleString kwname, @Cached.Shared @Cached(inline=false) TruffleString.EqualNode equalNode) {
            for (int j = 0; j < kwdefaults.length; ++j) {
                if (!equalNode.execute((AbstractTruffleString)kwdefaults[j].getName(), (AbstractTruffleString)kwname, PythonUtils.TS_ENCODING)) continue;
                return kwdefaults[j];
            }
            return null;
        }
    }

    protected static abstract class FillBaseNode
    extends PNodeWithContext {
        protected FillBaseNode() {
        }

        protected static PException raiseMissing(Node inliningTarget, Object callable, TruffleString[] missingNames, int missingCnt, TruffleString type, PRaiseNode raise, Signature signature) {
            throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.MISSING_D_REQUIRED_S_ARGUMENT_S_S, CreateArgumentsNode.getName(callable, signature), missingCnt, type, missingCnt == 1 ? "" : "s", missingCnt == 1 ? missingNames[0] : FillBaseNode.joinArgNames(missingNames, missingCnt));
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString joinArgNames(TruffleString[] missingNames, int missingCnt) {
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            sb.appendStringUncached(missingNames[0]);
            if (missingCnt == 2) {
                sb.appendStringUncached(PythonUtils.toTruffleStringUncached("' and '"));
            } else {
                TruffleString delim = PythonUtils.toTruffleStringUncached("', '");
                for (int i = 1; i < missingCnt - 1; ++i) {
                    sb.appendStringUncached(delim);
                    sb.appendStringUncached(missingNames[i]);
                }
                sb.appendStringUncached(PythonUtils.toTruffleStringUncached("', and '"));
            }
            sb.appendStringUncached(missingNames[missingCnt - 1]);
            return sb.toStringUncached();
        }

        protected static boolean checkIterations(int input_argcount, int co_argcount) {
            return co_argcount - input_argcount < 32;
        }
    }
}

