/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.traceback;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.traceback.LazyTraceback;
import com.oracle.graal.python.builtins.objects.traceback.MaterializeLazyTracebackNodeGen;
import com.oracle.graal.python.builtins.objects.traceback.PTraceback;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
@GenerateCached
public abstract class MaterializeLazyTracebackNode
extends Node {
    public abstract PTraceback execute(Node var1, LazyTraceback var2);

    public final PTraceback executeCached(LazyTraceback tb) {
        return this.execute(this, tb);
    }

    public static PTraceback executeUncached(LazyTraceback tb) {
        return MaterializeLazyTracebackNodeGen.getUncached().execute(null, tb);
    }

    @Specialization(guards={"tb.isMaterialized()"})
    static PTraceback getMaterialized(LazyTraceback tb) {
        return tb.getTraceback();
    }

    @Fallback
    static PTraceback getTraceback(Node inliningTarget, LazyTraceback tb, @Cached InlinedLoopConditionProfile loopConditionProfile) {
        PTraceback newTraceback = null;
        LazyTraceback current = tb;
        do {
            if (current.isEmptySegment()) continue;
            if (current.isMaterialized()) {
                newTraceback = current.getTraceback();
                break;
            }
            newTraceback = PFactory.createTraceback(PythonLanguage.get(inliningTarget), current);
            break;
        } while (loopConditionProfile.profile(inliningTarget, (current = current.getNextChain()) != null));
        tb.setTraceback(newTraceback);
        return newTraceback;
    }

    @NeverDefault
    public static MaterializeLazyTracebackNode create() {
        return MaterializeLazyTracebackNodeGen.create();
    }
}

