/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.ordereddict;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.ordereddict.OrderedDictIteratorBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.ordereddict.OrderedDictIteratorBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.ordereddict.POrderedDictIterator;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.POrderedDictIterator})
public class OrderedDictIteratorBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = OrderedDictIteratorBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return OrderedDictIteratorBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        ReduceNode() {
        }

        @Specialization
        static Object reduce(VirtualFrame frame, POrderedDictIterator self, @Bind Node inliningTarget, @Cached PyObjectGetAttr getAttr, @Bind PythonLanguage language, @Cached ListNodes.ConstructListNode constructListNode) {
            PythonContext context = PythonContext.get(inliningTarget);
            Object iterBuiltin = getAttr.execute((Frame)frame, inliningTarget, context.getBuiltins(), BuiltinNames.T_ITER);
            POrderedDictIterator copy = PFactory.createOrderedDictIterator(language, self.dict, self.type, self.reversed);
            copy.current = self.current;
            PList list = constructListNode.execute((Frame)frame, copy);
            PTuple args = PFactory.createTuple(language, new Object[]{list});
            return PFactory.createTuple(language, new Object[]{iterBuiltin, args});
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    static abstract class NextNode
    extends TpSlotIterNext.TpIterNextBuiltin {
        NextNode() {
        }

        @Specialization
        static Object next(VirtualFrame frame, POrderedDictIterator self, @Bind Node inliningTarget, @Cached PRaiseNode raiseNode, @Cached HashingStorageNodes.HashingStorageGetItemWithHash getItem) {
            Object result;
            if (self.current == null) {
                throw NextNode.iteratorExhausted();
            }
            if (self.size != self.dict.nodes.size()) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.RuntimeError, ErrorMessages.CHANGED_SIZE_DURING_ITERATION, "OrderedDict");
            }
            Object key = self.current.key;
            if (self.type == POrderedDictIterator.IteratorType.KEYS) {
                result = key;
            } else {
                Object value = getItem.execute((Frame)frame, inliningTarget, self.dict.getDictStorage(), key, self.current.hash);
                if (value == null) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.KeyError, new Object[]{key});
                }
                result = self.type == POrderedDictIterator.IteratorType.VALUES ? value : PFactory.createTuple(PythonLanguage.get(inliningTarget), new Object[]{key, value});
            }
            self.current = !self.reversed ? self.current.next : self.current.prev;
            return result;
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        IterNode() {
        }

        @Specialization
        static Object iter(POrderedDictIterator self) {
            return self;
        }
    }
}

