/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ItertoolsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.itertools.DropwhileBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.itertools.DropwhileBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.itertools.PDropwhile;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaBooleanNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PDropwhile})
public final class DropwhileBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = DropwhileBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return DropwhileBuiltinsFactory.getFactories();
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object setState(PDropwhile self, Object state, @Bind Node inliningTarget, @Cached CastToJavaBooleanNode castToBoolean, @Cached PRaiseNode raiseNode) {
            ItertoolsModuleBuiltins.warnPickleDeprecated();
            try {
                self.setDoneDropping(castToBoolean.execute(inliningTarget, state));
            }
            catch (CannotCastException e) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_ARGS, SpecialMethodNames.T___SETSTATE__);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(PDropwhile self, @Bind Node inliningTarget, @Cached GetClassNode getClassNode, @Bind PythonLanguage language) {
            ItertoolsModuleBuiltins.warnPickleDeprecated();
            Object type = getClassNode.execute(inliningTarget, self);
            PTuple tuple = PFactory.createTuple(language, new Object[]{self.getPredicate(), self.getIterable()});
            return PFactory.createTuple(language, new Object[]{type, tuple, self.isDoneDropping()});
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends TpSlotIterNext.TpIterNextBuiltin {
        @Specialization
        static Object next(VirtualFrame frame, PDropwhile self, @Bind Node inliningTarget, @Cached TpSlots.GetObjectSlotsNode getSlots, @Cached TpSlotIterNext.CallSlotTpIterNextNode callIterNext, @Cached CallNode callNode, @Cached PyObjectIsTrueNode isTrue, @Cached InlinedBranchProfile doneDroppingProfile, @Cached InlinedLoopConditionProfile loopProfile) {
            Object iterable = self.getIterable();
            TpSlot iterNext = getSlots.execute(inliningTarget, iterable).tp_iternext();
            Object result = null;
            do {
                Object item = callIterNext.execute(frame, inliningTarget, iterNext, iterable);
                if (self.isDoneDropping()) {
                    result = item;
                    continue;
                }
                if (isTrue.execute((Frame)frame, callNode.execute((Frame)frame, self.getPredicate(), item))) continue;
                doneDroppingProfile.enter(inliningTarget);
                self.setDoneDropping(true);
                result = item;
            } while (loopProfile.profile(inliningTarget, result == null));
            return result;
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PDropwhile self) {
            return self;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="dropwhile", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class DropwhileNode
    extends PythonVarargsBuiltinNode {
        @Specialization
        static PDropwhile construct(VirtualFrame frame, Object cls, Object[] args, PKeyword[] keywords, @Bind Node inliningTarget, @Cached(inline=false) TypeNodes.HasObjectInitNode hasObjectInitNode, @Cached PyObjectGetIter getIter, @Cached TypeNodes.IsTypeNode isTypeNode, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached PRaiseNode raiseNode) {
            if (!isTypeNode.execute(inliningTarget, cls)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_TYPE_OBJ, "'cls'", cls);
            }
            if (keywords.length > 0 && hasObjectInitNode.executeCached(cls)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.S_TAKES_NO_KEYWORD_ARGS, "dropwhile()");
            }
            if (args.length != 2) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.S_EXPECTED_D_ARGS, "dropwhile", 2);
            }
            Object predicate = args[0];
            Object iterable = args[1];
            PDropwhile self = PFactory.createDropwhile(language, cls, getInstanceShape.execute(cls));
            self.setPredicate(predicate);
            self.setIterable(getIter.execute((Frame)frame, inliningTarget, iterable));
            self.setDoneDropping(false);
            return self;
        }
    }
}

