/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ItertoolsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.itertools.ChainBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.itertools.ChainBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.itertools.PChain;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.lib.IteratorExhausted;
import com.oracle.graal.python.lib.PyIterCheckNode;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PChain})
public final class ChainBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = ChainBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ChainBuiltinsFactory.getFactories();
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object classGetItem(Object cls, Object key, @Bind PythonLanguage language) {
            return PFactory.createGenericAlias(language, cls, key);
        }
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object setState(VirtualFrame frame, PChain self, Object state, @Bind Node inliningTarget, @Cached TupleBuiltins.LenNode lenNode, @Cached TupleBuiltins.GetItemNode getItemNode, @Cached InlinedBranchProfile len2Profile, @Cached PyIterCheckNode iterCheckNode, @Cached PRaiseNode raiseNode) {
            ItertoolsModuleBuiltins.warnPickleDeprecated();
            if (!(state instanceof PTuple)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_A, "state", "a length 1 or 2 tuple");
            }
            int len = (Integer)lenNode.execute(frame, state);
            if (len < 1 || len > 2) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_A, "state", "a length 1 or 2 tuple");
            }
            Object source = getItemNode.execute(frame, state, 0);
            SetStateNode.checkIterator(inliningTarget, iterCheckNode, source, raiseNode);
            self.setSource(source);
            if (len == 2) {
                len2Profile.enter(inliningTarget);
                Object active = getItemNode.execute(frame, state, 1);
                SetStateNode.checkIterator(inliningTarget, iterCheckNode, active, raiseNode);
                self.setActive(active);
            }
            return PNone.NONE;
        }

        private static void checkIterator(Node inliningTarget, PyIterCheckNode iterCheckNode, Object obj, PRaiseNode raiseNode) throws PException {
            if (!iterCheckNode.execute(inliningTarget, obj)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.ARGUMENTS_MUST_BE_ITERATORS);
            }
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reducePos(PChain self, @Bind Node inliningTarget, @Cached GetClassNode getClass, @Cached InlinedConditionProfile hasSourceProfile, @Cached InlinedConditionProfile hasActiveProfile, @Bind PythonLanguage language) {
            ItertoolsModuleBuiltins.warnPickleDeprecated();
            Object type = getClass.execute(inliningTarget, self);
            PTuple empty = PFactory.createEmptyTuple(language);
            if (hasSourceProfile.profile(inliningTarget, self.getSource() != PNone.NONE)) {
                if (hasActiveProfile.profile(inliningTarget, self.getActive() != PNone.NONE)) {
                    PTuple tuple = PFactory.createTuple(language, new Object[]{self.getSource(), self.getActive()});
                    return PFactory.createTuple(language, new Object[]{type, empty, tuple});
                }
                PTuple tuple = PFactory.createTuple(language, new Object[]{self.getSource()});
                return PFactory.createTuple(language, new Object[]{type, empty, tuple});
            }
            return PFactory.createTuple(language, new Object[]{type, empty});
        }
    }

    @Builtin(name="from_iterable", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class FromIterNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object fromIter(VirtualFrame frame, Object cls, Object arg, @Bind Node inliningTarget, @Cached PyObjectGetIter getIter, @Bind PythonLanguage language) {
            PChain instance = PFactory.createChain(language);
            instance.setSource(getIter.execute((Frame)frame, inliningTarget, arg));
            instance.setActive(PNone.NONE);
            return instance;
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends TpSlotIterNext.TpIterNextBuiltin {
        @Specialization
        static Object next(VirtualFrame frame, PChain self, @Bind Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached PyIterNextNode nextNode, @Cached InlinedBranchProfile nextExceptionProfile, @Cached InlinedLoopConditionProfile loopProfile) {
            while (loopProfile.profile(inliningTarget, self.getSource() != PNone.NONE)) {
                if (self.getActive() == PNone.NONE) {
                    try {
                        Object next;
                        try {
                            next = nextNode.execute((Frame)frame, inliningTarget, self.getSource());
                        }
                        catch (IteratorExhausted e) {
                            self.setSource(PNone.NONE);
                            throw e;
                        }
                        catch (PException e) {
                            nextExceptionProfile.enter(inliningTarget);
                            self.setSource(PNone.NONE);
                            throw e;
                        }
                        Object iter = getIter.execute((Frame)frame, inliningTarget, next);
                        self.setActive(iter);
                    }
                    catch (PException e) {
                        nextExceptionProfile.enter(inliningTarget);
                        self.setSource(PNone.NONE);
                        throw e;
                    }
                }
                try {
                    return nextNode.execute((Frame)frame, inliningTarget, self.getActive());
                }
                catch (IteratorExhausted e) {
                    self.setActive(PNone.NONE);
                }
            }
            throw NextNode.iteratorExhausted();
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PChain self) {
            return self;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="chain", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class ChainNode
    extends PythonVarargsBuiltinNode {
        @Specialization
        static PChain construct(VirtualFrame frame, Object cls, Object[] args, PKeyword[] keywords, @Bind Node inliningTarget, @Cached(inline=false) TypeNodes.HasObjectInitNode hasObjectInitNode, @Cached PyObjectGetIter getIter, @Cached TypeNodes.IsTypeNode isTypeNode, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached PRaiseNode raiseNode) {
            if (!isTypeNode.execute(inliningTarget, cls)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_TYPE_OBJ, "'cls'", cls);
            }
            if (keywords.length > 0 && hasObjectInitNode.executeCached(cls)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.S_TAKES_NO_KEYWORD_ARGS, "chain()");
            }
            PChain self = PFactory.createChain(language, cls, getInstanceShape.execute(cls));
            self.setSource(getIter.execute((Frame)frame, inliningTarget, PFactory.createList(language, args)));
            self.setActive(PNone.NONE);
            return self;
        }
    }
}

