/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.internal.OracleBfile;
import oracle.jdbc.internal.OracleBlob;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class OracleBlobInputStream
extends OracleBufferedStream {
    long lobOffset;
    OracleBlob blob;
    OracleBfile bfile;
    boolean isStreamForBlob;
    long markedByte;
    boolean endOfStream;
    long maxPosition;
    boolean internalBlob;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;

    public OracleBlobInputStream(OracleBlob blob, int chunkSize) throws SQLException {
        this(blob, chunkSize, 1L, false);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$10, null, blob, chunkSize);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$10, null);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$10, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleBlobInputStream(OracleBlob blob, int chunkSize, long beginOffset) throws SQLException {
        this(blob, chunkSize, beginOffset, false);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$11, null, blob, chunkSize, beginOffset);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$11, null);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$11, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleBlobInputStream(OracleBlob blob, int chunkSize, boolean isInternal) throws SQLException {
        this(blob, chunkSize, 1L, isInternal);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$12, null, blob, chunkSize, isInternal);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$12, null);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$12, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleBlobInputStream(OracleBlob blob, int chunkSize, long beginOffset, boolean isInternal) throws SQLException {
        super(chunkSize);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$13, null, blob, chunkSize, beginOffset, isInternal);
            }
            this.endOfStream = false;
            this.maxPosition = Long.MAX_VALUE;
            this.internalBlob = false;
            if (blob == null || chunkSize <= 0 || beginOffset < 1L) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Illegal Arguments");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$13, null, illegalArgumentException);
                }
                throw illegalArgumentException;
            }
            this.isStreamForBlob = true;
            this.blob = blob;
            this.bfile = null;
            this.markedByte = -1L;
            this.lobOffset = beginOffset;
            this.internalBlob = isInternal;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$13, null);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$13, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$13, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleBlobInputStream(OracleBlob blob, int chunkSize, long beginOffset, long length, boolean isInternal) throws SQLException {
        this(blob, chunkSize, beginOffset, isInternal);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$14, null, blob, chunkSize, beginOffset, length, isInternal);
            }
            this.maxPosition = beginOffset + length;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$14, null);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$14, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$14, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleBlobInputStream(OracleBlob blob, int chunkSize, long beginOffset, long length) throws SQLException {
        this(blob, chunkSize, beginOffset, false);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$15, null, blob, chunkSize, beginOffset, length);
            }
            this.maxPosition = beginOffset + length;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$15, null);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$15, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$15, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleBlobInputStream(OracleBfile bfile, int chunkSize) throws SQLException {
        this(bfile, chunkSize, 1L);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$16, null, bfile, chunkSize);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$16, null);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$16, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$16, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleBlobInputStream(OracleBfile bfile, int chunkSize, long beginOffset) throws SQLException {
        super(chunkSize);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$17, null, bfile, chunkSize, beginOffset);
            }
            this.endOfStream = false;
            this.maxPosition = Long.MAX_VALUE;
            this.internalBlob = false;
            if (bfile == null || chunkSize <= 0 || beginOffset < 1L) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Illegal Arguments");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$17, null, illegalArgumentException);
                }
                throw illegalArgumentException;
            }
            this.isStreamForBlob = false;
            this.blob = null;
            this.bfile = bfile;
            this.markedByte = -1L;
            this.lobOffset = beginOffset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$17, null);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$17, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$17, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean needBytes(int n2) throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$0, this, n2);
            }
            this.ensureOpen();
            if (this.pos >= this.count) {
                block14: {
                    if (!this.endOfStream) {
                        boolean bl2;
                        block15: {
                            boolean bl3;
                            void howMany;
                            if (howMany > this.currentBufferSize || howMany == false) {
                                this.currentBufferSize = Math.max((int)howMany, this.initialBufferSize);
                                this.resizableBuffer = new byte[this.currentBufferSize];
                            }
                            try {
                                int size = (long)this.currentBufferSize < this.maxPosition - this.lobOffset ? this.currentBufferSize : (int)(this.maxPosition - this.lobOffset);
                                this.count = this.isStreamForBlob ? this.blob.getBytes(this.lobOffset, size, this.resizableBuffer) : this.bfile.getBytes(this.lobOffset, size, this.resizableBuffer);
                                if (this.count < this.currentBufferSize) {
                                    this.endOfStream = true;
                                }
                                if (this.count <= 0) break block14;
                                this.pos = 0;
                                this.lobOffset += (long)this.count;
                                if (this.lobOffset > this.maxPosition) {
                                    this.endOfStream = true;
                                }
                                bl2 = bl3 = true;
                                if (!bl) break block15;
                            }
                            catch (SQLException e2) {
                                IOException iOException = (IOException)DatabaseError.createIOException(e2).fillInStackTrace();
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$0, this, iOException);
                                }
                                throw iOException;
                            }
                            ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$0, this, bl3);
                            ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$0, this, null);
                        }
                        return bl2;
                    }
                }
                boolean bl4 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$0, this, bl4);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$0, this, null);
                }
                return false;
            }
            boolean bl5 = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$0, this, bl5);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$0, this, null);
            }
            return true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    void ensureOpen() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$1, this, new Object[0]);
            }
            try {
                if (this.closed) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$1, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            catch (SQLException e2) {
                IOException iOException = (IOException)DatabaseError.createIOException(e2).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$1, this, iOException);
                }
                throw iOException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean markSupported() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$2, this, new Object[0]);
            }
            boolean bl2 = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$2, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$2, this, null);
            }
            return true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void mark(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void readLimit;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$3, this, n2);
            }
            if (readLimit < 0) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Read-ahead limit < 0");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$3, this, illegalArgumentException);
                }
                throw illegalArgumentException;
            }
            this.markedByte = this.lobOffset - (long)this.count + (long)this.pos;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    public void markInternal(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$4, this, n2);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void reset() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$5, this, new Object[0]);
            }
            this.ensureOpen();
            if (this.markedByte < 0L) {
                IOException iOException = new IOException("Mark invalid or stream not marked.");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$5, this, iOException);
                }
                throw iOException;
            }
            this.lobOffset = this.markedByte;
            this.pos = this.count;
            this.endOfStream = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void close() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$6, this, new Object[0]);
            }
            if (this.closed) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$6, this);
                    ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$6, this, null);
                }
                return;
            }
            try {
                if (this.blob != null && this.internalBlob) {
                    this.blob.free();
                    this.internalBlob = false;
                }
            }
            catch (SQLException se) {
                try {
                    IOException iOException = (IOException)DatabaseError.createIOException(se).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$6, this, iOException);
                    }
                    throw iOException;
                }
                catch (Throwable throwable) {
                    super.close();
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$6, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            super.close();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$6, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long skip(long l2) throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void n2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$7, this, l2);
            }
            this.ensureOpen();
            long start = 0L;
            if ((long)(this.count - this.pos) >= n2) {
                this.pos = (int)((long)this.pos + n2);
                start += n2;
            } else {
                start += (long)(this.count - this.pos);
                this.pos = this.count;
                try {
                    long remainLen = 0L;
                    remainLen = this.isStreamForBlob ? this.blob.length() - this.lobOffset + 1L : this.bfile.length() - this.lobOffset + 1L;
                    if (remainLen >= n2 - start) {
                        this.lobOffset += n2 - start;
                        start += n2 - start;
                    } else {
                        this.lobOffset += remainLen;
                        start += remainLen;
                    }
                }
                catch (SQLException e2) {
                    IOException iOException = (IOException)DatabaseError.createIOException(e2).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$7, this, iOException);
                    }
                    throw iOException;
                }
            }
            long l3 = start;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$7, this, l3);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$7, this, null);
            }
            return l3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int available() throws IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            int prefetchSize;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$8, this, new Object[0]);
            }
            this.ensureOpen();
            if (this.isStreamForBlob && this.blob.isActivePrefetch() && (prefetchSize = this.blob.getPrefetchedDataSize()) > 0) {
                if (this.lobOffset == 1L) {
                    int n2 = prefetchSize;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$8, this, n2);
                        ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$8, this, null);
                    }
                    return n2;
                }
                if (this.lobOffset - 1L < (long)prefetchSize) {
                    int n3 = prefetchSize - this.pos;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$8, this, n3);
                        ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$8, this, null);
                    }
                    return n3;
                }
            }
            int n4 = super.available();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$8, this, n4);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$8, this, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$9, this, new Object[0]);
            }
            OracleConnection _conn = null;
            try {
                if (this.isStreamForBlob && this.blob != null) {
                    _conn = this.blob.getInternalConnection();
                } else if (!this.isStreamForBlob && this.bfile != null) {
                    _conn = this.bfile.getInternalConnection();
                }
            }
            catch (Exception exc) {
                _conn = null;
            }
            OracleConnection oracleConnection = _conn;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$9, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$9, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleBlobInputStream.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$17 = OracleBlobInputStream.class.getDeclaredConstructor(OracleBfile.class, Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleBlobInputStream.class.getDeclaredConstructor(OracleBfile.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleBlobInputStream.class.getDeclaredConstructor(OracleBlob.class, Integer.TYPE, Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleBlobInputStream.class.getDeclaredConstructor(OracleBlob.class, Integer.TYPE, Long.TYPE, Long.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleBlobInputStream.class.getDeclaredConstructor(OracleBlob.class, Integer.TYPE, Long.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleBlobInputStream.class.getDeclaredConstructor(OracleBlob.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleBlobInputStream.class.getDeclaredConstructor(OracleBlob.class, Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleBlobInputStream.class.getDeclaredConstructor(OracleBlob.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleBlobInputStream.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleBlobInputStream.class.getDeclaredMethod("available", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleBlobInputStream.class.getDeclaredMethod("skip", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleBlobInputStream.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleBlobInputStream.class.getDeclaredMethod("reset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleBlobInputStream.class.getDeclaredMethod("markInternal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleBlobInputStream.class.getDeclaredMethod("mark", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleBlobInputStream.class.getDeclaredMethod("markSupported", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleBlobInputStream.class.getDeclaredMethod("ensureOpen", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleBlobInputStream.class.getDeclaredMethod("needBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

