/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractDatabaseObject;
import schemacrawler.crawl.SchemaCrawler;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.DataTypeType;
import schemacrawler.schema.JavaSqlType;
import schemacrawler.schema.Schema;
import schemacrawler.schema.SearchableType;
import schemacrawler.schemacrawler.Identifiers;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

final class MutableColumnDataType
extends AbstractDatabaseObject
implements ColumnDataType {
    private static final long serialVersionUID = 3688503281676530744L;
    private static final Logger LOGGER = Logger.getLogger(SchemaCrawler.class.getName());
    private final DataTypeType type;
    private boolean autoIncrementable;
    private ColumnDataType baseType;
    private boolean caseSensitive;
    private String createParameters;
    private boolean fixedPrecisionScale;
    private transient String fullName;
    private JavaSqlType javaSqlType;
    private Class<?> javaSqlTypeMappedClass;
    private String literalPrefix;
    private String literalSuffix;
    private String localizedTypeName;
    private int maximumScale;
    private int minimumScale;
    private boolean nullable;
    private int numPrecisionRadix;
    private long precision;
    private SearchableType searchable;
    private boolean unsigned;
    private List<String> enumValues;

    MutableColumnDataType(ColumnDataType columnDataType) {
        this(columnDataType.getSchema(), columnDataType.getName(), (DataTypeType)((Object)columnDataType.getType()));
        this.autoIncrementable = columnDataType.isAutoIncrementable();
        this.baseType = columnDataType.getBaseType();
        this.caseSensitive = columnDataType.isCaseSensitive();
        this.createParameters = columnDataType.getCreateParameters();
        this.fixedPrecisionScale = columnDataType.isFixedPrecisionScale();
        this.javaSqlType = columnDataType.getJavaSqlType();
        this.javaSqlTypeMappedClass = columnDataType.getTypeMappedClass();
        this.literalPrefix = columnDataType.getLiteralPrefix();
        this.literalSuffix = columnDataType.getLiteralSuffix();
        this.localizedTypeName = columnDataType.getLocalTypeName();
        this.maximumScale = columnDataType.getMaximumScale();
        this.minimumScale = columnDataType.getMinimumScale();
        this.nullable = columnDataType.isNullable();
        this.numPrecisionRadix = columnDataType.getNumPrecisionRadix();
        this.precision = columnDataType.getPrecision();
        this.searchable = columnDataType.getSearchable();
        this.unsigned = columnDataType.isUnsigned();
        this.enumValues = new ArrayList<String>(columnDataType.getEnumValues());
    }

    MutableColumnDataType(Schema schema, String name, DataTypeType type) {
        super(schema, name);
        Objects.requireNonNull(type, "No type provided");
        this.type = type;
        this.javaSqlType = JavaSqlType.UNKNOWN;
        this.javaSqlTypeMappedClass = Object.class;
        this.searchable = SearchableType.unknown;
        this.literalPrefix = "";
        this.literalSuffix = "";
        this.createParameters = "";
        this.localizedTypeName = "";
        this.enumValues = new ArrayList<String>();
    }

    @Override
    public ColumnDataType getBaseType() {
        return this.baseType;
    }

    @Override
    public String getCreateParameters() {
        return this.createParameters;
    }

    @Override
    public List<String> getEnumValues() {
        return new ArrayList<String>(this.enumValues);
    }

    @Override
    public String getFullName() {
        this.buildFullName();
        return this.fullName;
    }

    @Override
    public JavaSqlType getJavaSqlType() {
        return this.javaSqlType;
    }

    @Override
    public String getLiteralPrefix() {
        return this.literalPrefix;
    }

    @Override
    public String getLiteralSuffix() {
        return this.literalSuffix;
    }

    @Override
    public String getLocalTypeName() {
        return this.localizedTypeName;
    }

    @Override
    public int getMaximumScale() {
        return this.maximumScale;
    }

    @Override
    public int getMinimumScale() {
        return this.minimumScale;
    }

    @Override
    public int getNumPrecisionRadix() {
        return this.numPrecisionRadix;
    }

    @Override
    public long getPrecision() {
        return this.precision;
    }

    @Override
    public SearchableType getSearchable() {
        return this.searchable;
    }

    @Override
    public DataTypeType getType() {
        return this.type;
    }

    @Override
    public Class<?> getTypeMappedClass() {
        return this.javaSqlTypeMappedClass;
    }

    @Override
    public boolean isAutoIncrementable() {
        return this.autoIncrementable;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public boolean isEnumerated() {
        return !this.enumValues.isEmpty();
    }

    @Override
    public boolean isFixedPrecisionScale() {
        return this.fixedPrecisionScale;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public boolean isUnsigned() {
        return this.unsigned;
    }

    @Override
    public void withQuoting(Identifiers identifiers) {
        if (identifiers == null) {
            return;
        }
        this.buildFullName(identifiers);
    }

    void setAutoIncrementable(boolean autoIncrementable) {
        this.autoIncrementable = autoIncrementable;
    }

    void setBaseType(ColumnDataType baseType) {
        this.baseType = baseType;
    }

    void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    void setCreateParameters(String createParams) {
        this.createParameters = createParams;
    }

    void setEnumValues(List<String> enumValues) {
        this.enumValues = enumValues == null ? new ArrayList<String>() : new ArrayList<String>(enumValues);
    }

    void setFixedPrecisionScale(boolean fixedPrecisionScale) {
        this.fixedPrecisionScale = fixedPrecisionScale;
    }

    void setJavaSqlType(JavaSqlType javaSqlType) {
        this.javaSqlType = javaSqlType != null ? javaSqlType : JavaSqlType.UNKNOWN;
    }

    void setLiteralPrefix(String literalPrefix) {
        this.literalPrefix = literalPrefix;
    }

    void setLiteralSuffix(String literalSuffix) {
        this.literalSuffix = literalSuffix;
    }

    void setLocalTypeName(String localTypeName) {
        this.localizedTypeName = localTypeName;
    }

    void setMaximumScale(int maximumScale) {
        this.maximumScale = maximumScale;
    }

    void setMinimumScale(int minimumScale) {
        this.minimumScale = minimumScale;
    }

    void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    void setNumPrecisionRadix(int numPrecisionRadix) {
        this.numPrecisionRadix = numPrecisionRadix;
    }

    void setPrecision(long precision) {
        this.precision = precision;
    }

    void setSearchable(SearchableType searchable) {
        this.searchable = searchable;
    }

    void setTypeMappedClass(Class<?> mappedClass) {
        this.javaSqlTypeMappedClass = mappedClass != null ? mappedClass : Object.class;
    }

    void setTypeMappedClass(String mappedClassName) {
        if (!Utility.isBlank((String)mappedClassName)) {
            try {
                this.javaSqlTypeMappedClass = Class.forName(mappedClassName);
            }
            catch (ClassNotFoundException e) {
                LOGGER.log(Level.FINE, e, (Supplier<String>)new StringFormat("Could not load mapped class <%s>", new Object[]{mappedClassName}));
                this.javaSqlTypeMappedClass = Object.class;
            }
        } else {
            this.javaSqlTypeMappedClass = Object.class;
        }
    }

    void setUnsigned(boolean unsignedAttribute) {
        this.unsigned = unsignedAttribute;
    }

    private void buildFullName() {
        this.buildFullName(Identifiers.STANDARD);
    }

    private void buildFullName(Identifiers identifiers) {
        if (identifiers == null || this.fullName != null) {
            return;
        }
        Schema schema = this.getSchema();
        this.fullName = !Utility.isBlank((String)schema.getFullName()) ? identifiers.quoteFullName(this) : this.getName();
    }
}

