/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.js.api.ValueLibrary;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(value=JSDynamicObject.class)
public final class JSDynamicObjectGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private JSDynamicObjectGen() {
    }

    static {
        LibraryExport.register(JSDynamicObject.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports(), new ValueLibraryExports()});
    }

    @GeneratedBy(value=JSDynamicObject.class)
    public static class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, JSDynamicObject.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof JSDynamicObject);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof JSDynamicObject);
            return new Cached(receiver);
        }

        @GeneratedBy(value=JSDynamicObject.class)
        public static class Uncached
        extends InteropLibrary
        implements UnadoptableNode {
            private final Class<? extends JSDynamicObject> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((Object)((Object)((JSDynamicObject)((Object)receiver)))).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            @CompilerDirectives.TruffleBoundary
            public TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSDynamicObject arg0Value = (JSDynamicObject)((Object)arg0Value_);
                if (arg1Value instanceof JSDynamicObject) {
                    JSDynamicObject arg1Value_ = (JSDynamicObject)((Object)arg1Value);
                    return JSDynamicObject.IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                }
                return JSDynamicObject.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSDynamicObject)((Object)receiver)).identityHashCode();
            }
        }

        @GeneratedBy(value=JSDynamicObject.class)
        public static class Cached
        extends InteropLibrary {
            private final Class<? extends JSDynamicObject> receiverClass_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            protected Cached(Object receiver) {
                JSDynamicObject castReceiver = (JSDynamicObject)((Object)receiver);
                this.receiverClass_ = ((Object)((Object)castReceiver)).getClass();
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            private boolean fallbackGuard_(int state_0, JSDynamicObject arg0Value, Object arg1Value) {
                return (state_0 & 1) != 0 || !(arg1Value instanceof JSDynamicObject);
            }

            protected TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSDynamicObject arg0Value = (JSDynamicObject)((Object)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_));
                int state_0 = this.state_0_;
                if (state_0 != 0) {
                    if ((state_0 & 1) != 0 && arg1Value instanceof JSDynamicObject) {
                        JSDynamicObject arg1Value_ = (JSDynamicObject)((Object)arg1Value);
                        return JSDynamicObject.IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 2) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return JSDynamicObject.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private TriState executeAndSpecialize(JSDynamicObject arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg1Value instanceof JSDynamicObject) {
                    JSDynamicObject arg1Value_ = (JSDynamicObject)((Object)arg1Value);
                    this.state_0_ = state_0 |= 1;
                    return JSDynamicObject.IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                }
                this.state_0_ = state_0 |= 2;
                return JSDynamicObject.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSDynamicObject)((Object)CompilerDirectives.castExact((Object)receiver, this.receiverClass_))).identityHashCode();
            }
        }
    }

    @GeneratedBy(value=JSDynamicObject.class)
    public static class ValueLibraryExports
    extends LibraryExport<ValueLibrary> {
        private ValueLibraryExports() {
            super(ValueLibrary.class, JSDynamicObject.class, false, false, 0);
        }

        protected ValueLibrary createUncached(Object receiver) {
            assert (receiver instanceof JSDynamicObject);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected ValueLibrary createCached(Object receiver) {
            assert (receiver instanceof JSDynamicObject);
            return new Cached(receiver);
        }

        @GeneratedBy(value=JSDynamicObject.class)
        public static class Uncached
        extends ValueLibrary
        implements UnadoptableNode {
            private final Class<? extends JSDynamicObject> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((Object)((Object)((JSDynamicObject)((Object)receiver)))).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public TruffleString toString(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSDynamicObject arg0Value = (JSDynamicObject)((Object)arg0Value_);
                return JSDynamicObject.ToString.toString(arg0Value, JSToStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Number toNumber(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSDynamicObject arg0Value = (JSDynamicObject)((Object)arg0Value_);
                return JSDynamicObject.ToNumber.toNumber(arg0Value, JSToNumberNodeGen.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean toBoolean(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSDynamicObject arg0Value = (JSDynamicObject)((Object)arg0Value_);
                return JSDynamicObject.ToBoolean.toBoolean(arg0Value, JSToBooleanNode.getUncached());
            }
        }

        @GeneratedBy(value=JSDynamicObject.class)
        public static class Cached
        extends ValueLibrary {
            private final Class<? extends JSDynamicObject> receiverClass_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private JSToStringNode toString_toString_toStringNode_;
            @Node.Child
            private JSToNumberNode toNumber_toNumber_toNumberNode_;
            @Node.Child
            private JSToBooleanNode toBoolean_toBoolean_toBooleanNode_;

            protected Cached(Object receiver) {
                JSDynamicObject castReceiver = (JSDynamicObject)((Object)receiver);
                this.receiverClass_ = ((Object)((Object)castReceiver)).getClass();
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            @Override
            public TruffleString toString(Object arg0Value_) {
                JSToStringNode toStringNode__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (ValueLibraryExports.assertAdopted((Node)((Node)this)));
                JSDynamicObject arg0Value = (JSDynamicObject)((Object)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_));
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0 && (toStringNode__ = this.toString_toString_toStringNode_) != null) {
                    return JSDynamicObject.ToString.toString(arg0Value, toStringNode__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.toStringAndSpecialize(arg0Value);
            }

            private TruffleString toStringAndSpecialize(JSDynamicObject arg0Value) {
                int state_0 = this.state_0_;
                JSToStringNode toStringNode__ = (JSToStringNode)this.insert(JSToStringNode.create());
                Objects.requireNonNull(toStringNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.toString_toString_toStringNode_ = toStringNode__;
                this.state_0_ = state_0 |= 1;
                return JSDynamicObject.ToString.toString(arg0Value, toStringNode__);
            }

            @Override
            public Number toNumber(Object arg0Value_) {
                JSToNumberNode toNumberNode__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (ValueLibraryExports.assertAdopted((Node)((Node)this)));
                JSDynamicObject arg0Value = (JSDynamicObject)((Object)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_));
                int state_0 = this.state_0_;
                if ((state_0 & 2) != 0 && (toNumberNode__ = this.toNumber_toNumber_toNumberNode_) != null) {
                    return JSDynamicObject.ToNumber.toNumber(arg0Value, toNumberNode__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.toNumberAndSpecialize(arg0Value);
            }

            private Number toNumberAndSpecialize(JSDynamicObject arg0Value) {
                int state_0 = this.state_0_;
                JSToNumberNode toNumberNode__ = (JSToNumberNode)this.insert(JSToNumberNode.create());
                Objects.requireNonNull(toNumberNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.toNumber_toNumber_toNumberNode_ = toNumberNode__;
                this.state_0_ = state_0 |= 2;
                return JSDynamicObject.ToNumber.toNumber(arg0Value, toNumberNode__);
            }

            @Override
            public boolean toBoolean(Object arg0Value_) {
                JSToBooleanNode toBooleanNode__;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (ValueLibraryExports.assertAdopted((Node)((Node)this)));
                JSDynamicObject arg0Value = (JSDynamicObject)((Object)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_));
                int state_0 = this.state_0_;
                if ((state_0 & 4) != 0 && (toBooleanNode__ = this.toBoolean_toBoolean_toBooleanNode_) != null) {
                    return JSDynamicObject.ToBoolean.toBoolean(arg0Value, toBooleanNode__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.toBooleanAndSpecialize(arg0Value);
            }

            private boolean toBooleanAndSpecialize(JSDynamicObject arg0Value) {
                int state_0 = this.state_0_;
                JSToBooleanNode toBooleanNode__ = (JSToBooleanNode)this.insert(JSToBooleanNode.create());
                Objects.requireNonNull(toBooleanNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.toBoolean_toBoolean_toBooleanNode_ = toBooleanNode__;
                this.state_0_ = state_0 |= 4;
                return JSDynamicObject.ToBoolean.toBoolean(arg0Value, toBooleanNode__);
            }
        }
    }
}

