/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.parser;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.logging.Logger;
import oracle.jdbc.driver.json.BufferPoolImpl;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.parser.JsonLocationImpl;
import oracle.sql.json.OracleJsonParser;

final class JsonTokenizer
implements Closeable {
    private static final int[] HEX;
    private static final int HEX_LENGTH;
    private final BufferPoolImpl bufferPool;
    private final Reader reader;
    private char[] buf;
    private int readBegin;
    private int readEnd;
    private int storeBegin;
    private int storeEnd;
    private long lineNo = 1L;
    private long lastLineOffset = 0L;
    private long bufferOffset = 0L;
    private boolean minus;
    private boolean fracOrExp;
    private BigDecimal bd;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;

    JsonTokenizer(Reader reader, BufferPoolImpl bufferPool) {
        this.reader = reader;
        this.bufferPool = bufferPool;
        this.buf = bufferPool.take();
    }

    private OracleJsonExceptions.ExceptionFactory factory() {
        return OracleJsonExceptions.ORACLE_FACTORY;
    }

    private void readString() {
        int ch;
        boolean inPlace = true;
        this.storeBegin = this.storeEnd = this.readBegin;
        block4: while (true) {
            if (inPlace) {
                while (this.readBegin < this.readEnd && (ch = this.buf[this.readBegin]) >= 32 && ch != 92) {
                    if (ch == 34) {
                        this.storeEnd = this.readBegin++;
                        return;
                    }
                    ++this.readBegin;
                }
                this.storeEnd = this.readBegin;
            }
            if ((ch = this.read()) >= 32 && ch != 34 && ch != 92) {
                if (!inPlace) {
                    this.buf[this.storeEnd] = (char)ch;
                }
                ++this.storeEnd;
                continue;
            }
            switch (ch) {
                case 92: {
                    inPlace = false;
                    this.unescape();
                    continue block4;
                }
                case 34: {
                    return;
                }
            }
            break;
        }
        throw this.unexpectedChar(ch);
    }

    private void unescape() {
        int ch = this.read();
        switch (ch) {
            case 98: {
                this.buf[this.storeEnd++] = 8;
                break;
            }
            case 116: {
                this.buf[this.storeEnd++] = 9;
                break;
            }
            case 110: {
                this.buf[this.storeEnd++] = 10;
                break;
            }
            case 102: {
                this.buf[this.storeEnd++] = 12;
                break;
            }
            case 114: {
                this.buf[this.storeEnd++] = 13;
                break;
            }
            case 34: 
            case 47: 
            case 92: {
                this.buf[this.storeEnd++] = (char)ch;
                break;
            }
            case 117: {
                int unicode = 0;
                for (int i2 = 0; i2 < 4; ++i2) {
                    int digit;
                    int ch3 = this.read();
                    int n2 = digit = ch3 >= 0 && ch3 < HEX_LENGTH ? HEX[ch3] : -1;
                    if (digit < 0) {
                        throw this.unexpectedChar(ch3);
                    }
                    unicode = unicode << 4 | digit;
                }
                this.buf[this.storeEnd++] = (char)unicode;
                break;
            }
            default: {
                throw this.unexpectedChar(ch);
            }
        }
    }

    private int readNumberChar() {
        if (this.readBegin < this.readEnd) {
            return this.buf[this.readBegin++];
        }
        this.storeEnd = this.readBegin;
        return this.read();
    }

    private void readNumber(int ch) {
        int count;
        this.storeBegin = this.storeEnd = this.readBegin - 1;
        if (ch == 45) {
            this.minus = true;
            ch = this.readNumberChar();
            if (ch < 48 || ch > 57) {
                throw this.unexpectedChar(ch);
            }
        }
        if (ch == 48) {
            ch = this.readNumberChar();
        } else {
            while ((ch = this.readNumberChar()) >= 48 && ch <= 57) {
            }
        }
        if (ch == 46) {
            this.fracOrExp = true;
            count = 0;
            do {
                ch = this.readNumberChar();
                ++count;
            } while (ch >= 48 && ch <= 57);
            if (count == 1) {
                throw this.unexpectedChar(ch);
            }
        }
        if (ch == 101 || ch == 69) {
            this.fracOrExp = true;
            ch = this.readNumberChar();
            if (ch == 43 || ch == 45) {
                ch = this.readNumberChar();
            }
            count = 0;
            while (ch >= 48 && ch <= 57) {
                ch = this.readNumberChar();
                ++count;
            }
            if (count == 0) {
                throw this.unexpectedChar(ch);
            }
        }
        if (ch != -1) {
            --this.readBegin;
            this.storeEnd = this.readBegin;
        }
    }

    private void readTrue() {
        int ch1 = this.read();
        if (ch1 != 114) {
            throw this.expectedChar(ch1, 'r');
        }
        int ch2 = this.read();
        if (ch2 != 117) {
            throw this.expectedChar(ch2, 'u');
        }
        int ch3 = this.read();
        if (ch3 != 101) {
            throw this.expectedChar(ch3, 'e');
        }
    }

    private void readFalse() {
        int ch1 = this.read();
        if (ch1 != 97) {
            throw this.expectedChar(ch1, 'a');
        }
        int ch2 = this.read();
        if (ch2 != 108) {
            throw this.expectedChar(ch2, 'l');
        }
        int ch3 = this.read();
        if (ch3 != 115) {
            throw this.expectedChar(ch3, 's');
        }
        int ch4 = this.read();
        if (ch4 != 101) {
            throw this.expectedChar(ch4, 'e');
        }
    }

    private void readNull() {
        int ch1 = this.read();
        if (ch1 != 117) {
            throw this.expectedChar(ch1, 'u');
        }
        int ch2 = this.read();
        if (ch2 != 108) {
            throw this.expectedChar(ch2, 'l');
        }
        int ch3 = this.read();
        if (ch3 != 108) {
            throw this.expectedChar(ch3, 'l');
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    JsonToken nextToken() {
        this.reset();
        int ch = this.read();
        while (ch == 32 || ch == 9 || ch == 10 || ch == 13) {
            block19: {
                if (ch == 13) {
                    ++this.lineNo;
                    ch = this.read();
                    if (ch == 10) {
                        this.lastLineOffset = this.bufferOffset + (long)this.readBegin;
                        break block19;
                    } else {
                        this.lastLineOffset = this.bufferOffset + (long)this.readBegin - 1L;
                        continue;
                    }
                }
                if (ch == 10) {
                    ++this.lineNo;
                    this.lastLineOffset = this.bufferOffset + (long)this.readBegin;
                }
            }
            ch = this.read();
        }
        switch (ch) {
            case 34: {
                this.readString();
                return JsonToken.STRING;
            }
            case 123: {
                return JsonToken.CURLYOPEN;
            }
            case 91: {
                return JsonToken.SQUAREOPEN;
            }
            case 58: {
                return JsonToken.COLON;
            }
            case 44: {
                return JsonToken.COMMA;
            }
            case 116: {
                this.readTrue();
                return JsonToken.TRUE;
            }
            case 102: {
                this.readFalse();
                return JsonToken.FALSE;
            }
            case 110: {
                this.readNull();
                return JsonToken.NULL;
            }
            case 93: {
                return JsonToken.SQUARECLOSE;
            }
            case 125: {
                return JsonToken.CURLYCLOSE;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.readNumber(ch);
                return JsonToken.NUMBER;
            }
            case -1: {
                return JsonToken.EOF;
            }
        }
        throw this.unexpectedChar(ch);
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean hasNextToken() {
        this.reset();
        int ch = this.peek();
        while (ch == 32 || ch == 9 || ch == 10 || ch == 13) {
            block5: {
                if (ch == 13) {
                    ++this.lineNo;
                    ++this.readBegin;
                    ch = this.peek();
                    if (ch == 10) {
                        this.lastLineOffset = this.bufferOffset + (long)this.readBegin + 1L;
                        break block5;
                    } else {
                        this.lastLineOffset = this.bufferOffset + (long)this.readBegin;
                        continue;
                    }
                }
                if (ch == 10) {
                    ++this.lineNo;
                    this.lastLineOffset = this.bufferOffset + (long)this.readBegin + 1L;
                }
            }
            ++this.readBegin;
            ch = this.peek();
        }
        if (ch == -1) return false;
        return true;
    }

    private int peek() {
        try {
            if (this.readBegin == this.readEnd) {
                int len = this.fillBuf();
                if (len == -1) {
                    return -1;
                }
                assert (len != 0);
                this.readBegin = this.storeEnd;
                this.readEnd = this.readBegin + len;
            }
            return this.buf[this.readBegin];
        }
        catch (IOException ioe) {
            throw OracleJsonExceptions.IO.create(this.factory(), ioe, new Object[0]);
        }
    }

    JsonLocationImpl getLastCharLocation() {
        return new JsonLocationImpl(this.lineNo, this.bufferOffset + (long)this.readBegin - this.lastLineOffset, this.bufferOffset + (long)this.readBegin - 1L);
    }

    JsonLocationImpl getLocation() {
        return new JsonLocationImpl(this.lineNo, this.bufferOffset + (long)this.readBegin - this.lastLineOffset + 1L, this.bufferOffset + (long)this.readBegin);
    }

    private int read() {
        try {
            if (this.readBegin == this.readEnd) {
                int len = this.fillBuf();
                if (len == -1) {
                    return -1;
                }
                assert (len != 0);
                this.readBegin = this.storeEnd;
                this.readEnd = this.readBegin + len;
            }
            return this.buf[this.readBegin++];
        }
        catch (IOException ioe) {
            throw OracleJsonExceptions.IO.create(this.factory(), ioe, new Object[0]);
        }
    }

    private int fillBuf() throws IOException {
        if (this.storeEnd != 0) {
            int storeLen = this.storeEnd - this.storeBegin;
            if (storeLen > 0) {
                if (storeLen == this.buf.length) {
                    char[] doubleBuf = Arrays.copyOf(this.buf, 2 * this.buf.length);
                    this.bufferPool.recycle(this.buf);
                    this.buf = doubleBuf;
                } else {
                    System.arraycopy(this.buf, this.storeBegin, this.buf, 0, storeLen);
                    this.storeEnd = storeLen;
                    this.storeBegin = 0;
                    this.bufferOffset += (long)(this.readBegin - this.storeEnd);
                }
            } else {
                this.storeEnd = 0;
                this.storeBegin = 0;
                this.bufferOffset += (long)this.readBegin;
            }
        } else {
            this.bufferOffset += (long)this.readBegin;
        }
        return this.reader.read(this.buf, this.storeEnd, this.buf.length - this.storeEnd);
    }

    private void reset() {
        if (this.storeEnd != 0) {
            this.storeBegin = 0;
            this.storeEnd = 0;
            this.bd = null;
            this.minus = false;
            this.fracOrExp = false;
        }
    }

    String getValue() {
        return new String(this.buf, this.storeBegin, this.storeEnd - this.storeBegin);
    }

    BigDecimal getBigDecimal() {
        if (this.bd == null) {
            this.bd = new BigDecimal(this.buf, this.storeBegin, this.storeEnd - this.storeBegin);
        }
        return this.bd;
    }

    int getInt() {
        int storeLen = this.storeEnd - this.storeBegin;
        if (!this.fracOrExp && (storeLen <= 9 || this.minus && storeLen <= 10)) {
            int i2;
            int num = 0;
            int n2 = i2 = this.minus ? 1 : 0;
            while (i2 < storeLen) {
                num = num * 10 + (this.buf[this.storeBegin + i2] - 48);
                ++i2;
            }
            return this.minus ? -num : num;
        }
        return this.getBigDecimal().intValue();
    }

    long getLong() {
        int storeLen = this.storeEnd - this.storeBegin;
        if (!this.fracOrExp && (storeLen <= 18 || this.minus && storeLen <= 19)) {
            int i2;
            long num = 0L;
            int n2 = i2 = this.minus ? 1 : 0;
            while (i2 < storeLen) {
                num = num * 10L + (long)(this.buf[this.storeBegin + i2] - 48);
                ++i2;
            }
            return this.minus ? -num : num;
        }
        return this.getBigDecimal().longValue();
    }

    boolean isDefinitelyInt() {
        int storeLen = this.storeEnd - this.storeBegin;
        return !this.fracOrExp && (storeLen <= 9 || this.minus && storeLen <= 10);
    }

    boolean isDefinitelyLong() {
        int storeLen = this.storeEnd - this.storeBegin;
        return !this.fracOrExp && (storeLen <= 18 || this.minus && storeLen <= 19);
    }

    boolean isIntegral() {
        return !this.fracOrExp || this.getBigDecimal().scale() == 0;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        this.bufferPool.recycle(this.buf);
    }

    private RuntimeException unexpectedChar(int ch) {
        JsonLocationImpl location = this.getLastCharLocation();
        return OracleJsonExceptions.TOKEN_UNEXPECTED_CHAR.create(this.factory(), this.chToString(ch), location.getLineNumber(), location.getColumnNumber());
    }

    private RuntimeException expectedChar(int unexpected, char expected) {
        JsonLocationImpl location = this.getLastCharLocation();
        return OracleJsonExceptions.TOKEN_EXPECTED_CHAR.create(this.factory(), this.chToString(unexpected), location.getLineNumber(), location.getColumnNumber(), this.chToString(expected));
    }

    private String chToString(int ch) {
        StringBuilder builder = new StringBuilder();
        if (ch >= 32 && ch <= 126) {
            builder.append("'");
            builder.appendCodePoint(ch);
            builder.append("'");
        } else {
            builder.append("0x");
            builder.append(Integer.toHexString(ch));
        }
        return builder.toString();
    }

    static {
        int i2;
        try {
            $$$methodRef$$$27 = JsonTokenizer.class.getDeclaredConstructor(Reader.class, BufferPoolImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = JsonTokenizer.class.getDeclaredMethod("chToString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = JsonTokenizer.class.getDeclaredMethod("expectedChar", Integer.TYPE, Character.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = JsonTokenizer.class.getDeclaredMethod("unexpectedChar", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = JsonTokenizer.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = JsonTokenizer.class.getDeclaredMethod("isIntegral", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = JsonTokenizer.class.getDeclaredMethod("isDefinitelyLong", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = JsonTokenizer.class.getDeclaredMethod("isDefinitelyInt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = JsonTokenizer.class.getDeclaredMethod("getLong", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = JsonTokenizer.class.getDeclaredMethod("getInt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = JsonTokenizer.class.getDeclaredMethod("getBigDecimal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = JsonTokenizer.class.getDeclaredMethod("getValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = JsonTokenizer.class.getDeclaredMethod("reset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = JsonTokenizer.class.getDeclaredMethod("fillBuf", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = JsonTokenizer.class.getDeclaredMethod("read", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = JsonTokenizer.class.getDeclaredMethod("getLocation", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = JsonTokenizer.class.getDeclaredMethod("getLastCharLocation", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = JsonTokenizer.class.getDeclaredMethod("peek", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = JsonTokenizer.class.getDeclaredMethod("hasNextToken", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = JsonTokenizer.class.getDeclaredMethod("nextToken", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = JsonTokenizer.class.getDeclaredMethod("readNull", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = JsonTokenizer.class.getDeclaredMethod("readFalse", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = JsonTokenizer.class.getDeclaredMethod("readTrue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = JsonTokenizer.class.getDeclaredMethod("readNumber", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = JsonTokenizer.class.getDeclaredMethod("readNumberChar", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = JsonTokenizer.class.getDeclaredMethod("unescape", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = JsonTokenizer.class.getDeclaredMethod("readString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = JsonTokenizer.class.getDeclaredMethod("factory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        HEX = new int[128];
        Arrays.fill(HEX, -1);
        for (i2 = 48; i2 <= 57; ++i2) {
            JsonTokenizer.HEX[i2] = i2 - 48;
        }
        for (i2 = 65; i2 <= 70; ++i2) {
            JsonTokenizer.HEX[i2] = 10 + i2 - 65;
        }
        for (i2 = 97; i2 <= 102; ++i2) {
            JsonTokenizer.HEX[i2] = 10 + i2 - 97;
        }
        HEX_LENGTH = HEX.length;
    }

    static final class JsonToken
    extends Enum<JsonToken> {
        public static final /* enum */ JsonToken CURLYOPEN;
        public static final /* enum */ JsonToken SQUAREOPEN;
        public static final /* enum */ JsonToken COLON;
        public static final /* enum */ JsonToken COMMA;
        public static final /* enum */ JsonToken STRING;
        public static final /* enum */ JsonToken NUMBER;
        public static final /* enum */ JsonToken TRUE;
        public static final /* enum */ JsonToken FALSE;
        public static final /* enum */ JsonToken NULL;
        public static final /* enum */ JsonToken CURLYCLOSE;
        public static final /* enum */ JsonToken SQUARECLOSE;
        public static final /* enum */ JsonToken EOF;
        private final OracleJsonParser.Event event;
        private final boolean value;
        private static final /* synthetic */ JsonToken[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;

        public static JsonToken[] values() {
            return (JsonToken[])$VALUES.clone();
        }

        public static JsonToken valueOf(String name) {
            return Enum.valueOf(JsonToken.class, name);
        }

        private JsonToken(OracleJsonParser.Event event, boolean value) {
            this.event = event;
            this.value = value;
        }

        OracleJsonParser.Event getEvent() {
            return this.event;
        }

        boolean isValue() {
            return this.value;
        }

        static {
            try {
                $$$methodRef$$$4 = JsonToken.class.getDeclaredConstructor(String.class, Integer.TYPE, OracleJsonParser.Event.class, Boolean.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = JsonToken.class.getDeclaredMethod("isValue", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = JsonToken.class.getDeclaredMethod("getEvent", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = JsonToken.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = JsonToken.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            CURLYOPEN = new JsonToken(OracleJsonParser.Event.START_OBJECT, false);
            SQUAREOPEN = new JsonToken(OracleJsonParser.Event.START_ARRAY, false);
            COLON = new JsonToken(null, false);
            COMMA = new JsonToken(null, false);
            STRING = new JsonToken(OracleJsonParser.Event.VALUE_STRING, true);
            NUMBER = new JsonToken(OracleJsonParser.Event.VALUE_DECIMAL, true);
            TRUE = new JsonToken(OracleJsonParser.Event.VALUE_TRUE, true);
            FALSE = new JsonToken(OracleJsonParser.Event.VALUE_FALSE, true);
            NULL = new JsonToken(OracleJsonParser.Event.VALUE_NULL, true);
            CURLYCLOSE = new JsonToken(OracleJsonParser.Event.END_OBJECT, false);
            SQUARECLOSE = new JsonToken(OracleJsonParser.Event.END_ARRAY, false);
            EOF = new JsonToken(null, false);
            $VALUES = new JsonToken[]{CURLYOPEN, SQUAREOPEN, COLON, COMMA, STRING, NUMBER, TRUE, FALSE, NULL, CURLYCLOSE, SQUARECLOSE, EOF};
        }
    }
}

