/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotEngineOptions;
import com.oracle.truffle.polyglot.PolyglotSharingLayer;
import com.oracle.truffle.polyglot.SourceCacheListener;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.logging.Level;

final class TracingSourceCacheListener
implements SourceCacheListener {
    static final int MAX_SOURCE_NAME_LENGTH = 50;
    static final int MAX_EXCEPTION_STRING_LENGTH = 175;
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS").withZone(ZoneId.of("UTC"));
    private static final String COMMON_PARAMS = "|Engine %-2d|Layer %-2d|CallTarget %-5d|Lang %-10s|Policy %-9s|%-8s|UTC %s";
    private static final String SOURCE_FORMAT = "0x%08x %-50s";
    private static final String HIT_FORMAT = "source-cache-hit   0x%08x %-50s|Hits %12d|Engine %-2d|Layer %-2d|CallTarget %-5d|Lang %-10s|Policy %-9s|%-8s|UTC %s";
    private static final String MISS_FORMAT = "source-cache-miss  0x%08x %-50s|ParseTime %4d ms|Engine %-2d|Layer %-2d|CallTarget %-5d|Lang %-10s|Policy %-9s|%-8s|UTC %s";
    private static final String FAIL_FORMAT = "source-cache-fail  0x%08x %-50s|ParseTime %4d ms|Engine %-2d|Layer %-2d|CallTarget %-5d|Lang %-10s|Policy %-9s|%-8s|UTC %s|Error %s";
    private static final String EVICT_FORMAT = "source-cache-evict 0x%08x %-50s|Hits %12d|Engine %-2d|Layer %-2d|CallTarget %-5d|Lang %-10s|Policy %-9s|%-8s|UTC %s";
    private final boolean traceSourceCacheDetails;

    private static void log(PolyglotSharingLayer sharingLayer, String logFormat, Object ... params) {
        sharingLayer.engine.getEngineLogger().log(Level.INFO, String.format(logFormat, params));
    }

    static String truncateString(String s, int maxLength) {
        if (s == null || s.length() <= maxLength) {
            return s;
        }
        return s.substring(0, maxLength);
    }

    private TracingSourceCacheListener(boolean traceSourceCacheDetails) {
        this.traceSourceCacheDetails = traceSourceCacheDetails;
    }

    static TracingSourceCacheListener createOrNull(PolyglotEngineImpl engine) {
        boolean traceSourceCache;
        boolean traceSourceCacheDetails = engine.engineOptionValues.get(PolyglotEngineOptions.TraceSourceCacheDetails);
        boolean bl = traceSourceCache = traceSourceCacheDetails || engine.engineOptionValues.get(PolyglotEngineOptions.TraceSourceCache) != false;
        if (traceSourceCache) {
            return new TracingSourceCacheListener(traceSourceCacheDetails);
        }
        return null;
    }

    @Override
    public void onCacheHit(Source source, CallTarget target, SourceCacheListener.CacheType cacheType, long hits) {
        if (this.traceSourceCacheDetails && target instanceof RootCallTarget) {
            PolyglotSharingLayer sharingLayer = (PolyglotSharingLayer)EngineAccessor.NODES.getSharingLayer(((RootCallTarget)target).getRootNode());
            TracingSourceCacheListener.log(sharingLayer, HIT_FORMAT, new Object[]{source.hashCode(), TracingSourceCacheListener.truncateString(source.getName(), 50), hits, sharingLayer.engine.engineId, sharingLayer.shared.id, EngineAccessor.RUNTIME.getCallTargetId(target), source.getLanguage(), sharingLayer.getContextPolicy().name(), cacheType, TIME_FORMATTER.format(ZonedDateTime.now())});
        }
    }

    @Override
    public void onCacheMiss(Source source, CallTarget target, SourceCacheListener.CacheType cacheType, long startTime) {
        if ((this.traceSourceCacheDetails || cacheType != SourceCacheListener.CacheType.UNCACHED) && target instanceof RootCallTarget) {
            PolyglotSharingLayer sharingLayer = (PolyglotSharingLayer)EngineAccessor.NODES.getSharingLayer(((RootCallTarget)target).getRootNode());
            TracingSourceCacheListener.log(sharingLayer, MISS_FORMAT, new Object[]{source.hashCode(), TracingSourceCacheListener.truncateString(source.getName(), 50), System.currentTimeMillis() - startTime, sharingLayer.engine.engineId, sharingLayer.shared.id, EngineAccessor.RUNTIME.getCallTargetId(target), source.getLanguage(), sharingLayer.getContextPolicy().name(), cacheType, TIME_FORMATTER.format(ZonedDateTime.now())});
        }
    }

    @Override
    public void onCacheFail(PolyglotSharingLayer sharingLayer, Source source, SourceCacheListener.CacheType cacheType, long startTime, Throwable throwable) {
        TracingSourceCacheListener.log(sharingLayer, FAIL_FORMAT, new Object[]{source.hashCode(), TracingSourceCacheListener.truncateString(source.getName(), 50), System.currentTimeMillis() - startTime, sharingLayer.engine.engineId, sharingLayer.shared.id, 0, source.getLanguage(), sharingLayer.getContextPolicy().name(), cacheType, TIME_FORMATTER.format(ZonedDateTime.now()), TracingSourceCacheListener.truncateString(throwable.toString(), 175)});
    }

    @Override
    public void onCacheEvict(Source source, CallTarget target, SourceCacheListener.CacheType cacheType, long hits) {
        if (target instanceof RootCallTarget) {
            PolyglotSharingLayer sharingLayer = (PolyglotSharingLayer)EngineAccessor.NODES.getSharingLayer(((RootCallTarget)target).getRootNode());
            TracingSourceCacheListener.log(sharingLayer, EVICT_FORMAT, new Object[]{source.hashCode(), TracingSourceCacheListener.truncateString(source.getName(), 50), hits, sharingLayer.engine.engineId, sharingLayer.shared.id, EngineAccessor.RUNTIME.getCallTargetId(target), source.getLanguage(), sharingLayer.getContextPolicy().name(), cacheType, TIME_FORMATTER.format(ZonedDateTime.now())});
        }
    }
}

