/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib.fastpath;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.expression.BinaryOpNode;
import com.oracle.graal.python.nodes.truffle.PythonIntegerTypes;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;

@GenerateCached(value=false)
@TypeSystemReference(value=PythonIntegerTypes.class)
public abstract class PyNumberAddFastPathsBase
extends BinaryOpNode {
    @Specialization(rewriteOn={ArithmeticException.class})
    public static int doII(int left, int right) {
        return Math.addExact(left, right);
    }

    @Specialization(replaces={"doII"}, rewriteOn={ArithmeticException.class})
    public static long doLL(long left, long right) {
        return Math.addExact(left, right);
    }

    @Specialization(replaces={"doLL"})
    public static Object doLLOvf(long x, long y, @Bind PythonLanguage language) {
        long r = x + y;
        if (((x ^ r) & (y ^ r)) < 0L) {
            return PFactory.createInt(language, IntBuiltins.AddNode.add(PInt.longToBigInteger(x), PInt.longToBigInteger(y)));
        }
        return r;
    }

    @Specialization
    public static double doDD(double left, double right) {
        return left + right;
    }

    @Specialization
    public static double doDL(double left, long right) {
        return left + (double)right;
    }

    @Specialization
    public static double doLD(long left, double right) {
        return (double)left + right;
    }
}

