/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryOp;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSizeArgFun;
import com.oracle.graal.python.lib.CallBinaryIOp1Node;
import com.oracle.graal.python.lib.PySequenceCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;

@GenerateInline
@GenerateCached(value=false)
public abstract class PySequenceInPlaceRepeatNode
extends PNodeWithContext {
    public abstract Object execute(VirtualFrame var1, Node var2, Object var3, int var4);

    @Specialization
    static Object doIt(VirtualFrame frame, Node inliningTarget, Object o, int count, @Cached GetClassNode getClassNode, @Cached TpSlots.GetCachedTpSlotsNode slotsNode, @Cached PySequenceCheckNode sequenceCheckNode, @Cached CallBinaryIOp1Node callBinaryIOp1Node, @Cached InlinedBranchProfile hasInplaceRepeat, @Cached InlinedBranchProfile hasRepeat, @Cached InlinedBranchProfile isSequence, @Cached InlinedBranchProfile hasNbMultiplyResult, @Cached TpSlotSizeArgFun.CallSlotSizeArgFun callSlot, @Cached PRaiseNode raiseNode) {
        Object classV = getClassNode.execute(inliningTarget, o);
        TpSlots slotsV = slotsNode.execute(inliningTarget, classV);
        TpSlot repeatSlot = null;
        if (slotsV.sq_inplace_repeat() != null) {
            hasInplaceRepeat.enter(inliningTarget);
            repeatSlot = slotsV.sq_inplace_repeat();
        } else if (slotsV.sq_repeat() != null) {
            hasRepeat.enter(inliningTarget);
            repeatSlot = slotsV.sq_repeat();
        }
        if (repeatSlot != null) {
            return callSlot.execute(frame, inliningTarget, repeatSlot, o, count);
        }
        if (sequenceCheckNode.execute(inliningTarget, o)) {
            isSequence.enter(inliningTarget);
            PythonBuiltinClassType countType = PythonBuiltinClassType.PInt;
            Object result = callBinaryIOp1Node.execute(frame, inliningTarget, o, classV, slotsV, count, (Object)countType, countType.getSlots(), TpSlotBinaryOp.InplaceSlot.NB_INPLACE_MULTIPLY);
            if (result != PNotImplemented.NOT_IMPLEMENTED) {
                hasNbMultiplyResult.enter(inliningTarget);
                return result;
            }
        }
        return PySequenceInPlaceRepeatNode.raiseNotSupported(inliningTarget, o, raiseNode);
    }

    @HostCompilerDirectives.InliningCutoff
    private static PException raiseNotSupported(Node inliningTarget, Object v, PRaiseNode raiseNode) {
        return raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_CANT_BE_REPEATED, v);
    }
}

