/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotUnaryFunc;
import com.oracle.graal.python.lib.PyFloatAsDoubleNodeGen;
import com.oracle.graal.python.lib.PyLongAsDoubleNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CastToJavaDoubleNode;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class PyFloatAsDoubleNode
extends PNodeWithContext {
    public static double executeUncached(Object object) {
        return PyFloatAsDoubleNodeGen.getUncached().execute(null, null, object);
    }

    public abstract double execute(VirtualFrame var1, Node var2, Object var3);

    @Specialization
    static double doDouble(double object) {
        return object;
    }

    @Specialization
    static double doPFloat(PFloat object) {
        return object.getValue();
    }

    @Specialization
    static double doInt(int object) {
        return object;
    }

    @Specialization
    static double doLong(long object) {
        return object;
    }

    @Specialization
    static double doBoolean(boolean object) {
        return object ? 1.0 : 0.0;
    }

    @Specialization(guards={"isFloatSubtype(inliningTarget, object, getClassNode, isSubtype)"}, limit="1")
    @HostCompilerDirectives.InliningCutoff
    static double doNative(Node inliningTarget, PythonAbstractNativeObject object, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached.Exclusive @Cached(inline=false) IsSubtypeNode isSubtype, @Cached(inline=false) CStructAccess.ReadDoubleNode read) {
        return read.readFromObj(object, CFields.PyFloatObject__ob_fval);
    }

    @HostCompilerDirectives.InliningCutoff
    @Fallback
    static double doObject(VirtualFrame frame, Node inliningTarget, Object object, @Cached.Exclusive @Cached GetClassNode getClassNode, @Cached TpSlots.GetCachedTpSlotsNode getSlots, @Cached TpSlotUnaryFunc.CallSlotUnaryNode callFloat, @Cached PyNumberIndexNode indexNode, @Cached PyLongAsDoubleNode asDoubleNode, @Cached HandleFloatResultNode handleFloatResultNode, @Cached PRaiseNode raiseNode) {
        Object type = getClassNode.execute(inliningTarget, object);
        TpSlots slots = getSlots.execute(inliningTarget, type);
        if (slots.nb_float() != null) {
            Object result = callFloat.execute(frame, inliningTarget, slots.nb_float(), object);
            if (result instanceof Double) {
                Double doubleResult = (Double)result;
                return doubleResult;
            }
            return PyFloatAsDoubleNode.handleFloatResult(frame, result, object, handleFloatResultNode);
        }
        if (slots.nb_index() != null) {
            Object index = indexNode.execute((Frame)frame, inliningTarget, object);
            return asDoubleNode.execute(inliningTarget, index);
        }
        throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_REAL_NUMBER, object);
    }

    @HostCompilerDirectives.InliningCutoff
    static double handleFloatResult(VirtualFrame frame, Object result, Object object, HandleFloatResultNode handleFloatResultNode) {
        return handleFloatResultNode.execute(frame, result, object);
    }

    static boolean isFloatSubtype(Node inliningTarget, Object object, GetClassNode getClass, IsSubtypeNode isSubtype) {
        return CExtNodes.FromNativeSubclassNode.isFloatSubtype(inliningTarget, object, getClass, isSubtype);
    }

    @GenerateInline(value=false)
    @GenerateUncached
    static abstract class HandleFloatResultNode
    extends Node {
        HandleFloatResultNode() {
        }

        public abstract double execute(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        static double handle(VirtualFrame frame, Object result, Object original, @Bind Node inliningTarget, @Cached GetClassNode resultClassNode, @Cached BuiltinClassProfiles.IsBuiltinClassExactProfile resultProfile, @Cached IsSubtypeNode resultSubtypeNode, @Cached CastToJavaDoubleNode cast, @Cached WarningsModuleBuiltins.WarnNode warnNode, @Cached PRaiseNode raiseNode) {
            Object resultType = resultClassNode.execute(inliningTarget, result);
            if (!resultProfile.profileClass(inliningTarget, resultType, PythonBuiltinClassType.PFloat)) {
                if (!resultSubtypeNode.execute(resultType, (Object)PythonBuiltinClassType.PFloat)) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.RETURNED_NON_FLOAT, original, result);
                }
                warnNode.warnFormat((Frame)frame, null, (Object)PythonBuiltinClassType.DeprecationWarning, 1, ErrorMessages.WARN_P_RETURNED_NON_P, original, SpecialMethodNames.T___FLOAT__, "float", result, "float");
            }
            return cast.execute(inliningTarget, result);
        }
    }
}

