/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.charset;

import com.oracle.graal.python.builtins.objects.str.StringUtils;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;

public class PythonUnicodeEscapeCharsetDecoder
extends CharsetDecoder {
    private int octalCodePoint;
    private int octalLength;

    protected PythonUnicodeEscapeCharsetDecoder(Charset cs) {
        super(cs, 1.0f, 1.0f);
    }

    static CoderResult decodeHexUnicodeEscape(ByteBuffer source, CharBuffer target, byte b, int initialPosition) {
        int codePoint;
        int count = switch (b) {
            case 120 -> 2;
            case 117 -> 4;
            case 85 -> 8;
            default -> throw new IllegalArgumentException();
        };
        if (source.remaining() < count) {
            source.position(initialPosition);
            return CoderResult.UNDERFLOW;
        }
        byte[] numbuf = new byte[count];
        source.get(numbuf, 0, count);
        try {
            codePoint = Integer.parseInt(new String(numbuf, 0, count, StandardCharsets.US_ASCII), 16);
        }
        catch (NumberFormatException e) {
            int pos = source.position();
            source.position(initialPosition);
            return CoderResult.malformedForLength(pos - initialPosition);
        }
        return PythonUnicodeEscapeCharsetDecoder.outputCodePoint(source, target, codePoint, initialPosition);
    }

    static CoderResult outputCodePoint(ByteBuffer source, CharBuffer target, int codePoint, int initialPosition) {
        if (!Character.isValidCodePoint(codePoint)) {
            int pos = source.position();
            source.position(initialPosition);
            return CoderResult.malformedForLength(pos - initialPosition);
        }
        if (Character.charCount(codePoint) == 2) {
            target.put(Character.highSurrogate(codePoint));
            if (!target.hasRemaining()) {
                source.position(initialPosition);
                target.position(target.position() - 1);
                return CoderResult.OVERFLOW;
            }
            target.put(Character.lowSurrogate(codePoint));
        } else {
            target.put((char)codePoint);
        }
        return null;
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer source, CharBuffer target) {
        block15: while (source.hasRemaining()) {
            if (!target.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            int initialPosition = source.position();
            byte b = source.get();
            if (b == 92) {
                if (!source.hasRemaining()) {
                    source.position(initialPosition);
                    return CoderResult.UNDERFLOW;
                }
                b = source.get();
                if (b >= 48 && b <= 55) {
                    this.octalLength = 1;
                    this.octalCodePoint = b - 48;
                    continue;
                }
                switch (b) {
                    case 92: {
                        target.put('\\');
                        continue block15;
                    }
                    case 97: {
                        target.put('\u0007');
                        continue block15;
                    }
                    case 98: {
                        target.put('\b');
                        continue block15;
                    }
                    case 102: {
                        target.put('\f');
                        continue block15;
                    }
                    case 110: {
                        target.put('\n');
                        continue block15;
                    }
                    case 114: {
                        target.put('\r');
                        continue block15;
                    }
                    case 116: {
                        target.put('\t');
                        continue block15;
                    }
                    case 118: {
                        target.put('\u000b');
                        continue block15;
                    }
                    case 34: {
                        target.put('\"');
                        continue block15;
                    }
                    case 39: {
                        target.put('\'');
                        continue block15;
                    }
                    case 10: 
                    case 13: {
                        continue block15;
                    }
                    case 85: 
                    case 117: 
                    case 120: {
                        CoderResult result = PythonUnicodeEscapeCharsetDecoder.decodeHexUnicodeEscape(source, target, b, initialPosition);
                        if (result == null) continue block15;
                        return result;
                    }
                    case 78: {
                        if (!source.hasRemaining()) {
                            source.position(initialPosition);
                            return CoderResult.UNDERFLOW;
                        }
                        b = source.get();
                        if (b != 123) {
                            source.position(initialPosition);
                            return CoderResult.malformedForLength(2);
                        }
                        do {
                            if (source.hasRemaining()) continue;
                            source.position(initialPosition);
                            return CoderResult.UNDERFLOW;
                        } while ((b = source.get()) != 125);
                        int end = source.position();
                        source.position(initialPosition + 3);
                        byte[] nameBytes = new byte[end - source.position() - 1];
                        source.get(nameBytes);
                        int codePoint = StringUtils.getCodePoint(new String(nameBytes, StandardCharsets.US_ASCII));
                        if (codePoint < 0) {
                            source.position(initialPosition);
                            return CoderResult.malformedForLength(end - initialPosition);
                        }
                        CoderResult result = PythonUnicodeEscapeCharsetDecoder.outputCodePoint(source, target, codePoint, initialPosition);
                        if (result == null) continue block15;
                        return result;
                    }
                }
                target.put('\\');
                source.position(source.position() - 1);
                continue;
            }
            if (this.octalLength > 0 && b >= 48 && b <= 55) {
                ++this.octalLength;
                this.octalCodePoint = this.octalCodePoint * 8 + (b - 48);
                if (this.octalLength < 3) continue;
                this.outputOctal(target);
                continue;
            }
            if (this.octalLength >= 1) {
                this.outputOctal(target);
                if (!target.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
            }
            target.put((char)(b & 0xFF));
        }
        return CoderResult.UNDERFLOW;
    }

    private void outputOctal(CharBuffer target) {
        assert (Character.isValidCodePoint(this.octalCodePoint) && Character.charCount(this.octalCodePoint) == 1);
        target.put((char)this.octalCodePoint);
        this.octalCodePoint = 0;
        this.octalLength = 0;
    }

    @Override
    protected void implReset() {
        this.octalCodePoint = 0;
        this.octalLength = 0;
    }

    @Override
    protected CoderResult implFlush(CharBuffer target) {
        if (this.octalLength > 0) {
            if (!target.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            this.outputOctal(target);
        }
        return CoderResult.UNDERFLOW;
    }
}

