/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.SREModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.array.PArray;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.cext.common.NativePointer;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.builtins.objects.mmap.PMMap;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.slice.SliceNodes;
import com.oracle.graal.python.lib.PyLongAsIntNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonSenaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.graalvm.collections.EconomicMap;

@CoreFunctions(defineModule="_sre")
public final class SREModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return SREModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        this.addBuiltinConstant("_with_tregex", (Object)core.getContext().getLanguage().getEngineOption(PythonOptions.WithTRegex));
        this.addBuiltinConstant("_with_sre", (Object)core.getContext().getLanguage().getEngineOption(PythonOptions.TRegexUsesSREFallback));
        this.addBuiltinConstant("_METHOD_SEARCH", (Object)PythonMethod.Search);
        this.addBuiltinConstant("_METHOD_MATCH", (Object)PythonMethod.Match);
        this.addBuiltinConstant("_METHOD_FULLMATCH", (Object)PythonMethod.FullMatch);
        super.initialize(core);
    }

    public static enum PythonMethod implements TruffleObject
    {
        Search(PythonUtils.tsLiteral("search")),
        Match(PythonUtils.tsLiteral("match")),
        FullMatch(PythonUtils.tsLiteral("fullmatch"));

        public static final int PYTHON_METHOD_COUNT;
        private final TruffleString name;

        private PythonMethod(TruffleString name) {
            this.name = name;
        }

        public TruffleString getMethodName() {
            return this.name;
        }

        public String getTRegexOption() {
            return "PythonMethod=" + this.name.toJavaStringUncached();
        }

        static {
            PYTHON_METHOD_COUNT = PythonMethod.values().length;
        }
    }

    @Builtin(name="tregex_call_exec", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    static abstract class TRegexCallExec
    extends PythonTernaryBuiltinNode {
        @Node.Child
        private BufferToTruffleStringNode bufferToTruffleStringNode;

        TRegexCallExec() {
        }

        @Specialization(guards={"callable == cachedCallable"}, limit="2")
        Object doCached(VirtualFrame frame, Object callable, Object inputStringOrBytes, Number fromIndex, @Bind Node inliningTarget, @Cached.Shared @Cached(value="createFor($node)") IndirectCallData indirectCallData, @Cached(value="callable", weak=true) Object cachedCallable, @Cached @Cached.Shared CastToTruffleStringNode cast, @CachedLibrary(limit="3") @Cached.Shared PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="1") @Cached.Shared PythonBufferAccessLibrary bufferLib, @CachedLibrary(value="callable") InteropLibrary interop, @Cached @Cached.Shared InlinedBranchProfile binaryProfile) {
            TruffleString input;
            Object buffer = null;
            try {
                input = cast.execute(inliningTarget, inputStringOrBytes);
            }
            catch (CannotCastException e1) {
                binaryProfile.enter(inliningTarget);
                buffer = bufferAcquireLib.acquireReadonly(inputStringOrBytes, frame, indirectCallData);
                input = this.getBufferToTruffleStringNode().execute(buffer);
            }
            try {
                Object e1 = interop.invokeMember(cachedCallable, "exec", new Object[]{input, fromIndex});
                if (buffer != null) {
                    bufferLib.release(buffer, frame, indirectCallData);
                }
                return e1;
            }
            catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e2) {
                try {
                    throw CompilerDirectives.shouldNotReachHere((String)"could not call TRegex exec method", (Throwable)e2);
                }
                catch (Throwable throwable) {
                    if (buffer != null) {
                        bufferLib.release(buffer, frame, indirectCallData);
                    }
                    throw throwable;
                }
            }
        }

        @Specialization(limit="1", replaces={"doCached"})
        @ReportPolymorphism.Megamorphic
        Object doUncached(VirtualFrame frame, Object callable, Object inputStringOrBytes, Number fromIndex, @Bind Node inliningTarget, @Cached.Shared @Cached(value="createFor($node)") IndirectCallData indirectCallData, @Cached @Cached.Shared CastToTruffleStringNode cast, @CachedLibrary(limit="3") @Cached.Shared PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="1") @Cached.Shared PythonBufferAccessLibrary bufferLib, @CachedLibrary(value="callable") InteropLibrary interop, @Cached @Cached.Shared InlinedBranchProfile binaryProfile) {
            return this.doCached(frame, callable, inputStringOrBytes, fromIndex, inliningTarget, indirectCallData, callable, cast, bufferAcquireLib, bufferLib, interop, binaryProfile);
        }

        private BufferToTruffleStringNode getBufferToTruffleStringNode() {
            if (this.bufferToTruffleStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.bufferToTruffleStringNode = (BufferToTruffleStringNode)this.insert(BufferToTruffleStringNode.create());
            }
            return this.bufferToTruffleStringNode;
        }

        @GenerateInline(value=false)
        static abstract class BufferToTruffleStringNode
        extends PNodeWithContext {
            BufferToTruffleStringNode() {
            }

            public abstract TruffleString execute(Object var1);

            @Specialization(limit="4")
            static TruffleString convert(Object buffer, @Bind Node inliningTarget, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached TruffleString.FromNativePointerNode fromNativePointerNode, @Cached InlinedBranchProfile internalArrayProfile, @Cached InlinedBranchProfile nativeProfile, @Cached InlinedBranchProfile fallbackProfile) {
                PythonBufferAccessLibrary.assertIsBuffer(buffer);
                int len = bufferLib.getBufferLength(buffer);
                if (bufferLib.hasInternalByteArray(buffer)) {
                    internalArrayProfile.enter(inliningTarget);
                    byte[] bytes = bufferLib.getInternalByteArray(buffer);
                    return fromByteArrayNode.execute(bytes, 0, len, TruffleString.Encoding.ISO_8859_1, false);
                }
                if (bufferLib.isNative(buffer)) {
                    nativeProfile.enter(inliningTarget);
                    Object ptr = bufferLib.getNativePointer(buffer);
                    if (ptr != null) {
                        if (ptr instanceof Long) {
                            Long lptr = (Long)ptr;
                            ptr = new NativePointer(lptr);
                        }
                        return fromNativePointerNode.execute(ptr, 0, len, TruffleString.Encoding.ISO_8859_1, false);
                    }
                }
                fallbackProfile.enter(inliningTarget);
                byte[] bytes = bufferLib.getCopiedByteArray(buffer);
                return fromByteArrayNode.execute(bytes, 0, len, TruffleString.Encoding.ISO_8859_1, false);
            }

            @NeverDefault
            public static BufferToTruffleStringNode create() {
                return SREModuleBuiltinsFactory.TRegexCallExecFactory.BufferToTruffleStringNodeGen.create();
            }
        }
    }

    @Builtin(name="tregex_search", minNumOfPositionalArgs=6)
    @GenerateNodeFactory
    @ImportStatic(value={PythonMethod.class})
    static abstract class TRegexSearch
    extends PythonSenaryBuiltinNode {
        protected static final TruffleString T__PATTERN__FALLBACK_COMPILE = PythonUtils.tsLiteral("_Pattern__fallback_compile");
        @Node.Child
        private HiddenAttr.ReadNode readCacheNode = HiddenAttr.ReadNode.create();
        @Node.Child
        private GetAttributeNode getFallbackCompileNode;
        @Node.Child
        private CallNode callFallbackCompileNode;
        @Node.Child
        private CallNode callFallbackMethodNode;
        @Node.Child
        private SliceNodes.CreateSliceNode createSliceNode;
        @Node.Child
        private PyObjectGetItem getItemNode;

        TRegexSearch() {
        }

        @Specialization(guards={"isSingleContext()", "pattern == cachedPattern", "method == cachedMethod", "mustAdvance == cachedMustAdvance", "!tRegexCache.isLocaleSensitive()"}, limit="1")
        protected Object doCached(VirtualFrame frame, PythonObject pattern, Object input, Object posArg, Object endPosArg, PythonMethod method, boolean mustAdvance, @Bind Node inliningTarget, @Cached(value="pattern", weak=true) PythonObject cachedPattern, @Cached(value="method") PythonMethod cachedMethod, @Cached(value="mustAdvance") boolean cachedMustAdvance, @Cached @Cached.Shared TRegexCompile tRegexCompileNode, @Cached(value="getTRegexCache(pattern)", weak=true) TRegexCache tRegexCache, @Cached(value="tRegexCompileNode.execute(frame, pattern, method, mustAdvance)") Object compiledRegex, @Cached @Cached.Shared InlinedConditionProfile fallbackProfile, @Cached @Cached.Shared InlinedConditionProfile truncatingInputProfile, @Cached @Cached.Shared RECheckInputTypeNode reCheckInputTypeNode, @Cached @Cached.Shared PyNumberIndexNode indexNode, @Cached @Cached.Shared PyNumberAsSizeNode asSizeNode, @Cached @Cached.Shared PyObjectSizeNode lengthNode, @CachedLibrary(limit="1") @Cached.Shared InteropLibrary libCompiledRegex, @Cached(value="create(method.getMethodName())") GetAttributeNode getFallbackMethodNode, @Cached @Cached.Shared TRegexCallExec tRegexCallExec, @Cached @Cached.Shared CreateMatchFromTRegexResultNode createMatchFromTRegexResultNode) {
            int pos = asSizeNode.executeExact((Frame)frame, inliningTarget, indexNode.execute((Frame)frame, inliningTarget, posArg));
            int endPos = asSizeNode.executeExact((Frame)frame, inliningTarget, indexNode.execute((Frame)frame, inliningTarget, endPosArg));
            int length = lengthNode.execute((Frame)frame, inliningTarget, input);
            if (pos < 0) {
                pos = 0;
            } else if (pos > length) {
                pos = length;
            }
            if (endPos < 0) {
                endPos = 0;
            } else if (endPos > length) {
                endPos = length;
            }
            reCheckInputTypeNode.execute(frame, input, tRegexCache.isBinary());
            if (fallbackProfile.profile(inliningTarget, libCompiledRegex.isNull(compiledRegex))) {
                Object fallbackRegex = this.getCallFallbackCompileNode().executeWithoutFrame(this.getGetFallbackCompileNode().executeObject(frame, pattern), new Object[0]);
                return this.getCallFallbackMethodNode().executeWithoutFrame(getFallbackMethodNode.executeObject(frame, fallbackRegex), input, pos, endPos);
            }
            Object truncatedInput = input;
            if (truncatingInputProfile.profile(inliningTarget, endPos != length)) {
                truncatedInput = this.getGetItemNode().executeCached((Frame)frame, input, this.getCreateSliceNode().execute(0, endPos, 1));
            }
            Object regexResult = tRegexCallExec.execute(frame, compiledRegex, truncatedInput, pos);
            return createMatchFromTRegexResultNode.execute(frame, inliningTarget, pattern, pos, endPos, regexResult, input);
        }

        @Specialization(guards={"tRegexCompileNode.execute(frame, pattern, method, mustAdvance) == compiledRegex", "method == cachedMethod", "mustAdvance == cachedMustAdvance", "!tRegexCache.isLocaleSensitive()"}, limit="1", replaces={"doCached"})
        protected Object doCachedRegex(VirtualFrame frame, PythonObject pattern, Object input, Object posArg, Object endPosArg, PythonMethod method, boolean mustAdvance, @Bind Node inliningTarget, @Cached(value="method") PythonMethod cachedMethod, @Cached(value="mustAdvance") boolean cachedMustAdvance, @Cached @Cached.Shared TRegexCompile tRegexCompileNode, @Cached(value="getTRegexCache(pattern)", weak=true) TRegexCache tRegexCache, @Cached(value="tRegexCompileNode.execute(frame, pattern, method, mustAdvance)") Object compiledRegex, @Cached @Cached.Shared InlinedConditionProfile fallbackProfile, @Cached @Cached.Shared InlinedConditionProfile truncatingInputProfile, @Cached @Cached.Shared RECheckInputTypeNode reCheckInputTypeNode, @Cached @Cached.Shared PyNumberIndexNode indexNode, @Cached @Cached.Shared PyNumberAsSizeNode asSizeNode, @Cached @Cached.Shared PyObjectSizeNode lengthNode, @CachedLibrary(limit="1") @Cached.Shared InteropLibrary libCompiledRegex, @Cached(value="create(method.getMethodName())") GetAttributeNode getFallbackMethodNode, @Cached @Cached.Shared TRegexCallExec tRegexCallExec, @Cached @Cached.Shared CreateMatchFromTRegexResultNode createMatchFromTRegexResultNode) {
            return this.doCached(frame, pattern, input, posArg, endPosArg, method, mustAdvance, inliningTarget, pattern, cachedMethod, mustAdvance, tRegexCompileNode, tRegexCache, compiledRegex, fallbackProfile, truncatingInputProfile, reCheckInputTypeNode, indexNode, asSizeNode, lengthNode, libCompiledRegex, getFallbackMethodNode, tRegexCallExec, createMatchFromTRegexResultNode);
        }

        @Specialization(guards={"method == cachedMethod"}, limit="PYTHON_METHOD_COUNT", replaces={"doCached", "doCachedRegex"})
        @ReportPolymorphism.Megamorphic
        protected Object doDynamic(VirtualFrame frame, PythonObject pattern, Object input, Object posArg, Object endPosArg, PythonMethod method, boolean mustAdvance, @Bind Node inliningTarget, @Cached(value="method") PythonMethod cachedMethod, @Cached @Cached.Shared TRegexCompile tRegexCompileNode, @Cached @Cached.Shared PyNumberIndexNode indexNode, @Cached @Cached.Shared PyNumberAsSizeNode asSizeNode, @Cached @Cached.Shared RECheckInputTypeNode reCheckInputTypeNode, @Cached @Cached.Shared PyObjectSizeNode lengthNode, @Cached @Cached.Shared InlinedConditionProfile fallbackProfile, @Cached @Cached.Shared InlinedConditionProfile truncatingInputProfile, @CachedLibrary(limit="1") @Cached.Shared InteropLibrary libCompiledRegex, @Cached(value="create(method.getMethodName())") GetAttributeNode getFallbackMethodNode, @Cached @Cached.Shared TRegexCallExec tRegexCallExec, @Cached @Cached.Shared CreateMatchFromTRegexResultNode createMatchFromTRegexResultNode) {
            TRegexCache tRegexCache = this.getTRegexCache(pattern);
            Object compiledRegex = tRegexCompileNode.execute(frame, pattern, (Object)method, mustAdvance);
            return this.doCached(frame, pattern, input, posArg, endPosArg, method, mustAdvance, inliningTarget, pattern, cachedMethod, mustAdvance, tRegexCompileNode, tRegexCache, compiledRegex, fallbackProfile, truncatingInputProfile, reCheckInputTypeNode, indexNode, asSizeNode, lengthNode, libCompiledRegex, getFallbackMethodNode, tRegexCallExec, createMatchFromTRegexResultNode);
        }

        protected TRegexCache getTRegexCache(PythonObject pattern) {
            return (TRegexCache)this.readCacheNode.executeCached(pattern, HiddenAttr.TREGEX_CACHE, null);
        }

        private GetAttributeNode getGetFallbackCompileNode() {
            if (this.getFallbackCompileNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getFallbackCompileNode = (GetAttributeNode)this.insert(GetAttributeNode.create(T__PATTERN__FALLBACK_COMPILE));
            }
            return this.getFallbackCompileNode;
        }

        private CallNode getCallFallbackCompileNode() {
            if (this.callFallbackCompileNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callFallbackCompileNode = (CallNode)this.insert(CallNode.create());
            }
            return this.callFallbackCompileNode;
        }

        private CallNode getCallFallbackMethodNode() {
            if (this.callFallbackMethodNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.callFallbackMethodNode = (CallNode)this.insert(CallNode.create());
            }
            return this.callFallbackMethodNode;
        }

        private SliceNodes.CreateSliceNode getCreateSliceNode() {
            if (this.createSliceNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.createSliceNode = (SliceNodes.CreateSliceNode)this.insert(SliceNodes.CreateSliceNode.create());
            }
            return this.createSliceNode;
        }

        private PyObjectGetItem getGetItemNode() {
            if (this.getItemNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getItemNode = (PyObjectGetItem)this.insert(PyObjectGetItem.create());
            }
            return this.getItemNode;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class CreateMatchFromTRegexResultNode
    extends PNodeWithContext {
        private static final TruffleString T_MATCH_CONSTRUCTOR = PythonUtils.tsLiteral("Match");
        private static final TruffleString T__PATTERN__INDEXGROUP = PythonUtils.tsLiteral("_Pattern__indexgroup");

        CreateMatchFromTRegexResultNode() {
        }

        public abstract Object execute(VirtualFrame var1, Node var2, Object var3, int var4, int var5, Object var6, Object var7);

        @Specialization
        static Object createMatch(VirtualFrame frame, Node inliningTarget, Object pattern, int pos, int endPos, Object regexResult, Object input, @Cached GetMatchConstructorNode getConstructor, @Cached InlinedConditionProfile matchProfile, @CachedLibrary(limit="1") InteropLibrary libResult, @Cached PyObjectLookupAttr lookupIndexGroupNode, @Cached(inline=false) CallNode constructResultNode) {
            try {
                if (matchProfile.profile(inliningTarget, ((Boolean)libResult.readMember(regexResult, "isMatch")).booleanValue())) {
                    Object indexGroup = lookupIndexGroupNode.execute((Frame)frame, inliningTarget, pattern, T__PATTERN__INDEXGROUP);
                    return constructResultNode.execute((Frame)frame, getConstructor.execute(inliningTarget), pattern, pos, endPos, regexResult, input, indexGroup);
                }
                return PNone.NONE;
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        @GenerateInline
        @GenerateCached(value=false)
        static abstract class GetMatchConstructorNode
        extends PNodeWithContext {
            GetMatchConstructorNode() {
            }

            public abstract Object execute(Node var1);

            @Specialization(guards={"isSingleContext()"})
            static Object doSingleContext(@Cached(value="lookupMatchConstructor()") Object constructor) {
                return constructor;
            }

            @Specialization(replaces={"doSingleContext"})
            static Object doRead(@Bind PythonContext context, @Cached ReadAttributeFromObjectNode read) {
                PythonModule module = context.lookupBuiltinModule(BuiltinNames.T__SRE);
                return read.execute(module, T_MATCH_CONSTRUCTOR);
            }

            @CompilerDirectives.TruffleBoundary
            @NeverDefault
            protected static Object lookupMatchConstructor() {
                PythonModule module = PythonContext.get(null).lookupBuiltinModule(BuiltinNames.T__SRE);
                return PyObjectLookupAttr.executeUncached(module, T_MATCH_CONSTRUCTOR);
            }
        }
    }

    @GenerateInline(value=false)
    static abstract class RECheckInputTypeNode
    extends Node {
        private static final TruffleString T_UNSUPPORTED_INPUT_TYPE = PythonUtils.tsLiteral("expected string or bytes-like object");
        private static final TruffleString T_UNEXPECTED_BYTES = PythonUtils.tsLiteral("cannot use a string pattern on a bytes-like object");
        private static final TruffleString T_UNEXPECTED_STR = PythonUtils.tsLiteral("cannot use a bytes pattern on a string-like object");

        RECheckInputTypeNode() {
        }

        public abstract void execute(VirtualFrame var1, Object var2, boolean var3);

        @Specialization
        static void check(Object input, boolean expectBytes, @Bind Node inliningTarget, @Cached PyUnicodeCheckNode unicodeCheckNode, @Cached BytesNodes.BytesLikeCheck bytesLikeCheck, @Cached PRaiseNode unexpectedStrRaise, @Cached PRaiseNode unexpectedBytesRaise, @Cached PRaiseNode unexpectedTypeRaise) {
            if (unicodeCheckNode.execute(inliningTarget, input)) {
                if (expectBytes) {
                    throw unexpectedStrRaise.raise(inliningTarget, PythonErrorType.TypeError, T_UNEXPECTED_STR);
                }
                return;
            }
            if (bytesLikeCheck.execute(inliningTarget, input) || input instanceof PMMap || input instanceof PMemoryView || input instanceof PArray) {
                if (!expectBytes) {
                    throw unexpectedBytesRaise.raise(inliningTarget, PythonErrorType.TypeError, T_UNEXPECTED_BYTES);
                }
                return;
            }
            throw unexpectedTypeRaise.raise(inliningTarget, PythonErrorType.TypeError, T_UNSUPPORTED_INPUT_TYPE);
        }
    }

    @Builtin(name="tregex_compile", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    @ImportStatic(value={PythonMethod.class})
    static abstract class TRegexCompile
    extends PythonTernaryBuiltinNode {
        @Node.Child
        private HiddenAttr.ReadNode readCacheNode = HiddenAttr.ReadNode.create();
        private static final TruffleString T__GETLOCALE = PythonUtils.tsLiteral("_getlocale");
        protected static final int SPECIALIZATION_LIMIT = 2 * PythonMethod.PYTHON_METHOD_COUNT;

        TRegexCompile() {
        }

        @Specialization(guards={"getTRegexCache(pattern) == cachedTRegexCache", "method == cachedMethod", "mustAdvance == cachedMustAdvance", "!cachedTRegexCache.isLocaleSensitive()"}, limit="2")
        Object cached(PythonObject pattern, PythonMethod method, boolean mustAdvance, @Cached(value="getTRegexCache(pattern)", weak=true) TRegexCache cachedTRegexCache, @Cached(value="method") PythonMethod cachedMethod, @Cached(value="mustAdvance") boolean cachedMustAdvance, @Cached(value="getCompiledRegex(pattern, method, mustAdvance)") Object compiledRegex) {
            return compiledRegex;
        }

        protected Object getCompiledRegex(PythonObject pattern, PythonMethod method, boolean mustAdvance) {
            return this.localeNonSensitive(pattern, method, mustAdvance, method, mustAdvance);
        }

        @Specialization(guards={"method == cachedMethod", "mustAdvance == cachedMustAdvance", "!getTRegexCache(pattern).isLocaleSensitive()"}, limit="SPECIALIZATION_LIMIT", replaces={"cached"})
        Object localeNonSensitive(PythonObject pattern, PythonMethod method, boolean mustAdvance, @Cached(value="method") PythonMethod cachedMethod, @Cached(value="mustAdvance") boolean cachedMustAdvance) {
            TRegexCache tRegexCache = this.getTRegexCache(pattern);
            Object tRegex = tRegexCache.getRegexp(method, mustAdvance);
            if (tRegex != null) {
                return tRegex;
            }
            return tRegexCache.compile(this, this.getContext(), method, mustAdvance, null);
        }

        @Specialization(guards={"method == cachedMethod", "mustAdvance == cachedMustAdvance", "getTRegexCache(pattern).isLocaleSensitive()"}, limit="SPECIALIZATION_LIMIT", replaces={"cached"})
        Object localeSensitive(VirtualFrame frame, PythonObject pattern, PythonMethod method, boolean mustAdvance, @Bind Node inliningTarget, @Cached(value="method") PythonMethod cachedMethod, @Cached(value="mustAdvance") boolean cachedMustAdvance, @Cached(value="lookupGetLocaleFunction()") Object getLocale, @Cached CallNode callGetLocale, @Cached CastToTruffleStringNode castToTruffleStringNode) {
            TruffleString locale;
            TRegexCache tRegexCache = this.getTRegexCache(pattern);
            Object tRegex = tRegexCache.getLocaleSensitiveRegexp(method, mustAdvance, locale = castToTruffleStringNode.execute(inliningTarget, callGetLocale.execute((Frame)frame, getLocale, new Object[0])));
            if (tRegex != null) {
                return tRegex;
            }
            return tRegexCache.compile(this, this.getContext(), method, mustAdvance, locale);
        }

        @CompilerDirectives.TruffleBoundary
        @NeverDefault
        protected Object lookupGetLocaleFunction() {
            PythonModule module = this.getContext().lookupBuiltinModule(BuiltinNames.T__SRE);
            return PyObjectLookupAttr.executeUncached(module, T__GETLOCALE);
        }

        protected TRegexCache getTRegexCache(PythonObject pattern) {
            return (TRegexCache)this.readCacheNode.executeCached(pattern, HiddenAttr.TREGEX_CACHE, null);
        }
    }

    @Builtin(name="tregex_init_cache", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    static abstract class TRegexInitCache
    extends PythonTernaryBuiltinNode {
        TRegexInitCache() {
        }

        @Specialization
        Object call(VirtualFrame frame, PythonObject patternObject, Object pattern, Object flags, @Bind Node inliningTarget, @Cached PyLongAsIntNode flagsToIntNode, @Cached HiddenAttr.WriteNode writeCacheNode) {
            int flagsStr = flagsToIntNode.execute((Frame)frame, inliningTarget, flags);
            TRegexCache tRegexCache = new TRegexCache(inliningTarget, pattern, flagsStr);
            writeCacheNode.execute(inliningTarget, patternObject, HiddenAttr.TREGEX_CACHE, tRegexCache);
            return PNone.NONE;
        }
    }

    public static final class TRegexCache {
        private final Object originalPattern;
        private final String pattern;
        private final String flags;
        private final boolean binary;
        private final boolean localeSensitive;
        private Object searchRegexp;
        private Object matchRegexp;
        private Object fullMatchRegexp;
        private Object mustAdvanceSearchRegexp;
        private Object mustAdvanceMatchRegexp;
        private Object mustAdvanceFullMatchRegexp;
        private final EconomicMap<RegexKey, Object> localeSensitiveRegexps;
        private static final String ENCODING_UTF_32 = "Encoding=UTF-32";
        private static final String ENCODING_LATIN_1 = "Encoding=LATIN-1";
        private static final TruffleString T_ERROR = PythonUtils.tsLiteral("error");
        private static final TruffleString T_VALUE_ERROR_UNICODE_FLAG_BYTES_PATTERN = PythonUtils.tsLiteral("cannot use UNICODE flag with a bytes pattern");
        private static final TruffleString T_VALUE_ERROR_LOCALE_FLAG_STR_PATTERN = PythonUtils.tsLiteral("cannot use LOCALE flag with a str pattern");
        private static final TruffleString T_VALUE_ERROR_ASCII_UNICODE_INCOMPATIBLE = PythonUtils.tsLiteral("ASCII and UNICODE flags are incompatible");
        private static final TruffleString T_VALUE_ERROR_ASCII_LOCALE_INCOMPATIBLE = PythonUtils.tsLiteral("ASCII and LOCALE flags are incompatible");
        private static final int FLAG_IGNORECASE = 2;
        private static final int FLAG_LOCALE = 4;
        private static final int FLAG_MULTILINE = 8;
        private static final int FLAG_DOTALL = 16;
        private static final int FLAG_UNICODE = 32;
        private static final int FLAG_VERBOSE = 64;
        private static final int FLAG_ASCII = 256;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        public TRegexCache(Node node, Object pattern, int flags) {
            String patternStr;
            this.originalPattern = pattern;
            boolean binary = true;
            try {
                patternStr = CastToTruffleStringNode.executeUncached(pattern).toJavaStringUncached();
                binary = false;
            }
            catch (CannotCastException ce) {
                Object buffer;
                try {
                    buffer = PythonBufferAcquireLibrary.getUncached().acquireReadonly(pattern);
                }
                catch (PException e) {
                    throw PRaiseNode.raiseStatic(node, PythonErrorType.TypeError, ErrorMessages.EXPECTED_STR_OR_BYTESLIKE_OBJ);
                }
                PythonBufferAccessLibrary bufferLib = PythonBufferAccessLibrary.getUncached();
                try {
                    byte[] bytes = bufferLib.getInternalOrCopiedByteArray(buffer);
                    int bytesLen = bufferLib.getBufferLength(buffer);
                    patternStr = new String(bytes, 0, bytesLen, StandardCharsets.ISO_8859_1);
                }
                finally {
                    bufferLib.release(buffer);
                }
            }
            this.pattern = patternStr;
            this.binary = binary;
            this.flags = TRegexCache.getTRegexFlags(flags);
            this.localeSensitive = this.calculateLocaleSensitive();
            this.localeSensitiveRegexps = this.localeSensitive ? EconomicMap.create() : null;
        }

        public boolean isBinary() {
            return this.binary;
        }

        @Idempotent
        public boolean isLocaleSensitive() {
            return this.localeSensitive;
        }

        private static String getTRegexFlags(int flags) {
            StringBuilder sb = new StringBuilder();
            if ((flags & 2) != 0) {
                sb.append('i');
            }
            if ((flags & 4) != 0) {
                sb.append('L');
            }
            if ((flags & 8) != 0) {
                sb.append('m');
            }
            if ((flags & 0x10) != 0) {
                sb.append('s');
            }
            if ((flags & 0x20) != 0) {
                sb.append('u');
            }
            if ((flags & 0x40) != 0) {
                sb.append('x');
            }
            if ((flags & 0x100) != 0) {
                sb.append('a');
            }
            return sb.toString();
        }

        private boolean calculateLocaleSensitive() {
            if (!this.isBinary()) {
                return false;
            }
            if (this.flags.indexOf(76) != -1) {
                return true;
            }
            int position = 0;
            while (position < this.pattern.length() && (position = this.pattern.indexOf("(?", position)) != -1) {
                int backslashPosition;
                for (backslashPosition = position - 1; backslashPosition >= 0 && this.pattern.charAt(backslashPosition) == '\\'; --backslashPosition) {
                }
                if (((position += 2) - backslashPosition) % 2 == 0) continue;
                while (position < this.pattern.length() && "aiLmsux".indexOf(this.pattern.charAt(position)) != -1) {
                    if (this.pattern.charAt(position) == 'L') {
                        return true;
                    }
                    ++position;
                }
            }
            return false;
        }

        public Object getRegexp(PythonMethod method, boolean mustAdvance) {
            assert (!this.isLocaleSensitive());
            switch (method.ordinal()) {
                case 0: {
                    if (mustAdvance) {
                        return this.mustAdvanceSearchRegexp;
                    }
                    return this.searchRegexp;
                }
                case 1: {
                    if (mustAdvance) {
                        return this.mustAdvanceMatchRegexp;
                    }
                    return this.matchRegexp;
                }
                case 2: {
                    if (mustAdvance) {
                        return this.mustAdvanceFullMatchRegexp;
                    }
                    return this.fullMatchRegexp;
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        @CompilerDirectives.TruffleBoundary
        public Object getLocaleSensitiveRegexp(PythonMethod method, boolean mustAdvance, TruffleString locale) {
            assert (this.isLocaleSensitive());
            return this.localeSensitiveRegexps.get((Object)new RegexKey(method, mustAdvance, locale));
        }

        private void setRegexp(PythonMethod method, boolean mustAdvance, Object regexp) {
            assert (!this.isLocaleSensitive());
            switch (method.ordinal()) {
                case 0: {
                    if (mustAdvance) {
                        this.mustAdvanceSearchRegexp = regexp;
                        break;
                    }
                    this.searchRegexp = regexp;
                    break;
                }
                case 1: {
                    if (mustAdvance) {
                        this.mustAdvanceMatchRegexp = regexp;
                        break;
                    }
                    this.matchRegexp = regexp;
                    break;
                }
                case 2: {
                    if (mustAdvance) {
                        this.mustAdvanceFullMatchRegexp = regexp;
                        break;
                    }
                    this.fullMatchRegexp = regexp;
                }
            }
        }

        @CompilerDirectives.TruffleBoundary
        private void setLocaleSensitiveRegexp(PythonMethod method, boolean mustAdvance, TruffleString locale, Object regexp) {
            assert (this.isLocaleSensitive());
            this.localeSensitiveRegexps.put((Object)new RegexKey(method, mustAdvance, locale), regexp);
        }

        private String getTRegexOptions(String encoding, PythonMethod pythonMethod, boolean mustAdvance, TruffleString locale) {
            StringBuilder sb = new StringBuilder();
            sb.append("Flavor=Python");
            sb.append(',');
            sb.append(encoding);
            sb.append(',');
            sb.append(pythonMethod.getTRegexOption());
            if (mustAdvance) {
                sb.append(',');
                sb.append("MustAdvance=true");
            }
            if (locale != null) {
                sb.append(',');
                sb.append("PythonLocale=" + locale.toJavaStringUncached());
            }
            return sb.toString();
        }

        @CompilerDirectives.TruffleBoundary
        public Object compile(Node node, PythonContext context, PythonMethod method, boolean mustAdvance, TruffleString locale) {
            Object regexp;
            String encoding = this.isBinary() ? ENCODING_LATIN_1 : ENCODING_UTF_32;
            String options = this.getTRegexOptions(encoding, method, mustAdvance, locale);
            InteropLibrary lib = InteropLibrary.getUncached();
            try {
                Source regexSource = Source.newBuilder((String)"regex", (CharSequence)(options + "/" + this.pattern + "/" + this.flags), (String)"re").mimeType("application/tregex").internal(true).build();
                Object compiledRegex = context.getEnv().parseInternal(regexSource, new String[0]).call(new Object[0]);
                regexp = lib.isNull(compiledRegex) ? PNone.NONE : compiledRegex;
            }
            catch (RuntimeException e) {
                throw this.handleCompilationError(node, e, lib, context);
            }
            if (this.isLocaleSensitive()) {
                this.setLocaleSensitiveRegexp(method, mustAdvance, locale, regexp);
            } else {
                this.setRegexp(method, mustAdvance, regexp);
            }
            return regexp;
        }

        private RuntimeException handleCompilationError(Node node, RuntimeException e, InteropLibrary lib, PythonContext context) {
            try {
                if (lib.isException((Object)e) && lib.getExceptionType((Object)e) == ExceptionType.PARSE_ERROR) {
                    TruffleString reason = lib.asTruffleString(lib.getExceptionMessage((Object)e)).switchEncodingUncached(PythonUtils.TS_ENCODING);
                    if (reason.equalsUncached((AbstractTruffleString)T_VALUE_ERROR_UNICODE_FLAG_BYTES_PATTERN, PythonUtils.TS_ENCODING) || reason.equalsUncached((AbstractTruffleString)T_VALUE_ERROR_LOCALE_FLAG_STR_PATTERN, PythonUtils.TS_ENCODING) || reason.equalsUncached((AbstractTruffleString)T_VALUE_ERROR_ASCII_UNICODE_INCOMPATIBLE, PythonUtils.TS_ENCODING) || reason.equalsUncached((AbstractTruffleString)T_VALUE_ERROR_ASCII_LOCALE_INCOMPATIBLE, PythonUtils.TS_ENCODING)) {
                        return PRaiseNode.raiseStatic(node, PythonErrorType.ValueError, reason);
                    }
                    SourceSection sourceSection = lib.getSourceLocation((Object)e);
                    int position = sourceSection.getCharIndex();
                    PythonModule module = context.lookupBuiltinModule(BuiltinNames.T__SRE);
                    Object errorConstructor = PyObjectLookupAttr.executeUncached(module, T_ERROR);
                    PBaseException exception = (PBaseException)CallNode.executeUncached(errorConstructor, reason, this.originalPattern, position);
                    return PRaiseNode.raiseExceptionObjectStatic(node, exception);
                }
            }
            catch (UnsupportedMessageException e1) {
                return CompilerDirectives.shouldNotReachHere();
            }
            return e;
        }

        private static final class RegexKey {
            private final PythonMethod pythonMethod;
            private final boolean mustAdvance;
            private final TruffleString pythonLocale;

            RegexKey(PythonMethod pythonMethod, boolean mustAdvance, TruffleString pythonLocale) {
                this.pythonMethod = pythonMethod;
                this.mustAdvance = mustAdvance;
                this.pythonLocale = pythonLocale;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof RegexKey)) {
                    return false;
                }
                RegexKey other = (RegexKey)obj;
                return this.pythonMethod == other.pythonMethod && this.mustAdvance == other.mustAdvance && this.pythonLocale.equalsUncached((AbstractTruffleString)other.pythonLocale, PythonUtils.TS_ENCODING);
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.pythonMethod, this.mustAdvance, this.pythonLocale});
            }
        }
    }
}

