/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.sql.Date;
import java.sql.SQLException;
import java.time.OffsetDateTime;
import java.util.Calendar;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.field.AbstractWithTimeZoneField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

class FBTimestampTzField
extends AbstractWithTimeZoneField {
    FBTimestampTzField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getOffsetDateTime();
    }

    @Override
    public Date getDate() throws SQLException {
        OffsetDateTime offsetDateTime = this.getOffsetDateTime();
        if (offsetDateTime == null) {
            return null;
        }
        return new Date(offsetDateTime.toInstant().toEpochMilli());
    }

    @Override
    public Date getDate(Calendar cal) throws SQLException {
        return this.getDate();
    }

    @Override
    public void setDate(Date value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        OffsetDateTime offsetDateTime = value.toLocalDate().atStartOfDay().atZone(this.getDefaultZoneId()).toOffsetDateTime();
        this.setOffsetDateTime(offsetDateTime);
    }

    @Override
    public void setDate(Date value, Calendar cal) throws SQLException {
        this.setDate(value);
    }

    @Override
    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return String.valueOf(this.getOffsetDateTime());
    }
}

