/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.DataTruncation;
import java.sql.RowId;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.FBRowId;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.util.IOUtils;

class FBBinaryField
extends FBField {
    FBBinaryField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getBytes();
    }

    @Override
    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDatatypeCoder().decodeString(this.getFieldData());
    }

    @Override
    public void setString(String value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        this.setBytes(this.getDatatypeCoder().encodeString(value));
    }

    @Override
    public byte[] getBytes() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return (byte[])this.getFieldData().clone();
    }

    @Override
    public void setBytes(byte[] value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        if (value.length > this.fieldDescriptor.getLength()) {
            throw new DataTruncation(this.fieldDescriptor.getPosition() + 1, true, false, value.length, this.fieldDescriptor.getLength());
        }
        this.setFieldData(value);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new ByteArrayInputStream(this.getFieldData());
    }

    @Override
    protected void setBinaryStreamInternal(InputStream in, long length) throws SQLException {
        if (this.setWhenNull(in)) {
            return;
        }
        if (length > (long)this.fieldDescriptor.getLength()) {
            throw new DataTruncation(this.fieldDescriptor.getPosition() + 1, true, false, (int)length, this.fieldDescriptor.getLength());
        }
        try {
            this.setBytes(IOUtils.toBytes(in, (int)length));
        }
        catch (IOException ioex) {
            SQLException conversionException = this.invalidSetConversion(InputStream.class);
            conversionException.initCause(ioex);
            throw conversionException;
        }
    }

    @Override
    protected void setCharacterStreamInternal(Reader in, long length) throws SQLException {
        if (this.setWhenNull(in)) {
            return;
        }
        if (length > (long)this.fieldDescriptor.getLength()) {
            throw new DataTruncation(this.fieldDescriptor.getPosition() + 1, true, false, (int)length, this.fieldDescriptor.getLength());
        }
        try {
            this.setString(IOUtils.toString(in, (int)length));
        }
        catch (IOException ioex) {
            SQLException conversionException = this.invalidSetConversion(Reader.class);
            conversionException.initCause(ioex);
            throw conversionException;
        }
    }

    @Override
    public RowId getRowId() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new FBRowId(this.getBytes());
    }

    @Override
    public void setRowId(RowId value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        this.setBytes(value.getBytes());
    }
}

