/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.profiler;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

final class JoinableExecutors {
    private JoinableExecutors() {
    }

    static ExecutorService newSingleThreadExecutor(ThreadFactory threadFactory) {
        return new JoinableThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory threadFactory) {
        return new JoinableScheduledThreadPoolExecutor(1, threadFactory);
    }

    private static final class JoinableThreadPoolExecutor
    extends ThreadPoolExecutor {
        JoinableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, new ThreadCollectingFactory(threadFactory));
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return ((ThreadCollectingFactory)this.getThreadFactory()).join(timeout, unit);
        }
    }

    private static final class JoinableScheduledThreadPoolExecutor
    extends ScheduledThreadPoolExecutor {
        JoinableScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
            super(corePoolSize, new ThreadCollectingFactory(threadFactory));
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return ((ThreadCollectingFactory)this.getThreadFactory()).join(timeout, unit);
        }
    }

    private static final class ThreadCollectingFactory
    implements ThreadFactory {
        private final ThreadFactory delegate;
        private final Set<Thread> threads = Collections.newSetFromMap(new ConcurrentHashMap());

        ThreadCollectingFactory(ThreadFactory delegate) {
            this.delegate = delegate;
        }

        boolean join(long timeout, TimeUnit unit) throws InterruptedException {
            long timeoutNanos = unit.toNanos(timeout);
            for (Thread thread : this.threads) {
                long joinStart = System.nanoTime();
                TimeUnit.NANOSECONDS.timedJoin(thread, timeoutNanos);
                long joinEnd = System.nanoTime();
                if ((timeoutNanos -= joinEnd - joinStart) > 0L) continue;
                return false;
            }
            return true;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread result = this.delegate.newThread(r);
            this.threads.add(result);
            return result;
        }
    }
}

