/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.network;

import com.jetbrains.cef.remote.CefServer;
import com.jetbrains.cef.remote.network.RemoteCookieManagerImpl;
import com.jetbrains.cef.remote.thrift_codegen.Cookie;
import java.util.Date;
import org.cef.callback.CefCompletionCallback;
import org.cef.callback.CefCookieVisitor;
import org.cef.network.CefCookie;
import org.cef.network.CefCookieManager;

public class RemoteCookieManager
extends CefCookieManager {
    RemoteCookieManagerImpl myImpl;
    private volatile boolean myIsDisposed = false;

    private RemoteCookieManager(CefServer server) {
        server.onConnected(() -> {
            this.myImpl = RemoteCookieManagerImpl.create(server.getRpcContext());
        }, "CookieManager_Create", true);
    }

    public static RemoteCookieManager createGlobal(CefServer server) {
        return new RemoteCookieManager(server);
    }

    @Override
    public void dispose() {
        this.myIsDisposed = true;
    }

    @Override
    public boolean visitAllCookies(CefCookieVisitor visitor) {
        if (this.myImpl != null) {
            if (this.myIsDisposed) {
                return false;
            }
            return this.myImpl.visitAllCookies(visitor);
        }
        throw new RuntimeException("visitAllCookies: connection with cef_server wasn't established yet. Consider subscribing on JCEF initialisation(see CefApp#onInitialization)");
    }

    @Override
    public boolean visitUrlCookies(String url, boolean includeHttpOnly, CefCookieVisitor visitor) {
        if (this.myImpl != null) {
            if (this.myIsDisposed) {
                return false;
            }
            return this.myImpl.visitUrlCookies(url, includeHttpOnly, visitor);
        }
        throw new RuntimeException("visitUrlCookies: connection with cef_server wasn't established yet. Consider subscribing on JCEF initialisation(see CefApp#onInitialization)");
    }

    @Override
    public boolean setCookie(String url, CefCookie cookie) {
        if (this.myImpl != null) {
            if (this.myIsDisposed) {
                return false;
            }
            return this.myImpl.setCookie(url, cookie);
        }
        throw new RuntimeException("setCookie: connection with cef_server wasn't established yet. Consider subscribing on JCEF initialisation(see CefApp#onInitialization)");
    }

    @Override
    public boolean deleteCookies(String url, String cookieName) {
        if (this.myImpl != null) {
            if (this.myIsDisposed) {
                return false;
            }
            return this.myImpl.deleteCookies(url, cookieName);
        }
        throw new RuntimeException("deleteCookies: connection with cef_server wasn't established yet. Consider subscribing on JCEF initialisation(see CefApp#onInitialization)");
    }

    @Override
    public boolean flushStore(CefCompletionCallback handler) {
        if (this.myImpl != null) {
            if (this.myIsDisposed) {
                return false;
            }
            return this.myImpl.flushStore(handler);
        }
        throw new RuntimeException("flushStore: connection with cef_server wasn't established yet. Consider subscribing on JCEF initialisation(see CefApp#onInitialization)");
    }

    public static CefCookie toCefCookie(Cookie c) {
        if (c == null) {
            return null;
        }
        Date creation = c.creation == 0L ? null : new Date(c.creation);
        Date lastAccess = c.lastAccess == 0L ? null : new Date(c.lastAccess);
        Date expires = c.isSetExpires() ? new Date(c.expires) : null;
        return new CefCookie(c.name, c.value, c.domain, c.path, c.secure, c.httponly, creation, lastAccess, expires != null, expires);
    }

    public static Cookie toThriftCookie(CefCookie c) {
        if (c == null) {
            return null;
        }
        Cookie cookie = new Cookie(c.name, c.value, c.domain, c.path, c.secure, c.httponly, c.creation == null ? 0L : c.creation.getTime(), c.lastAccess == null ? 0L : c.lastAccess.getTime());
        if (c.hasExpires && c.expires != null) {
            cookie.setExpires(c.expires.getTime());
        }
        return cookie;
    }
}

