/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.metadata;

import java.util.concurrent.atomic.AtomicReference;
import org.opensearch.common.io.IndexIOStreamHandler;
import org.opensearch.common.io.IndexIOStreamHandlerFactory;
import org.opensearch.index.store.remote.metadata.RemoteSegmentMetadata;
import org.opensearch.index.store.remote.metadata.RemoteSegmentMetadataHandler;

public class RemoteSegmentMetadataHandlerFactory
implements IndexIOStreamHandlerFactory<RemoteSegmentMetadata> {
    private final AtomicReference<IndexIOStreamHandler<RemoteSegmentMetadata>> handlerRef = new AtomicReference();

    @Override
    public IndexIOStreamHandler<RemoteSegmentMetadata> getHandler(int version) {
        IndexIOStreamHandler<RemoteSegmentMetadata> current = this.handlerRef.get();
        if (current != null) {
            return current;
        }
        IndexIOStreamHandler<RemoteSegmentMetadata> newHandler = this.createHandler(version);
        this.handlerRef.compareAndSet(null, newHandler);
        return this.handlerRef.get();
    }

    private IndexIOStreamHandler<RemoteSegmentMetadata> createHandler(int version) {
        return switch (version) {
            case 1 -> new RemoteSegmentMetadataHandler(1);
            case 2 -> new RemoteSegmentMetadataHandler(2);
            default -> throw new IllegalArgumentException("Unsupported RemoteSegmentMetadata version: " + version);
        };
    }
}

