/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.Base64;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.internal.OpaqueString;
import oracle.net.ns.NetException;
import oracle.net.nt.CustomSSLSocketFactory;
import oracle.net.nt.PEMKeyStore;
import oracle.net.nt.SSLConfig;

class DataURIKeyStore
implements Diagnosable {
    private final SSLConfig config;
    private final String uri;
    private final OpaqueString password;
    private final byte[] uriDataBytes;
    private final String uriDataStr;
    private final String resolvedKeyStoreType;
    private final KeyStore keyStore;
    private final boolean isTrustStore;
    private PEMKeyStore pemKeyStore;

    DataURIKeyStore(SSLConfig cfg, boolean isTrustStore) throws Exception {
        this.config = cfg;
        this.isTrustStore = isTrustStore;
        this.uri = isTrustStore ? cfg.getTrustStore() : cfg.getKeyStore();
        this.password = isTrustStore ? cfg.getTrustStorePassword() : cfg.getKeyStorePassword();
        this.uriDataBytes = this.decodeURIData(this.uri);
        this.uriDataStr = new String(this.uriDataBytes, StandardCharsets.UTF_8);
        this.resolvedKeyStoreType = this.resolveKeyStoreType();
        this.keyStore = CustomSSLSocketFactory.getKeyStoreInstance(this.resolvedKeyStoreType, this.getDiagnosable());
        if ("PEM".equals(this.resolvedKeyStoreType)) {
            this.loadDataURIPEMKeyStore();
        } else {
            this.loadDataURISSOKeyStore();
        }
    }

    KeyStore getKeyStore() {
        return this.keyStore;
    }

    PEMKeyStore getPemKeyStore() {
        return this.pemKeyStore;
    }

    private void loadDataURISSOKeyStore() throws Exception {
        CustomSSLSocketFactory.loadKeyStore(this.keyStore, new ByteArrayInputStream(this.uriDataBytes), this.password);
    }

    private void loadDataURIPEMKeyStore() throws Exception {
        this.pemKeyStore = new PEMKeyStore(this.config, this.keyStore, this.uriDataStr, this.isTrustStore);
    }

    private String base64Data(String dataURI) throws NetException {
        int index = dataURI.indexOf(";base64,");
        if (index == -1) {
            throw new NetException(17829, null, false, new Object[0]);
        }
        return dataURI.substring(index + ";base64,".length());
    }

    private byte[] decodeURIData(String uri) throws NetException {
        try {
            return Base64.getDecoder().decode(this.base64Data(uri));
        }
        catch (IllegalArgumentException e) {
            throw (NetException)new NetException(17969).initCause(e);
        }
    }

    private String resolveKeyStoreType() {
        if (this.uriDataStr.startsWith("-----")) {
            return "PEM";
        }
        return "SSO";
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.config.diagnosable == null ? CommonDiagnosable.getInstance() : this.config.diagnosable;
    }
}

