/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.actions.OffRoadAction;

public class ShowWikipediaAction
extends OffRoadAction {
    private String mContent;
    private String mTitle;
    private String mArticle;

    public ShowWikipediaAction(OsmWindow pContext, String pContent, String pTitle, String pArticle) {
        super(pContext);
        this.mContent = pContent;
        this.mTitle = pTitle;
        this.mArticle = pArticle;
    }

    @Override
    public void actionPerformed(ActionEvent pE) {
        this.createDialog();
        this.mDialog.setTitle(this.mTitle);
        Container contentPane = this.mDialog.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        gbl.columnWeights = new double[]{1.0};
        gbl.rowWeights = new double[]{1.0};
        contentPane.setLayout(gbl);
        int y = 0;
        String htmlContent = "<html><body><a href=''>" + this.mArticle + "</a></body></html>";
        JTextPane contentDisplay = new JTextPane();
        contentDisplay.setContentType("text/html");
        contentDisplay.setText(this.mContent);
        contentDisplay.setEditable(false);
        contentDisplay.setBackground(null);
        contentDisplay.setBorder(null);
        JLabel articleLabel = new JLabel(htmlContent);
        articleLabel.setCursor(new Cursor(12));
        articleLabel.setToolTipText(this.mArticle);
        articleLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI(ShowWikipediaAction.this.mArticle));
                }
                catch (IOException | URISyntaxException ex) {
                    ex.printStackTrace();
                }
            }
        });
        contentPane.add((Component)new JScrollPane(contentDisplay), new GridBagConstraints(0, y++, 4, 1, 4.0, 10.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        contentPane.add((Component)articleLabel, new GridBagConstraints(0, y++, 4, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JButton okButton = new JButton(this.mContext.getString(720));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                ShowWikipediaAction.this.disposeDialog();
            }
        });
        contentPane.add((Component)okButton, new GridBagConstraints(3, y++, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mDialog.getRootPane().setDefaultButton(okButton);
        this.mDialog.pack();
        this.mDialog.setVisible(true);
    }

    @Override
    public void save() {
    }
}

