/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTable;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.data.TableCell;
import org.assertj.swing.dependency.jsr305.Nonnull;

public final class JTableLocation {
    @Nonnull
    @RunsInCurrentThread
    public Point pointAt(@Nonnull JTable table, int row, int column) {
        Rectangle cellBounds = this.cellBounds(table, row, column);
        return new Point(cellBounds.x + cellBounds.width / 2, cellBounds.y + cellBounds.height / 2);
    }

    @Nonnull
    @RunsInCurrentThread
    public Rectangle cellBounds(@Nonnull JTable table, @Nonnull TableCell cell) {
        return this.cellBounds(table, cell.row, cell.column);
    }

    @Nonnull
    @RunsInCurrentThread
    public Rectangle cellBounds(JTable table, int row, int column) {
        return (Rectangle)Preconditions.checkNotNull((Object)table.getCellRect(row, column, false));
    }
}

