/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CommitInfo;
import com.intellij.openapi.vcs.checkin.CommitProblemWithDetails;
import com.intellij.openapi.vcs.checkin.TodoCheckinHandler;
import com.intellij.openapi.vcs.checkin.TodoCheckinHandlerWorker;
import com.intellij.psi.search.TodoItem;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0014\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/checkin/TodoCommitProblem;", "Lcom/intellij/openapi/vcs/checkin/CommitProblemWithDetails;", "worker", "Lcom/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker;", "isPostCommit", "", "<init>", "(Lcom/intellij/openapi/vcs/checkin/TodoCheckinHandlerWorker;Z)V", "text", "", "getText", "()Ljava/lang/String;", "showDetails", "", "project", "Lcom/intellij/openapi/project/Project;", "showModalSolution", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler$ReturnResult;", "commitInfo", "Lcom/intellij/openapi/vcs/checkin/CommitInfo;", "showDetailsAction", "getShowDetailsAction", "intellij.platform.vcs.impl.lang"})
public final class TodoCommitProblem
implements CommitProblemWithDetails {
    @NotNull
    private final TodoCheckinHandlerWorker worker;
    private final boolean isPostCommit;

    public TodoCommitProblem(@NotNull TodoCheckinHandlerWorker worker, boolean isPostCommit) {
        Intrinsics.checkNotNullParameter((Object)worker, (String)"worker");
        this.worker = worker;
        this.isPostCommit = isPostCommit;
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[]{this.worker.inOneList().size()};
        String string = VcsBundle.message((String)"label.todo.items.found", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void showDetails(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List<Change> list = this.worker.getChanges();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getChanges(...)");
        Collection collection = list;
        Set<TodoItem> set = this.worker.inOneList();
        Intrinsics.checkNotNullExpressionValue(set, (String)"inOneList(...)");
        TodoCheckinHandler.Companion.showTodoItems$intellij_platform_vcs_impl_lang(project, collection, (Collection<? extends TodoItem>)set, this.isPostCommit);
    }

    @NotNull
    public CheckinHandler.ReturnResult showModalSolution(@NotNull Project project, @NotNull CommitInfo commitInfo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)commitInfo, (String)"commitInfo");
        return TodoCheckinHandler.Companion.showDialog$intellij_platform_vcs_impl_lang(project, this.worker, commitInfo.getCommitActionText());
    }

    @NotNull
    public String getShowDetailsAction() {
        String string = VcsBundle.message((String)"todo.in.new.review.button", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

