/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.ui.text.paragraph.ListParagraph;
import com.intellij.ide.ui.text.paragraph.TextParagraph;
import com.intellij.ide.ui.text.parts.CodeTextPart;
import com.intellij.ide.ui.text.parts.IconTextPart;
import com.intellij.ide.ui.text.parts.IllustrationTextPart;
import com.intellij.ide.ui.text.parts.LinkTextPart;
import com.intellij.ide.ui.text.parts.RegularTextPart;
import com.intellij.ide.ui.text.parts.ShortcutTextPart;
import com.intellij.ide.ui.text.parts.TextPart;
import com.intellij.ide.util.IconWithRoundedBorder;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.JBFont;
import java.awt.Desktop;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ide/util/TipContentConverter;", "", "tipContent", "Lorg/jsoup/nodes/Element;", "iconMap", "", "", "Ljavax/swing/Icon;", "isStrict", "", "<init>", "(Lorg/jsoup/nodes/Element;Ljava/util/Map;Z)V", "convert", "", "Lcom/intellij/ide/ui/text/paragraph/TextParagraph;", "convertParagraph", "element", "convertImageParagraph", "convertListParagraph", "convertCommonParagraph", "getElementInnerText", "warnIfNotBlankNode", "", "node", "Lorg/jsoup/nodes/Node;", "handleWarning", "message", "Companion", "intellij.platform.tips"})
@SourceDebugExtension(value={"SMAP\nTipContentConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TipContentConverter.kt\ncom/intellij/ide/util/TipContentConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,211:1\n1#2:212\n*E\n"})
public final class TipContentConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Element tipContent;
    @NotNull
    private final Map<String, Icon> iconMap;
    private final boolean isStrict;
    @NotNull
    private static final Logger LOG;

    public TipContentConverter(@NotNull Element tipContent, @NotNull Map<String, ? extends Icon> iconMap, boolean isStrict) {
        Intrinsics.checkNotNullParameter((Object)tipContent, (String)"tipContent");
        Intrinsics.checkNotNullParameter(iconMap, (String)"iconMap");
        this.tipContent = tipContent;
        this.iconMap = iconMap;
        this.isStrict = isStrict;
    }

    @NotNull
    public final List<TextParagraph> convert() {
        List list = new ArrayList();
        for (Object e : this.tipContent.childNodes()) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Node node = (Node)e;
            if (node instanceof Element) {
                if (this.convertParagraph((Element)node) != null) {
                    TextParagraph it;
                    boolean bl = false;
                    list.add(it);
                }
                continue;
            }
            if (node instanceof TextNode) {
                String text;
                Intrinsics.checkNotNullExpressionValue((Object)((TextNode)node).text(), (String)"text(...)");
                if (!(!StringsKt.isBlank((CharSequence)text))) continue;
                list.add(new TextParagraph(CollectionsKt.listOf((Object)new RegularTextPart(text, false, 2, null))));
                continue;
            }
            this.warnIfNotBlankNode(node);
        }
        return list;
    }

    private final TextParagraph convertParagraph(Element element) {
        TextParagraph textParagraph;
        if (Intrinsics.areEqual((Object)element.tagName(), (Object)"p") && element.hasClass("image")) {
            textParagraph = this.convertImageParagraph(element);
        } else if (Intrinsics.areEqual((Object)element.tagName(), (Object)"p")) {
            textParagraph = this.convertCommonParagraph(element);
        } else if (Intrinsics.areEqual((Object)element.tagName(), (Object)"ul")) {
            textParagraph = this.convertListParagraph(element);
        } else {
            this.warnIfNotBlankNode((Node)element);
            textParagraph = null;
        }
        return textParagraph;
    }

    private final TextParagraph convertImageParagraph(Element element) {
        for (Object e : element.childNodes()) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Node node = (Node)e;
            if (node instanceof Element && Intrinsics.areEqual((Object)((Element)node).tagName(), (Object)"img") && node.hasAttr("src")) {
                String path;
                Intrinsics.checkNotNullExpressionValue((Object)node.attr("src"), (String)"attr(...)");
                Icon icon = this.iconMap.get(path);
                if (icon != null) {
                    IconWithRoundedBorder roundedIcon = new IconWithRoundedBorder(icon);
                    return new TextParagraph(CollectionsKt.listOf((Object)new IllustrationTextPart((Icon)roundedIcon))).editAttributes(TipContentConverter::convertImageParagraph$lambda$1);
                }
                this.handleWarning("Failed to find icon for path: " + path);
                continue;
            }
            this.warnIfNotBlankNode(node);
        }
        this.handleWarning("Not found img node in element:\n" + element);
        return null;
    }

    private final TextParagraph convertListParagraph(Element element) {
        TextParagraph textParagraph;
        List items = new ArrayList();
        for (Object e : element.childNodes()) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Node node = (Node)e;
            if (node instanceof Element && Intrinsics.areEqual((Object)((Element)node).tagName(), (Object)"li")) {
                List paragraphs = new ArrayList();
                for (Object e2 : node.childNodes()) {
                    Intrinsics.checkNotNullExpressionValue(e2, (String)"next(...)");
                    Node child = (Node)e2;
                    if (child instanceof Element) {
                        if (this.convertParagraph((Element)child) != null) {
                            TextParagraph it;
                            boolean bl = false;
                            paragraphs.add(it);
                        }
                        continue;
                    }
                    this.warnIfNotBlankNode(child);
                }
                if (!((Collection)paragraphs).isEmpty()) {
                    items.add(paragraphs);
                    continue;
                }
                this.handleWarning("List item doesn't contain any paragraph:\n" + node);
                continue;
            }
            this.warnIfNotBlankNode(node);
        }
        if (!((Collection)items).isEmpty()) {
            textParagraph = (TextParagraph)new ListParagraph(items);
        } else {
            this.handleWarning("List doesn't contain any list item:\n" + element);
            textParagraph = null;
        }
        return textParagraph;
    }

    private final TextParagraph convertCommonParagraph(Element element) {
        TextParagraph textParagraph;
        List list = new ArrayList();
        for (Object e : element.childNodes()) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Node node = (Node)e;
            if (node instanceof TextNode) {
                String string = ((TextNode)node).text();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
                list.add(new RegularTextPart(string, false, 2, null));
                continue;
            }
            if (node instanceof Element) {
                TextPart textPart;
                if (Intrinsics.areEqual((Object)((Element)node).tagName(), (Object)"b")) {
                    RegularTextPart regularTextPart;
                    RegularTextPart $this$convertCommonParagraph_u24lambda_u244 = regularTextPart = new RegularTextPart(this.getElementInnerText((Element)node), true);
                    boolean bl = false;
                    $this$convertCommonParagraph_u24lambda_u244.setFontGetter(TipContentConverter::convertCommonParagraph$lambda$4$lambda$3);
                    v2 = (TextPart)regularTextPart;
                } else if (Intrinsics.areEqual((Object)((Element)node).tagName(), (Object)"span") && ((Element)node).hasClass("control")) {
                    v2 = (TextPart)new RegularTextPart(this.getElementInnerText((Element)node), true);
                } else if (Intrinsics.areEqual((Object)((Element)node).tagName(), (Object)"span") && ((Element)node).hasClass("shortcut")) {
                    Object object;
                    text = this.getElementInnerText((Element)node);
                    delimiter = new RegularTextPart("\u00a0\u00a0", false, 2, null);
                    if (StringsKt.startsWith$default((String)text, (String)"&shortcut:", (boolean)false, (int)2, null)) {
                        ShortcutTextPart shortcutTextPart;
                        actionId = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)text, (CharSequence)"&shortcut:"), (CharSequence)";");
                        if (this.isStrict && ActionManager.getInstance().getAction((String)actionId) == null) {
                            this.handleWarning("Failed to find action with id: " + (String)actionId);
                        }
                        ShortcutTextPart $this$convertCommonParagraph_u24lambda_u245 = shortcutTextPart = new ShortcutTextPart((String)actionId, false);
                        boolean bl = false;
                        $this$convertCommonParagraph_u24lambda_u245.setDelimiter((TextPart)delimiter);
                        object = shortcutTextPart;
                    } else {
                        ShortcutTextPart $this$convertCommonParagraph_u24lambda_u246 = actionId = new ShortcutTextPart(text, true);
                        boolean bl = false;
                        $this$convertCommonParagraph_u24lambda_u246.setDelimiter((TextPart)delimiter);
                        object = actionId;
                    }
                    v2 = (TextPart)object;
                } else if (Intrinsics.areEqual((Object)((Element)node).tagName(), (Object)"span") && ((Element)node).hasClass("code_emphasis")) {
                    text = StringsKt.replace$default((String)this.getElementInnerText((Element)node), (String)" ", (String)"\u00a0", (boolean)false, (int)4, null);
                    RegularTextPart $this$convertCommonParagraph_u24lambda_u247 = delimiter = new CodeTextPart(text);
                    boolean bl = false;
                    $this$convertCommonParagraph_u24lambda_u247.setDelimiter((TextPart)new RegularTextPart("\u00a0\u00a0", false, 2, null));
                    v2 = (TextPart)delimiter;
                } else if (Intrinsics.areEqual((Object)((Element)node).tagName(), (Object)"span")) {
                    v2 = (TextPart)new RegularTextPart(this.getElementInnerText((Element)node), false, 2, null);
                } else if (Intrinsics.areEqual((Object)((Element)node).tagName(), (Object)"img") && node.hasAttr("src")) {
                    IconTextPart iconTextPart;
                    String path;
                    Intrinsics.checkNotNullExpressionValue((Object)node.attr("src"), (String)"attr(...)");
                    Icon icon = this.iconMap.get(path);
                    if (icon != null) {
                        iconTextPart = new IconTextPart(icon);
                    } else {
                        this.handleWarning("Failed to find icon for path: " + path);
                        iconTextPart = null;
                    }
                    v2 = (TextPart)iconTextPart;
                } else if (Intrinsics.areEqual((Object)((Element)node).tagName(), (Object)"a") && node.hasAttr("href")) {
                    String url;
                    Intrinsics.checkNotNullExpressionValue((Object)node.attr("href"), (String)"attr(...)");
                    v2 = (TextPart)new LinkTextPart(this.getElementInnerText((Element)node), () -> TipContentConverter.convertCommonParagraph$lambda$8(url));
                } else {
                    this.handleWarning("Found unknown node:\n" + node);
                    v2 = textPart = (TextPart)new RegularTextPart(this.getElementInnerText((Element)node), false, 2, null);
                }
                if (textPart != null) {
                    list.add(textPart);
                    continue;
                }
                this.handleWarning("Failed to covert element to text part:\n" + node);
                continue;
            }
            this.warnIfNotBlankNode(node);
        }
        if (!((Collection)list).isEmpty()) {
            textParagraph = new TextParagraph(list);
        } else {
            this.handleWarning("Paragraph is empty:\n" + element);
            textParagraph = null;
        }
        return textParagraph;
    }

    private final String getElementInnerText(Element element) {
        String string;
        if (element.childNodeSize() == 0) {
            this.handleWarning("Expected element with child node, but was:\n" + element);
            String string2 = element.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            return string2;
        }
        Node node = element.childNode(0);
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"childNode(...)");
        Node child = node;
        if (child instanceof TextNode) {
            String string3 = ((TextNode)child).text();
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        } else {
            this.handleWarning("Expected text node, but was:\n" + child);
            String string4 = child.toString();
            Intrinsics.checkNotNull((Object)string4);
            string = string4;
        }
        return string;
    }

    private final void warnIfNotBlankNode(Node node) {
        block3: {
            block2: {
                if (!(node instanceof TextNode)) break block2;
                String string = ((TextNode)node).text();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text(...)");
                if (!(!StringsKt.isBlank((CharSequence)string))) break block3;
            }
            this.handleWarning("Found unknown node:\n" + node);
        }
    }

    private final void handleWarning(String message) {
        if (this.isStrict) {
            throw new RuntimeException("Warning: " + message);
        }
        LOG.warn(message);
    }

    private static final Unit convertImageParagraph$lambda$1(SimpleAttributeSet $this$editAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$editAttributes, (String)"$this$editAttributes");
        StyleConstants.setSpaceAbove($this$editAttributes, 12.0f);
        StyleConstants.setLineSpacing($this$editAttributes, 0.0f);
        return Unit.INSTANCE;
    }

    private static final JBFont convertCommonParagraph$lambda$4$lambda$3() {
        return JBFont.h3();
    }

    private static final Unit convertCommonParagraph$lambda$8(String $url) {
        try {
            Desktop desktop;
            Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
            if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                desktop.browse(new URI($url));
            }
        }
        catch (Exception ex) {
            LOG.warn((Throwable)ex);
        }
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance(TipContentConverter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ide/util/TipContentConverter$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.tips"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

