/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.color.Illuminant;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.BaseProfiledColor;
import io.sf.carte.doc.style.css.property.ChromaticAdaption;
import io.sf.carte.doc.style.css.property.ColorProfile;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.SRGBColorProfile;
import io.sf.jclf.math.linear3.Matrices;
import java.util.Arrays;
import java.util.Objects;

class ProfiledColorImpl
extends BaseProfiledColor {
    private static final long serialVersionUID = 1L;
    private ColorProfile profile;

    ProfiledColorImpl(String profileName, ColorProfile profile, double[] components) {
        super(profileName, new PrimitiveValue[components.length]);
        this.profile = profile;
        this.setColorComponents(components);
    }

    ProfiledColorImpl(ProfiledColorImpl copyMe) {
        super(copyMe);
        this.profile = copyMe.profile;
    }

    @Override
    void set(BaseColor color) {
        super.set(color);
        this.profile = ((ProfiledColorImpl)color).profile;
    }

    @Override
    public double[] toXYZ(Illuminant white) {
        double[] comps = this.toNumberArray();
        for (int i = 0; i < comps.length; ++i) {
            comps[i] = this.profile.linearComponent(comps[i]);
        }
        double[] xyz = new double[3];
        this.profile.linearRgbToXYZ(comps[0], comps[1], comps[2], xyz);
        if (white != this.profile.getIlluminant()) {
            xyz = white == Illuminant.D50 ? ColorUtil.d65xyzToD50(xyz) : ColorUtil.d50xyzToD65(xyz);
        }
        return xyz;
    }

    @Override
    public double[] toXYZ(double[] white) {
        double[] comps = this.toNumberArray();
        for (int i = 0; i < comps.length; ++i) {
            comps[i] = this.profile.linearComponent(comps[i]);
        }
        double[] xyz = new double[3];
        this.profile.linearRgbToXYZ(comps, xyz);
        double[] wp = this.profile.getWhitePoint();
        if (!Arrays.equals(wp, white)) {
            double[][] cam = new double[3][3];
            ChromaticAdaption.chromaticAdaptionMatrix(wp, white, cam);
            double[] result = new double[3];
            Matrices.multiplyByVector3((double[][])cam, (double[])xyz, (double[])result);
            xyz = result;
        }
        return xyz;
    }

    @Override
    double[] toSRGB(boolean clamp) {
        double[] xyz = this.toXYZ(Illuminant.D65);
        double[] rgb = new double[3];
        ColorUtil.d65xyzToSRGB(xyz, rgb);
        if (!ColorUtil.rangeRoundCheck(rgb) && clamp) {
            double[] xyzD50 = ColorUtil.d65xyzToD50(xyz);
            double[] lab = new double[3];
            ColorUtil.xyzD50ToLab(xyzD50, lab);
            SRGBColorProfile profile = new SRGBColorProfile();
            ColorUtil.clampRGB(lab[0], lab[1], lab[2], profile, rgb);
        }
        return rgb;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.profile);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProfiledColorImpl other = (ProfiledColorImpl)obj;
        return Objects.equals(this.profile, other.profile);
    }

    @Override
    public ProfiledColorImpl clone() {
        return new ProfiledColorImpl(this);
    }
}

