/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.util.SecurityUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.PrivilegedAction;
import jogamp.common.Debug;
import jogamp.common.os.PlatformPropsImpl;

public class UnsafeUtil {
    static final boolean DEBUG = Debug.debug("UnsafeUtil");
    private static final Object theUnsafe;
    private static final Method unsafeCleanBB;
    private static volatile boolean hasUnsafeCleanBBError;
    private static final Method m_getObject;
    private static final Method m_putObject;
    private static final Method m_getObjectVolatile;
    private static final Method m_putObjectVolatile;
    private static final Method m_getLong;
    private static final Method m_putLong;
    private static final Method m_staticFieldOffset;
    private static final Class<?> c_illegalAccessLoggerClass;
    private static final Long o_illegalAccessLoggerOffset;
    private static final Object o_illegalAccessLoggerSync;
    private static volatile boolean hasIllegalAccessError;

    protected UnsafeUtil() {
    }

    public static boolean hasInvokeCleaner() {
        return !hasUnsafeCleanBBError;
    }

    public static boolean invokeCleaner(ByteBuffer byteBuffer) {
        if (hasUnsafeCleanBBError || !byteBuffer.isDirect()) {
            return false;
        }
        try {
            unsafeCleanBB.invoke(theUnsafe, byteBuffer);
            return true;
        }
        catch (Throwable throwable) {
            hasUnsafeCleanBBError = true;
            if (DEBUG) {
                ExceptionUtils.dumpThrowable("UnsafeUtil", throwable);
            }
            return false;
        }
    }

    public static long staticFieldOffset(Field field) {
        if (null != m_staticFieldOffset) {
            throw new UnsupportedOperationException("staticFieldOffset");
        }
        try {
            Long l = (Long)m_staticFieldOffset.invoke(theUnsafe, field);
            if (null != l) {
                return l;
            }
            throw new RuntimeException("staticFieldOffset: f " + field);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new RuntimeException("UnsafeUtil");
        }
    }

    public static Object getObject(Object object, long l) {
        if (null != m_getObject) {
            throw new UnsupportedOperationException("getObject");
        }
        try {
            return m_getObject.invoke(theUnsafe, object, l);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new RuntimeException("UnsafeUtil: o " + object + ", offset " + l, reflectiveOperationException);
        }
    }

    public static void putObject(Object object, long l, Object object2) {
        if (null != m_putObject) {
            throw new UnsupportedOperationException("putObject");
        }
        try {
            m_putObject.invoke(theUnsafe, object, l, object2);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new RuntimeException("UnsafeUtil");
        }
    }

    public static Object getObjectVolatile(Object object, long l) {
        if (null != m_getObjectVolatile) {
            throw new UnsupportedOperationException("getObjectVolatile");
        }
        try {
            return m_getObjectVolatile.invoke(theUnsafe, object, l);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new RuntimeException("UnsafeUtil");
        }
    }

    public static void putObjectVolatile(Object object, long l, Object object2) {
        if (null != m_putObjectVolatile) {
            throw new UnsupportedOperationException("putObjectVolatile");
        }
        try {
            m_putObjectVolatile.invoke(theUnsafe, object, l, object2);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new RuntimeException("UnsafeUtil");
        }
    }

    public static long getLong(Object object, long l) {
        if (null != m_getLong) {
            throw new UnsupportedOperationException("getLong");
        }
        try {
            Long l2 = (Long)m_getLong.invoke(theUnsafe, object, l);
            if (null != l2) {
                return l2;
            }
            throw new RuntimeException("getLong: o " + object + ", offset " + l);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new RuntimeException("UnsafeUtil");
        }
    }

    public static void putLong(Object object, long l, long l2) {
        if (null != m_putLong) {
            throw new UnsupportedOperationException("putLong");
        }
        try {
            m_putLong.invoke(theUnsafe, object, l);
            throw new RuntimeException("putLong: o " + object + ", offset " + l + ", x " + l2);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new RuntimeException("UnsafeUtil");
        }
    }

    public static long getLong(long l) {
        return UnsafeUtil.getLong(null, l);
    }

    public static void putLong(long l, long l2) {
        UnsafeUtil.putLong(null, l, l2);
    }

    public static boolean hasIllegalAccessLoggerAccess() {
        return !hasIllegalAccessError;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T doWithoutIllegalAccessLogger(PrivilegedAction<T> privilegedAction) throws RuntimeException {
        if (hasIllegalAccessError) return privilegedAction.run();
        Object object = o_illegalAccessLoggerSync;
        synchronized (object) {
            T t;
            Object var2_2 = null;
            Object object2 = null;
            try {
                object2 = m_getObjectVolatile.invoke(theUnsafe, c_illegalAccessLoggerClass, o_illegalAccessLoggerOffset);
                m_putObjectVolatile.invoke(theUnsafe, c_illegalAccessLoggerClass, o_illegalAccessLoggerOffset, var2_2);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                hasIllegalAccessError = true;
                if (!DEBUG) return privilegedAction.run();
                ExceptionUtils.dumpThrowable("UnsafeUtil", exception);
                return privilegedAction.run();
            }
            try {
                t = privilegedAction.run();
            }
            catch (Throwable throwable) {
                try {
                    if (!DEBUG) throw new RuntimeException(throwable);
                    throwable.printStackTrace();
                    throw new RuntimeException(throwable);
                }
                catch (Throwable throwable2) {
                    try {
                        m_putObjectVolatile.invoke(theUnsafe, c_illegalAccessLoggerClass, o_illegalAccessLoggerOffset, object2);
                        throw throwable2;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                        hasIllegalAccessError = true;
                        throw new InternalError(exception);
                    }
                }
            }
            try {
                m_putObjectVolatile.invoke(theUnsafe, c_illegalAccessLoggerClass, o_illegalAccessLoggerOffset, object2);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                hasIllegalAccessError = true;
                throw new InternalError(exception);
            }
            return t;
        }
    }

    static {
        o_illegalAccessLoggerSync = new Object();
        final Object[] objectArray = new Object[]{null};
        final Method[] methodArray = new Method[]{null};
        final Method[] methodArray2 = new Method[]{null};
        final Method[] methodArray3 = new Method[]{null, null};
        final Method[] methodArray4 = new Method[]{null, null};
        final Method[] methodArray5 = new Method[]{null, null};
        final Class[] classArray = new Class[]{null};
        final Long[] longArray = new Long[]{null};
        SecurityUtil.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                block19: {
                    Field field;
                    Class<?> clazz;
                    block14: {
                        clazz = null;
                        try {
                            clazz = Class.forName("sun.misc.Unsafe");
                            field = clazz.getDeclaredField("theUnsafe");
                            field.setAccessible(true);
                            objectArray[0] = field.get(null);
                            methodArray[0] = clazz.getMethod("invokeCleaner", ByteBuffer.class);
                            methodArray[0].setAccessible(true);
                        }
                        catch (Throwable throwable) {
                            if (!DEBUG) break block14;
                            ExceptionUtils.dumpThrowable("UnsafeUtil", throwable);
                        }
                    }
                    if (null != objectArray[0]) {
                        block18: {
                            block17: {
                                block16: {
                                    block15: {
                                        try {
                                            methodArray3[0] = clazz.getDeclaredMethod("getObject", Object.class, Long.TYPE);
                                            methodArray3[1] = clazz.getDeclaredMethod("putObject", Object.class, Long.TYPE, Object.class);
                                        }
                                        catch (Throwable throwable) {
                                            if (!DEBUG) break block15;
                                            ExceptionUtils.dumpThrowable("UnsafeUtil", throwable);
                                        }
                                    }
                                    try {
                                        methodArray4[0] = clazz.getDeclaredMethod("getObjectVolatile", Object.class, Long.TYPE);
                                        methodArray4[1] = clazz.getDeclaredMethod("putObjectVolatile", Object.class, Long.TYPE, Object.class);
                                    }
                                    catch (Throwable throwable) {
                                        if (!DEBUG) break block16;
                                        ExceptionUtils.dumpThrowable("UnsafeUtil", throwable);
                                    }
                                }
                                try {
                                    methodArray5[0] = clazz.getDeclaredMethod("getLong", Object.class, Long.TYPE);
                                    methodArray5[1] = clazz.getDeclaredMethod("putLong", Object.class, Long.TYPE, Long.TYPE);
                                }
                                catch (Throwable throwable) {
                                    if (!DEBUG) break block17;
                                    ExceptionUtils.dumpThrowable("UnsafeUtil", throwable);
                                }
                            }
                            try {
                                methodArray2[0] = clazz.getDeclaredMethod("staticFieldOffset", Field.class);
                            }
                            catch (Throwable throwable) {
                                if (!DEBUG) break block18;
                                ExceptionUtils.dumpThrowable("UnsafeUtil", throwable);
                            }
                        }
                        if (PlatformPropsImpl.JAVA_9 && null != methodArray2[0]) {
                            try {
                                classArray[0] = Class.forName("jdk.internal.module.IllegalAccessLogger");
                                field = classArray[0].getDeclaredField("logger");
                                longArray[0] = (Long)methodArray2[0].invoke(objectArray[0], field);
                            }
                            catch (Throwable throwable) {
                                if (!DEBUG) break block19;
                                ExceptionUtils.dumpThrowable("UnsafeUtil", throwable);
                            }
                        }
                    }
                }
                return null;
            }
        });
        theUnsafe = objectArray[0];
        unsafeCleanBB = methodArray[0];
        boolean bl = hasUnsafeCleanBBError = null == theUnsafe || null == unsafeCleanBB;
        if (DEBUG) {
            System.err.println("UnsafeUtil.init: hasTheUnsafe: " + (null != theUnsafe) + ", hasInvokeCleaner: " + !hasUnsafeCleanBBError);
        }
        m_staticFieldOffset = methodArray2[0];
        m_getObject = methodArray3[0];
        m_putObject = methodArray3[1];
        m_getObjectVolatile = methodArray4[0];
        m_putObjectVolatile = methodArray4[1];
        m_getLong = methodArray5[0];
        m_putLong = methodArray5[1];
        c_illegalAccessLoggerClass = classArray[0];
        o_illegalAccessLoggerOffset = longArray[0];
        boolean bl2 = hasIllegalAccessError = null == m_getObjectVolatile || null == m_putObjectVolatile || null == c_illegalAccessLoggerClass || null == o_illegalAccessLoggerOffset;
        if (DEBUG) {
            System.err.println("UnsafeUtil.init: hasUnsafeIllegalAccessLogger: " + !hasIllegalAccessError);
        }
    }
}

