/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.GraphicsNodeBridge;
import io.sf.carte.echosvg.bridge.SVGFontElementBridge;
import io.sf.carte.echosvg.gvt.font.GVTFont;
import io.sf.carte.echosvg.gvt.font.GVTFontFace;
import io.sf.carte.echosvg.gvt.font.GVTFontFamily;
import io.sf.carte.echosvg.gvt.text.GVTAttributedCharacterIterator;
import java.lang.ref.SoftReference;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVGFontFamily
implements GVTFontFamily {
    public static final AttributedCharacterIterator.Attribute TEXT_COMPOUND_ID = GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_ID;
    protected GVTFontFace fontFace;
    protected Element fontElement;
    protected BridgeContext ctx;
    protected Boolean complex = null;

    public SVGFontFamily(GVTFontFace fontFace, Element fontElement, BridgeContext ctx) {
        this.fontFace = fontFace;
        this.fontElement = fontElement;
        this.ctx = ctx;
    }

    public String getFamilyName() {
        return this.fontFace.getFamilyName();
    }

    public GVTFontFace getFontFace() {
        return this.fontFace;
    }

    public GVTFont deriveFont(float size, AttributedCharacterIterator aci) {
        return this.deriveFont(size, aci.getAttributes());
    }

    public GVTFont deriveFont(float size, Map<AttributedCharacterIterator.Attribute, ?> attrs) {
        SVGFontElementBridge fontBridge = (SVGFontElementBridge)this.ctx.getBridge(this.fontElement);
        if (fontBridge == null) {
            return null;
        }
        SoftReference sr = (SoftReference)attrs.get(TEXT_COMPOUND_ID);
        Element textElement = (Element)sr.get();
        if (textElement == null) {
            return null;
        }
        return fontBridge.createFont(this.ctx, this.fontElement, textElement, size, this.fontFace);
    }

    public boolean isComplex() {
        if (this.complex != null) {
            return this.complex;
        }
        boolean ret = SVGFontFamily.isComplex(this.fontElement, this.ctx);
        this.complex = ret ? Boolean.TRUE : Boolean.FALSE;
        return ret;
    }

    public static boolean isComplex(Element fontElement, BridgeContext ctx) {
        NodeList glyphElements = fontElement.getElementsByTagNameNS("http://www.w3.org/2000/svg", "glyph");
        int numGlyphs = glyphElements.getLength();
        for (int i = 0; i < numGlyphs; ++i) {
            Element glyph = (Element)glyphElements.item(i);
            for (Node child = glyph.getFirstChild(); child != null; child = child.getNextSibling()) {
                Element e;
                Bridge b;
                if (child.getNodeType() != 1 || (b = ctx.getBridge(e = (Element)child)) == null || !(b instanceof GraphicsNodeBridge)) continue;
                return true;
            }
        }
        return false;
    }
}

