/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.connectors;

import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import java.util.Collection;
import java.util.Collections;
import org.freeplane.plugin.codeexplorer.connectors.CodeConnectorModel;
import org.freeplane.plugin.codeexplorer.map.CodeMap;
import org.freeplane.plugin.codeexplorer.map.CodeNode;

public class CodeConnectorFilter {
    private Collection<Dependency> filteredDependencies = Collections.emptySet();

    public void setFilteredDependencies(Collection<Dependency> filteredDependencies) {
        this.filteredDependencies = filteredDependencies;
    }

    boolean isActive() {
        return !this.filteredDependencies.isEmpty();
    }

    boolean isFiltered(CodeConnectorModel connector) {
        if (this.filteredDependencies.isEmpty()) {
            return true;
        }
        return this.filteredDependencies.stream().anyMatch(d -> this.matches((Dependency)d, connector));
    }

    private boolean matches(Dependency dependency, CodeConnectorModel connector) {
        CodeNode connectorTargetNode;
        JavaClass originClass;
        CodeNode connectorSourceNode = connector.getSource();
        CodeMap map = connectorSourceNode.getMap();
        CodeNode originNode = map.getNodeByClass(originClass = dependency.getOriginClass());
        if (originNode != connectorSourceNode && !originNode.isDescendantOf(connectorSourceNode)) {
            return false;
        }
        JavaClass targetClass = dependency.getTargetClass();
        CodeNode targetNode = map.getNodeByClass(targetClass);
        return targetNode == (connectorTargetNode = connector.getTarget()) || targetNode.isDescendantOf(connectorTargetNode);
    }
}

